/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Apr 14, 2004
 * Time: 3:02:14 PM
 */
package ch.abacus.lib.ui.customizer;

import ch.abacus.designcockpit.ide.IDEObjectPopupMenu;
import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

/**
 * CustomizerDataConnectionInterface - this object is used as a conduit between The Design Cockpit and a controlling program.
 * It controls the saving and loading of Forms and uer-preferences. It also provides a list of data-tables that can be
 * modelled in the Customizer.<p>
 * An instance of this object is passed to the Customizer in its constructor.
 */
public interface CustomizerDataConnectionInterface {
    /**
     * getDataTableCount - returns the number of data-tables.
     * @return int - number of data-tables.
     */
    int getDataTableCount ();

    /**
     * getDataTables - returns an array list of CustomizerDataTable instances that give access to
     * the data source elements.
     * @return ArrayList - the data-tables that represent data sources to associate with
     * data fields.
     */
    ArrayList getDataTables ();

    /**
     * getPreferencesInputStream - returns an instance of ObjectInputStream used to read Customizer preferences from.<p>
     * When the customizer has finished reading the preferences, it will send a preferencesLoaded callback.<p>
     * @return an instance of ObjectInputStream
     */
    ObjectInputStream getPreferencesInputStream ();

    /**
     * getPreferencesOutputStream - returns an instance of ObjectOutputStream used to write Customizer preferences to<p>
     * When the customizer has finished saving the preferences, it will send a preferencesSaved callback.
     * @return an instance of ObjectOutputStream
     */
    ObjectOutputStream getPreferencesOutputStream ();

    /**
     * preferencesSaved - indicates that the Customizer has completed trying to save the preferences.<p>
     * You should cleanup any resources used (such as close() on the ObjectOutputStream)
     * @param bSaved - indicates whether the save was successful
     */
    void preferencesSaved (boolean bSaved);

    /**
     * preferencesLoaded - indicates that the Customizer has completed trying to load the preferences
     * You should cleanup any resources used (such as close() on the ObjectInputStream)
     * @param bLoaded - indicates whether the load was successful
     */
    void preferencesLoaded (boolean bLoaded);

    /**
     * getTablesDisplayName - returns the display name that you want to see in the Customizer's "tables" branch of the Component Tree.
     * @return the name to display, for example "Customer Data Elements"
     */
    String getTablesDisplayName ();

    /**
     * getCustomizerTitle - the string you want displayed in the Customizer's Caption Bar when it is Customizing a Form
     * @return - the string the display
     */
    String getCustomizerTitle ();

    /**
     * getLoadProjectInputStream - when the Customizer wants to load a Form, it will invoke this method to receive an InputStream
     * to load the project from. When the Customizer has finished trying to load the Form, it will send a projectLoaded() method indicating the success of the load.
     * @return an InputStream instance that you have opened ready for reading.
     */
    InputStream getLoadProjectInputStream ();

    /**
     * projectLoaded - sent when the Cusomizer has finished loading a Form.
     * @param bLoaded - a value of true, if the Form loaded successfully, or false otherwise.
     */
    void projectLoaded (boolean bLoaded);

    /**
     * getSavedProjectOutputStream - when the Customizer wants to save a Form, it will invoke this method to receive an OutputStream
     * to save the project to. When the Customizer has finished trying to save the Form, it will send a projectSaved() method indicating the success of the save.
     * @return an InputStream instance that you have opened ready for reading.
     */
    OutputStream getSaveProjectOutputStream ();

    /**
     * projectSaved - sent when the Cusomizer has finished saving a Form.
     * @param bSaved - a value of true, if the Form saved successfully, or false otherwise.
     */
    void projectSaved (boolean bSaved);

    /**
     * addToContextMenu - sent whenever the Customizer is about to display a Context Menu
     * for a component that was created from a CustomizerDataElementInterface.<p>
     * When the message is received, the menu has been created and all standard items added. You can modify the menu
     * in any way you want. For example, adding a separator and item or even deleteing items.<p>
     * You can retrieve the value of the meta-properties using metaObject.getPropertyValue()
     * and set them with metaObject.setPropertyValue(). If you modify the meta-properties of the object, you should send
     * metaObject.refresh() to update the object in the display and Property Table;<p>
     * @param popupMenu - the IDEObjectPopupMenu menu
     * @param metaObject - the MetaObject representing the Component that has been clicked
     */
    void addToContextMenu (IDEObjectPopupMenu popupMenu, MetaObject metaObject);

    /**
     * querySaveOnExit is called whenever the Customizer is closed with a project that needs saving.<p>
     * You may want to display your own message dialog box to ask if they want to save.
     * @return a value indicating how process the save: JOptionPane.YES_OPTION, to save the project; JOptionPane_NO_OPTION, to not save the project; JOptionPane.CANCEL_OPTION, to abort the process and not close the Customizer
     */
    int querySaveOnExit ();

    /**
     * getToolTip - the tooltip to display when the mouse hovers over the Element in the Customizer's Component Tree
     * <p><B>Note:</B> You can use HTML in the string to achieve visual affects. For example:
     * <Pre>return "<HTML>&LT;HTML&GT;The &LT;B&GT;Country&LT;/B&GT that the customer resides in&LT;/HTML&GT;"</Pre>
     * <p> will output "<HTML>The <B>Country</B> that the customer resides in&quot</HTML>
     * @return  the text to display
     */
    String getToolTip();

    /**
     * getIcon - the icon to display in the Component Palette for the node representing the Data Connection (the list of Data Tables)
     *
     * @return Icon - the icon for node rendering.
     */
    Icon getIcon();

    /**
     * postLoadMetaObjectEnumerator - this method is sent as a callback, once for each object in the project when the project has been opened.
     * @param metaObject - the instance of MetaObject
     */
    void postLoadMetaObjectEnumerator (MetaObject metaObject);

    /**
     * languageChanged - this method is sent as a callback whenever the language is set/changed in the Customizer. You will receive this when the program starts (as the language is initially set to its default) and whenever the user explicitly changes the language.
     * @param iLanguageId - the language code.
     */
    void languageChanged (int iLanguageId);

    /**
     * getInstanceIcon - returns the icon to display in the DC's Object Hierarchy window for a Customizer-created component.
     * @param metaObject - the instance that requires an Icon to represent it in the Object Hierarchy window
     * @return - the Icon to display in the Object Hierarchy window
     */
    Icon getInstanceIcon (MetaObject metaObject);

    /**
     * Returns an Unique name for the proz so the Designcockpit can use compiled classes
     * @return
     */
    String getProzName();

    /**
     * canDeleteCompilerFiles - should the java and class files be deleted after a compilation?
     * @return true to delete the files; false to keep the files (useful for debugging)
     */
    boolean canDeleteCompilerFiles();

    /**
     * getObjectDisplayName - returns the string to display in the Object Tree.<br>
     * Typically, this is the object name, but in cases such as tab-panes, this could be the label, etc.
     * @param metaObject The MetaObject that is about to be displayed in the Object Tree
     * @return the String to display
     */
    String getObjectDisplayName(MetaObject metaObject);
}