/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.layout;

import java.awt.*;

/**
2004  Abacus Research AG , St. Gallen , Switzerland .
 * All rights reserved. Terms of Use under The ABACUS RESEARCH AG PUBLIC LICENSE Version 1.0.
  THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
public class AbaCardLayoutManager extends CardLayout {
    AbaCardLayoutComponent firstComponent = null;
    AbaCardLayoutComponent lastComponent = null;

    // If outside of a scrollpane there is no chance for recursion.
    // When you use the card layout manager outside of a scrollpane, you can turn off this check.
    // If you turn off this check improperly you may miss alternate resizes.

    static public int USE_LAYOUT_MANAGER_TO_CONTROL_RECURSION = 1;
    static public int DO_NOT_USE_LAYOUT_MANAGER_TO_CONTROL_RECURSION = 2;
    int ResizeableMode = USE_LAYOUT_MANAGER_TO_CONTROL_RECURSION;

    public AbaCardLayoutManager(int ResizeableMode) {
        super();
        this.ResizeableMode = ResizeableMode;
    }

    public AbaCardLayoutManager() {
        super();
    }


    /**
     * Adds the specified component to this card layout's internal
     * table of names. The object specified by <code>constraints</code>
     * must be a string. The card layout stores this string as a key-value
     * pair that can be used for random access to a particular card.
     * By calling the <code>show</code> method, an application can
     * display the component with the specified name.
     * @param     comp          the component to be added.
     * @param     constraints   a tag that identifies a particular
     *                                        card in the layout.
     * @see       java.awt.CardLayout#show(java.awt.Container, java.lang.String)
     * @exception  IllegalArgumentException  if the constraint is not a string.
     */

    public void addLayoutComponent(Component comp, Object constraints) {
        super.addLayoutComponent(comp, constraints);
        synchronized (comp.getTreeLock()) {
            if (constraints instanceof String) {
                AbaCardLayoutComponent theNewComponent = new AbaCardLayoutComponent();
                theNewComponent.name = (String) constraints;
                theNewComponent.component = comp;
                if (firstComponent == null)
                    firstComponent = theNewComponent;
                else
                    lastComponent.nextComponent = theNewComponent;
                theNewComponent.prevComponent = lastComponent;
                lastComponent = theNewComponent;
            }
        }
    }

    public AbaCardLayoutComponent findLayoutComponent(Component comp) {
        AbaCardLayoutComponent theComponent = firstComponent;
        while (theComponent != null) {
            if (theComponent.component==comp)
                break;
            theComponent = theComponent.nextComponent;
        }
        return theComponent;
    }

    public void layoutContainer(Container parent) {
        synchronized (parent.getTreeLock()) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            Component comp = null;
            boolean currentFound = false;

            for (int i = 0; i < ncomponents; i++) {
                comp = parent.getComponent(i);
                AbaCardLayoutComponent theLayoutData = findLayoutComponent(comp);
                if (theLayoutData.getRecursiveFlag()==AbaCardLayoutComponent.RESIZING)
                    theLayoutData.setRecursiveFlag(AbaCardLayoutComponent.STATIC);
                else {
                    // Prevent this from going recursive.
                    // When you nest a container that can resize
                    // inside of a card layout, there can be infinite recursion.
                    Dimension dimPreferredSize = comp.getPreferredSize();
                    comp.setBounds(getHgap() + insets.left, getVgap() + insets.top,
                            parent.getWidth() - (getHgap() * 2 + insets.left + insets.right),
                            parent.getHeight() - (getVgap() * 2 + insets.top + insets.bottom));
                    if (comp instanceof Container) {
                        Dimension dimNewPreferredSize = comp.getPreferredSize();
                        if (dimPreferredSize.equals(dimNewPreferredSize)==false) {
                            switch (theLayoutData.getRecursiveFlag()) {
                                case AbaCardLayoutComponent.INITIALIZING:
                                    theLayoutData.setRecursiveFlag(AbaCardLayoutComponent.STATIC);
                                    break;
                                case AbaCardLayoutComponent.STATIC:
                                    if (this.ResizeableMode == AbaCardLayoutManager.USE_LAYOUT_MANAGER_TO_CONTROL_RECURSION)
                                        theLayoutData.setRecursiveFlag(AbaCardLayoutComponent.RESIZING);
                                    break;
                            }
                        }
                    }
                }
                if (comp.isVisible()) {
                    currentFound = true;
                }
            }

            if (!currentFound && ncomponents > 0) {
                parent.getComponent(0).setVisible(true);
            }
        }
    }
    public void removeLayoutComponent(Component comp) {
        AbaCardLayoutComponent theComponent = findLayoutComponent(comp);
        if (theComponent != null) {
            if (theComponent.equals(firstComponent)) {
                firstComponent = theComponent.nextComponent;
                if (firstComponent != null)
                    firstComponent.prevComponent = null;
            }
            if (theComponent.equals(lastComponent)) {
                lastComponent = theComponent.prevComponent;
                if (lastComponent != null)
                    lastComponent.nextComponent = null;
            }
            if (theComponent.prevComponent != null)
                theComponent.prevComponent.nextComponent = theComponent.nextComponent;
            if (theComponent.nextComponent != null)
                theComponent.nextComponent.prevComponent = theComponent.prevComponent;
        }
    }
    public String getName(Component comp) {
        AbaCardLayoutComponent theComponent = findLayoutComponent(comp);
        if (theComponent!=null)
            return theComponent.name;
        return null;
    }

}
