/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.layout;

/**
2004  Abacus Research AG , St. Gallen , Switzerland .
 * All rights reserved. Terms of Use under The ABACUS RESEARCH AG PUBLIC LICENSE Version 1.0.
  THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

public class Anchoring {

    public int anchorTop;           // holds offset from top
    public int anchorBottom;        // holds offset from bottom
    public int anchorLeft;          // holds offset from left
    public int anchorRight;         // holds offset from right
    public boolean anchorInitialized = false;  // indicates whether anchors have been set up
    public int anchoring = NONE;
    public static final int  NONE                   = 0;
    public static final int  TOP                    = 1;
    public static final int  BOTTOM                 = 2;
    public static final int  LEFT                   = 4;
    public static final int  RIGHT                  = 8;

    public static final int  TOP_BOTTOM             = 3;  // Object stretches or shrinks on resize vertically
    public static final int  TOP_LEFT               = 5;  // Object anchors to top left
    public static final int  BOTTOM_LEFT            = 6;  // Object anchors to bottom left
    public static final int  TOP_BOTTOM_LEFT        = 7;  // Object anchors left and stretches/shrinks vertically
    public static final int  TOP_RIGHT              = 9;  // Object anchors to top right
    public static final int  BOTTOM_RIGHT           = 10; // Object anchors to bottom right
    public static final int  TOP_BOTTOM_RIGHT       = 11; // Object anchors to right and stretches/shrinks vertically
    public static final int  LEFT_RIGHT             = 12; // Object stretches/shrinks horizontally
    public static final int  TOP_LEFT_RIGHT         = 13; // Object anchors to top and stretches/shrinks horizontally
    public static final int  BOTTOM_LEFT_RIGHT      = 14; // Object anchors to bottom and stretches/shrinks horizontally
    public static final int  TOP_BOTTOM_LEFT_RIGHT  = 15; // Object stretches/shrinks horizontally and vertically on resize

    public Anchoring(boolean left, boolean right, boolean top, boolean bottom) {
        anchoring = (left ? LEFT:0) + (right ? RIGHT:0) +
                    (top ? TOP:0) + (bottom ? BOTTOM:0);
    }
    public Anchoring(int iAnchoring) {
        anchoring = iAnchoring;
    }
}
