/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.plaf.generic;
/**
 * Created by IntelliJ IDEA.
 * Based on code from Abacus Research @Authors: Vegh/Lauchenauer
 * Moved/Edited to generic branch by open source team
 * Date: Mar 23, 2005
 * Time: 5:55:22 PM
 * To change this template use File | Settings | File Templates.
 * This is for the opensource Look and Feel and we like a lot of the Abacus Look and Feel.
 */
import java.awt.*;
import java.awt.event.KeyEvent;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.text.DefaultEditorKit;
import sun.awt.AppContext;

public class GenericLookAndFeel extends BasicLookAndFeel
{
    /**
     * font for default text, label etc. in size 11 and font tahoma
     */
    public final static Font DEFAULT_FONT = new Font("Tahoma", Font.PLAIN, 11);

    /**
     * font for titles in the gradient (size is 14)
     * use the font "dialog" cause the default font is painted wrong
     * @see http://developer.java.sun.com/developer/bugParade/bugs/4747330.html
     */
    public final static Font TITLE_FONT_14 = new Font("dialog", Font.BOLD, 14);

    /**
     * font for titles in the panels (size is 12)
     * use the font "dialog" cause the default font is painted wrong
     * @see http://developer.java.sun.com/developer/bugParade/bugs/4747330.html
     */
    public final static Font TITLE_FONT_12 = new Font("dialog", Font.BOLD, 12);


    private static boolean mIsInstalled = false;

    private static GenericTheme currentTheme;
    private static AppContext cachedAppContext;



    public GenericLookAndFeel() {
      if (!mIsInstalled) {
        UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("GenericLookAndFeel", this.getClass().getName()));
        mIsInstalled = true;
      }

      UIManager.getDefaults().put("Button.font", DEFAULT_FONT);
      UIManager.getDefaults().put("CheckBox.font", DEFAULT_FONT);
      UIManager.getDefaults().put("CheckBoxMenuItem.acceleratorFont", DEFAULT_FONT);
      UIManager.getDefaults().put("CheckBoxMenuItem.font", DEFAULT_FONT);
      UIManager.getDefaults().put("ComboBox.font", DEFAULT_FONT);
      UIManager.getDefaults().put("Label.font", DEFAULT_FONT);
      UIManager.getDefaults().put("Menu.acceleratorFont", DEFAULT_FONT);
      UIManager.getDefaults().put("Menu.font", DEFAULT_FONT);
      UIManager.getDefaults().put("MenuBar.font", DEFAULT_FONT);
      UIManager.getDefaults().put("MenuItem.acceleratorFont", DEFAULT_FONT);
      UIManager.getDefaults().put("MenuItem.font", DEFAULT_FONT);
      UIManager.getDefaults().put("PasswordField.font", DEFAULT_FONT);
      UIManager.getDefaults().put("ProgressBar.font", DEFAULT_FONT);
      UIManager.getDefaults().put("RadioButton.font", DEFAULT_FONT);
      UIManager.getDefaults().put("RadioButtonMenuItem.acceleratorFont", DEFAULT_FONT);
      UIManager.getDefaults().put("RadioButtonMenuItem.font", DEFAULT_FONT);
      UIManager.getDefaults().put("TabbedPane.font", DEFAULT_FONT);
      UIManager.getDefaults().put("Table.font", DEFAULT_FONT);
      UIManager.getDefaults().put("TableHeader.font", DEFAULT_FONT);
      UIManager.getDefaults().put("TextField.font", DEFAULT_FONT);

      UIManager.getDefaults().put("TextArea.font", DEFAULT_FONT);
      UIManager.getDefaults().put("TitledBorder.font", DEFAULT_FONT);
      UIManager.getDefaults().put("ToggleButton.font", DEFAULT_FONT);
      UIManager.getDefaults().put("ToolBar.font", DEFAULT_FONT);
      UIManager.getDefaults().put("ToolTip.font", DEFAULT_FONT);
      UIManager.getDefaults().put("Tree.font", DEFAULT_FONT);
      UIManager.getDefaults().put("FormattedTextField.font", DEFAULT_FONT);

    }

    protected void initComponentDefaults(UIDefaults table)
    {
        super.initComponentDefaults(table);
        String abacusPackageName = "ch.abacus.lib.ui.plaf.generic.";
        String abacusBorderFactoryClass = "ch.abacus.lib.ui.plaf.generic.GenericBorders";
        Object textFieldBorder = new UIDefaults.ProxyLazyValue(abacusBorderFactoryClass, "getTextFieldBorder");
        Object lineBorder = new UIDefaults.ProxyLazyValue(abacusBorderFactoryClass, "getLineBorder");
        Border emptyBorder1111 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        Object buttonBorder = new UIDefaults.ProxyLazyValue(abacusBorderFactoryClass, "getButtonBorder");
        Object progressBarBorder = new UIDefaults.ProxyLazyValue(abacusBorderFactoryClass, "getProgressBarBorder");

        Object fieldInputMap = new UIDefaults.LazyInputMap(new Object[] {
          "ctrl C", DefaultEditorKit.copyAction,
          "ctrl V", DefaultEditorKit.pasteAction,
          "ctrl X", DefaultEditorKit.cutAction,
          "COPY", DefaultEditorKit.copyAction,
          "PASTE", DefaultEditorKit.pasteAction,
          "CUT", DefaultEditorKit.cutAction,
          "shift LEFT", DefaultEditorKit.selectionBackwardAction,
          "shift KP_LEFT", DefaultEditorKit.selectionBackwardAction,
          "shift RIGHT", DefaultEditorKit.selectionForwardAction,
          "shift KP_RIGHT", DefaultEditorKit.selectionForwardAction,
          "ctrl LEFT", DefaultEditorKit.previousWordAction,
          "ctrl KP_LEFT", DefaultEditorKit.previousWordAction,
          "ctrl RIGHT", DefaultEditorKit.nextWordAction,
          "ctrl KP_RIGHT", DefaultEditorKit.nextWordAction,
          "ctrl shift LEFT", DefaultEditorKit.selectionPreviousWordAction,
          "ctrl shift KP_LEFT", DefaultEditorKit.selectionPreviousWordAction,
          "ctrl shift RIGHT", DefaultEditorKit.selectionNextWordAction,
          "ctrl shift KP_RIGHT", DefaultEditorKit.selectionNextWordAction,
          "ctrl A", DefaultEditorKit.selectAllAction,
          "HOME", DefaultEditorKit.beginLineAction,
          "END", DefaultEditorKit.endLineAction,
          "shift HOME", DefaultEditorKit.selectionBeginLineAction,
          "shift END", DefaultEditorKit.selectionEndLineAction,
          "typed \010", DefaultEditorKit.deletePrevCharAction,
          "DELETE", DefaultEditorKit.deleteNextCharAction,
          "RIGHT", DefaultEditorKit.forwardAction,
          "LEFT", DefaultEditorKit.backwardAction,
          "KP_RIGHT", DefaultEditorKit.forwardAction,
          "KP_LEFT", DefaultEditorKit.backwardAction,
          "ENTER", JTextField.notifyAction,
          "ctrl BACK_SLASH", "unselect"/*DefaultEditorKit.unselectAction*/,
          "control shift O", "toggle-componentOrientation"/*DefaultEditorKit.toggleComponentOrientation*/
          });


          Object multilineInputMap = new UIDefaults.LazyInputMap(new Object[] {
            "ctrl C", DefaultEditorKit.copyAction,
            "ctrl V", DefaultEditorKit.pasteAction,
            "ctrl X", DefaultEditorKit.cutAction,
            "COPY", DefaultEditorKit.copyAction,
            "PASTE", DefaultEditorKit.pasteAction,
            "CUT", DefaultEditorKit.cutAction,
            "shift LEFT", DefaultEditorKit.selectionBackwardAction,
            "shift KP_LEFT", DefaultEditorKit.selectionBackwardAction,
            "shift RIGHT", DefaultEditorKit.selectionForwardAction,
            "shift KP_RIGHT", DefaultEditorKit.selectionForwardAction,
            "ctrl LEFT", DefaultEditorKit.previousWordAction,
            "ctrl KP_LEFT", DefaultEditorKit.previousWordAction,
            "ctrl RIGHT", DefaultEditorKit.nextWordAction,
            "ctrl KP_RIGHT", DefaultEditorKit.nextWordAction,
            "ctrl shift LEFT", DefaultEditorKit.selectionPreviousWordAction,
            "ctrl shift KP_LEFT", DefaultEditorKit.selectionPreviousWordAction,
            "ctrl shift RIGHT", DefaultEditorKit.selectionNextWordAction,
            "ctrl shift KP_RIGHT", DefaultEditorKit.selectionNextWordAction,
            "ctrl A", DefaultEditorKit.selectAllAction,
            "HOME", DefaultEditorKit.beginLineAction,
            "END", DefaultEditorKit.endLineAction,
            "shift HOME", DefaultEditorKit.selectionBeginLineAction,
            "shift END", DefaultEditorKit.selectionEndLineAction,

            "UP", DefaultEditorKit.upAction,
            "KP_UP", DefaultEditorKit.upAction,
            "DOWN", DefaultEditorKit.downAction,
            "KP_DOWN", DefaultEditorKit.downAction,
            "PAGE_UP", DefaultEditorKit.pageUpAction,
            "PAGE_DOWN", DefaultEditorKit.pageDownAction,
            "shift PAGE_UP", "selection-page-up",
            "shift PAGE_DOWN", "selection-page-down",
            "ctrl shift PAGE_UP", "selection-page-left",
            "ctrl shift PAGE_DOWN", "selection-page-right",
            "shift UP", DefaultEditorKit.selectionUpAction,
            "shift KP_UP", DefaultEditorKit.selectionUpAction,
            "shift DOWN", DefaultEditorKit.selectionDownAction,
            "shift KP_DOWN", DefaultEditorKit.selectionDownAction,
            "ENTER", DefaultEditorKit.insertBreakAction,
            "typed \010", DefaultEditorKit.deletePrevCharAction,
            "DELETE", DefaultEditorKit.deleteNextCharAction,
            "RIGHT", DefaultEditorKit.forwardAction,
            "LEFT", DefaultEditorKit.backwardAction,
            "KP_RIGHT", DefaultEditorKit.forwardAction,
            "KP_LEFT", DefaultEditorKit.backwardAction,
            "TAB", DefaultEditorKit.insertTabAction,
            "ctrl BACK_SLASH", "unselect"/*DefaultEditorKit.unselectAction*/,
            "ctrl HOME", DefaultEditorKit.beginAction,
            "ctrl END", DefaultEditorKit.endAction,
            "ctrl shift HOME", DefaultEditorKit.selectionBeginAction,
            "ctrl shift END", DefaultEditorKit.selectionEndAction,
            "ctrl T", "next-link-action",
            "ctrl shift T", "previous-link-action",
            "ctrl SPACE", "activate-link-action",
            "control shift O", "toggle-componentOrientation"/*DefaultEditorKit.toggleComponentOrientation*/
          });

        Object[] defaults = {
          "TextField.border", textFieldBorder, // TextField settings
          "PasswordField.border", textFieldBorder,

          "TextArea.border", textFieldBorder,
          "TextArea.focusInputMap", multilineInputMap,
          "TextPane.focusInputMap", multilineInputMap,
          "EditorPane.focusInputMap", multilineInputMap,

          "Panel.border", emptyBorder1111,
          "TextPane.border", emptyBorder1111,
          "TitledBorder.border", BorderFactory.createLineBorder(getDarkGray(), 1),
          "TextField.focusInputMap", fieldInputMap,
          "PasswordField.focusInputMap", fieldInputMap,
          "FormattedTextField.focusInputMap",
                new UIDefaults.LazyInputMap(new Object[] {
                  "ctrl C", DefaultEditorKit.copyAction,
                  "ctrl V", DefaultEditorKit.pasteAction,
                  "ctrl X", DefaultEditorKit.cutAction,
                  "COPY", DefaultEditorKit.copyAction,
                  "PASTE", DefaultEditorKit.pasteAction,
                  "CUT", DefaultEditorKit.cutAction,
                  "shift LEFT", DefaultEditorKit.selectionBackwardAction,
                  "shift KP_LEFT", DefaultEditorKit.selectionBackwardAction,
                  "shift RIGHT", DefaultEditorKit.selectionForwardAction,
                  "shift KP_RIGHT", DefaultEditorKit.selectionForwardAction,
                  "ctrl LEFT", DefaultEditorKit.previousWordAction,
                  "ctrl KP_LEFT", DefaultEditorKit.previousWordAction,
                  "ctrl RIGHT", DefaultEditorKit.nextWordAction,
                  "ctrl KP_RIGHT", DefaultEditorKit.nextWordAction,
                  "ctrl shift LEFT", DefaultEditorKit.selectionPreviousWordAction,
                  "ctrl shift KP_LEFT", DefaultEditorKit.selectionPreviousWordAction,
                  "ctrl shift RIGHT", DefaultEditorKit.selectionNextWordAction,
                  "ctrl shift KP_RIGHT", DefaultEditorKit.selectionNextWordAction,
                  "ctrl A", DefaultEditorKit.selectAllAction,
                  "HOME", DefaultEditorKit.beginLineAction,
                  "END", DefaultEditorKit.endLineAction,
                  "shift HOME", DefaultEditorKit.selectionBeginLineAction,
                  "shift END", DefaultEditorKit.selectionEndLineAction,
                  "typed \010", DefaultEditorKit.deletePrevCharAction,
                  "DELETE", DefaultEditorKit.deleteNextCharAction,
                  "RIGHT", DefaultEditorKit.forwardAction,
                  "LEFT", DefaultEditorKit.backwardAction,
                  "KP_RIGHT", DefaultEditorKit.forwardAction,
                  "KP_LEFT", DefaultEditorKit.backwardAction,
                  "ENTER", JTextField.notifyAction,
                  "ctrl BACK_SLASH", "unselect",
                  "control shift O", "toggle-componentOrientation",
                  "ESCAPE", "reset-field-edit",
                  "UP", "increment",
                  "KP_UP", "increment",
                   "DOWN", "decrement",
                  "KP_DOWN", "decrement",
                  }),

          // FormattedTextFields
          "FormattedTextField.border", textFieldBorder,

          // button section
          //    "Button.border", buttonBorder //Remove the comment for flat look

          // toggle button
          //     "ToggleButton.border", buttonBorder, //Remove the comment for flat look
          //"Checkbox.border", buttonBorder,        //Remove the comment for flat look

          // checkbox section
          "CheckBox.icon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getCheckBoxIcon"),

          // radio buttons
          "RadioButton.disabledText", getInactiveCaption(),
          "RadioButton.icon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getRadioButtonIcon"),
          "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[] {
             "SPACE", "pressed",
             "released SPACE", "released"
            }),
          "ComboBox.border", lineBorder,
          "ComboBox.buttonShadow", getSilver(),
          "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[] {
                      "ESCAPE", "hidePopup",
                      "PAGE_UP", "pageUpPassThrough",
                      "PAGE_DOWN", "pageDownPassThrough",
                      "HOME", "homePassThrough",
                      "END", "endPassThrough",
                      "DOWN", "selectNext",
                      "KP_DOWN", "selectNext",
                      "UP", "selectPrevious",
                      "KP_UP", "selectPrevious",
                      "ENTER", "enterPressed",
                      "F4", "togglePopup"
                  }),
          // label
          "Label.disabledForeground", getInactiveCaption(),
          "ScrollPane.border", lineBorder,
          "EditorPane.border", emptyBorder1111,
          "TextPane.border", textFieldBorder,

           "ScrollPane.viewportBorder", emptyBorder1111,
           "ScrollBar.border", emptyBorder1111,

          "SplitPane.border", emptyBorder1111,
          "SplitPaneDivider.border", BorderFactory.createEmptyBorder(),
          "SplitPane.dividerSize", new Integer(3),
          "SplitPane.ancestorInputMap",
               new UIDefaults.LazyInputMap(new Object[] {
                  "UP", "negativeIncrement",
                "DOWN", "positiveIncrement",
                "LEFT", "negativeIncrement",
               "RIGHT", "positiveIncrement",
               "KP_UP", "negativeIncrement",
             "KP_DOWN", "positiveIncrement",
             "KP_LEFT", "negativeIncrement",
            "KP_RIGHT", "positiveIncrement",
                "HOME", "selectMin",
                 "END", "selectMax",
            "ctrl TAB", "focusOutForward",
             "ctrl shift TAB", "focusOutBackward"
           }),

          "RootPane.frameBorder", emptyBorder1111,
          "RootPane.plainDialogBorder", emptyBorder1111,
          "RootPane.informationDialogBorder", emptyBorder1111,
          "RootPane.errorDialogBorder", emptyBorder1111,
          "RootPane.colorChooserDialogBorder", emptyBorder1111,
          "RootPane.fileChooserDialogBorder", emptyBorder1111,
          "RootPane.questionDialogBorder", emptyBorder1111,
          "RootPane.warningDialogBorder", emptyBorder1111,

          "InternalFrame.border", emptyBorder1111,

          // table
          "TableHeader.cellBorder", GenericBorders.getTableHeaderBorder(),
          "Table.gridColor", new ColorUIResource(0xD4D0C8),
          "Table.scrollPaneBorder", lineBorder,
          "Table.focusCellHighlightBorder", BorderFactory.createLineBorder(getSelectBorderColor(), 1),
          // list
          "List.font", DEFAULT_FONT,
          "List.border", BorderFactory.createEmptyBorder(),
          "List.scrollPaneBorder", emptyBorder1111, //textFieldBorder,
          "List.focusCellHighlightBorder", BorderFactory.createLineBorder(getSelectBorderColor(), 1),
          // menubar etc.
          "ToolBar.border", emptyBorder1111,
          "ToolBar.background", getToolBarBGColor(),
            //"ToolBar.buttonSize", new Dimension(24, 24),
          "MenuBar.border", emptyBorder1111, // textFieldBorder,
          "Menu.border", lineBorder,
          "MenuItem.border", lineBorder,
          "PopupMenu.border", lineBorder,

          "Menu.foreground", getBlack(),
          "Menu.disabledForeground", getDisabledColor(),
          "Menu.acceleratorForeground", getBlack(),
          "Menu.acceleratorSelectionForeground", getBlack(),

          // normal menu item
          "MenuItem.foreground", getBlack(),
          "MenuItem.background", getFillHovered(),
          "MenuItem.disabledForeground", getDisabledColor(),
          "MenuItem.acceleratorForeground", getBlack(),
          "MenuItem.acceleratorSelectionForeground", getBlack(),

          // menu radio buttons
          "RadioButtonMenuItem.background", getFillHovered(),
          "RadioButtonMenuItem.checkIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getRadioButtonIcon"), // "getRadioButtonMenuItemIcon"), // radioButtonMenuItemIcon,

          // menu check box
        "CheckBoxMenuItem.background", getFillHovered(),
        "CheckBoxMenuItem.checkIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getCheckBoxIcon"),

          // File View
          "FileView.directoryIcon", new UIDefaults.ProxyLazyValue( "javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"),
          "FileView.fileIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"),
          "FileView.computerIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeComputerIcon"),
          "FileView.hardDriveIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeHardDriveIcon"),
          "FileView.floppyDriveIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFloppyDriveIcon"),

          "FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI",
          // File Chooser
          "FileChooser.detailsViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserDetailViewIcon"),
          "FileChooser.homeFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserHomeFolderIcon"),
          "FileChooser.listViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserListViewIcon"),
          "FileChooser.newFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserNewFolderIcon"),
          "FileChooser.upFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserUpFolderIcon"),

          "OptionPane.errorIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getErrorIcon"),
          "OptionPane.informationIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getInformIcon"),
          "OptionPane.warningIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getWarningIcon"),
          "OptionPane.questionIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getQuestionIcon"),

          // Progress Bar

          "ProgressBar.border", progressBarBorder,

          // *** Spinner
            "Entry.font", DEFAULT_FONT,
            "Entry.background", table.get("control"),
            "Entry.foreground", table.get("control"),
            "Entry.border", emptyBorder1111,
            "Entry.arrowButtonSize", new Dimension(16, 11),
          "Entry.dateButtonSize", new Dimension(14, 19),
          "Entry.promptButtonSize", new Dimension(16, 19),
          "Entry.entryHeight", new Integer(19),

//UIManager.getIcon("Tree.closedIcon"),
            "Tree.openIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"),
            "Tree.closedIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getTreeFolderIconClosed"),
            "Tree.leafIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"),
            "Tree.expandedIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getTreeExpandedIcon" ),
            "Tree.collapsedIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getTreeCollapsedIcon" ),
            "Tree.editorBorder", emptyBorder1111,
            "Tree.background", getWhite(),
            "Tree.textBackground", getWhite(),

          "TabbedPane.border", emptyBorder1111,
          "TabbedPane.highlight", getSilver(),
          "PanelExtenderPanel.background", getColGroupFill(),
          "PanelExtenderPanel.border", BorderFactory.createLineBorder(getColGroupBorder())

        };

        table.putDefaults(defaults);
      }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);

        String abacusPackageName = "ch.abacus.lib.ui.plaf.generic.";
        String basicPackageName = "javax.swing.plaf.basic.";

        Object[] uiDefaults =
        {
            "CheckBoxUI", abacusPackageName + "GenericCheckBoxUI",
            "ToggleButtonUI", abacusPackageName + "GenericToggleButtonUI",
            "ButtonUI", abacusPackageName + "GenericButtonUI",
            "ToolBarUI", abacusPackageName + "GenericToolBarUI",
        };

        table.putDefaults(uiDefaults);
        // register the classloader, if not the abacus ui classes could not be found
        ClassLoader cl = this.getClass().getClassLoader();
        table.put("ClassLoader", cl);

  }
    public String getID() {
      return "GenericLookAndFeel";
    }

    public String getName() {
      return "GenericLookAndFeel";
    }

    public String getDescription() {
      return "GenericLookAndFeel Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
      return false;
    }

    public boolean isSupportedLookAndFeel() {
      return true;
    }



    protected void initSystemColorDefaults(UIDefaults table) {
      super.initSystemColorDefaults(table);

      Object[] systemColors = {

        "control", getColor(), /* Default color for controls (buttons, sliders, etc) */
        "menu", getColor(), /* Background color for menus */
        "text", getColor(), /* Text background color */

      };

      for (int i = 0; i < systemColors.length; i += 2) {
        table.put(systemColors[i], systemColors[i + 1]);
      }

    }


    public static void setCurrentTheme(GenericTheme theme) {
      if (theme == null) {
        throw new NullPointerException("Can't have null theme");
      }
      currentTheme = theme;
      cachedAppContext = AppContext.getAppContext();
      cachedAppContext.put("currentAbacusGenericTheme", theme);
    }
    public static GenericTheme getCurrentTheme() {
      if(currentTheme == null) {
        currentTheme = new GenericTheme();
      }
      return currentTheme;
    }

    // methods to get the colors
//  public static ColorUIResource getMouseOverColor() { return getCurrentTheme().getMouseOver(); }


    /**
     * Returns the aqua.
     * @return ColorUIResource
     */
    public static ColorUIResource getAqua() {
      return getCurrentTheme().getAqua();
    }

    /**
     * Returns the black.
     * @return ColorUIResource
     */
    public static ColorUIResource getBlack() {
      return getCurrentTheme().getBlack();
    }

    /**
     * Returns the blue.
     * @return ColorUIResource
     */
    public static ColorUIResource getBlue() {
      return getCurrentTheme().getBlue();
    }

    /**
     * Returns the btnFace.
     * @return ColorUIResource
     */
    public static ColorUIResource getBtnFace() {
      return getCurrentTheme().getBtnFace();
    }

    /**
     * Returns the btnShadow.
     * @return ColorUIResource
     */
    public static ColorUIResource getBtnShadow() {
      return getCurrentTheme().getBtnShadow();
    }

    /**
     * Returns the colGroupBorder.
     * @return ColorUIResource
     */
    public static ColorUIResource getColGroupBorder() {
      return getCurrentTheme().getColGroupBorder();
    }

    /**
     * Returns the colGroupBorderFooter.
     * @return ColorUIResource
     */
    public static ColorUIResource getColGroupBorderFooter() {
      return getCurrentTheme().getColGroupBorderFooter();
    }

    /**
     * Returns the colGroupFill.
     * @return ColorUIResource
     */
    public static ColorUIResource getColGroupFill() {
      return getCurrentTheme().getColGroupFill();
    }

    /**
     * Returns the colGroupFillFooter.
     * @return ColorUIResource
     */
    public static ColorUIResource getColGroupFillFooter() {
      return getCurrentTheme().getColGroupFillFooter();
    }

    /**
     * Returns the colGroupFont.
     * @return ColorUIResource
     */
    public static ColorUIResource getColGroupFont() {
      return getCurrentTheme().getColGroupFont();
    }

    /**
     * Returns the colGroupFontFooter.
     * @return ColorUIResource
     */
    public static ColorUIResource getColGroupFontFooter() {
      return getCurrentTheme().getColGroupFontFooter();
    }

    /**
     * Returns the colorsInitialized.
     * @return boolean
     */
    public static boolean isColorsInitialized() {
      return getCurrentTheme().isColorsInitialized();
    }

    /**
     * Returns the darkGray.
     * @return ColorUIResource
     */
    public static ColorUIResource getDarkGray() {
      return getCurrentTheme().getDarkGray();
    }

    /**
     * Returns the fuchsia.
     * @return ColorUIResource
     */
    public static ColorUIResource getFuchsia() {
      return getCurrentTheme().getFuchsia();
    }

    /**
     * Returns the gray.
     * @return ColorUIResource
     */
    public static ColorUIResource getGray() {
      return getCurrentTheme().getGray();
    }

    /**
     * Returns the green.
     * @return ColorUIResource
     */
    public static ColorUIResource getGreen() {
      return getCurrentTheme().getGreen();
    }

    /**
     * Returns the highLight.
     * @return ColorUIResource
     */
    public static ColorUIResource getHighLight() {
      return getCurrentTheme().getHighLight();
    }

    /**
     * Returns the inactiveCaption.
     * @return ColorUIResource
     */
    public static ColorUIResource getInactiveCaption() {
      return getCurrentTheme().getInactiveCaption();
    }

    /**
     * Returns the lightGray.
     * @return ColorUIResource
     */
    public static ColorUIResource getLightGray() {
      return getCurrentTheme().getLightGray();
    }

    /**
     * Returns the lime.
     * @return ColorUIResource
     */
    public static ColorUIResource getLime() {
      return getCurrentTheme().getLime();
    }

    /**
     * Returns the maroon.
     * @return ColorUIResource
     */
    public static ColorUIResource getMaroon() {
      return getCurrentTheme().getMaroon();
    }

    /**
     * Returns the enuText.
     * @return ColorUIResource
     */
    public static ColorUIResource getMenuText() {
      return getCurrentTheme().getMenuText();
    }

    /**
     * Returns the navy.
     * @return ColorUIResource
     */
    public static ColorUIResource getNavy() {
      return getCurrentTheme().getNavy();
    }

    /**
     * Returns the olive.
     * @return ColorUIResource
     */
    public static ColorUIResource getOlive() {
      return getCurrentTheme().getOlive();
    }

    /**
     * Returns the purple.
     * @return ColorUIResource
     */
    public static ColorUIResource getPurple() {
      return getCurrentTheme().getPurple();
    }

    /**
     * Returns the red.
     * @return ColorUIResource
     */
    public static ColorUIResource getRed() {
      return getCurrentTheme().getRed();
    }

    /**
     * Returns the silver.
     * @return ColorUIResource
     */
    public static ColorUIResource getSilver() {
      return getCurrentTheme().getSilver();
    }

    /**
     * Returns the teal.
     * @return ColorUIResource
     */
    public static ColorUIResource getTeal() {
      return getCurrentTheme().getTeal();
    }

    /**
     * Returns the white.
     * @return ColorUIResource
     */
    public static ColorUIResource getWhite() {
      return getCurrentTheme().getWhite();
    }

    /**
     * Returns the xpArrowDisabled.
     * @return ColorUIResource
     */
    public static ColorUIResource getArrowDisabled() {
      return getCurrentTheme().getArrowDisabled();
    }

    /**
     * Returns the xpArrowDown.
     * @return ColorUIResource
     */
    public static ColorUIResource getArrowDown() {
      return getCurrentTheme().getArrowDown();
    }

    /**
     * Returns the xpArrowNormal.
     * @return ColorUIResource
     */
    public static ColorUIResource getArrowNormal() {
      return getCurrentTheme().getArrowNormal();
    }

    /**
     * Returns the xpBaseSelectColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getBaseSelectColor() {
      return getCurrentTheme().getBaseSelectColor();
    }

    /**
     * Returns the xpBorderFocused.
     * @return ColorUIResource
     */
    public static ColorUIResource getBorderFocused() {
      return getCurrentTheme().getBorderFocused();
    }

    /**
     * Returns the xpBorderHovered.
     * @return ColorUIResource
     */
    public static ColorUIResource getBorderHovered() {
      return getCurrentTheme().getBorderHovered();
    }

    /**
     * Returns the xpBorderNormal.
     * @return ColorUIResource
     */
    public static ColorUIResource getBorderNormal() {
      return getCurrentTheme().getBorderNormal();
    }

    /**
     * Returns the xpButtonUpLeftCorner.
     * @return ColorUIResource
     */
    public static ColorUIResource getButtonUpLeftCorner() {
      return getCurrentTheme().getButtonUpLeftCorner();
    }

    /**
     * Returns the xpCheckedAreaColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getCheckedAreaColor() {
      return getCurrentTheme().getCheckedAreaColor();
    }

    /**
     * Returns the xpCheckedAreaSelectColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getCheckedAreaSelectColor() {
      return getCurrentTheme().getCheckedAreaSelectColor();
    }

    /**
     * Returns the xpCheckedColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getCheckedColor() {
      return getCurrentTheme().getCheckedColor();
    }

    /**
     * Returns the xpColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getColor() {
      return getCurrentTheme().getColor();
    }

    /**
     * Returns the xpDisabledColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getDisabledColor() {
      return getCurrentTheme().getDisabledColor();
    }

    /**
     * Returns the xpFillDown.
     * @return ColorUIResource
     */
    public static ColorUIResource getFillDown() {
      return getCurrentTheme().getFillDown();
    }

    /**
     * Returns the xpFillFocused.
     * @return ColorUIResource
     */
    public static ColorUIResource getFillFocused() {
      return getCurrentTheme().getFillFocused();
    }

    /**
     * Returns the xpFillHovered.
     * @return ColorUIResource
     */
    public static ColorUIResource getFillHovered() {
      return getCurrentTheme().getFillHovered();
    }

    /**
     * Returns the xpFillNormal.
     * @return ColorUIResource
     */
    public static ColorUIResource getFillNormal() {
      return getCurrentTheme().getFillNormal();
    }

    /**
     * Returns the xpIconBackColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getIconBackColor() {
      return getCurrentTheme().getIconBackColor();
    }

    /**
     * Returns the xpMenuBarColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getMenuBarColor() {
      return getCurrentTheme().getMenuBarColor();
    }

    /**
     * Returns the xpMenuBorderColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getMenuBorderColor() {
      return getCurrentTheme().getMenuBorderColor();
    }

    /**
     * Returns the xpMenuShadowColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getMenuShadowColor() {
      return getCurrentTheme().getMenuShadowColor();
    }

    /**
     * Returns the getCurrentTheme().getSelectBorderColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getSelectBorderColor() {
      return getCurrentTheme().getSelectBorderColor();
    }

    /**
     * Returns the getCurrentTheme().getSelectColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getSelectColor() {
      return getCurrentTheme().getSelectColor();
    }

    /**
     * Returns the getCurrentTheme().getSelectFontColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getSelectFontColor() {
      return getCurrentTheme().getSelectFontColor();
    }

    /**
     * Returns the getCurrentTheme().getSeparatorColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getSeparatorColor() {
      return getCurrentTheme().getSeparatorColor();
    }

    /**
     * Returns the getCurrentTheme().getToolButtonBGColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getToolButtonBGColor() {
      return getCurrentTheme().getToolButtonBGColor();
    }



    /**
     * Returns the xpToolBarBGColor.
     * @return ColorUIResource
     */
    public static ColorUIResource getToolBarBGColor() {
      return getCurrentTheme().getToolBarBGColor();
    }

      public static ColorUIResource getCatalogBGColor(){
          return getCurrentTheme().getCatalogBGColor();
      }



    /**
     * Returns the yellow.
     * @return ColorUIResource
     */
    public static ColorUIResource getYellow() {
      return getCurrentTheme().getYellow();
    }

    /**
     * Returns the color for a selected component that has no focus
     * @return ColorUIResource
     */
    public static ColorUIResource getSelectedNonFocus() {
      return getSilver();
    }

      /**
       * Returns the color for the background of a window, also Textfields etc
       * @return ColorUIResource
       */
      public static ColorUIResource getWindow() {
        return getCurrentTheme ().window;
      }

      /**
       * Returns the color for the foreground of a window, also Textfields etc
       * @return ColorUIResource
       */
      public static ColorUIResource getWindowText() {
        return getCurrentTheme ().windowText;
      }


}
