package ch.abacus.lib.ui.plaf.generic;
/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;

import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

/**
  * Created on 27.09.2002
 * Based on code from @author Lauchenauer
 * 
 * Moved/Edited to Generic brach by Open Source team 3/25/2005  
 * Copyright (c) 2001-2002 ABACUS Research AG All Rights Reserved.
 */
public class GenericToggleButtonUI extends BasicToggleButtonUI {
  protected GenericToggleButtonListener mButtonListener = new GenericToggleButtonListener(null);

  public static ComponentUI createUI(JComponent c) {
    return new GenericToggleButtonUI();
  }

  protected BasicButtonListener createButtonListener(AbstractButton b) {
    return mButtonListener;
  }

  protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    Rectangle focusRect = new Rectangle();
    String text = b.getText();
    boolean isIcon = b.getIcon() != null;
    // If there is text
    if (text != null && !text.equals("")) {
      if (!isIcon) {
        focusRect.setBounds(textRect);
      } else {
        focusRect.setBounds(iconRect.union(textRect));
      }
    }
    // If there is an icon and no text
    else if (isIcon) {
      focusRect.setBounds(iconRect);
    }

    // paint the selection of the button
    g.setColor(GenericLookAndFeel.getDarkGray());
    g.drawRect((focusRect.x - 1), (focusRect.y - 1), focusRect.width + 1, focusRect.height + 1);
  }

  protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
    AbstractButton b = (AbstractButton) c;
    ButtonModel model = b.getModel();
    FontMetrics fm = g.getFontMetrics();
    int mnemIndex = b.getDisplayedMnemonicIndex();
    /* Draw the Text */
    if (model.isEnabled()) {
      /*** paint the text normally */
      g.setColor(b.getForeground());
      BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    } else {
      /*** paint the text disabled ***/
      g.setColor(GenericLookAndFeel.getDarkGray());
      BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }
  }

  protected void paintButtonPressed(Graphics g, AbstractButton b) {
    if (b.isContentAreaFilled()) {
      Dimension size = b.getSize();
      g.setColor(GenericLookAndFeel.getFillDown());
      g.fillRect(0, 0, size.width, size.height);
    }
  }
}

class GenericToggleButtonListener extends BasicButtonListener {

  private Border mSavedBorder;
  private Color mSavedBackgroundColor;

  public GenericToggleButtonListener(AbstractButton b) {
    super(b);
  }
  public void focusGained(FocusEvent e) {
    Component c = (Component) e.getSource();
    c.repaint();
  }

  public void mouseEntered(MouseEvent e) {
    if (((JComponent) e.getSource()).isEnabled()) {
      AbstractButton button = (AbstractButton) e.getSource();

      if (!button.getModel().isPressed()) { // this is for the catalog, do not change color if a button is pressed
        mSavedBackgroundColor = button.getBackground();
        mSavedBorder = button.getBorder();
        button.setBackground(GenericLookAndFeel.getSelectColor());
      } else {
        button.setBackground(GenericLookAndFeel.getFillDown());
      }
      button.setBorder(GenericBorders.getHoveredButtonBorder(button));
    }
  }

  public void mouseExited(MouseEvent e) {
    if (mSavedBackgroundColor != null && mSavedBorder != null) {
      AbstractButton button = (AbstractButton) e.getSource();
      if (!button.getModel().isPressed()) {
        button.setBackground(mSavedBackgroundColor);
        button.setBorder(mSavedBorder);
        mSavedBackgroundColor = null;
        mSavedBorder = null;
      }
    }
  }

  public void mousePressed(MouseEvent e) {
    super.mousePressed(e);
    if (((JComponent) e.getSource()).isEnabled()) {
      AbstractButton button = (AbstractButton) e.getSource();
      if (mSavedBackgroundColor == null && mSavedBorder == null) {
        mSavedBackgroundColor = button.getBackground();
        mSavedBorder = button.getBorder();
      }
      button.setBackground(GenericLookAndFeel.getFillDown());

    }
  }
  public void mouseReleased(MouseEvent e) {
    super.mouseReleased(e);
    if (mSavedBackgroundColor != null && mSavedBorder != null) {
      AbstractButton button = (AbstractButton) e.getSource();
      if (!button.getModel().isPressed()) { // this is for the catalog, do not change color if a button is pressed
        button.setBackground(mSavedBackgroundColor);
        button.setBorder(mSavedBorder);
      }
      mSavedBackgroundColor = null;
      mSavedBorder = null;
    }
  }
}