/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 12:42:03 Misteli
 *
 * Maintainer:
 * 15.04.2005 12:42:03 Misteli
 *
 * Last Modification:
 * $Id: Group.java,v 1.1 2005/09/02 14:26:04 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.core;

/**
 * The Group class defines a grouping method for properties. For example, a Swing class has properties for left, top, width and height and
 * defines groups for Location and Size. The groups that the property inspector defines do not have to be the same as the physical
 * class, an application can group them to the application needs.
 * Each Group contains a name that is displayed in the Property Inspector, a hint that is used as tooltip, the folded property which
 * is used to set and retrieve the status whether the group is folded right now or not, a parent group it may belong to (For example,
 * the font style properties bold, italics, etc might belong to the general font group which contains the name and size properties),
 * and a ton of properties which belong to this group.
 * A group may contain sub groups, however, due to the parent concept, an application does not need to define subgroups if it defines
 * the parent group. A Group may also contain a GroupEditorInterface implementation which is used to edit all properties of the group
 * at once (A FontEditor Dialog could edit all font properties at once, for example).
 */
public class Group {

  private String name;
  private String hint;
  private boolean folded;
  private Group parent;
  private Groups groups = new Groups();
  private Properties properties = new Properties();
  private GroupEditorInterface editor;

  public Group(Group parent, String name, String hint, GroupEditorInterface editor) {
    if (parent != null)
      parent.groups.add(this);
    this.parent = parent;
    this.name = name;
    this.hint = hint;
    this.editor = editor;
  }

  public void setEditor(GroupEditorInterface editor) {
    this.editor = editor;
  }

  public GroupEditorInterface getEditor() {
    return editor;
  }

  public String getName() {
    return name;
  }

  public Properties getProperties() {
    return properties;
  }

  public void setProperties(Properties properties) {
    this.properties = properties;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getHint() {
    return hint;
  }

  public void setHint(String hint) {
    this.hint = hint;
  }

  public boolean isFolded() {
    return folded;
  }

  public void setFolded(boolean folded) {
    this.folded = folded;
  }

  public Group getParent() {
    return parent;
  }

  public void setParent(Group parent) {
    this.parent = parent;
  }

  public Groups getGroups() {
    return groups;
  }

  public void setGroups(Groups groups) {
    this.groups = groups;
  }

  public String toString() {
    return name;
  }
}
