/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 12:32:11 Misteli
 *
 * Maintainer:
 * 15.04.2005 12:32:11 Misteli
 *
 * Last Modification:
 * $Id: Properties.java,v 1.2 2005/09/03 08:50:24 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.core;

import java.util.Comparator;

public class Properties extends BaseList {

  private Clazz clazz;

  public Properties(Clazz clazz) {
    this.clazz = clazz;
  }

  public Properties() {
    this(null);
  }

  public Property get(int index) {
    return (Property) list.get(index);
  }

  public Comparator comparator(final boolean sortAlphabetically) {
    return new Comparator() {
      public int compare(Object o, Object o1) {
        if (!sortAlphabetically)
          return 0;
        Property g1 = (Property) o;
        Property g2 = (Property) o1;
        return g1.getName().compareTo(g2.getName());
      }
    };
  }

  public void remove(Property property) {
    list.remove(property);
  }

  public void add(Property property) {
    if (!propertyDoesNotAppearInSuperClass(property))
      super.add(property);
  }

  private boolean propertyDoesNotAppearInSuperClass(Property property) {
    if (list.contains(property))
      return true;
    if (clazz == null)
      return false;
    if (clazz.getParent() != null)
      return clazz.getParent().getProperties().propertyDoesNotAppearInSuperClass(property);
    return false;
  }

}
