/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 22.04.2005 08:55:38 Misteli
 *
 * Maintainer:
 * 22.04.2005 08:55:38 Misteli
 *
 * Last Modification:
 * $Id: PropertyEditorRegistry.java,v 1.1 2005/09/02 14:26:05 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import java.util.HashMap;
import java.util.Iterator;

public class PropertyEditorRegistry {

  private HashMap<String, PropertyValueEditorInterface> map = new HashMap<String, PropertyValueEditorInterface>();

  public PropertyValueEditorInterface register(String name, PropertyValueEditorInterface editor) {
    if (map.containsKey(name))
      throw new IllegalArgumentException("PropertyEditor " + name + " is already registered");
    map.put(name, editor);
    return editor;
  }

  public PropertyValueEditorInterface get(String name) {
    return map.get(name);
  }

  public Iterator iterator() {
    return map.values().iterator();
  }
}
