/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 16:34:20 Misteli
 *
 * Maintainer:
 * 15.04.2005 16:34:20 Misteli
 *
 * Last Modification:
 * $Id: PropertyInspector.java,v 1.3 2005/09/03 09:03:21 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.util.GlobalInterface;

import javax.swing.BorderFactory;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Iterator;

public class PropertyInspector extends JAPanel {

  private PropertyTable table = new PropertyTable();
  private PropertyModel model;
  private GlobalInterface globalInterface;
  private HashMap<String, String> languageStrings = new HashMap<String, String>();
  private PropertyEditorRegistry editorRegistry = new PropertyEditorRegistry();
  private PropertyRendererRegistry rendererRegistry = new PropertyRendererRegistry();

  public PropertyInspector(GlobalInterface globalInterface) {
    super();
    init(globalInterface, true);
  }

  public PropertyInspector(GlobalInterface globalInterface, boolean useInternalScrollPane) {
    super();
    init(globalInterface, useInternalScrollPane);
  }

  private void init(GlobalInterface globalInterface, boolean useInternalScrollPane) {
    setBorder(BorderFactory.createEmptyBorder());
    this.globalInterface = globalInterface;
    model = new PropertyModel(this, table);
    table.setModel(model);
    Dimension nullSize = new Dimension(0, 0);
    table.getTableHeader().setPreferredSize(nullSize);
    table.getTableHeader().setMinimumSize(nullSize);
    table.getTableHeader().setMaximumSize(nullSize);
    table.getTableHeader().setVisible(false);
    table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    table.setGridColor(UIManager.getColor("Panel.background"));
    new HeaderlessColumnResizer(table);
    model.initialize();
    setLayout(new BorderLayout(0, 0));
    if (useInternalScrollPane) {
      JAScrollPane scrollPane = new JAScrollPane(table);
      add(scrollPane, BorderLayout.CENTER);
    }
    else
      add(table, BorderLayout.CENTER);
  }

  public GlobalInterface getGlobalInterface() {
    return globalInterface;
  }

  public void initialize() {
    Iterator iterator = editorRegistry.iterator();
    while (iterator.hasNext())
      ((PropertyValueEditorInterface) iterator.next()).initialized();
  }

  public HashMap<String, String> getLanguageStrings() {
    return languageStrings;
  }

  public PropertyEditorRegistry getEditorRegistry() {
    return editorRegistry;
  }

  public PropertyRendererRegistry getRendererRegistry() {
    return rendererRegistry;
  }

  public PropertyModel getModel() {
    return model;
  }

  public JATable getTable() {
    return table;
  }

  public void endEditing() {
    table.endEditing();
  }

  public void beginEditing() {
    model.editCurrentRow();
  }

  public void beginUpdate() {
    model.beginUpdate();
  }

  public void endUpdate() {
    model.endUpdate();
  }

  public void changeSelection() {
    model.changeSelection();
  }

  public void addSelection(Object object) {
    model.addSelection(object);
  }

  public void editCurrentRow() {
    model.editCurrentRow();
  }

  public boolean isEditing() {
    return table.isEditing();
  }
}
