/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 21.04.2005 08:06:48 Misteli
 *
 * Maintainer:
 * 21.04.2005 08:06:48 Misteli
 *
 * Last Modification:
 * $Id: AbstractListEditor.java,v 1.3 2005/09/27 07:00:42 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.editor;

import ch.abacus.lib.ui.JAComboBox;

import javax.swing.DefaultComboBoxModel;
import javax.swing.ListCellRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;

public abstract class AbstractListEditor extends BaseEditor implements EditorValueAccessor {

  protected JAComboBox comboBox;

  private boolean lazyInitialisation;

  public AbstractListEditor(boolean lazyInitialisation) {
    super();
    this.lazyInitialisation = lazyInitialisation;
  }

  public abstract List getItemList();
  public abstract int indexOf(Object value);
  public abstract ListCellRenderer getListCellRenderer();

  public void reformatValue(Object value) {  }

  public boolean shouldSelectCell(EventObject anEvent) {
    if (anEvent instanceof MouseEvent) {
      MouseEvent e = (MouseEvent)anEvent;
      return e.getClickCount() > 2;
    }
    return true;
  }

  public void initialized() {
    comboBox = new JAComboBox();
    comboBox.setRenderer(getListCellRenderer());
    delegate = new EditorDelegate(this) {
      public Object getValue() {
        return AbstractListEditor.this.getValue();
      }

      public void setValue(Object value) {
        reformatValue(value);
        AbstractListEditor.this.setValue(value);
      }

      public boolean shouldSelectCell(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
          MouseEvent e = (MouseEvent) anEvent;
          return e.getID() != MouseEvent.MOUSE_DRAGGED;
        }
        return true;
      }

      public boolean stopCellEditing() {
        if (comboBox.isEditable())
          comboBox.actionPerformed(new ActionEvent(AbstractListEditor.this, 0, ""));
        return super.stopCellEditing();
      }
    };
    if (!lazyInitialisation)
      comboBox.setModel(new DefaultComboBoxModel(getItemList().toArray()));
    comboBox.addActionListener(delegate);
    initialize(comboBox);
  }

  public Object getValue() {
    return comboBox.getSelectedItem();
  }

  public void setValue(Object value) {
    reformatValue(value);
    if (value == null)
      comboBox.setSelectedIndex(-1);
    else
      comboBox.setSelectedIndex(indexOf(value));
    modify();
  }
}
