/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 19.04.2005 16:37:29 Misteli
 *
 * Maintainer:
 * 19.04.2005 16:37:29 Misteli
 *
 * Last Modification:
 * $Id: EditorDelegate.java,v 1.6 2005/10/04 12:53:44 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.editor;

import javax.swing.SwingUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.EventObject;

public class EditorDelegate implements ActionListener, ItemListener, Serializable, FocusListener, KeyListener, EditorValueAccessor {

  protected Object value;
  private BaseEditor baseEditor;

  protected boolean modified;

  public EditorDelegate(BaseEditor baseEditor) {
    this.baseEditor = baseEditor;
  }

  public void clearModified() {
    modified = false;
  }

  /**
   * Returns the value of this cell.
   *
   * @return the value of this cell
   */
  public Object getValue() {
    return value;
  }

  /**
   * Sets the value of this cell.
   *
   * @param value the new value of this cell
   */
  public void setValue(Object value) {
    this.value = value;
  }

  public void modify() {
    modified = true;
  }

  public boolean isModified() {
    return modified;
  }

  /**
   * Returns true if <code>anEvent</code> is <b>not</b> a
   * <code>MouseEvent</code>.  Otherwise, it returns true
   * if the necessary number of clicks have occurred, and
   * returns false otherwise.
   *
   * @param anEvent the event
   * @return true  if cell is ready for editing, false otherwise
   * @see #setClickCountToStart
   * @see #shouldSelectCell
   */
  public boolean isCellEditable(EventObject anEvent) {
    return true;
  }

  /**
   * Returns true to indicate that the editing cell may
   * be selected.
   *
   * @param anEvent the event
   * @return true
   * @see #isCellEditable
   */
  public boolean shouldSelectCell(EventObject anEvent) {
    return true;
  }

  /**
   * Returns true to indicate that editing has begun.
   *
   * @param anEvent the event
   */
  public boolean startCellEditing(EventObject anEvent) {
    modified = false;
    return true;
  }

  /**
   * Stops editing and
   * returns true to indicate that editing has stopped.
   * This method calls <code>fireEditingStopped</code>.
   *
   * @return true
   */
  public boolean stopCellEditing() {
    baseEditor.fireEditingStopped();
    return true;
  }

  /**
   * Cancels editing.  This method calls <code>fireEditingCanceled</code>.
   */
  public void cancelCellEditing() {
    modified = false;
    baseEditor.fireEditingCanceled();
  }

  public void selectAll() {

  }

  public void selectNone() {
  }

  /**
   * When an action is performed, editing is ended.
   *
   * @param e the action event
   * @see #stopCellEditing
   */
  public void actionPerformed(ActionEvent e) {
    modify();
    baseEditor.stopCellEditing();
  }

  /**
   * When an item's state changes, editing is ended.
   *
   * @param e the action event
   * @see #stopCellEditing
   */
  public void itemStateChanged(ItemEvent e) {
    modify();
    baseEditor.stopCellEditing();
  }

  public void focusGained(FocusEvent e) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        selectAll();
      }
    });
  }

  public void focusLost(FocusEvent e) {
    if (e.getOppositeComponent() == null || e.getOppositeComponent() == baseEditor.getEditorButton())
      return;
    baseEditor.stopCellEditing();
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        selectNone();
      }
    });
  }

  public void keyTyped(KeyEvent e) {
    modify();
  }

  public void keyPressed(KeyEvent e) {
    modify();
  }

  public void keyReleased(KeyEvent e) {
    modify();
  }

}
