/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Aug 31, 2004
 * Time: 2:08:21 PM
 */
package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.util.GlobalInterface;

public class DefaultPathAbaRenderer extends AbaRenderer {

    public DefaultPathAbaRenderer(MetaProject theProject, boolean attachedToDesigner, GlobalInterface theGlobalInterface) throws HammerException {
        super(theProject, attachedToDesigner, theGlobalInterface);
    }

    public DefaultPathAbaRenderer(String theXMLDocumentName, boolean attachedToDesigner, GlobalInterface theGlobalInterface) throws HammerException {
        super(theXMLDocumentName, attachedToDesigner, theGlobalInterface);
    }

    public DefaultPathAbaRenderer(byte[] theProz, boolean attachedToDesigner, GlobalInterface theGlobalInterface) throws HammerException {
        super(null, theProz, attachedToDesigner, theGlobalInterface);
    }

    public DefaultPathAbaRenderer(MetaProject theProject,
                                  boolean attachedToDesigner,
                                  GlobalInterface theGlobalInterface,
                                  int iInputType) throws HammerException {
        super(theProject, attachedToDesigner, theGlobalInterface, iInputType);
    }

    public DefaultPathAbaRenderer(String theXMLParameter,
                                  boolean attachedToDesigner,
                                  GlobalInterface theGlobalInterface,
                                  int iInputType) throws HammerException {
        super(theXMLParameter, attachedToDesigner, theGlobalInterface, iInputType);
    }

    public DefaultPathAbaRenderer() throws HammerException {
        super();
    }

    public DefaultPathAbaRenderer (boolean _LoadMetadata) throws HammerException {
        super(_LoadMetadata);
    }

    public void init(boolean bTest) throws HammerException {
        super.init(bTest);
        this.bAddDefaultPaths = true;  // hard wire this.
    }

    public boolean getAddDefaultPaths() {
        return true;
    }

    public AbaRenderer makeFakeRenderer() throws HammerException {
        return new DefaultPathAbaRenderer();
    }

}