/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.util.ArrayList;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class MetaPropertyDescriptor {
    MetaPropertyDescriptor theNextProperty = null;
    String sGetName = null;
    String sSetName = null;
    String theHelperClass = null;
    String sClass = null;
    String sType = null;
    private String sDefaultValue = null;

    String sName = null;
    String sDoc = null;
    public boolean bAllowMultipleLanguages = false;
    public int iSubpropertyCount = 0;
    public MetaPropertyDescriptor theFirstSubproperty = null;
    public MetaPropertyDescriptor theLastSubproperty = null;
    public MetaPropertyDescriptor theSuperProperty = null; // the parent of subproperties

    public boolean bAllowMultipleValues = false;
    ArrayList theValueChoices = new ArrayList(0);
    public boolean bGenerate = true;
    public boolean bVisible = false;
    public boolean bObjectReference = false;
    public boolean bObjectPromptList = false;
    private String sIncludeTypeConstants = null;
    private int iOrder = 0;
    private ArrayList objectReferenceList = null; //MHC
    private boolean bDataAwareness = false;
    private boolean bReadOnly = false;
    private MetaClassDetail theMetaClassDetail = null;

    public MetaPropertyDescriptor() {
    }

    public MetaPropertyDescriptor(String theName, String theType, String theClass,
                                  String[] theValueChoiceList,
                                  String theDoc,
                                  String theDefaultValue,
                                  String theSetName,
                                  String theGetName,
                                  String theHelperClass,
                                  String sIncludeTypeConstants,
                                  int iOrder,
                                  MetadataDispenser theMetadataDispenser,
                                  MetaClassDetail theClassDetail) {
        sGetName = theGetName;
        sSetName = theSetName;
        sName = theName;
        sType = theType;
        sDoc = theDoc;
        this.theHelperClass = theHelperClass;
        this.sIncludeTypeConstants = sIncludeTypeConstants;
        this.theMetaClassDetail = theClassDetail;
        setDefaultValue(theMetadataDispenser, theClassDetail, theDefaultValue);
        sClass = theClass;
        this.iOrder = iOrder;
        if (theValueChoiceList != null) {
            for (int i = 0; i < theValueChoiceList.length; i++)
                theValueChoices.add(theValueChoiceList[i]);
        }
    }

    public int getSubpropertyCount() {
        return iSubpropertyCount;
    }

    public MetaPropertyDescriptor getProperty(String sPropertyName) {
        MetaPropertyDescriptor theProperty = theFirstSubproperty;
        while (theProperty != null) {
            String sMetaDataPropertyName = theProperty.getName();
            sMetaDataPropertyName = sMetaDataPropertyName.substring(sMetaDataPropertyName.lastIndexOf(".") + 1);
            if (sMetaDataPropertyName.equals(sPropertyName))
                return theProperty;
            int iDotPos = sPropertyName.indexOf(".");
            if (iDotPos != -1) {
                String sFront = sPropertyName.substring(0, iDotPos);
                if (theProperty.getName().equals(sFront)) {
                    if (theProperty.theFirstSubproperty != null) {
                        return theProperty.theFirstSubproperty.getProperty(sPropertyName.substring(iDotPos + 1));
                    }
                    return null;
                }
            }
            theProperty = theProperty.getNextProperty();
        }
        return null;
    }

    public void addSubproperty(MetaPropertyDescriptor theNewSubproperty) {
        if (theFirstSubproperty == null)
            theFirstSubproperty = theNewSubproperty;
        else {
            theLastSubproperty.theNextProperty = theNewSubproperty;
        }
        theLastSubproperty = theNewSubproperty;

        theNewSubproperty.theSuperProperty = this;
    }

    public boolean removeSubProperty (String sPropertyName) {
        MetaPropertyDescriptor theProperty = theFirstSubproperty;
        MetaPropertyDescriptor theLastProcessed = null;
        while (theProperty != null) {
            if (theProperty.sName.equals(sPropertyName)) {
                if (theLastProcessed == null) {
                    theFirstSubproperty = theProperty.theNextProperty;
                }
                else
                    theLastProcessed.theNextProperty = theProperty.theNextProperty;
                if (theProperty == theLastSubproperty) {
                    theLastSubproperty = theLastProcessed;
                    if (theLastProcessed != null && theLastProcessed.theNextProperty != null)
                        theLastProcessed.theNextProperty = null;
                }
                iSubpropertyCount--;
                // reset the order parameter...
                int iOrder = 0;
                theProperty = theFirstSubproperty;
                while (theProperty != null) {
                    theProperty.iOrder = iOrder++;
                    theProperty = theProperty.getNextProperty();
                }

                return true;
            }
            theLastProcessed = theProperty;
            theProperty = theProperty.theNextProperty;
        }
        return false;

    }

    public Object getValueChoice(int i) {
        String sValue;
        if (i >= theValueChoices.size())
            sValue = "";
        else
            sValue = (String) theValueChoices.get(i);
        if (sClass.equalsIgnoreCase("string"))
            return sValue;
        if (sClass.equalsIgnoreCase("integer")) {
            if (sValue.trim().length() == 0)
                return new Integer(0);
            else
                return new Integer(sValue);
        }
        if (sClass.equalsIgnoreCase("boolean")) {
            if (sValue.trim().length() == 0)
                return new Boolean(false);
            else
                return new Boolean(sValue);
        }
        return sValue;
    }

    public String getValueChoiceAsString(int i) {
        return getValueChoice(i).toString();
    }

    public String getName() {
        return sName;
    }

    public String getClassName() {
        return sClass;
    }

    public String getTypeName() {
        return sType;
    }

    public String getDoc() {
        return sDoc;
    }

    public String getDefaultValue() {
        return sDefaultValue;
    }

    public String getGetMethod() {
        return sGetName;
    }

    public String getSetMethod() {
        return sSetName;
    }

    public void setGetMethod(String sMethodName) {
        sGetName = sMethodName;
    }

    public void setSetMethod(String sMethodName) {
        sSetName = sMethodName;
    }

    public void setValueChoiceAsString(int i, String sValue) {
        theValueChoices.set(i, sValue);
    }

    public void setValueChoice(int i, Object objValue) {
        String sValue = "";
        if (objValue instanceof String)
            sValue = (String) objValue;
        else if (objValue instanceof Integer)
            sValue = (objValue).toString();
        else if (objValue instanceof Boolean)
            sValue = (objValue).toString();
        else
            sValue = objValue.toString();
        theValueChoices.set(i, sValue);
    }

    public int getValueChoiceCount() {
        if (theValueChoices == null)
            return 0;
        else
            return theValueChoices.size();
    }

    public void removeValueChoice(String sValue) {
        theValueChoices.remove(sValue);
    }

    public void addValueChoice(String sValue) {
        if (theValueChoices.contains(sValue) == false)
            theValueChoices.add(sValue);
    }

    public boolean getDataAwareness() {
        return bDataAwareness;
    }

    public void setDataAwareness(boolean bDataAwareness) {
        this.bDataAwareness = bDataAwareness;
    }

    public void setName(String sValue) {
        sName = sValue;
    }

    public void setClassName(String sValue) {
        sClass = sValue;
    }

    public void getTypeName(String sValue) {
        sType = sValue;
        ;
    }

    public void setDoc(String sValue) {
        sDoc = sValue;
    }

    public void setHelperClass(String sValue) {
        theHelperClass = sValue;
    }

    public String getHelperClass() {
        return theHelperClass;
    }

    public boolean isReadOnly() {
        return bReadOnly;
    }

    public void setReadOnly(boolean bReadOnly) {
        this.bReadOnly = bReadOnly;
    }


    public MetaPropertyDescriptor getNextProperty() {
        return theNextProperty;
    }

    public void setDefaultValue(MetadataDispenser theProject, MetaClassDetail metaClassDetail, String sDefaultValue) {
        this.sDefaultValue = sDefaultValue;
        String sExpandedValue = getExpandedMatch(theProject, sDefaultValue);
        if (sDefaultValue != null)
            metaClassDetail.setPropertyDefaultValue(this.sName, sDefaultValue, sExpandedValue);
    }

    /**
     * Used by the Metadata Editor to store the simple value
     * @param sDefaultValue - the default value
     */
    public void setSimpleDefaultValue (String sDefaultValue) {
        this.sDefaultValue = sDefaultValue;
    }

    public String getExpandedMatch(MetadataDispenser theProject, String sValue) {
        String sMatch = null;
        MetaConstantGroup theConstantTable = theProject.findConstantGroup(sIncludeTypeConstants);
        if (theConstantTable != null) {
            sMatch = theConstantTable.get(sValue);
        } else {
            MetaConstantGroupCollection theConstantTableCollection =
                    theProject.findConstantGroupCollection(sIncludeTypeConstants);
            if (theConstantTableCollection != null) {
                sMatch = theConstantTableCollection.get(sValue);
            }
        }
        if (sMatch != null)
            sValue = sMatch;
        return sValue;
    }

    public Object getExpandedValue(MetaProject theProject, String sValue) {
        String sMatch = null;
        MetaConstantGroup theConstantTable = theProject.findConstantGroup(sIncludeTypeConstants);
        if (theConstantTable != null) {
            sMatch = theConstantTable.getKey(sValue);
            if (sMatch != null) {
                if (sType.endsWith("oolean"))
                    return new Boolean(sMatch);
            }
        } else {
            MetaConstantGroupCollection theConstantTableCollection =
                    theProject.findConstantGroupCollection(sIncludeTypeConstants);
            if (theConstantTableCollection != null) {
                sMatch = theConstantTableCollection.getKey(sValue);
                if (sMatch != null) {
                    if (sType.endsWith("oolean"))
                        return new Boolean(sMatch);
                }
            }
        }
        if (sMatch != null)
            sValue = sMatch;
        return sValue;
    }

    public String getIncludeTypeConstants() {
        return this.sIncludeTypeConstants;
    }

    public void setIncludeTypeConstants(String sIncludeTypeConstants) {
        this.sIncludeTypeConstants = sIncludeTypeConstants;
    }

    public String getConciseValue(MetaProject theProject, String sTestValue) {
        String sMatch = null;
        MetaConstantGroup theConstantTable = theProject.findConstantGroup(sIncludeTypeConstants);
        if (theConstantTable != null) {
            sMatch = theConstantTable.getKey(sTestValue);
        } else {
            MetaConstantGroupCollection theConstantTableCollection =
                    theProject.findConstantGroupCollection(sIncludeTypeConstants);
            if (theConstantTableCollection != null) {
                sMatch = theConstantTableCollection.getKey(sTestValue);
            }
        }
        if (sMatch != null)
            sTestValue = sMatch;
        return sTestValue;
    }

    public int getOrder() {
        return iOrder;
    }

    //********** MHC     ************//

    public void setObjectReferenceList(ArrayList objList) {
        objectReferenceList = objList;
    }

    public ArrayList getObjectReferenceList() {
        return objectReferenceList;
    }
    //********** MHC     ************//

}

