/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.lang.reflect.Method;

/**
 * Title:        uifactory
 * Description:  Class the facilitates indirect invocations.  These are methods
 *              that are invoked dynamically via invoke method.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class UIFactoryInvokeHelper {

    public Method mSetCustomCode;
    public Method mSetConstructorParameterList;
    public Method mSetPreConstructionCode;
    public Method mSetAddWindowListener;
    public Method mSetAddActionListener;
    public Method mSetActivateAsPopup;
    public Method mSetActionListenerTarget;
    public Method mSetActionListenerClass;
    public Method mSetActionListenerMessage;
    public Method mSetContainerName;
    public Method mGetContainerName;
    public Method mSetMemberData;
    public Method mSetDeclareAsMember;
    public Method mSetParentMeta;
    public Method mGetParentMeta;
//  public Method mSetPropertyValue;
    public Method mGetPropertyValue;
    public Method mSetCustomGenerator;
    public Method mGetCustomGenerator;

    /**
     * UIFactoryInvokeHelper - This is an object that allows method of a class to be
     * invoked easily without doing a lookup each time in the method list.
     * InvokeHelpers are placed in the class proxy objects that are used for
     * all supported classes in the class pool.
     */

    public UIFactoryInvokeHelper(Class cMetaObject) {
        Method[] methods = cMetaObject.getMethods();
        for (int i = methods.length - 1; i >= 0; i--) {
//          System.out.println(methods[i].getName().toString());
//          if (methods[i].getName().toString().equals("setPropertyValue"))
//              mSetPropertyValue = methods[i];
            if (methods[i].getName().toString().equals("setCustomGenerator"))
                mSetCustomGenerator = methods[i];
            if (methods[i].getName().toString().equals("getPropertyValue"))
                mGetPropertyValue = methods[i];
            if (methods[i].getName().toString().equals("getCustomGenerator"))
                mGetCustomGenerator = methods[i];
            if (methods[i].getName().toString().equals("setCustomCode"))
                mSetCustomCode = methods[i];
            if (methods[i].getName().toString().equals("setContainerName"))
                mSetContainerName = methods[i];
            if (methods[i].getName().toString().equals("getContainerName"))
                mGetContainerName = methods[i];
            if (methods[i].getName().toString().equals("setParentMeta"))
                mSetParentMeta = methods[i];
            if (methods[i].getName().toString().equals("getParentMeta"))
                mGetParentMeta = methods[i];
            if (methods[i].getName().toString().equals("setConstructorParameterList"))
                mSetConstructorParameterList = methods[i];
            if (methods[i].getName().toString().equals("setPreConstructionCode"))
                mSetPreConstructionCode = methods[i];
            if (methods[i].getName().toString().equals("setAddWindowListener"))
                mSetAddWindowListener = methods[i];
            if (methods[i].getName().toString().equals("setDeclareAsMember"))
                mSetDeclareAsMember = methods[i];
            if (methods[i].getName().toString().equals("setAddActionListener"))
                mSetAddActionListener = methods[i];
            if (methods[i].getName().toString().equals("setActivateAsPopup"))
                mSetActivateAsPopup = methods[i];
            if (methods[i].getName().toString().equals("setActionListenerMessage"))
                mSetActionListenerMessage = methods[i];
            if (methods[i].getName().toString().equals("setActionListenerClass"))
                mSetActionListenerClass = methods[i];
            if (methods[i].getName().toString().equals("setActionListenerTarget"))
                mSetActionListenerTarget = methods[i];
            if (methods[i].getName().toString().equals("setMemberData"))
                mSetMemberData = methods[i];
        }
    }

}

