/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common.jdbc;


/* Beta Version */
/**
 * Created by IntelliJ IDEA.
 * User: Mario
 * Date: Mar 13, 2004
 * Time: 3:51:27 PM
 * To change this template use Options | File Templates.
 */

import com.sun.rowset.JdbcRowSetImpl;
import com.sun.rowset.FilteredRowSetImpl;

import javax.sql.RowSet;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;
import javax.sql.rowset.CachedRowSet;
import javax.swing.*;
import java.sql.*;
import java.util.ArrayList;
import java.text.SimpleDateFormat;


public class JSSDataSource extends JPanel {
    Connection      conn        = null;
    JSSUpdatableRowSet  rowset      = null;
    int             paramCount  = 1;
    // Public Propterties

    public boolean readOnly = false;

    // Private properties
    private String JDBCClassName = null;
    private String JDBCURL = null;
    private String JDBCUserName = null;
    private String JDBCPassword = null;
    private String SQLCommand = null;
    private String sqlTable = null;
    private boolean bRetryCommand = false;
    private int columnCount = 0;

    String datePattern = "MM/dd/yyyy";


    public JSSDataSource() {
        super();
    }

    public JSSDataSource(String ClassName, String URL, String UserName, String Password) {
        JDBCClassName = ClassName;
        JDBCURL = URL;
        JDBCUserName = UserName;
        JDBCPassword = Password;
        setConnection();
    }


    public void setJDBCClassName(String sValue) {
        JDBCClassName = sValue;
        this.setConnection();
    }

    public void setJDBCURL(String sValue) {
        JDBCURL = sValue;
        this.setConnection();
    }

    public void setJDBCUserName(String sValue) {
        JDBCUserName = sValue;
        this.setConnection();
    }

    public void setJDBCPassword(String sValue) {
        JDBCPassword = sValue;
        this.setConnection();
    }

    public void setTableName(String Table) {
        sqlTable = Table;
    }

    public void setReadOnly(boolean bFlag) {
        rowset.setReadOnly(bFlag);
    }

    public boolean isReadOnly() {
        return rowset.isReadOnly();
    }

    public String getCommand()
    {
        return rowset.getCommand();
    }

    public void setSQLCommand(String sValue) {
        SQLCommand = sValue;

        if (conn == null || rowset == null) {
            this.setConnection();

            if (rowset == null) {
                bRetryCommand = true;
                return;
            }
        }

        try {
            if (SQLCommand.length() > 0 && !SQLCommand.equalsIgnoreCase("")) {
                rowset.setCommand(SQLCommand);
                bRetryCommand = false;
                rowset.execute();
            }
        } catch (Exception e) {
            e.printStackTrace();
            //  conn = null;
        }
    }

    public RowSet getRowSet() {
        return rowset;
    }


    public synchronized void setConnection() {
        boolean bAllParams = true;

        if (JDBCClassName==null || JDBCURL==null || JDBCUserName==null || JDBCPassword==null)
            bAllParams = false;

        if (paramCount < 5 && bAllParams==false)
        {
            paramCount++;
            return;
        }

        else
           paramCount=1;


        if (conn != null && rowset != null)
            return;
        System.out.println("In setConnection" + ":" + JDBCClassName + ":" + JDBCURL + ":" + JDBCUserName + ":" + JDBCPassword);
        try {
            Class.forName(JDBCClassName);
        } catch (Exception E) {
            E.printStackTrace();
            return;
        }

        try {
            if(JDBCPassword == null) // User without password migh be valid
            {
                conn = DriverManager.getConnection(JDBCURL);
                /*
                    conn = new AbaConnection(DriverManager.getConnection(JDBCURL));
                */
            }
             else
            {
                conn = DriverManager.getConnection(JDBCURL, JDBCUserName, JDBCPassword);
                /*
                    conn = new AbaConnection(DriverManager.getConnection(JDBCURL, JDBCUserName, JDBCPassword));
                */
            }
        } catch (SQLException E) {
            System.err.println(E.getMessage() + ", SQLState: " + E.getSQLState() + ", VendorError:  " + E.getErrorCode() + "\n");
        }

        if (conn == null)
            return;

        try {
            rowset = new JSSUpdatableRowSet(conn, sqlTable, null);  // TODO: Table name and Unique field
            rowset.setUrl(JDBCURL);
            rowset.setReadOnly(readOnly);
            try
            {
                rowset.setType(ResultSet.TYPE_SCROLL_SENSITIVE);
            }
            catch (SQLException e)
            {
                System.err.println("setType(ResultSet.TYPE_SCROLL_SENSITIVE): "+e);
            }

            try
            {
                if (readOnly == false)
                    rowset.setConcurrency(ResultSet.CONCUR_UPDATABLE);
            }
            catch (SQLException e)
            {
                System.err.println("setConcurrency(ResultSet.CONCUR_UPDATABLE): "+e);
                readOnly=true;
                rowset.setConcurrency(ResultSet.CONCUR_READ_ONLY);
            }

            if (JDBCUserName != null)
                rowset.setUsername(JDBCUserName);

            if (JDBCPassword != null)
                rowset.setPassword(JDBCPassword);

            if (bRetryCommand)
                setSQLCommand(SQLCommand);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection()
    {
        return this.conn;
    }

    public boolean execute() {
        try {
            rowset.execute();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    public boolean next() {
        try {
            if (rowset.isLast() == false)
            {
                rowset.next();
            }
            else
               rowset.last();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    public boolean previous() {
        try {
            if (rowset.isFirst() == false)
                rowset.previous();
            else
               rowset.first();

        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    public boolean first() {
        try {
            rowset.first();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    public boolean update() {
        try {
            rowset.updateRow();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    public boolean insert() {
        try {
            rowset.insertRow();
            rowset.moveToCurrentRow();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    public boolean delete() {
        try {
            int answer = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this record?", "Delete Present Record", JOptionPane.YES_NO_OPTION);
            if (answer != JOptionPane.YES_OPTION)
                return false;
            rowset.deleteRow();
            if (!rowset.next())
                rowset.last();
        } catch (Exception e) {                                               
            e.printStackTrace();
            return false;
        }

        return true;
    }

    public boolean last() {
        try {
            rowset.last();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    public boolean clear() {
        // There is a better way.....
        try {
            rowset.beforeFirst();
            rowset.moveToInsertRow();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

     public String getStringValue(String _columnName) {
        String strValue = "";
        try {
            if(rowset.isBeforeFirst() || rowset.isAfterLast())
                return null;
            int type = rowset.getMetaData().getColumnType(rowset.findColumn(_columnName));
            switch(type){
                case Types.DATE:
                    //Calendar calendar = Calendar.getInstance();
                    //calendar.setTime(_rs.getDate(_columnName));
                    SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
                    //dateFormat.setCalendar(calendar);
                    //strValue = dateFormat.toLocalizedPattern();
                    strValue = dateFormat.format(rowset.getDate(_columnName));
                break;
                default:
                    strValue = rowset.getString(_columnName);
                break;
            }
        } catch(SQLException se) {
            se.printStackTrace();
        }
        return strValue;
    }

    public ArrayList getFieldNames() {
        ArrayList fieldList = new ArrayList();

        if (rowset != null) {
            try {
                ResultSetMetaData mt = rowset.getMetaData();
                columnCount = mt.getColumnCount();

                for (int i = 1; i <= columnCount; i++) {
                    fieldList.add(mt.getColumnName(i));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fieldList;
    }

    public ArrayList getTableNames()
    {
        ArrayList tableList = new ArrayList();

         try
         {
             if(conn!=null)
             {
                // Gets the database metadata
                DatabaseMetaData dbmd = conn.getMetaData();

                // Specify the type of object; in this case we want tables
                String[] types = {"TABLE"};
                ResultSet resultSet = dbmd.getTables(null, null, "%", types);


                // Get the table names
                while (resultSet.next()) {
                    // Get the table name
                    String tableName = resultSet.getString(3);

                    // Get the table's catalog and schema names (if any)
                    String tableCatalog = resultSet.getString(1);
                    String tableSchema = resultSet.getString(2);
                    tableList.add(tableName);
                }
            }
         }
        catch (SQLException e)
        {
         e.printStackTrace();
        }

        return tableList;
    }
}

