/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* $Header: /cvs/v2006_cdnew/aba/java/src/ch/abacus/lib/ui/renderer/programmableCompiler/CustomClassLoader.java,v 1.6 2004/08/31 16:25:50 gouker Exp $
 * $Log: CustomClassLoader.java,v $
 * Revision 1.6  2004/08/31 16:25:50  gouker
 * Changes for optimization.  Droplet code generator changes.
 * This code still has some debugging that must be removed.
 *
 * Revision 1.5  2003/12/12 16:26:56  gouker
 * Moved source code from design cockpit to renderer
 * Merged in all 11/30 fixes for resource losses
 * Added metadata dispenser
 *
 * Revision 1.1  2003/07/02 18:53:18  gouker
 * Design Cockpit - New check in after refactoring.  In progress still so don't even try to build yet.
 *
 * Thanks!
 *
 * Revision 1.1  2003/03/24 14:59:57  gouker
 * First time checking in design cockpit.  This time it allows renderer.
 *
 * Revision 1.1  1998/11/06 10:37:03  graham
 * Initial revision
 *
 * Revision 1.2  1998/07/17 09:00:00  graham
 * Supports compiling to files, bytes or classes.
 *
 * Revision 1.1  1998/01/07 10:00:00  graham
 * Initial revision
 *
 */

/* Copyright (C) 1998 Graham Kirby
 *
 * This library is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
 *
 * To receive a copy of the GNU Library General Public License, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

package ch.abacus.lib.ui.renderer.programmableCompiler;

import java.util.Hashtable;

/**
 * Loads classes using a specified <A HREF="ClassByteLoader.html">ClassByteLoader</A> instance to map
 * class names to the corresponding bytes.<P>
 *
 * The <A HREF="../../compiler/CustomClassLoader.java">source code</A> is available.
 *
 * @author	Graham Kirby (<A HREF="mailto:graham@dcs.st-and.ac.uk">graham@dcs.st-and.ac.uk</A>)
 * @version 1.2 2-Nov-98
 */
public class CustomClassLoader extends ClassLoader {

    /**
     * Hash table memorising loaded classes.
     */
    private Hashtable hashtable;

    /**
     * Object used to map class names to byte codes.
     */
    private ClassByteLoader classByteLoader;

    /**
     * Custom class loader. It attempts to load classes by trying the following steps in turn:<P>
     *
     * <OL>
     *   <LI>looks for a version already loaded by the VM
     *   <LI>looks for a version already loaded by this class loader
     *   <LI>delegates to the specified <A HREF="ClassByteLoader.html">ClassByteLoader</A> instance, throwing an exception if that fails
     * </OL>
     *
     * @param classByteLoader	used to map class names to byte codes
     */
    public CustomClassLoader(ClassByteLoader classByteLoader) {

        this.classByteLoader = classByteLoader;
        hashtable = new Hashtable();
    }

    /**
     * Attempts to load the named class.
     *
     * @param name		the name of the class to be loaded
     * @param resolve	flag specifying whether referenced classes should be resolved
     * @return			the loaded class
     * @exception		ClassNotFoundException	if the class cannot be loaded
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {

        Class resultClass;

        try {

            // Attempt to access an already loaded version of the class.
            resultClass = findSystemClass(name);
        } catch (Exception e1) {

            // Check whether the class has been loaded previously by this class loader.
            Object lookup = hashtable.get(name);

            // If so, return the class from the hash table.
            if (lookup != null)
                resultClass = (Class) lookup;
            else {
                try {

                    // Read the bytes from the appropriate .class file.
                    byte[] classBytes = classByteLoader.get(name);

                    // Throw exception if the class byte loader failed to load the bytes.
                    if (classBytes == null) throw new ClassNotFoundException("ClassByteLoader.get returned null for class " + name);

                    // Convert the array to a class.
                    resultClass = defineClass(name, classBytes, 0, classBytes.length);
                } catch (ClassFormatError e2) {
                    throw new ClassNotFoundException("format of class file incorrect for class " + name + ": " + e2.getMessage());
                }
            }
        }

        // Resolve the class if necessary.
        if (resolve) resolveClass(resultClass);

        // Memorise the class for any further loading attempts.
        hashtable.put(name, resultClass);

        return resultClass;
    }
}
