// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;
import electric.util.*;

/**
 * <tt>AttlistDecl</tt> represents an XML ATTLIST declaration.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class AttlistDecl extends Child
  {
  static final String START = "<!ATTLIST";
  static final String STOP = ">";

  private String content;

  // ********** CONSTRUCTION ************************************************

  /**
   * Construct an AttlistDecl with the specified content.
   * @param content The content.
   */
  public AttlistDecl( String content )
    {
    this.content = content;
    }

  /**
   * Construct a copy of the specified AttlistDecl.
   * @param attlistDecl The AttlistDecl to copy.
   */
  public AttlistDecl( AttlistDecl attlistDecl )
    {
    this.content = attlistDecl.content;
    }

  /**
   * Construct an AttlistDecl from the specified lexical analyzer.
   * @param lex The lexical analyzer.
   * @param parent The parent of this AttlistDecl.
   * @throws IOException If an error occurs during parsing.
   */
  AttlistDecl( Lex lex, Parent parent )
    throws IOException
    {
    super( parent );
    lex.skip( START.length() );
    String token = lex.readToPattern( STOP, Lex.CONSUME | Lex.INCLUDE | Lex.QUOTES );
    content = token.substring( 0, token.length() - STOP.length() );
    }

  // ********** CLONING *****************************************************

  /**
   * Return a clone of this AttlistDecl.
   */
  public Object clone()
    {
    return new AttlistDecl( this );
    }

  // ********** CONTENT *****************************************************

  /**
   * Return my content.
   */
  public String getContent()
    {
    return content;
    }

  /**
   * Set my content.
   * @param content The new content value.
   */
  public void setContent( String content )
    {
    this.content = content;
    }

  // ********** WRITING *****************************************************

  /**
   * Write myself to the specified writer.
   * @param writer The nodeWriter.
   * @throws IOException If an I/O exception occurs.
   */
  public void write( NodeWriter writer )
    throws IOException
    {
    writer.writeIndent();
    writer.write( START );
    writer.write( content );
    writer.write( STOP );
    }
  }