// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;
import electric.util.*;

/**
 * <tt>EntityDecl</tt> represents an XML ENTITY declaration.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class EntityDecl extends Child
  {
  static final String START = "<!ENTITY";
  static final String STOP = ">";

  private String content;

  // ********** CONSTRUCTION ************************************************

  /**
   * Construct an EntityDecl with the specified content.
   * @param content The content.
   */
  public EntityDecl( String content )
    {
    this.content = content;
    }

  /**
   * Construct a copy of the specified EntityDecl.
   * @param entityDecl The EntityDecl to copy.
   */
  public EntityDecl( EntityDecl entityDecl )
    {
    this.content = entityDecl.content;
    }

  /**
   * Construct an EntityDecl from the specified lexical analyzer.
   * @param lex The lexical analyzer.
   * @param parent The parent of this EntityDecl.
   * @throws IOException If an error occurs during parsing.
   */
  EntityDecl( Lex lex, Parent parent )
    throws IOException
    {
    super( parent );
    lex.skip( START.length() );
    String token = lex.readToPattern( STOP, Lex.CONSUME | Lex.INCLUDE | Lex.QUOTES );
    content = token.substring( 0, token.length() - STOP.length() );
    }

  // ********** CLONING *****************************************************

  /**
   * Return a clone of this EntityDecl.
   */
  public Object clone()
    {
    return new EntityDecl( this );
    }

  // ********** CONTENT *****************************************************

  /**
   * Return my content.
   */
  public String getContent()
    {
    return content;
    }

  /**
   * Set my content.
   * @param content The new content value.
   */
  public void setContent( String content )
    {
    this.content = content;
    }

  // ********** WRITING *****************************************************

  /**
   * Write myself to the specified writer.
   * @param writer The nodeWriter.
   * @throws IOException If an I/O exception occurs.
   */
  public void write( NodeWriter writer )
    throws IOException
    {
    writer.writeIndent();
    writer.write( START );
    writer.write( content );
    writer.write( STOP );
    }
  }