// copyright 2001-2002 by The Mind Electric

package electric.xml.io.collections.sun;

import java.io.*;
import com.sun.java.util.collections.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.schema.*;
import electric.util.Value;

/**
 * <tt>LinkedListType</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class LinkedListType extends CollectionType
  {
  // ********** SCHEMA ******************************************************

  /**
   * @param schema
   * @throws SchemaException
   */
  public void writeSchema( Element schema )
    throws SchemaException
    {
    Type type = getType( OBJECT_ARRAY_CLASS );
    String xsdPrefix = Namespaces.getPrefix( schema, SchemaProperties.getDefaultSchema() , "xsd" );

    Element complexType = schema.addElement( xsdPrefix, "complexType" );
    complexType.setAttribute( "name", "SunLinkedList" );
    Element sequence = complexType.addElement( xsdPrefix, "sequence" );

    Element objects = sequence.addElement( xsdPrefix, "element" );
    objects.setAttribute( "name", "elements" );
    objects.setAttribute( "type", getName( type.getNamespace(), type.getName(), objects ) );
    }

  // ********** XML SERIALIZATION *******************************************

  /**
   * @param writer
   * @param object
   * @throws IOException
   */
  public void writeObject( IWriter writer, Object object )
    throws IOException
    {
    writeArray( writer, "elements", ((LinkedList) object).toArray() );
    }

  /**
   * @param reader
   * @param value
   * @throws IOException
   */
  public void readObject( IReader reader, Value value )
    throws IOException
    {
    LinkedList linkedList = (LinkedList) value.getObject();

    if( linkedList == null )
      {
      linkedList = new LinkedList();
      value.setObject( linkedList );
      }

    Object[] array = readArray( reader, "elements" );

    for( int i = 0; i < array.length; i++ )
      linkedList.add( array[ i ] );
    }
  }