// copyright 2001-2002 by The Mind Electric
// based on source code contributed by the jaxen group, http://www.jaxen.org

package electric.xml.jaxen;

import org.jaxen.*;
import java.util.*;
import electric.xml.*;

/**
 * <tt>JaxenXPath</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class JaxenXPath extends BaseXPath implements IXPath
  {
  // ********** CONSTRUCTION ************************************************

  /**
   * @param xpathExpr
   * @throws JaxenException
   */
  public JaxenXPath( String xpathExpr )
    throws JaxenException
    {
    super( xpathExpr, DocumentNavigator.getInstance() );
    }

  // ********** IXPATH METHODS **********************************************

  /**
   * @param element
   * @throws XPathException
   */
  public Attributes getAttributes( Element element )
    throws XPathException
    {
    try
      {
      List list = selectNodes( element );
      NodeList nodeList = new NodeList();

      for( Iterator iterator = list.iterator(); iterator.hasNext(); )
        nodeList.append( new Selection( (Attribute) iterator.next() ) );

      return new Attributes( nodeList );
      }
    catch( JaxenException exception )
      {
      throw new XPathException( exception.toString() );
      }
    }

  /**
   * @param element
   * @throws XPathException
   */
  public Attribute getAttribute( Element element )
    throws XPathException
    {
    try
      {
      return (Attribute) selectSingleNode( element );
      }
    catch( JaxenException exception )
      {
      throw new XPathException( exception.toString() );
      }
    }

  /**
   * @param parent
   * @throws XPathException
   */
  public Elements getElements( Parent parent )
    throws XPathException
    {
    try
      {
      List list = selectNodes( parent );
      NodeList nodeList = new NodeList();

      for( Iterator iterator = list.iterator(); iterator.hasNext(); )
        nodeList.append( new Selection( (Element) iterator.next() ) );

      return new Elements( nodeList );
      }
    catch( JaxenException exception )
      {
      throw new XPathException( exception.toString() );
      }
    }

  /**
   * @param parent
   * @throws XPathException
   */
  public Element getElement( Parent parent )
    throws XPathException
    {
    try
      {
      return (Element) selectSingleNode( parent );
      }
    catch( JaxenException exception )
      {
      throw new XPathException( exception.toString() );
      }
    }

  /**
   * @param prefix
   * @param namespace
   * @throws XPathException
   */
  public void setNamespace( String prefix, String namespace )
    throws XPathException
    {
    try
      {
      addNamespace( prefix, namespace );
      }
    catch( JaxenException exception )
      {
      throw new XPathException( exception.toString() );
      }
    }
  }