// copyright 2001-2002 by The Mind Electric

package electric.xml.sax;

import org.xml.sax.*;
import electric.util.*;

/**
 * <tt>SAXScope</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final class SAXScope
  {
  SAXScope parent;
  String[][] namespaces = null;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param parent
   */
  SAXScope( SAXScope parent )
    {
    this.parent = parent;
    }

  // ********** NAMESPACES **************************************************

  /**
   * @param prefix
   * @param uri
   */
  void setNamespace( String prefix, String uri )
    {
    if( namespaces == null )
      namespaces = new String[][]{ { prefix, uri } };
    else
      namespaces = (String[][]) ArrayUtil.addElement( namespaces, new String[]{ prefix, uri } );
    }

  /**
   * @param prefix
   */
  String getNamespace( String prefix )
    {
    if( namespaces != null )
      for( int i = 0; i < namespaces.length; i++ )
        if( namespaces[ i ][ 0 ].equals( prefix ) )
          return namespaces[ i ][ 1 ];

    if( parent != null )
      return parent.getNamespace( prefix );
    else
      return null;
    }
  }