// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import electric.xml.*;

/**
 * <tt>NameNode</tt> processes XPath "name" sub-expressions.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class NameNode extends XPathNode
  {
  protected String prefix;
  protected String name;

  // ********** CONSTRUCTION ************************************************

  /**
   *
   */
  public NameNode()
    {
    }

  /**
   * @param name
   * @throws XPathException
   */
  public NameNode( String name )
    throws XPathException
    {
    setName( name );
    }

  // ********** NAME ********************************************************

  /**
   * @param name
   * @throws XPathException
   */
  public void setName( String name )
    throws XPathException
    {
    int colon = name.lastIndexOf( ':' );

    if( colon != -1 )
      {
      this.prefix = name.substring( 0, colon );
      this.name = name.substring( colon + 1 );
      }
    else
      {
      this.name = name;
      }
    }

  /**
   * @param xpath
   * @param node
   * @throws XPathException
   */
  public String getNamespace( TMEXPath xpath, Node node )
    throws XPathException
    {
    if( prefix == null )
      return null;

    INamespaceContext namespaceContext = xpath.getNamespaceContext();
    String namespace = null;

    if( namespaceContext != null )
      namespace = namespaceContext.getNamespace( prefix );
    else
      namespace = ((Parent) node).getNamespace( prefix );

    if( namespace == null )
      throw new XPathException( "cannot resolve " + xpath + ", no namespace for prefix " + prefix );

    return namespace;
    }

  // ********** MATCHING ****************************************************

  /**
   * @param xpath
   * @param node
   * @param list
   * @throws XPathException
   */
  public void addNodes( TMEXPath xpath, Node node, NodeList list )
    throws XPathException
    {
    addNextNodes( xpath, ((Parent) node).getElements( getNamespace( xpath, node ), name ), list );
    }
  }