/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.HammerImageIconFactory;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.designcockpit.ide.IDEProjectTool;

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class LizardClassDetailViewer extends JAPanel {
    public LizardClassNameViewer theClassNameViewer = null;
    public LizardClassMemberDataViewer theMemberDataViewer = null;
    public LizardClassMethodViewer theMethodViewer = null;
    public LizardClassPropertyViewer thePropertyViewer = null;
    public LizardClassCodeGeneratorViewer theCodeGeneratorViewer = null;
    MetaClass theMetaClass = null;
    MetadataDispenser theMetadataDispenser;
    protected JToolBar theToolBar;
    protected SuperDesignCockpit theDesignCockpit = null;
    protected HammerImageIconFactory theIconFactory = null;
    protected JPanel currPanel = null;

    public LizardClassDetailViewer(MetaClass objMetaClass, MetadataDispenser theMetadataDispenser ,SuperDesignCockpit theCockpit) {
        theMetaClass = objMetaClass;
        this.theMetadataDispenser = theMetadataDispenser;
        this.theDesignCockpit = theCockpit;
        AnchoringLayoutManager layoutManagerJAFrameXSubclass0Subclass01 = new AnchoringLayoutManager();
        setLayout(layoutManagerJAFrameXSubclass0Subclass01);

        // Make the tab pages.
        theClassNameViewer = new LizardClassNameViewer(theMetaClass);
        theMemberDataViewer = new LizardClassMemberDataViewer(theMetaClass, theMetadataDispenser);
        theMethodViewer = new LizardClassMethodViewer(theMetaClass, theMetadataDispenser);
        thePropertyViewer = new LizardClassPropertyViewer(theMetaClass, theMetadataDispenser);
        theCodeGeneratorViewer = new LizardClassCodeGeneratorViewer(theMetaClass, theMetadataDispenser);
        theToolBar   = new JToolBar(JToolBar.VERTICAL);
        theIconFactory = new HammerImageIconFactory(theDesignCockpit.theClassLoader);


        Border loweredetched = BorderFactory.createEtchedBorder();

        theClassNameViewer.setVisible(true);
        theMemberDataViewer.setVisible(false);
        theMethodViewer.setVisible(false);
        thePropertyViewer.setVisible(false);
        theCodeGeneratorViewer.setVisible(false);
        theToolBar.setLocation(0, 0);
        theToolBar.setSize(100,400);

        // Enable rollover mode
        theToolBar.setRollover(true);
        theToolBar.setBorderPainted(true);
        theToolBar.setFloatable(false);
        addButtons();
        JAScrollPane listSettings = new JAScrollPane(theToolBar);
        listSettings.setLocation(0,0);
        listSettings.setSize(100,400);
        listSettings.setFocusable(true);
        listSettings.setBackground(this.getBackground());
        listSettings.setBorder(loweredetched);
        this.add( "List Panels",listSettings);
        this.add("theCodeGeneratorViewer",theCodeGeneratorViewer);
        this.add("Identification", theClassNameViewer);
        this.add("Member Data", theMemberDataViewer);
        this.add("Methods", theMethodViewer);
        this.add("Properties", thePropertyViewer);
        this.add("Code Generator", theCodeGeneratorViewer);
        listSettings.setBackground(theToolBar.getBackground());

        this.currPanel = theClassNameViewer;
        // Add the tab page listener
        //addChangeListener(new LizardTabbedPaneListener());
    }

    protected void addButtons()
    {
        JButton c1 = new JButton(this.theDesignCockpit.impClassNameSetIcon);
        c1.setText("<html>" + "Identification"  + "</html>");
        c1.setMargin(new Insets(0, 0, 0, 0));
        c1.setSize(90,90);
        c1.setVerticalTextPosition(AbstractButton.BOTTOM);
        c1.setHorizontalTextPosition(AbstractButton.CENTER);
        c1.addActionListener(new LizardClassDetailViewer.ToolBarListener(this));
        theToolBar.add(c1);


        // Add a toggle button; remove the label and margin before adding
        JButton c2 = new JButton(this.theDesignCockpit.impMemberDataSetIcon);
        c2.setText("<html>" + "Member " + "<br>" + "Data" + "</html>");
        c2.setMargin(new Insets(0, 0, 0, 0));
        c2.setSize(90,90);
        c2.setVerticalTextPosition(AbstractButton.BOTTOM);
        c2.setHorizontalTextPosition(AbstractButton.CENTER);
        c2.addActionListener(new LizardClassDetailViewer.ToolBarListener(this));
        theToolBar.add(c2);

        // Add a button to the toolbar; remove the label and margin before adding
        JButton c3 = new JButton(this.theDesignCockpit.impMethodSetIcon);
        c3.setText("<html>" + "Methods" + "</html>");
        c3.setMargin(new Insets(0, 0, 0, 0));
        c3.setSize(90,90);
        c3.setVerticalTextPosition(AbstractButton.BOTTOM);
        c3.setHorizontalTextPosition(AbstractButton.CENTER);
        c3.addActionListener(new LizardClassDetailViewer.ToolBarListener(this));
        theToolBar.add(c3);
        // Add a button to the toolbar; remove the label and margin before adding

        JButton c4 = new JButton(this.theDesignCockpit.impPropertySetIcon);
        c4.setText("<html>" + "Properties" + "</html>");
        c4.setMargin(new Insets(0, 0, 0, 0));
        c4.setSize(90,90);
        c4.setVerticalTextPosition(AbstractButton.BOTTOM);
        c4.setHorizontalTextPosition(AbstractButton.CENTER);
        c4.addActionListener(new LizardClassDetailViewer.ToolBarListener(this));
        theToolBar.add(c4);

        // Add a button to the toolbar; remove the label and margin before adding
        JButton c5 = new JButton(this.theDesignCockpit.impCodeGenSetIcon);
        c5.setText("<html>" + "Code"+ "<br>" + "Generator"  + "</html>");
        c5.setMargin(new Insets(0, 0, 0, 0));
        c5.setSize(90,90);
        c5.setVerticalTextPosition(AbstractButton.BOTTOM);
        c5.setHorizontalTextPosition(AbstractButton.CENTER);
        c5.addActionListener(new LizardClassDetailViewer.ToolBarListener(this));
        theToolBar.add(c5);

    }

    public void setCurrentPanel(JPanel jCurrPanel)
    {
        this.currPanel = jCurrPanel;
    }

    public JPanel getCurrentPanel()
    {
        return this.currPanel;
    }

    class ToolBarListener implements ActionListener {
        LizardClassDetailViewer theProjectTool = null;

        public ToolBarListener (LizardClassDetailViewer objProjectTool) {
            theProjectTool = objProjectTool;
        }

        public void actionPerformed(ActionEvent evt) {
            String act = evt.getActionCommand().trim();

            JPanel jCurrPanel = getCurrentPanel();
            jCurrPanel.setVisible(false);

            if (act.equals("<html>Identification</html>"))
            {
                setCurrentPanel(theClassNameViewer);
            }
            else if (act.equals("<html>Member <br>Data</html>"))
            {
                setCurrentPanel(theMemberDataViewer);
            }
            else if (act.equals("<html>Methods</html>"))
            {
                setCurrentPanel(theMethodViewer);
            }
            else if (act.equals("<html>Properties</html>"))
            {
                setCurrentPanel(thePropertyViewer);
            }
            else if (act.equals("<html>Code<br>Generator</html>"))
            {
               setCurrentPanel(theCodeGeneratorViewer);
            }

            theProjectTool.currPanel.setVisible(true);
        }
    }

}
