/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.border.Border;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.*;
import javax.swing.BorderFactory;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.designcockpit.external.IDEFocusRequester;

public class LizardClassMemberDataViewer extends ProjectToolPanel {
    MetaClass theMetaClass;
    MetadataDispenser theMetadataDispenser;
    LizardMemberDataComboBoxModel theMemberDataComboBoxModel = new LizardMemberDataComboBoxModel();
    LizardMemberDataComboBox theMemberDataName = new LizardMemberDataComboBox(theMemberDataComboBoxModel, this);
    LizardTextArea theMemberDataDocumentation = new LizardTextArea(5, 15);
    JAScrollPane scrollDoc = new JAScrollPane(theMemberDataDocumentation);
    LizardTypeComboBox theMemberDataClass = null;
    JATextField theMemberDataDefaultValue = new JATextField(20);

    JALabel JALabelX5 = new JALabel();
    JALabel JALabelX6 = new JALabel();
    JALabel JALabelX7 = new JALabel();
    JALabel JALabelX8 = new JALabel();
    JAButton theDeleteMemberDataButton = new JAButton("Delete Member Data");
    JAButton theSaveMemberDataButton = new JAButton("Save Member Data");
    ProjectToolPanelNextButtonAction theNextButtonAction = new ProjectToolPanelNextButtonAction(this);

    class KillButtonAction implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            deleteSelectedMemberData();
        }
    }


    public LizardClassMemberDataViewer(MetaClass objMetaClass, MetadataDispenser theMetadataDispenser) {
        super();

        Border loweredetched = BorderFactory.createEtchedBorder();
        Border titledDescborder =  new TitledBorder(loweredetched,"Member Data");
        this.setBorder(titledDescborder);

        theMetaClass = objMetaClass;
        this.theMetadataDispenser = theMetadataDispenser;
        theMemberDataClass = new LizardTypeComboBox(theMetadataDispenser);

        AnchoringLayoutManager layoutManagertheMemberDataViewer = new AnchoringLayoutManager();
        setLayout(layoutManagertheMemberDataViewer);
        this.setLocation(100,0);
        this.setSize(400,400);
        JALabelX5.setLocation(32, 28);
        JALabelX5.setSize(104, 24);
        JALabelX5.setText("Name");
        //  Add the control JALabelX5 to the content pane.
        add(JALabelX5, "JALabelX5");
        layoutManagertheMemberDataViewer.setAnchoring(JALabelX5, false, false, false, false);
        JALabelX6.setLocation(32, 72);
        JALabelX6.setSize(104, 24);
        JALabelX6.setText("Class");
        //  Add the control JALabelX6 to the content pane.
        add(JALabelX6, "JALabelX6");
        layoutManagertheMemberDataViewer.setAnchoring(JALabelX6, false, false, false, false);
        JALabelX7.setLocation(32, 112);
        JALabelX7.setSize(104, 24);
        JALabelX7.setText("Default Value");
        //  Add the control JALabelX7 to the content pane.
        add(JALabelX7, "JALabelX7");
        layoutManagertheMemberDataViewer.setAnchoring(JALabelX7, false, false, false, false);
        JALabelX8.setLocation(32, 160);
        JALabelX8.setSize(104, 24);
        JALabelX8.setText("Documentation");
        //  Add the control JALabelX8 to the content pane.
        add(JALabelX8, "JALabelX8");
        layoutManagertheMemberDataViewer.setAnchoring(JALabelX8, false, false, false, false);
        theMemberDataName.setLocation(32, 46);
        theMemberDataName.setSize(200, 20);
        //  Add the control theMemberDataName to the content pane.
        add(theMemberDataName, "theMemberDataName");
        layoutManagertheMemberDataViewer.setAnchoring(theMemberDataName, false, false, false, false);
        theMemberDataClass.setLocation(32, 86);
        theMemberDataClass.setSize(200, 20);
        //  Add the control theMemberDataClass to the content pane.
        add(theMemberDataClass, "theMemberDataClass");
        layoutManagertheMemberDataViewer.setAnchoring(theMemberDataClass, false, false, false, false);
        theMemberDataDefaultValue.setLocation(32, 126);
        theMemberDataDefaultValue.setSize(200, 20);
        //  Add the control theMemberDataDefaultValue to the content pane.
        add(theMemberDataDefaultValue, "theMemberDataDefaultValue");
        layoutManagertheMemberDataViewer.setAnchoring(theMemberDataDefaultValue, false, false, false, false);
        theSaveMemberDataButton.setLocation(80, 360);
        theSaveMemberDataButton.setSize(104, 48);
        theSaveMemberDataButton.setText("Save Field");
        //  Add the control theSaveMemberDataButton to the content pane.
        add(theSaveMemberDataButton, "theSaveMemberDataButton");
        layoutManagertheMemberDataViewer.setAnchoring(theSaveMemberDataButton, false, false, false, false);
        theDeleteMemberDataButton.setLocation(280, 360);
        theDeleteMemberDataButton.setSize(104, 48);
        theDeleteMemberDataButton.setText("Delete Field");
        //  Add the control theDeleteMemberDataButton to the content pane.
        add(theDeleteMemberDataButton, "theDeleteMemberDataButton");
        layoutManagertheMemberDataViewer.setAnchoring(theDeleteMemberDataButton, false, false, false, false);
        theMemberDataDocumentation.setLocation(32, 184);
        theMemberDataDocumentation.setSize(350, 160);
        //  Add the control theMemberDataDocumenation to the content pane.
        add(theMemberDataDocumentation, "theMemberDataDocumentation");
        layoutManagertheMemberDataViewer.setAnchoring(theMemberDataDocumentation, false, false, false, false);

        theMemberDataName.Load(objMetaClass);
        theDeleteMemberDataButton.addActionListener(new KillButtonAction());
        theSaveMemberDataButton.addActionListener(new ProjectToolPanelNextButtonAction(this));
    }

    public Boolean getExitingComboBox(String sText, Object objLosingFocus) {
        if (sText.trim().length() != 0) {
            // Find if this method already exists.
            MetaDataMember match = theMetaClass.getData(sText, false);
            // If not, add it.
            if (match == null) {
                Object sConfirmationText = "Do you wish to add the new member data '" + sText + "'?";
                String sConfirmationTitle = "New Member Data";
                int optionType = JOptionPane.YES_NO_OPTION;
                int messageType = JOptionPane.QUESTION_MESSAGE;
                int iChoice = JOptionPane.showConfirmDialog(this, sConfirmationText,
                        sConfirmationTitle, optionType, messageType);
                if (iChoice == 0) { // yes. Add it then.
                    theMemberDataName.appendItem(sText);
                    theMemberDataClass.requestFocus();
                    IDEFocusRequester.requestFocus(theMemberDataClass);
                    // otherwise nothing gets the focus.
                    return new Boolean(true);
                } else
                    return new Boolean(false);
            }
            return new Boolean(true);
        }
        return new Boolean(true);
    }

    public void selectMemberData(MetaDataMember oldMember, MetaDataMember newMember) {
        if (oldMember != null) {
            String sTypeName = (String) theMemberDataClass.getSelectedItem();
            if ((sTypeName.equals("String")) || (sTypeName.equals("int")) ||
                    (sTypeName.equals("boolean")) || (sTypeName.equals("char")) ||
                    (sTypeName.equals("short")) || (sTypeName.equals("long")) ||
                    (sTypeName.equals("byte")) || (sTypeName.equals("float")) ||
                    (sTypeName.equals("double"))) {
                oldMember.setTypeName(sTypeName);
                oldMember.setClassName("");
            } else {
                oldMember.setTypeName("Class");
                oldMember.setTypeName(sTypeName);
            }
            oldMember.setValue(theMemberDataDefaultValue.getText());
            oldMember.setDoc(theMemberDataDocumentation.getText());
        }
        theMemberDataClass.setSelectedItem(newMember.getTypeName());
        theMemberDataDefaultValue.setText(newMember.getValue());
        theMemberDataDocumentation.setText(newMember.getDoc());
        theMemberDataName.setSelectedItem(newMember.getDataName());
    }

    public void selectMemberData(String sMemberData) {
        MetaDataMember newMemberData = theMetaClass.getData(sMemberData, false);
        selectMemberData(null, newMemberData);
    }

    public void deleteSelectedMemberData() {
        String sDataName = (String) theMemberDataName.getSelectedItem();
        theMetaClass.getMetadata().removeData(sDataName);
        Reset();
        theMemberDataName.Reload(theMetaClass);
        theMemberDataName.setSelectedItem("");
        theMemberDataName.resetEditor();
    }

    public void SaveAndClear() {
        MetaDataMember theMember = theMemberDataName.theMemberData;
        if (theMember != null) {
            theMember.setTypeName((String) theMemberDataClass.getSelectedItem());
            theMember.setValue(theMemberDataDefaultValue.getText());
            theMember.setDoc(theMemberDataDocumentation.getText());
        }
        theMemberDataName.theMemberData = null;
        Reset();
        theMemberDataName.Reload(theMetaClass);
    }

    public void Reset() {
        theMemberDataName.setSelectedItem("");
        theMemberDataClass.setSelectedItem("");
        theMemberDataDocumentation.setText("");
        theMemberDataDefaultValue.setText("");
        theMemberDataName.resetEditor();
    }
}
