/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.designcockpit.external.IDEFocusRequester;

import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class LizardClassPropertyViewer extends ProjectToolPanel {
    MetaClass theMetaClass;
    LizardPropertyComboBoxModel thePropertyComboBoxModel = new LizardPropertyComboBoxModel();
    MetadataDispenser theMetadataDispenser;
    protected LizardPropertyComboBox thePropertyName;
    protected JALabel JALabelX14 = new JALabel();
    protected LizardTypeComboBox thePropertyClass;
    protected JATabbedPane thePropertyDetailTabbedPane = new JATabbedPane();
    protected JAPanel thePropertyValueChoicesTab = new JAPanel();
    protected JAButton thePropertyValueDeleteButton = new JAButton();
    protected JAPanel thePropertyCodeGenerationTab = new JAPanel();
    protected LizardBooleanButton thePropertyDisplayCheckbox = new LizardBooleanButton("Display?", false);
    protected LizardBooleanButton thePropertyAutoGenerateCheckbox = new LizardBooleanButton("Auto Generate?", true);
    protected LizardBooleanButton thePropertyArrayCheckbox = new LizardBooleanButton("Array?", false);
    protected LizardBooleanButton thePropertyLanguageCheckbox = new LizardBooleanButton("Languages?", false);
    protected JAPanel thePropertyMethodsTab = new JAPanel();
    protected JATextField thePropertySetName = new JATextField();
    protected JATextField thePropertyGetName = new JATextField();
    protected JALabel JALabelX11 = new JALabel();
    protected JALabel JALabelX10 = new JALabel();
    protected JALabel JALabelX13 = new JALabel();
    protected JAPanel thePropertyDocumentationTab = new JAPanel();
    protected LizardTextArea thePropertyDocumentation = new LizardTextArea(5, 15);
    protected JAButton theSavePropertyButton = new JAButton();
    protected JAButton theDeletePropertyButton = new JAButton();
    protected JALabel JALabelX12 = new JALabel();
    protected JATextField thePropertyDefaultValue = new JATextField();

    JAScrollPane scrollDoc = new JAScrollPane(thePropertyDocumentation);
    LizardValueChoiceComboBoxModel theValueChoiceComboBoxModel;
    LizardValueChoiceComboBox thePropertyValueCombobox;

    class KillButtonAction implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            deleteSelectedProperty();
        }
    }

    class DeleteChoiceAction implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            deleteSelectedValueChoice();
        }
    }

    class PropertyViewerTabbedPaneListener implements ChangeListener {
        int selectedIndex = -1; // -1 = nothing has ever been selected.
        JATabbedPane tp;         // current pane.

        public void stateChanged(ChangeEvent evt) {
            tp = (JATabbedPane) evt.getSource();
            if ((selectedIndex == -1) || (selectedIndex != tp.getSelectedIndex())) {
                tp.setEnabledAt(tp.getSelectedIndex(), false);
                if (selectedIndex != -1)
                    tp.setEnabledAt(selectedIndex, true);
            }
            selectedIndex = tp.getSelectedIndex();
        }
    }

    public LizardClassPropertyViewer(MetaClass objMetaClass, MetadataDispenser theMetadataDispenser) {
        super();
        Border loweredetched = BorderFactory.createEtchedBorder();
        Border titledDescborder =  new TitledBorder(loweredetched,"Properties");
        this.setBorder(titledDescborder);

        this.setLocation(100,0);
        this.setSize(435,400);

        theMetaClass = objMetaClass;
        this.theMetadataDispenser = theMetadataDispenser;
        thePropertyName = new LizardPropertyComboBox(thePropertyComboBoxModel, this, theMetadataDispenser);
        thePropertyClass = new LizardTypeComboBox(theMetadataDispenser);
        thePropertyClass.addItemListener(new LizardTypeComboBoxListener(this));
        theValueChoiceComboBoxModel = new LizardValueChoiceComboBoxModel(theMetadataDispenser);
        thePropertyValueCombobox = new LizardValueChoiceComboBox(theValueChoiceComboBoxModel, // model
                theValueChoiceComboBoxModel); // receiver

        AnchoringLayoutManager layoutManagerthePropertyViewer = new AnchoringLayoutManager();
        setLayout(layoutManagerthePropertyViewer);
        //  Add the control thePropertyViewer to the Tabbed pane.
        JALabelX10.setLocation(32, 24);
        JALabelX10.setSize(136, 24);
        JALabelX10.setText("Name");
        //  Add the control JALabelX10 to the content pane.
        add(JALabelX10, "JALabelX10");
        layoutManagerthePropertyViewer.setAnchoring(JALabelX10, false, false, false, false);
        thePropertyName.setLocation(32, 46);
        thePropertyName.setSize(168, 20);
        //  Add the control thePropertyName to the content pane.
        add(thePropertyName, "thePropertyName");
        layoutManagerthePropertyViewer.setAnchoring(thePropertyName, false, false, false, false);
        JALabelX14.setLocation(32, 72);
        JALabelX14.setSize(136, 24);
        JALabelX14.setText("Class");
        //  Add the control JALabelX14 to the content pane.
        add(JALabelX14, "JALabelX14");
        layoutManagerthePropertyViewer.setAnchoring(JALabelX14, false, false, false, false);
        thePropertyClass.setLocation(32, 92);
        thePropertyClass.setSize(168, 20);
        //  Add the control thePropertyClass to the content pane.
        add(thePropertyClass, "thePropertyClass");
        layoutManagerthePropertyViewer.setAnchoring(thePropertyClass, false, false, false, false);
        thePropertyDetailTabbedPane.addChangeListener(new PropertyViewerTabbedPaneListener());
        thePropertyDetailTabbedPane.setLocation(20, 168);
        thePropertyDetailTabbedPane.setSize(400, 184);
        thePropertyDetailTabbedPane.setBorder(loweredetched);
        //  Add the control thePropertyDetailTabbedPane to the content pane.
        add(thePropertyDetailTabbedPane, "thePropertyDetailTabbedPane");
        layoutManagerthePropertyViewer.setAnchoring(thePropertyDetailTabbedPane, false, false, false, false);
        AnchoringLayoutManager layoutManagerthePropertyValueChoicesTab = new AnchoringLayoutManager();
        thePropertyValueChoicesTab.setLayout(layoutManagerthePropertyValueChoicesTab);
        thePropertyValueChoicesTab.setLocation(0, 0);
        thePropertyValueChoicesTab.setSize(336, 208);
        //  Add the control thePropertyValueChoicesTab to the Tabbed pane.
        thePropertyDetailTabbedPane.addTab("Value Choices", thePropertyValueChoicesTab);
        thePropertyValueCombobox.setLocation(48, 32);
        thePropertyValueCombobox.setSize(224, 20);
        //  Add the control thePropertyValueCombobox to the content pane.
        thePropertyValueChoicesTab.add(thePropertyValueCombobox, "thePropertyValueCombobox");
        layoutManagerthePropertyValueChoicesTab.setAnchoring(thePropertyValueCombobox, false, false, false, false);
        thePropertyValueDeleteButton.setLocation(112, 80);
        thePropertyValueDeleteButton.setSize(104, 40);
        thePropertyValueDeleteButton.setText("Delete Value");
        //  Add the control thePropertyValueDeleteButton to the content pane.
        thePropertyValueChoicesTab.add(thePropertyValueDeleteButton, "thePropertyValueDeleteButton");
        layoutManagerthePropertyValueChoicesTab.setAnchoring(thePropertyValueDeleteButton, false, false, false, false);
        AnchoringLayoutManager layoutManagerthePropertyCodeGenerationTab = new AnchoringLayoutManager();
        thePropertyCodeGenerationTab.setLayout(layoutManagerthePropertyCodeGenerationTab);
        thePropertyCodeGenerationTab.setLocation(0, 0);
        thePropertyCodeGenerationTab.setSize(336, 208);
        //  Add the control thePropertyCodeGenerationTab to the Tabbed pane.
        thePropertyDetailTabbedPane.addTab("Code Generation", thePropertyCodeGenerationTab);
        thePropertyDisplayCheckbox.setLocation(56, 16);
        thePropertyDisplayCheckbox.setSize(144, 32);
        thePropertyDisplayCheckbox.setText("Display?");
        //  Add the control thePropertyDisplayCheckbox to the content pane.
        thePropertyCodeGenerationTab.add(thePropertyDisplayCheckbox, "thePropertyDisplayCheckbox");
        layoutManagerthePropertyCodeGenerationTab.setAnchoring(thePropertyDisplayCheckbox, false, false, false, false);
        thePropertyAutoGenerateCheckbox.setLocation(56, 56);
        thePropertyAutoGenerateCheckbox.setSize(144, 28);
        thePropertyAutoGenerateCheckbox.setText("Auto Generate?");
        //  Add the control thePropertyAutoGenerateCheckbox to the content pane.
        thePropertyCodeGenerationTab.add(thePropertyAutoGenerateCheckbox, "thePropertyAutoGenerateCheckbox");
        layoutManagerthePropertyCodeGenerationTab.setAnchoring(thePropertyAutoGenerateCheckbox, false, false, false, false);

        thePropertyLanguageCheckbox.setLocation(56, 84);
        thePropertyLanguageCheckbox.setSize(144, 28);
        thePropertyLanguageCheckbox.setText("Languages?");
        //  Add the control thePropertyArrayCheckbox to the content pane.
        thePropertyCodeGenerationTab.add(thePropertyArrayCheckbox, "thePropertyLanguageCheckbox");
        layoutManagerthePropertyCodeGenerationTab.setAnchoring(thePropertyLanguageCheckbox, false, false, false, false);

        thePropertyArrayCheckbox.setLocation(56, 112);
        thePropertyArrayCheckbox.setSize(144, 24);
        thePropertyArrayCheckbox.setText("Array?");
        //  Add the control thePropertyArrayCheckbox to the content pane.
        thePropertyCodeGenerationTab.add(thePropertyArrayCheckbox, "thePropertyArrayCheckbox");
        layoutManagerthePropertyCodeGenerationTab.setAnchoring(thePropertyArrayCheckbox, false, false, false, false);
        AnchoringLayoutManager layoutManagerthePropertyMethodsTab = new AnchoringLayoutManager();
        thePropertyMethodsTab.setLayout(layoutManagerthePropertyMethodsTab);
        thePropertyMethodsTab.setLocation(0, 0);
        thePropertyMethodsTab.setSize(336, 208);
        //  Add the control thePropertyMethodsTab to the Tabbed pane.
        thePropertyDetailTabbedPane.addTab("Property Methods", thePropertyMethodsTab);
        thePropertySetName.setLocation(152, 24);
        thePropertySetName.setSize(200, 24);
        //  Add the control thePropertySetName to the content pane.
        thePropertyMethodsTab.add(thePropertySetName, "thePropertySetName");
        layoutManagerthePropertyMethodsTab.setAnchoring(thePropertySetName, false, false, false, false);
        thePropertyGetName.setLocation(152, 80);
        thePropertyGetName.setSize(192, 24);
        //  Add the control thePropertyGetName to the content pane.
        thePropertyMethodsTab.add(thePropertyGetName, "thePropertyGetName");
        layoutManagerthePropertyMethodsTab.setAnchoring(thePropertyGetName,
                false, false, false, false);
        JALabelX11.setLocation(24, 24);
        JALabelX11.setSize(104, 24);
        JALabelX11.setText("Set Name");
        //  Add the control JALabelX11 to the content pane.
        thePropertyMethodsTab.add(JALabelX11, "JALabelX11");
        layoutManagerthePropertyMethodsTab.setAnchoring(JALabelX11, false,
                false, false, false);
        JALabelX13.setLocation(22, 82);
        JALabelX13.setSize(104, 24);
        JALabelX13.setText("Get Name");
        //  Add the control JALabelX13 to the content pane.
        thePropertyMethodsTab.add(JALabelX13, "JALabelX13");
        layoutManagerthePropertyMethodsTab.setAnchoring(JALabelX13, false,
                false, false, false);
        AnchoringLayoutManager layoutManagerthePropertyDocumentationTab = new AnchoringLayoutManager();
        thePropertyDocumentationTab.setLayout(layoutManagerthePropertyDocumentationTab);
        thePropertyDocumentationTab.setLocation(0, 0);
        thePropertyDocumentationTab.setSize(336, 208);
        //  Add the control thePropertyDocumentationTab to the Tabbed pane.
        thePropertyDetailTabbedPane.addTab("Documentation", thePropertyDocumentationTab);
        thePropertyDocumentation.setLocation(0, 0);
        thePropertyDocumentation.setSize(392, 200);
        //  Add the control thePropertyDocumentation to the content pane.
        thePropertyDocumentationTab.add(thePropertyDocumentation, "thePropertyDocumentation");
        layoutManagerthePropertyDocumentationTab.setAnchoring(thePropertyDocumentation, false, false, false, false);
        theSavePropertyButton.setLocation(88, 368);
        theSavePropertyButton.setSize(104, 40);
        theSavePropertyButton.setText("Save Property");
        //  Add the control theSavePropertyButton to the content pane.
        add(theSavePropertyButton, "theSavePropertyButton");
        layoutManagerthePropertyViewer.setAnchoring(theSavePropertyButton, false, false, false, false);
        theDeletePropertyButton.setLocation(240, 368);
        theDeletePropertyButton.setSize(112, 40);
        theDeletePropertyButton.setText("Delete Property");
        //  Add the control theDeletePropertyButton to the content pane.
        add(theDeletePropertyButton, "theDeletePropertyButton");
        layoutManagerthePropertyViewer.setAnchoring(theDeletePropertyButton, false, false, false, false);
        JALabelX12.setLocation(32, 120);
        JALabelX12.setSize(136, 24);
        JALabelX12.setText("Default Value");
        //  Add the control JALabelX12 to the content pane.
        add(JALabelX12, "JALabelX12");
        layoutManagerthePropertyViewer.setAnchoring(JALabelX12, false, false, false, false);
        thePropertyDefaultValue.setLocation(32, 140);
        thePropertyDefaultValue.setSize(200, 20);
        //  Add the control thePropertyDefaultValue to the content pane.
        add(thePropertyDefaultValue, "thePropertyDefaultValue");
        layoutManagerthePropertyViewer.setAnchoring(thePropertyDefaultValue,
                false, false, false, false);

//      thePropertyDocumentation.setRows(5);
//      thePropertyDocumentation.setColumns(30);
//      thePropertyDocumentation.setPane(scrollDoc);
//      thePropertyDocumentation.fixupSize();
//      add(scrollDoc, 1, 9, 8, 6);

        thePropertyName.Load(objMetaClass);
        theDeletePropertyButton.addActionListener(new KillButtonAction());
        theSavePropertyButton.addActionListener(new ProjectToolPanelNextButtonAction(this));
        thePropertyValueDeleteButton.addActionListener(new DeleteChoiceAction());
    }

    public void typeChanged(String sNewType) {
        String sPropertyName = (String) thePropertyName.getSelectedItem();
        if ((sPropertyName != null) && (sPropertyName.trim().length() != 0)) {
            sPropertyName = sPropertyName.trim();
            MetaPropertyDescriptor match = theMetaClass.getProperty(sPropertyName, false);
            if ((sNewType != null) && (sNewType.trim().length() != 0))
                match.setClassName(sNewType);
            // enforce bean rule.
            if (!sNewType.equals("boolean")) {
                String sMethodName = thePropertyGetName.getText();
                if (sMethodName.equals("is" + sPropertyName))
                    thePropertyGetName.setText("get" + sPropertyName);
            }
        }
    }

    public Boolean getExitingComboBox(String sText, Object objLosingFocus) {
        if (sText.trim().length() != 0) {
            // Find if this method already exists.
            MetaPropertyDescriptor match = theMetaClass.getProperty(sText, false);
            // If not, add it.
            if (match == null) {
                Object sConfirmationText = "Do you wish to add the new property '" + sText + "'?";
                String sConfirmationTitle = "New Property";
                int optionType = JOptionPane.YES_NO_OPTION;
                int messageType = JOptionPane.QUESTION_MESSAGE;
                int iChoice = JOptionPane.showConfirmDialog(this, sConfirmationText,
                        sConfirmationTitle, optionType, messageType);
                if (iChoice == 0) { // yes. Add it then.
                    thePropertyName.appendItem(sText);
                    thePropertySetName.setText("set" + sText);
                    thePropertyGetName.setText("is" + sText);
                    thePropertyClass.setSelectedIndex(0);
                    IDEFocusRequester.requestFocus(thePropertyClass);
                    // otherwise nothing gets the focus.
                    thePropertyArrayCheckbox.setSelected(false);
                    thePropertyAutoGenerateCheckbox.setSelected(true);
                    thePropertyDisplayCheckbox.setSelected(false);
                    return new Boolean(true);
                } else
                    return new Boolean(false);
            }
            return new Boolean(true);
        }
        return new Boolean(true);
    }

    public void selectProperty(MetaPropertyDescriptor oldProperty, MetaPropertyDescriptor newProperty) {
        if (oldProperty != null) {
            oldProperty.setClassName((String) thePropertyClass.getSelectedItem());
            oldProperty.setDefaultValue(theMetadataDispenser, theMetaClass.getMetadata(),thePropertyDefaultValue.getText());
            oldProperty.setDoc(thePropertyDocumentation.getText());
            oldProperty.bVisible = thePropertyDisplayCheckbox.isSelected();
            oldProperty.bGenerate = thePropertyAutoGenerateCheckbox.isSelected();
            oldProperty.bAllowMultipleValues = thePropertyArrayCheckbox.isSelected();
            oldProperty.bAllowMultipleLanguages = thePropertyLanguageCheckbox.isSelected();
            oldProperty.setSetMethod(thePropertySetName.getText());
            oldProperty.setGetMethod(thePropertyGetName.getText());
        }
        thePropertyClass.setSelectedItem(newProperty.getClassName());
        thePropertyValueCombobox.Load(newProperty);
        thePropertyDocumentation.setText(newProperty.getDoc());

        thePropertySetName.setText(newProperty.getSetMethod());
        thePropertyGetName.setText(newProperty.getGetMethod());

        thePropertyAutoGenerateCheckbox.setSelected(newProperty.bGenerate);
        thePropertyArrayCheckbox.setSelected(newProperty.bAllowMultipleValues);
        thePropertyLanguageCheckbox.setSelected(newProperty.bAllowMultipleLanguages);
        thePropertyDisplayCheckbox.setSelected(newProperty.bVisible);
        thePropertyName.setSelectedItem(newProperty.getName());
        thePropertyDefaultValue.setText(newProperty.getDefaultValue());
    }

    public void selectProperty(String sProperty) {
        MetaPropertyDescriptor newProperty = theMetaClass.getProperty(sProperty, false);
        selectProperty(null, newProperty);
    }

    public void deleteSelectedProperty() {
        String sPropertyName = (String) thePropertyName.getSelectedItem();
        theMetaClass.getMetadata().removeProperty(sPropertyName);
        Reset();
        thePropertyName.Reload(theMetaClass);
        thePropertyName.setSelectedItem("");
        thePropertyName.resetEditor();
    }

    public void deleteSelectedValueChoice() {
        String sValueChoiceName = (String) thePropertyValueCombobox.getSelectedItem();
        String sPropertyName = (String) thePropertyName.getSelectedItem();
        MetaPropertyDescriptor theProperty = theMetaClass.getMetadata().getProperty(sPropertyName);
        if ((theProperty != null) && (sPropertyName != null) && (sPropertyName.trim().length() != 0)) {
            theProperty.removeValueChoice(sValueChoiceName);
            thePropertyValueCombobox.Reload(theProperty);
            thePropertyValueCombobox.setSelectedItem("");
        }
    }

    public void SaveAndClear() {
        MetaPropertyDescriptor theProperty = thePropertyName.theProperty;
        if (theProperty != null) {
            theProperty.setClassName((String) thePropertyClass.getSelectedItem());
            theProperty.setDefaultValue(theMetadataDispenser, theMetaClass.getMetadata(), thePropertyDefaultValue.getText());
            theProperty.setDoc(thePropertyDocumentation.getText());
            theProperty.bVisible = thePropertyDisplayCheckbox.isSelected();
            theProperty.bAllowMultipleValues = thePropertyArrayCheckbox.isSelected();
            theProperty.bAllowMultipleLanguages = thePropertyLanguageCheckbox.isSelected();
            theProperty.bGenerate = thePropertyAutoGenerateCheckbox.isSelected();
            theProperty.setSetMethod(thePropertySetName.getText());
            theProperty.setGetMethod(thePropertyGetName.getText());
        }
        thePropertyName.theProperty = null;
        Reset();
        thePropertyName.Reload(theMetaClass);
        thePropertyName.setSelectedItem("");
        thePropertyName.resetEditor();
    }

    public void Reset() {
        thePropertyName.setSelectedItem("");  // Must be first.
        thePropertyDefaultValue.setText("");
        thePropertyClass.setSelectedItem("");
        thePropertyDocumentation.setText("");
        thePropertyName.resetEditor();
        thePropertySetName.setText("");
        thePropertyGetName.setText("");
        thePropertyDisplayCheckbox.Reset();
        thePropertyAutoGenerateCheckbox.Reset();
        thePropertyArrayCheckbox.Reset();
        thePropertyName.resetEditor();
    }
}
