/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;

import javax.swing.*;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 10:06:34 PM
 * To change this template use Options | File Templates.
 */
class LizardPropertyListModel extends AbstractListModel {
    MetaClass theMetaClass = null;
    MetaPropertyDescriptor[] theProperties = null;

    public LizardPropertyListModel() {
    }

    public Object getElementAt(int iIndex) {
        if ((theProperties != null) && (theProperties[iIndex] != null))
            return theProperties[iIndex].getName();
        else
            return null;
    }

    public int getSize() {
        int iSize = 0;
        if ((theMetaClass != null) && (theMetaClass.getMetadata() != null))
            iSize = theMetaClass.getMetadata().iNumberOfProperties;
        return iSize;
    }

    public void Load(MetaClass someMetaClass) {
        int i = 0;
        theMetaClass = someMetaClass;
        // doesn't inherit properties!
        if (theMetaClass.getMetadata().iNumberOfProperties != 0) {
            theProperties = new MetaPropertyDescriptor[theMetaClass.getMetadata().iNumberOfProperties];
            MetaPropertyDescriptor theProperty = someMetaClass.getMetadata().theFirstProperty;
            while (theProperty != null) {
                theProperties[i++] = theProperty;
                theProperty = theProperty.getNextProperty();
            }
        }
    }
}
