/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.layout.Anchoring;

import java.awt.*;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

class DesignAnchoringComponent {
    public String name = "";
    public MetaObject theObject = null;
    public Component component = null;
    public Anchoring anchoring = null;
    public DesignAnchoringComponent nextAnchoringComponent = null;
    public DesignAnchoringComponent prevAnchoringComponent = null;

    public DesignAnchoringComponent() {
    }
}

public class DesignAnchoringLayoutManager implements LayoutManager {
    DesignAnchoringComponent firstAnchoringComponent = null;
    DesignAnchoringComponent lastAnchoringComponent = null;
    private static final int PREFERRED = 0;
    private static final int MINIMUM = 1;
    public int width;
    public int height;
    SuperDesignCockpit theDesignCockpit = null;
    MetaObject theContainer = null;
    public boolean bAnchoringEnabled = true; // this is used to switch off anchoring during operations such as mouse-resize

    public DesignAnchoringLayoutManager(MetaObject theContainer, SuperDesignCockpit theDesignCockpit) {
        width = -1;
        height = -1;
        this.theDesignCockpit = theDesignCockpit;
        this.theContainer = theContainer;
    }

    protected DesignAnchoringComponent findAnchoringComponent(Component comp) {
        DesignAnchoringComponent theAnchoringComponent = firstAnchoringComponent;
        while (theAnchoringComponent != null) {
            if (theAnchoringComponent.component.equals(comp))
                break;
            theAnchoringComponent = theAnchoringComponent.nextAnchoringComponent;
        }
        return theAnchoringComponent;
    }

    protected DesignAnchoringComponent findAnchoringComponent(MetaObject someObject) {
        DesignAnchoringComponent theAnchoringComponent = firstAnchoringComponent;
        while (theAnchoringComponent != null) {
            if (theAnchoringComponent.theObject.equals(someObject))
                break;
            theAnchoringComponent = theAnchoringComponent.nextAnchoringComponent;
        }
        return theAnchoringComponent;
    }

    protected DesignAnchoringComponent debugAnchoringComponent(Component comp) {
        System.err.println("Debugging anchoring layout manager for object " + theContainer.getName());
        DesignAnchoringComponent theAnchoringComponent = firstAnchoringComponent;
        if (firstAnchoringComponent != null) {
            System.err.println("The first anchoring component is " + firstAnchoringComponent.name);
            while (theAnchoringComponent != null) {
                System.err.println("Testing search component " + comp + " against " + theAnchoringComponent.component);
                if (theAnchoringComponent.component.equals(comp))
                    break;
                theAnchoringComponent = theAnchoringComponent.nextAnchoringComponent;
            }
        }
        System.err.println("Returning anchoring component " + theAnchoringComponent);
        return theAnchoringComponent;
    }

    String getName(Component comp) {
        DesignAnchoringComponent theComponent = findAnchoringComponent(comp);
        if (theComponent != null)
            return theComponent.name;
        return null;
    }

    public void addLayoutComponent(String name, Component comp) {
        DesignAnchoringComponent theComponent = findAnchoringComponent(comp);
        if (theComponent != null)  // already in the layout.
            return;
//        System.out.println("Adding component " + comp.toString() + ", Object is " + name);
        DesignAnchoringComponent theNewComponent = new DesignAnchoringComponent();
        theNewComponent.name = name;
        theNewComponent.component = comp;
        if (firstAnchoringComponent == null)
            firstAnchoringComponent = theNewComponent;
        else
            lastAnchoringComponent.nextAnchoringComponent = theNewComponent;
        theNewComponent.prevAnchoringComponent = lastAnchoringComponent;
        lastAnchoringComponent = theNewComponent;
    }

    public void setAnchoring(Component comp, MetaObject theObject, boolean left, boolean right,
                             boolean top, boolean bottom) {
        DesignAnchoringComponent theComponent = findAnchoringComponent(comp);
        if (theComponent != null) {
            Anchoring theAnchoring = new Anchoring(left, right, top, bottom);
            theComponent.anchoring = theAnchoring;
            theComponent.theObject = theObject;
        }
    }

    public void setAnchoring(Component comp, MetaObject theObject, int iAnchoring) {
        DesignAnchoringComponent theComponent = findAnchoringComponent(comp);
        if (theComponent != null) {
            Anchoring theAnchoring = new Anchoring(iAnchoring);
            theComponent.anchoring = theAnchoring;
            theComponent.theObject = theObject;
        }
    }

    public void removeLayoutComponent(Component comp) {
        DesignAnchoringComponent theComponent = findAnchoringComponent(comp);
        if (theComponent != null) {
//            System.out.println("Removing component " + comp.toString() + ", Object is " + theComponent.theObject.getName());
            if (theComponent.equals(firstAnchoringComponent)) {
                firstAnchoringComponent = theComponent.nextAnchoringComponent;
                if (firstAnchoringComponent != null)
                    firstAnchoringComponent.prevAnchoringComponent = null;
            }
            if (theComponent.equals(lastAnchoringComponent)) {
                lastAnchoringComponent = theComponent.prevAnchoringComponent;
                if (lastAnchoringComponent != null)
                    lastAnchoringComponent.nextAnchoringComponent = null;
            }
            if (theComponent.prevAnchoringComponent != null)
                theComponent.prevAnchoringComponent.nextAnchoringComponent = theComponent.nextAnchoringComponent;
            if (theComponent.nextAnchoringComponent != null)
                theComponent.nextAnchoringComponent.prevAnchoringComponent = theComponent.prevAnchoringComponent;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return layoutSize(parent, MINIMUM);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return layoutSize(parent, PREFERRED);
    }

    public void layoutContainer(Container parent) {
        if (! bAnchoringEnabled)
            return;

        Component comp;
        Component[] comps;
        Dimension dimComponent;
//        Dimension dimMinComponent;
        Dimension dimParent;
        Point ptLocation;
        int x;
        int y;
        int cx;
        int cy;

        comps = parent.getComponents();
//        Insets insets = parent.getInsets();
        dimParent = parent.getSize();
        for (int i = 0; i < comps.length; i++) {
            comp = comps[i];
            dimComponent = comp.getSize();
//            dimMinComponent = comp.getMinimumSize();
            ptLocation = comp.getLocation();
            x = (int) ptLocation.getX();
            y = (int) ptLocation.getY();
            cx = (int) dimComponent.getWidth();
            cy = (int) dimComponent.getHeight();
            DesignAnchoringComponent theAnchoring = findAnchoringComponent(comp);
            if (theAnchoring == null) {
                debugAnchoringComponent(comp);
                System.err.println("Cannot find anchoring component for component:  " + comp.toString());
                return;
            }
            if (theAnchoring.anchoring != null) {
                // Next 2 lines allow the anchored component to be dragged in the Designer.
                if (theAnchoring.theObject.bAnchoringOff == true) {
                    theAnchoring.anchoring.anchorInitialized = false;
                    theAnchoring.theObject.bAnchoringOff = false;
                }
                // Set up anchoring offsets.
                if (theAnchoring.anchoring.anchorInitialized) {
                    if ((theAnchoring.anchoring.anchoring & Anchoring.LEFT) == Anchoring.LEFT) {
                        x = theAnchoring.anchoring.anchorLeft;
                        if ((theAnchoring.anchoring.anchoring & Anchoring.RIGHT) == Anchoring.RIGHT) {
                            cx = (int) dimParent.getWidth() - (x + theAnchoring.anchoring.anchorRight);
                        }
                    } else if ((theAnchoring.anchoring.anchoring & Anchoring.RIGHT) == Anchoring.RIGHT)
                        x = (int) dimParent.getWidth() - (cx + theAnchoring.anchoring.anchorRight);
                    if ((theAnchoring.anchoring.anchoring & Anchoring.TOP) == Anchoring.TOP) {
                        y = theAnchoring.anchoring.anchorTop;
                        if ((theAnchoring.anchoring.anchoring & Anchoring.BOTTOM) == Anchoring.BOTTOM) {
                            cy = (int) dimParent.getHeight() - (y + theAnchoring.anchoring.anchorBottom);
                        }
                    } else if ((theAnchoring.anchoring.anchoring & Anchoring.BOTTOM) == Anchoring.BOTTOM)
                        y = (int) dimParent.getHeight() - (cy + theAnchoring.anchoring.anchorBottom);
                } else {
                    if ((theAnchoring.anchoring.anchoring & Anchoring.LEFT) == Anchoring.LEFT)
                        theAnchoring.anchoring.anchorLeft = x;
                    if ((theAnchoring.anchoring.anchoring & Anchoring.RIGHT) == Anchoring.RIGHT)
                        theAnchoring.anchoring.anchorRight = (int) dimParent.getWidth() - (x + (int) dimComponent.getWidth());
                    if ((theAnchoring.anchoring.anchoring & Anchoring.TOP) == Anchoring.TOP)
                        theAnchoring.anchoring.anchorTop = y;
                    if ((theAnchoring.anchoring.anchoring & Anchoring.BOTTOM) == Anchoring.BOTTOM)
                        theAnchoring.anchoring.anchorBottom = (int) dimParent.getHeight() - (y + (int) dimComponent.getHeight());
                    theAnchoring.anchoring.anchorInitialized = true;
                }
            }
//            if (cx<dimMinComponent.getWidth())
//                cx = (int)dimMinComponent.getWidth();
//            if (cy<dimMinComponent.getHeight())
//                cy = (int)dimMinComponent.getHeight();
            if ((comp instanceof Sizebox) == false)
                comp.setBounds(x, y, cx, cy);
            if ((comp instanceof Sizebox) == false)
                theDesignCockpit.setBounds(theAnchoring.theObject, x, y, cx, cy);
        }
    }

    protected Dimension layoutSize(Container parent, int iType) {
        int newWidth;
        int newHeight;

        if ((width == -1) || (height == -1)) {
            Component comp;
            Component[] comps;
            Dimension dimComponent;
            Dimension dimParent;
            Point pt;
            int x;
            int y;

            newWidth = newHeight = 0;
            comps = parent.getComponents();
            for (int i = 0; i < comps.length; i++) {
                comp = comps[i];
                DesignAnchoringComponent theAnchoring = findAnchoringComponent(comp);
                if (iType == PREFERRED)
                    dimComponent = comp.getPreferredSize();
                else
                    dimComponent = comp.getMinimumSize();
                dimParent = parent.getSize();
                pt = comp.getLocation();
                x = (int) dimComponent.getWidth();
                if (theAnchoring != null) {
                    if ((theAnchoring.anchoring.anchoring & Anchoring.LEFT) == Anchoring.LEFT)
                        x += (int) pt.getX();
                    if ((theAnchoring.anchoring.anchoring & Anchoring.RIGHT) == Anchoring.RIGHT)
                        x += (int) (dimParent.getWidth() - pt.getX() - dimComponent.getWidth());
                }
                y = (int) dimComponent.getHeight();
                if (theAnchoring != null) {
                    if ((theAnchoring.anchoring.anchoring & Anchoring.TOP) == Anchoring.TOP)
                        y += (int) pt.getY();
                    if ((theAnchoring.anchoring.anchoring & Anchoring.BOTTOM) == Anchoring.BOTTOM)
                        y += (int) (dimParent.getHeight() - pt.getY() - dimComponent.getHeight());
                }
                newWidth = Math.max(newWidth, x);
                newHeight = Math.max(newHeight, y);
            }
            if (width != -1)
                newWidth = width;
            if (height != -1)
                newHeight = height;
        } else {
            newWidth = width;
            newHeight = height;
        }
        Insets insets = parent.getInsets();
        return (new Dimension(newWidth + insets.left + insets.right,
                newHeight + insets.top + insets.bottom));
    }
}