/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.JATabbedPane;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class DesignTabbedPane extends JATabbedPane {

    public SuperDesignCockpit theDesignCockpit = null;
    public MetaObject theMetaObject = null;
    public TabbedPaneListener theListener = null;
    public TabbedPaneResizeListener theResizeListener = null;

    boolean bAllowRemoveTab = true;

    public DesignTabbedPane() {
    }

    public DesignTabbedPane(SuperDesignCockpit theDesignCockpit, MetaObject objMetaObject) {
        this.theDesignCockpit = theDesignCockpit;
        theMetaObject = objMetaObject;
        theListener = new TabbedPaneListener(theDesignCockpit);
        theResizeListener = new TabbedPaneResizeListener(theDesignCockpit);
        addChangeListener(theListener);
        addComponentListener(theResizeListener);
    }

    public void initalizeTabbedPane(SuperDesignCockpit theDesignCockpit, MetaObject objMetaObject) {
        this.theDesignCockpit = theDesignCockpit;
        theMetaObject = objMetaObject;
        theListener = new TabbedPaneListener(theDesignCockpit);
        theResizeListener = new TabbedPaneResizeListener(theDesignCockpit);
        addChangeListener(theListener);
        addComponentListener(theResizeListener);
    }

    public void removeTabAt(int index) {
        super.removeTabAt(index);

        if (bAllowRemoveTab) { // we need to ensure this is only done for individual tab-page removal
            // We need to also remove the TabTitle array element for the removed page...
            MetaProperty theProperty = theMetaObject.theFirstProperty;
            while (theProperty != null) {
                if (theProperty.theName.equals("TabTitle"))
                    break;
                theProperty = theProperty.theNextProperty;
            }
            if (theProperty != null && theProperty.theIndexedValue.size() > index) {
                theProperty.theIndexedValue.remove(index);
                if (theProperty.theIndexedValue.size() == 0)
                    theProperty.theIndexedValue.ensureCapacity(1); // other code requires that there be at least a size of 1

            }
        }
    }

    class TabbedPaneListener implements ChangeListener {
        public int selectedIndex = -1; // -1 = nothing has ever been selected.
        DesignTabbedPane tp;         // current pane.
        boolean bRecurse = false;
        SuperDesignCockpit theDesignCockpit = null;

        public TabbedPaneListener(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }

        public void stateChanged(ChangeEvent evt) {
            tp = (DesignTabbedPane) evt.getSource();
            if ((selectedIndex == -1) || (selectedIndex != tp.getSelectedIndex())) {
                int iTabPageSelectedBySwing = tp.getSelectedIndex();
                if (iTabPageSelectedBySwing != -1)
                    tp.setEnabledAt(iTabPageSelectedBySwing, false);
                if (selectedIndex != -1)
                    tp.setEnabledAt(selectedIndex, true);
                MetaObject theObject = tp.theMetaObject;
                if (theObject != null) {
                    DesignPanel theTabPage = (DesignPanel) tp.getSelectedComponent();
                    if (theTabPage != null) {
                        MetaObject theChild = theTabPage.theMetaObject;
                        while (theChild != null) {
                            if ((theChild.theVisualObject != null) && (theChild.theVisualObject.equals(theTabPage))) {
                                MetaObject theSelectedObject = theDesignCockpit.getSelectedObject();
                                if ((theSelectedObject == null) || (theSelectedObject.equals(theObject))) {
                                    if (iTabPageSelectedBySwing != tp.getSelectedIndex()) {
                                        theDesignCockpit.SelectContainer(theChild, true);
                                        theDesignCockpit.SelectObject(theChild, false);
                                    }
                                }
                            }
                            theChild = theChild.theNextObject;
                        }
                    }
                }
            }
            selectedIndex = tp.getSelectedIndex();
        }
    }

    class TabbedPaneResizeListener implements ComponentListener {
        SuperDesignCockpit theDesignCockpit;

        public TabbedPaneResizeListener(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }

        public void componentHidden(ComponentEvent evt) {
        }

        public void componentMoved(ComponentEvent evt) {
        }

        public void componentShown(ComponentEvent evt) {
        }

        public void componentResized(ComponentEvent evt) {
            DesignTabbedPane tp = (DesignTabbedPane) evt.getSource();
//            Dimension dim = tp.getSize();
//            MetaObject theMetaObject = tp.theMetaObject;
//            MetaObject theChild = theMetaObject.theFirstChild;
//          while (theChild != null) {
//              theChild.setSize((int)dim.getWidth(), (int)dim.getHeight());
//              theChild.theVisualObject.repaint();
//              theChild = theChild.theNextObject;
            //         }
            MetaObject theSelectedObject = theDesignCockpit.getSelectedObject();
            theDesignCockpit.setSelectedObject(null);
            theDesignCockpit.SelectContainer(null, true);
            theDesignCockpit.setSelectedObject(theSelectedObject);
            theDesignCockpit.SelectContainer(theSelectedObject, true);
            tp.repaint();
        }
    }

    Color getAppropriateColor(Color theColor) {
        Color newColor = new Color((theColor.getRed() + 128) % 256,
                (theColor.getGreen() + 128) % 256,
                (theColor.getBlue() + 128) % 256);
        return newColor;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
//      Dimension theSize = theMetaObject.getSize();
//      Color theColor = theMetaObject.theBackgroundColor;//
//      if (theColor==null)
//          theColor = new Color(160, 160, 160);
//      g.setColor(theColor);
//      g.fillRect(0, 20, (int)theSize.getWidth(), (int)theSize.getHeight());
        for (int i = 0; i < getTabCount(); i++) {
            MetaPropertyValueEx pvTabTitle = theMetaObject.getPropertyValue("TabTitle", i);
            String sTabTitle = null;
            if (pvTabTitle != null) {
                sTabTitle = pvTabTitle.getStringValue();
                sTabTitle = theMetaObject.theDesignProject.getNLS().getTranslatedValue
                ((String) sTabTitle,
                        theMetaObject.theDesignProject.getCurrentLanguage().theLanguage,
                        false);
            }
            if ((sTabTitle != null) && (sTabTitle.trim().length() != 0))
                setTitleAt(i, sTabTitle);

        }
    }

    public void setSelectedIndex(int iTab) {
        super.setSelectedIndex(iTab);
    }


}
