/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: May 26, 2004
 * Time: 2:18:40 AM
 */
package ch.abacus.designcockpit.ide;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowStateListener;
import java.awt.event.WindowEvent;
import java.awt.*;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 *
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 *          <p/>
 *          <p/>
 *          Build Revisions.
 *          <p/>
 *          0.1.0.1 - 4/04/2002 - mg - This is the first build that uses listeners
 *          instead of methods to trap events.  Since this was
 *          a necessary condition to supporting real java
 *          events, this is where we will start marking real
 *          revisions and builds.
 *          0.1.0.2 - 4/05/2002 - mg - This has the first markup tags in the code generation.
 *          It also introduces the code beautifier and syntax
 *          editor beans.
 *          0.1.0.3 - 4/06/2002 - mg - This is the first build that pops up the location
 *          of a user error.  The Code Jumper logic was just added.
 *          Class edit tool screens were redesigned.
 *          0.1.0.4 - 4/08/2002 - mg - Added capability of array based properties in property table.
 *          Array based properties in load/save projects.
 *          Still needs array based properties in ui factory (coming next)
 *          0.1.0.5 - 4/10/2002 - mg - Early morning backup.  Added multiple frame capability.
 *          Working on bug in method list / source editor switching.
 *          Fixed sticky mouse in view displayer
 *          General container logic (not in code generator though!)
 *          Array based properties now working in ui factory.
 *          0.1.0.6 - 4/11/2002 - mg - Added cut copy & paste to editors
 *          Added cockpit screensize resizing (still bad init values for components)
 *          Scrollpane for description window of project tool
 *          focus problems still between editor and method list.
 *          check box selection in component palette is working correctly now.
 *          Added status line for editors (still does not display line and row #)
 *          0.1.0.7 - 4/11/2002 - mg -Fixed major bug that was linking methods between all objects.
 *          Fixed method list / source editor saving and loading.
 *          Found new bug - When frame is selected for first time doesn't display.
 *          Sizing is _much_ better now.
 *          Changes in code generation for scroll pane and tabbed pane.
 *          DisplayClass is now used to determine whether an object is visual or not.
 *          Among other things this determines whether it can be attached,
 *          whether it gets handlers for events, etc.
 *          0.1.0.8 - 4/12/2002 - mg - Fixed problem with selected frame not displaying first time.
 *          Changed DisplayClass to be independent of whether s.t. has events.
 *          Button group needed to be displayed but not get events.
 *          Minor change to code generation dialog.
 *          0.1.0.9 - 4/12/2002 - mg - Edits and scrollbars need to set preferred state on
 *          enclosing scrollpane.  I need to fix this in htmllayout.
 *          0.1.1.1 - 4/13/2002 - mg - This has the fix for text areas and scrollbars with one minor
 *          problem still. The code produced causes a class cast exception.
 *          Switching subrevision to 1 in preparation for Alex/Claudio visit.
 *          Note that the metadata.meta has been changed to include "thePane"
 *          inside of JATextAreaX.  Also, fixed meta output and prog output
 *          to not require doc fields for member data or methods.
 *          0.1.1.2 - 4/14/2002 - mg - After cleaning up dialogs for class edit tool.  Also has the
 *          metadata.meta file that defines buttongroup correctly.
 *          0.1.1.3 - 4/14/2002 - mg - After fixing combo boxes in class edit tool.  Now they respect
 *          losing focus.  Tab is no longer "special".  Enter still "eaten".
 *          0.1.1.4 - 4/14/2002 - mg - Fixed save as and save to not write default.  Seems more stable here.
 *          List cannot be seen.  Combo cannot be selected by clicking on design object, only
 *          through the object tree.
 *          0.1.1.5 - 4/14/2002 - mg - Fixed problem with focus loss throwing exception when tabbing out of combos in
 *          class edit tool.  This workaround actually fixes a problem in the swing combo
 *          implementation.  See LizardComboBox for the note in focusLost.
 *          0.1.1.6 - 4/14/2002 - mg - Fixed problem in default value dialog.  Still has a blank row though.
 *          0.1.1.7 - 4/15/2002 - mg - Cautiously made autogen properties work ;^)
 *          0.1.1.8 - 4/17/2002 - mg - Added actions (no implementation yet) for redo/undo/about/color/font/saveall/savemeta
 *          to design cockpit
 *          0.1.1.9 - 4/17/2002 - mg - Initial font & color support. Saveall, redo, undo, and savemeta are not yet implemented.
 *          0.1.2.1 - 4/18/2002 - mg - Loew's night.  Quadruple expresso.  Fixed save box and directories.
 *          0.1.2.2 - 4/18/2002 - mg - Read in fonts and colors.
 *          0.1.3.1 - 4/23/2002 - mg - Removed html layout.
 *          0.1.3.2 - 4/30/2002 - mg - Introduced drag and drop for view displayer.
 *          0.1.3.3 - 5/01/2002 - mg - Anchoring support.
 *          0.1.3.4 - 5/3/2002  - mg - Alignment grid.  Update property list properly. Alignment grid is set to constants for now.
 *          This also has the "snap to" logic in place.  All appears to work.
 *          Fixed bug in repainting background color of view displayer.
 *          Still need to change default color of Frame.
 *          0.1.3.5 - 5/4/2002  - mg - Logic to guarantee unique naming.
 *          0.1.3.6 - 5/6/2002  - mg - Runtime execution of programs.  Set up class path and execute.
 *          0.1.3.7 - 5/6/2002  - mg - Fixed problem with font chooser not reading current font.
 *          0.1.3.8 - 5/7/2002  - mg - Intermediate version for tab page support.
 *          0.1.3.9 - 5/9/2002 AM - mg - Fixed tab page support selection and bug when dropping into nested container (at least 2 levels)
 *          This needs a more general fix that will recursively look into the object tree.
 *          0.1.3.10 - 5/9/2002 - mg - Fixed problem with sizeboxes in tabbed pane pages.  Fixed new project initialization.
 *          0.1.3.11  - 5/10/2002. - mg - Some fixes for the drop into nested container problem.  There are still plenty of issues.
 *          0.1.4.1  - 5/10/2002 - mg - Moved into designcockpit subdirectory.
 *          0.1.4.2  - 5/14/2002 - mg - Abstracted access of current project.  Allows for multiple projects to be open.
 *          Clone object method for cut/copy/paste - ready for implementation in cockpit.
 *          0.1.4.3 - 5/22/2002 - mg - Cut Copy Paste implemented.  View displayer now shows area that is active in applet.
 *          Fixed problem with location of controls that are dropped into nested containers.
 *          0.1.4.4 - 5/23/2002 - mg - cannot paste nested objects - bug!
 *          Fix for paste after paste is in this code.
 *          menu for view displayer allows paste anywhere.
 *          delete object bugs fixed so that the tree and view displayer are updated.
 *          0.1.4.5 - 5/29/2002 - mg - Fixed problem with pasting code.
 *          Still broken for nested objects but hooks in place (and exception code)
 *          Fixed view displayer background.
 *          0.1.5.1 - 5/31/2002 - mg - Background of tabbed pane and panel now based on internal class that draws grid lines.
 *          Fixed problems for nested object cloning.
 *          Fixed method list moving between methods and objects.
 *          Grid now adjusts (but doesn't save in project or workspace)
 *          Menu for obj tree view.
 *          0.1.5.2 - 6/12/2002 - mg - Tabbed pane add from popup menu option.  Changes to containers.
 *          Added DesignCockpitPreferences.
 *          Fixed font dialog to show a complete list of fonts.
 *          Added code to allow sizebox size to be changed.
 *          0.1.5.3 - 6/14/2002 - mg - More changes to tabbed panes.
 *          Changed to windows look and feel (by Alex's request)
 *          Added ".proj" to the name of the project file if not supplied.
 *          0.1.5.4 - 6/19/2002 - mg - Fixed problem with pasting at top level. (BUZZ! Not working)
 *          "IS" problem fixed for bean methods.
 *          Directory for transients added (needs tested)
 *          Send code in source editor through beautifier first.
 *          Fixed selection in object tree view with tab panes (prob with first still)
 *          Add Tab classname to menu duplication fixed.
 *          0.1.5.5 - 6/21/2002 - mg - Fixed initial screen size.
 *          Completed code generation optimization.
 *          0.1.5.6 - 6/24/2002 - mg - DesignCockpitPreferences for plaf.
 *          0.1.5.7 - 6/24/2002 - mg - Fixed many bugs:
 *          1.  Delete object was not removing visual object from tab pages.
 *          2.  Could not delete a tab page from a tabbed pane.
 *          3.  Tabs were getting mixed up after a paste.
 *          4.  When we pasted we lost the tab page displayed.
 *          0.1.5.8 - 6/26/2002 - mg BRAZIL BEAT TURKEY TO GO INTO THE SEMIFINAL OF THE WORLDCUP TODAY!
 *          1.  Added popup menu with undo/redo in source editor.
 *          2.  Turn off focus for components so the focus wouldn't get confused.
 *          3.  Same for toolbar.
 *          0.1.5.9 - 6/26/2002 - mg Logic in comedia bean for undo needed to be overridden.
 *          0.1.5.10 - 6/27/2002 - mg Multpile project support was causing havoc with selected frame
 *          Some of the tabbed pane support was showing problems especially changing the
 *          selected object by pressing the tab.  That no longer switches the container.
 *          0.1.5.11 - 6/28/2002 - mg Changed class edit tool to use new dialogs.
 *          0.1.5.12 - 6/28/2002 - mg Added bitmap capability for buttons.
 *          Fixed problem with code generation not declaring main object of application.
 *          0.1.5.13 - 7/2/2002 - mg Import class facility.
 *          0.1.5.14 - 7/5/2002 - mg Redirect tab page drags to tabbed pane.  Resize fix for tab page.
 *          0.1.5.15 - 7/6/2002 - mg moved anchoring layout manager to ch.abacus.lib.ui
 *          0.1.5.16 - 1/10/2003 - mg Added abalet logic.
 *          0.1.5.17 - 2/8/2003 - mg Added STRIPPED version for renderer.
 *          0.1.5.18 - 2/14/2003 - mg Anchoring layout, dots, renderer property changes, real names of classes
 *          are now stored in xml doc, new ui for import, resizing frames, cursors.
 *          0.1.6.1  - 2/28/2003 - mg (from St Gallen) AbaRenderer implementation complete with XML changes.
 *          <p/>
 *          Bugs (as of 5/10/2002)
 *          <p/>
 *          1.  Automatic property setting needs to be tested and debugged. (done)
 *          2.  Guarantee that object names are not the same. (fixed)
 *          3.  Right mouse click should allow objects to be renamed or deleted in object tree view. (done)
 *          4.  Drag option in object tree view should allow parent/child relationships to change. (postponed)
 *          5.  Error logic for class rename etc needs to be built.  Needs to check if objects are already instantiatied with that class.
 *          6.  Class edit dialogs need to be changed to use new anchor layout manager. (done)
 *          7.  Status line needs to be cleaned up. (done)
 *          8.  Change options for beautifier. (done)
 *          9.  Default property code for properties. Optimization to eliminate setting properties when unnecessary.
 *          10. Eliminate unnecessary listeners.  Too much code is generated that is actually just stubs. (done)
 *          11. UIFactoryBlueprint code generator by supplying actual method code in code generator box.
 *          12. Error logic from compiler needs to be improved.  Right now you double click on the line number to get to the block of bad code.
 *          13. Dropping components into nested panels and is not adjusting correctly for offset. (fixed)
 *          14. Selection of nested panel is not working properly.  It should only show the panel in the view displayer. (fixed)
 *          15. Object Cut/Copy/Paste is being reimplemented. (fixed)
 *          16. Drop object in a panel of a tabbed pane's tab page has offset problems for location. (fixed)
 *          17. Problems with default value combo storing and display. (done)
 *          18. Need to build transient files in output directory. (done)
 *          19. Need tool for adjusting the alignment grid. (fixed)
 *          20. No alignment grid shown except in view displayer.  It should always show in selected frame. (fixed)
 *          21. Delete option not working in popup menu of a view displayer component.  You need to use the delete key. (fixed)
 *          22. All projects need to set up a class path variable to point to the abajava source so that the anchoring code can be found.
 *          This should be automatic. (works)
 *          23. Need to press tab when you enter new property names, method names, field names in a class edit combobox.  Mouse off should
 *          also work. (done)
 *          24. When switching between projects, object tree view needs to open to the last current object of the newly selected
 *          project. (done)
 *          <p/>
 *          <p/>
 *          HAMMER & NAIL
 *          <p/>
 *          <p/>
 *          TO DO LIST
 *          <p/>
 *          <p/>
 *          LATER
 *          <p/>
 *          2.  Choices in XML document for choosing how it runs.  Also allow image directory to be configured and cache directory for class importer lookup.
 *          3.  Get java code builder to work again.
 *          <p/>
 *          <p/>
 *          DONE LIST
 *          <p/>
 *          1.  Replace drag & drop functionality.
 *          2.  Add cursors to show when operation changes (resizing, pointing, moving)
 *          3.  Frame size grips.
 *          4.  Anchoring Layout
 *          5.  Dots
 *          6.  Design mode (remove mouse listeners)
 *          7.  Fix project editor
 *          8.  Fix importer
 *          9.  Import new metadata.
 *          10.  Use real class names instead of deriving.
 *          11.  Remove subclassing.
 *          12.  Take off the method list, source editor, various popups.
 *          13.  Fix scroll pane bug.
 *          14.  Remove unnecessary tags.
 *          15.  Write simple renderer for Demo.
 *          16.  Need to change version number
 *          17.  Change name to hammer and nail throughout.   (DONE)
 *          18.  Change default value of grid to 4. (done)
 *          19.  Change container for import (somehow isn't inserting in selected container)
 *          20.  Popup menu isn't popping up in right place anymore.
 *          1.  Outside of selected frame we still see lines drawn.
 *          2.  Change grid to one setting for both horz and vertical.
 *          3.  Metadata - fix ugly defaults.
 *          4.  Test minimum and preferred sizes in Anchoring Layout Manager.
 *          5.  Multiple language support.  Put on toolbar a combo to choose language.
 *          6.  Confirmation for save and quit.
 *          7.  Property invoker consistency in hammer & nail.  Don't need names.  I can just use the order and type of parameter.  Misteli's idea!
 *          8.  Remove parsing requirement though.  We don't need to parse.
 *          9.  Invoke class factories with list of parameters.  Class factory needs tag.  If it exists invoke it instead of just a naked create.
 *          10.  Clipboard stuff - copy needs simplified for this version and .
 *          11.  Disable visual objects.  setEnabled doesn't allow and objects are ugly and shadowed.
 *          12.  Need to put version number in the xml docs.
 *          13.  Don't think I need the attached tag.
 *          1.  Add conditional button for renderer
 *          <p/>
 *          <p/>
 *          All above is done in 0.2.0 build 1.
 *          <p/>
 *          Build 2 - 4/6/2003 choose selected container from drop point on view displayer import.
 *          Layered pane implementation to mimic z order
 *          anchored components can now be dragged
 *          tab control editor buttons now repaint focus ring off
 *          <p/>
 *          <p/>
 *          Bug list:
 *          <p/>
 *          1.  Frame is too slow - 3d drawing is slow!
 *          2.  Property table needs to be snappier.  You need to double click to edit.  Unacceptable.
 *          3.  Anchor layout messages
 *          <p/>
 *          <p/>
 *          <p/>
 *          Build 3 - Property table is now snappier. 4/7/2003
 *          <p/>
 *          Build 4 - Anchor layout messages are gone. 4/8/2003
 *          <p/>
 *          Build 5 - 4/11/2003
 *          <p/>
 *          x2.    Editor in property table needs to highlight text (only does it on click)
 *          x3.    SelectedIndex in tab pages doesn't work. (timing issue in renderer)
 *          xx4.   Copy doesn't work at all.  Or paste. (project name wasn't propagating - fixed proj to proj too)
 *          x5.    Tab Pane keeps resizing.  Tabbed pane.  Put tab page.  Put button.  Set anchoring on button.  Click tabbed pane as selected object. Boom!
 *          xx11.  AbaRenderer (if proj open don't prompt)
 *          xx12.  Progress Bar needs to work.
 *          xx17.  Component List - Deselect the name of the class.
 *          xx18.  Scroll to selected object in object list.
 *          xx19.  Tab Page - Button inside of button.  (Fixed!)
 *          xx21.  Tooltip doesn't work on design cockpit toolbar buttons.
 *          xx22.  anchor props removed for frame and tab page
 *          xx23.  comboboxes were requiring a keyboard input - mouse wasn't working - changed from jacombo and now they are ok.
 *          <p/>
 *          4/20/2003:
 *          <p/>
 *          6.  Parser for hex values.  $xxxxxx (only for integer or longs) in metadata and project files.
 *          7.  Assign table and field to components.
 *          8.  Muliselect Copies
 *          9.  Button bars for save and save all need to reflect unchanged
 *          10. Button bars for set color and font
 *          1.  Named values for properties.
 *          13.  Names of objects - use property name that's defined in Swing.
 *          14.  Document Version written
 *          15.  Build Number - AutoIncrement
 *          16.  Date last saved. Time.
 *          20.  Store user directory in configuration file for open and save dialogs.
 *          24.  Tool to access tables from compiled classes to do associations (see 7)
 *          <p/>
 *          5/1/2003:
 *          <p/>
 *          xxx1.  Named values for properties.  (added tag to add all values)
 *          2.  Editor in property table needs to highlight text (only does it on click)
 *          x3.  SelectedIndex in tab pages doesn't work. (timing issue in renderer)
 *          xxx4.  Copy doesn't work at all.  Or paste. (project name wasn't propagating - fixed proj to proj too)
 *          xxx5.  Tab Pane keeps resizing.  Tabbed pane.  Put tab page.  Put button.  Set anchoring on button.  Click tabbed pane as selected object. Boom!
 *          xxx6.  Parser for hex values.  $xxxxxx (only for integer or longs) in metadata and project files.
 *          xxx7.  Assign table and field to components.
 *          xxx8.  Muliselect Copies
 *          xxx9.  Button bars for save and save all need to reflect unchanged (needs testing)
 *          xxx10. Button bars for set color and font (need to add hervo's icons)
 *          xxx11.  AbaRenderer (if proj open don't prompt)
 *          xxx12.  Progress Bar needs to work.
 *          xxx13.  Names of objects - use property name that's defined in Swing.
 *          xxx14.  Document Version
 *          xxx15.  Build Number - AutoIncrement
 *          xxx16.  Date last saved. Time.
 *          xxx17.  Component List - Deselect the name of the class.
 *          xxx18.  Scroll to selected object in object list.
 *          xxx19.  Tab Page - Button inside of button.  (Fixed!)
 *          xxx20.  Store user directory in configuration file for open and save dialogs.
 *          xxx21.  Tooltip doesn't work on design cockpit toolbar buttons.
 *          xxx22.  anchor props removed for frame and tab page
 *          xx23.  comboboxes were requiring a keyboard input - mouse wasn't working - changed from jacombo and now they are ok.
 *          xxx24.  Tool to access tables from compiled classes to do associations (see 7)  (Needs to read values for initialization)
 *          xxx25.  Drop object into panel with multiple containers always finds first!
 *          xxx26. Grid removed for millimeter size and location.
 *          xxx27.  Use check tree for file/field.
 *          yyy28.  Property table (use check tree).  For later version use Delphi class.
 *          xxx29.  Changing size of design cockpit windows needs to update coordinates for popup menus.  Add objects until scrollable.  Popup on object (for example obj 6).  Pops up like it would be if it wasn't in a scroll list.
 *          xxx30.  Run system, make 2 buttons and 2 panels, put button under panel, click on button, sizeboxes are behind panel.
 *          xxx31.  Property editor, editing, change selected object, value doesn't change.
 *          xxx32.  Panel has a button, click on property table (button is gone)
 *          33.  Focus listener of property table has to show that it is inactive when I click somewhere else. ???
 *          xxx34.  Close confirmation dialog needs a cancel.
 *          xxx35.  Program saved window goes away.
 *          xxx36.  Panel in frame.  Save.  Click anywhere.  Project can be saved again.
 *          xxx37.  Cannot change frame properties like color.
 *          xxx38.  Horizontal/Vertical/No Orientation (Scrollbar) , Colors
 *          x39.  Editable combobox on property (value) sdk problem
 *          xxx40.  Change grid to 8 8
 *          xxx41.  Left justify all entries in property table.
 *          xxx42.  Make component visible or not in component palette.
 *          43.  Insert tab page (tab pane covered by tab page) - check rect values and forward.  Postponed.
 *          44.  Undo / Redo events.
 *          xxx45.  Name of window has to have (1) (2) ETC
 *          xxx46.  Change title of designer to show active project name.
 *          xxx47.  Exclude by pathname on open.
 *          xxx48.  Merge hervo's icons
 *          xxx49.  Metadata tag for objects.
 *          xxx50.  Objects can be entered as a string.
 *          xxx51.  Tag for property table to bring in all objects.
 *          yyy52.  Property that says whether object can be deleted.
 *          xxx53.  Keyboard focus (tab go to next focusable, ctrl arrow to change location, delete key)
 *          xxx54.  Allow array values to be deleted.
 *          xxx55.  Misteli's bug with cut/copy/paste.
 *          56.  Versioning in document files and with metadata.
 *          xxx57.  Test anchoring for renderer.
 *          xxx58.  Cut & delete for multiselect were not working properly
 *          xxx59.  Resize wasn't working with anchoring.
 *          xxx60.  Blinking cursor, focus rect etc removed from designer components.
 *          xxx61.  Auto scrollpane (just set a property in the class - AutoEmbed)
 *          xxx62.  AbaRenderer needs to add space for frame insets.
 *          <p/>
 *          <p/>
 *          1.  Property Table
 *          <p/>
 *          a.  Needs to show highlighted cell.  (still a problem!)
 *          b.  Needs to purge value in "current" cell and reload when object changes. (fixed)
 *          c.  Needs to remove combo index and add F4 option. (fixed) - need to select table viewer from tablename.
 *          e.  Combobox needs to show selected value. (sdk)
 *          f.   The array helper is only showing once. (fixed)
 *          <p/>
 *          d.  Needs to load table/fields. (test) (Fixed)
 *          <p/>
 *          <p/>
 *          2.  Popup menu location when scrolling. (Fixed)
 *          <p/>
 *          3.  Save button needs to correctly reflect state.   (Fixed)
 *          Menu options for save and save all need to gray. (Fixed)
 *          <p/>
 *          4.  Anchoring in renderer. (FIXED!)
 *          <p/>
 *          5.  Frame props, scr orient, sel index on tab pages (renderer problems?)  (FIXED exc sel index)
 *          <p/>
 *          6.  Misteli's bug with cut and paste. (FIXED!)
 *          <p/>
 *          7.  Property set on container doesn't repaint children. (FIXED)
 *          <p/>
 *          8.  Anchoring in design cockpit - drag to new position.  (FIXED!)
 *          <p/>
 *          9.  Check switching between projects and saving.  Names.  3 projects.  Save.  Change from one to another. (Fixed)
 *          <p/>
 *          10.  Location of frame should only ever be 0 0. (Fixed)
 *          <p/>
 *          Postponed:
 *          <p/>
 *          1.  Tabbed pane transparency for drops of tab page.  (just removed from component list the tab page class)
 *          2.  Undo/Redo.
 *          3.  Generic implementation of constant groups when no specific class is available.
 *          4.  Allow for multiple constant groups per property. Use array.
 *          5.  Versioning in document files and with metadata.
 *          <p/>
 *          <p/>
 *          This version of 5/1/2003 includes some code for generic implementation of constant groups.
 *          <p/>
 *          5/2/2003 fixes bug with abacus lnf.  PropertyTable was calling updateUI and design cockpit needs to do lnf before _ANYTHING_ else.
 *          5/5/2003 fixed bug introduced in previous version with property table refresh when switching between objects.  Build 7.
 *          <p/>
 *          0.3.1.8 5/6/2003 Implement focus manager.
 *          0.3.1.9  5/6/2003 Set project changed state when we move the objects in the focus tree.
 *          0.3.1.10 5/6/2003 messed up merge - rebuilding from scratch
 *          0.3.1.11 5/6/2003 File compression of project.
 *          0.3.1.12 5/7/2003 Multiple constant groups per property.
 *          0.3.1.12 5/7/2003 Multiple values per constant groups.
 *          0.3.1.13 5/9/2003 Generic implementation of constant groups when no specific class is available.
 *          0.3.1.14 5/9/2003 Shift down and up arrows to move in focus tree.
 *          0.3.1.15 5/9/2003 Added generator of declarations to the project document generator.  New file has extension "decl".
 *          0.3.1.16 5/22/2003 Metadata versioning ready for test.
 *          0.3.1.17 5/22/2003 Code cleanup checkin. Fixed warnings that are not intentional. Also found bug with build number in metaversioning.
 *          0.3.1.18 6/10/2003 Initial work on class inheritance in metadata, national language support, and helper generalized interface.
 *          0.3.1.19 6/12/2003 NLS prompt tool
 *          0.3.1.20 6/14/2003 NLS prompt tool updates NLS files now.
 *          0.3.1.21 6/18/2003 Fix for class inheritance to disallow selection from component palette when there are children
 *          0.3.1.22 6/19/2003 Initial jar open file dialog.  Changes to allow design cockpit to load from resource.
 *          0.3.1.23 6/19/2003 Open projs from jars in dc.
 *          0.3.1.24 6/19/2003 Fixed bug in NLS translation with multiple docs.
 *          0.3.1.25 6/19/2003 Support for mnemonics and Character data.
 *          <p/>
 *          0.4.0.1  7/2/2003  Refactored into various directories to allow for building components separately.
 *          Sort Properties in Table.
 *          Change Declaration file to include proj name.
 *          Fix bug when last project is closed.  Now keeps open a new project.
 *          Save to jar bug fixed.
 *          0.4.2.1  8/19/2003 Sort NLS documents and keys
 *          Tool for multiselect setting size & alignment
 *          Fix some problems with ch.abacus.designcockpit embedded in code.
 *          Fix object naming problem with copy & paste
 *          Added <SkipDeclarations> tag support
 *          Added <DesignBorders> tag support
 *          Key shortcuts (do not work in property table) F9 Ctrl S
 *          Added shift click obj creation
 *          Author name wasn't being stored in proj file
 *          <p/>
 *          0.4.3.1  9/11/2003 A number of bugs were introduced in 0.4.2.1
 *          Problems writing project preferences
 *          Object naming problem was only half-fixed.
 *          One of the multiselect stuff was not correct (set to small width)
 *          Other bugs fixed & features implemented: F9 & Ctrl S now work in property table
 *          I fixed the scrolling panel class to not show scr bars when not necessary
 *          NLS helper stuff was broken because the preferences were not being written
 *          Implemented methods to query baseFrameSize, Color, MaxSize, MinSize, & Title in renderer.
 *          Allow design border to be set <DesignBorderDefinition> tag in the metadata.meta file.
 *          Author now saved properly in proj
 *          Problem with classes with display classes and factories.  In design mode, we don't call factory anymore.
 *          Fixed NLS resolving in renderer.  Very simply, the renderer was never loading NLS docs.
 *          Fixed name property so that it will never be redundant.
 *          <p/>
 *          0.4.3.2  10/2/2003 Rolled back many changes to fix an emergency bug reported by Karl Sippel
 *          The default new project that is open after you close all projects was
 *          not getting its "input type" set, so the system did not know if it was
 *          supposed to be written to a file or a jar.
 *          <p/>
 *          0.4.4.1  10/7/2003 In Design Cockpit, when changing the width size of a component with the mouse,
 *          the component was snapped to the grid.  This is no longer the case.
 *          Cut should preserve the object name now.
 *          Truncate child objects to parent extents.
 *          Implemented some code to fix the problem with the mouse pulling objects out of the container
 *          Removed noted refs to ch.abacus.designcockpit within the renderer.
 *          Implemented the HammerException class
 *          Added code to getBaseFrameSize to help Karl solve his problem
 *          Problem with null mnemonic not rendering is now fixed.
 *          <p/>
 *          0.4.4.2   11/20/2003 mg Fixes for Karl & Hervo - NLS keeps track of position and last document, 20 rows for value combobox
 *          Save to project directory.
 *          <p/>
 *          0.4.5.1   11/22/2003 mg Made changes to optimize metadata loading.  It will only be loaded once now no matter how many
 *          projects are rendered.  Deep change touched all components of the system.
 *          <p/>
 *          0.4.5.2   12/7/2003 mg Made change to system exit code.
 *          <p/>
 *          <p/>
 *          0.4.9.1   2/19/2004 mg Changes made before release of new proz file format
 *          <p/>
 *          1.  Removed load of db from classes to speed up dc loading (we were not using these)
 *          2.  Some external classes are called through reflection now to facilitate open source.
 *          3.  Changes to allow splitters (incomplete as of 2/20/2004)
 *          4.  Changes to allow saving compiled format.
 */

public class FramePlacement extends ComponentAdapter implements WindowStateListener {
    private final SuperDesignCockpit theDesignCockpit;

    private Dimension normalFrameSize; // the size the frame would be, if it were not minimized or maximized
    private Point normalFramelocation; // frame location
    private Point previousFramelocation; // workaround for Maximize setting location before alerting of state change

    public FramePlacement(SuperDesignCockpit objDesignCockpit) {
        theDesignCockpit = objDesignCockpit;
    }

    public void componentResized(ComponentEvent evt) {
        super.componentResized(evt);
        //if (theDesignCockpit.bInitialized) {
            Component comp = evt.getComponent();
            Dimension dim = comp.getSize();
            if (comp.equals(theDesignCockpit)) {
                //ensureWindowsVisible(dim);
                //System.out.println("Resized: " +dim.width + " " + dim.height);
                //System.out.println("   " + theDesignCockpit.paneLeft.getDividerLocation() + " " + theDesignCockpit.paneRight.getDividerLocation());
                //theDesignCockpit.setComponentSizes(dim);
                if (isNormal()) {
                    normalFrameSize = dim;
                }
            }
        //}
    }

    private void ensureWindowsVisible(Dimension dim) {
//        if (! theDesignCockpit.isVisible())
//            return;
//
//        if ( (theDesignCockpit.theComponentPalettePane.getSize().width <50) ||
//             (theDesignCockpit.theViewDisplayerScrollPane.getSize().width <50) ||
//             (theDesignCockpit.thePropertyTableScrollPane.getSize().width <50)) {
//                System.out.println("Problem!!! Width = " +theDesignCockpit.theComponentPalettePane.getSize().width + " paneLeft = " +theDesignCockpit.theViewDisplayerScrollPane.getSize().width + " right = " + theDesignCockpit.thePropertyTableScrollPane.getSize().width );
//                 theDesignCockpit.paneLeft.setDividerLocation(dim.width /4);
//                 theDesignCockpit.paneRight.setDividerLocation(dim.width /2);
//             }
//        if (theDesignCockpit.theComponentPalettePane.getSize().width + theDesignCockpit.theViewDisplayerScrollPane.getSize().width + theDesignCockpit.thePropertyTableScrollPane.getSize().width > dim.width ) {
//            System.out.println("Problem: Width = " +theDesignCockpit.theComponentPalettePane.getSize().width + " paneLeft = " +theDesignCockpit.theViewDisplayerScrollPane.getSize().width + " right = " + theDesignCockpit.thePropertyTableScrollPane.getSize().width );
//            theDesignCockpit.paneLeft.setDividerLocation(dim.width /4);
//            theDesignCockpit.paneRight.setDividerLocation(dim.width /2);
//
//        }
        //if ((theDesignCockpit.paneRight.getDividerLocation() - theDesignCockpit.paneLeft.getDividerLocation()) <50) {
            //theDesignCockpit.paneLeft.setDividerLocation(dim.width /4);
            //theDesignCockpit.paneRight.setDividerLocation(dim.width /2);
        //}
//        if ((theDesignCockpit.paneOne.getDividerLocation() ==0) || (theDesignCockpit.paneOne.getSize().height - theDesignCockpit.paneOne.getDividerLocation()) <50) {
//        //if ((theDesignCockpit.paneOne.getDividerLocation()) ==0) {
//            System.out.println("1 Problem!!!");
//            theDesignCockpit.paneOne.setDividerLocation(theDesignCockpit.paneOne.getSize().height /2);
//        }
//
//        if ((theDesignCockpit.paneTwo.getSize().height - theDesignCockpit.paneTwo.getDividerLocation()) <50) {
//            System.out.println("2 Problem!!!");
//            theDesignCockpit.paneTwo.setDividerLocation(theDesignCockpit.paneTwo.getSize().height /2);
//        }
//        if ((theDesignCockpit.paneThree.getSize().height - theDesignCockpit.paneThree.getDividerLocation()) <50) {
//            System.out.println("3 Problem!!!");
//            theDesignCockpit.paneThree.setDividerLocation(theDesignCockpit.paneThree.getSize().height /2);
//        }
    }

    public void componentMoved(ComponentEvent e) {
        if (isNormal()) {
            previousFramelocation = normalFramelocation;
            normalFramelocation = theDesignCockpit.getLocation();
        }
    }

    /**
     * Is the frame "Maximized". This is also known as "Zoomed" and other terms. It means that the frame is consuming the complete work area of the screen.
     * @return true, if the frame is maximized, false otherwise.
     * @see #isMinimized
     * @see #isNormal
     */
    public boolean isMaximized() {
        int iWindowState = theDesignCockpit.getExtendedState();
        return ((iWindowState & Frame.MAXIMIZED_BOTH) == Frame.MAXIMIZED_BOTH);
    }

    /**
     * Is the frame "Minimized". This is also known as "Iconized" and other terms. This is the opposite if maximized - it uses the minimum screen space
     * @return true, if the frame is minimized, false otherwise.
     * @see #isNormal
     * @see #isMaximized
     */
    public boolean isMinimized() {
        int iWindowState = theDesignCockpit.getExtendedState();
        return ((iWindowState & Frame.ICONIFIED) == Frame.ICONIFIED);
    }

    /**
     * Is the frame "Normal". That is, neither maximized nor minimized.
     * @return true if the frame is not maximized and not minimized.
     * @see #isMinimized
     * @see #isMaximized
     */
    public boolean isNormal() {
        int iWindowState = theDesignCockpit.getExtendedState();
        return (iWindowState == Frame.NORMAL);
    }

    /**
     * The "Normalized" size of the frame. If the frame is maximized, this will be the size the window would be if it were restored back to normal.
     * @return the normalized size of the frame
     * @see #getSize
     */
    public Dimension getNormalSize() {
        if (normalFrameSize != null)
            return normalFrameSize;
        else
            return getSize();
    }

    /**
     * The size of the frame, ragardles of it being normal, minimized or maximized.<p>
     * @return the size of the frame
     * @see #getNormalSize
     */
    public Dimension getSize() {
        return theDesignCockpit.getSize();
    }

    /**
     * Sets the size reported by getNormalSize.
     * @param normalFrameSize the size of the frame when it is normal
     */
    public void setNormalFrameSize(Dimension normalFrameSize) {
        this.normalFrameSize = normalFrameSize;
    }

    /**
     * The location of the frame. This value
     * @return the location of the frame
     */
    public Point getNormalLocation() {
        Point location = normalFramelocation;
        if (location == null)
            location = theDesignCockpit.getLocation();
        return location;
    }

    public Point getLocation() {
        return theDesignCockpit.getLocation();
    }

    public void windowStateChanged(WindowEvent e) {
        // We restore the previous location, if the frame is maximized. This is because the frame's location changes
        // before the window has changed its state to maximized. Because of this, we never know the location to "restore" back to. 
        if (e.getNewState() == Frame.MAXIMIZED_BOTH)
            normalFramelocation = previousFramelocation;
    }
}