/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.*;

import javax.swing.BorderFactory;
import javax.swing.*;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import com.sun.java.swing.plaf.windows.WindowsTreeUI;
import electric.xml.ParseException;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 *
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

class ClassPathHacker
{
    private static final Class[] parameters = new Class[]{URL.class};

    public static void addFile(String s) throws IOException
    {
        File f = new File(s);
        addFile(f);
    }//end method

    public static void addFile(File f) throws IOException
    {
        addURL(f.toURL());
    }//end method


    public static void addURL(URL u) throws IOException
    {

        URLClassLoader sysloader = (URLClassLoader) ClassLoader.getSystemClassLoader();
        Class sysclass = URLClassLoader.class;

        try
        {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke(sysloader, new Object[]{u});
        }
        catch (Throwable t)
        {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }//end try catch

    }//end method
}//end class

class FileTreeNode extends DefaultMutableTreeNode
{
    boolean hasbeenread;
    private String sFileName;

    public FileTreeNode(File file)
    {
        super(file);
        hasbeenread = false;
    }

    public boolean readTree()
    {
        return readTree(false);
    }

    public boolean readTree(boolean b)
    {
        if (hasbeenread)
            return false;

        sFileName = ((File) getFileObject()).getName();

        if ((sFileName.endsWith(IDEImporter.JAVALIBRARYEXT)))
        {
            try
            {
                String sFullPath = ((File) getFileObject()).getAbsolutePath();
                JarFile jFile = new JarFile(sFullPath);
                Enumeration enumClasses = jFile.entries();
                ClassPathHacker classPathPatcher = new ClassPathHacker();
                classPathPatcher.addFile(sFullPath);

                while (enumClasses.hasMoreElements())
                {
                    JarEntry zipdClass = (JarEntry) enumClasses.nextElement();
                    String sZipdClassName = zipdClass.getName();
                    if (sZipdClassName.endsWith(IDEImporter.JAVALIBRARYCLASS))
                    {
                        FileTreeNode mtn = new FileTreeNode(new File(sZipdClassName));
                        add(mtn);

                    }
                }

                hasbeenread = true;
            }
            catch (Exception excptObj)
            {
                excptObj.printStackTrace();
            }
        }
        else
        {
            String list[] = getFileObject().list();
            if (list != null)
            {
                for (int i = 0; i < list.length; i++)
                {
                    FileTreeNode subnode = new FileTreeNode(new File(getFileObject(),
                            list[i]));
                    add(subnode);
                    if (b)
                        subnode.readTree(b);
                }
            }
            hasbeenread = true;
        }
        return true;
    }

    public File getFileObject()
    {
        return (File) getUserObject();
    }

    public String toString()
    {
        return getFileObject().getName();
    }

    public boolean isLeaf()
    {
        boolean bRet = false;

        String fName = ((File) userObject).getName();

        if (fName.endsWith(IDEImporter.JAVALIBRARYEXT))
            bRet = false;
        else if (fName.endsWith(IDEImporter.JAVALIBRARYCLASS))
            bRet = true;
        else if (((File) userObject).isFile())
            bRet = true;

        return bRet;
    }
}

class CustomTreeCellRenderer extends DefaultTreeCellRenderer
{
    protected ImageIcon JarIcon;
    protected ImageIcon JarClassIcon;
    protected HammerImageIconFactory CellRIconFactory = null;

    public CustomTreeCellRenderer(HammerImageIconFactory objIconFactory, String ImgDirectory)
    {
        super();
        CellRIconFactory = objIconFactory;
        JarIcon = CellRIconFactory.getHammerImageIcon(ImgDirectory + "jar.png");
        JarClassIcon = CellRIconFactory.getHammerImageIcon(ImgDirectory + "component_green.png");
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value,
                                                  boolean selection, boolean expanded,
                                                  boolean leaf, int row, boolean hasFocus)
    {
        super.getTreeCellRendererComponent(tree, value, selection, expanded,
                leaf, row, hasFocus);

        //The value object is nothing but the DefaultMutableTreeNode.
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
        setIconAndToolTip(node.getUserObject());

        return this;
    }

    private void setIconAndToolTip(Object obj)
    {
        if (obj instanceof File)
        {
            File objFile = (File) (obj);

            if (objFile.getName().endsWith(IDEImporter.JAVALIBRARYEXT))
            {
                setIcon(JarIcon);
            }
            else if (objFile.getName().endsWith(IDEImporter.JAVALIBRARYCLASS))
            {
                setIcon(JarClassIcon);
                setText(objFile.getPath());
            }
        }
    }
}

/**
 * Listens for expansion events
 */
class HierarchyBrowserUpdater implements
        TreeExpansionListener, TreeSelectionListener, MouseListener
{
    FileTreeNode root;
    JTree jtree;
    DefaultTreeModel treemodel;
    IDEImporter frame;

    public HierarchyBrowserUpdater(JTree tree, FileTreeNode node,
                                   DefaultTreeModel tmodel, IDEImporter theFrame)
    {
        root = node;
        jtree = tree;
        treemodel = tmodel;
        frame = theFrame;
    }

    public void treeExpanded(TreeExpansionEvent event)
    {

        TreePath path = event.getPath();
        FileTreeNode node = (FileTreeNode) path.getLastPathComponent();

        frame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        frame.setEnabled(false);

        if (node.readTree())
        {
            int childrenIdx[] = new int[node.getChildCount()];
            int i = 0;
            for (Enumeration e = node.children(); e.hasMoreElements();)
            {
                Object obj = e.nextElement();
                childrenIdx[i] = node.getIndex((TreeNode) obj);
                i++;
            }
            treemodel.nodesWereInserted(node, childrenIdx);
        }
        frame.setEnabled(true);
        frame.setCursor(Cursor.getDefaultCursor());
    }

    public void treeCollapsed(TreeExpansionEvent event)
    {
    }

    /*
     * Utility routine to paper over array type names
     */
    static String getTypeName(Class type)
    {
        if (type.isArray())
        {
            try
            {
                Class cl = type;
                int dimensions = 0;
                while (cl.isArray())
                {
                    dimensions++;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; i++)
                {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable e)
            { /*FALLTHRU*/
            }
        }
        return type.getName();
    }

    /**
     * Supported Data Types:
     * - boolean, byte, double, float, int, long, short and String
     * - Border (javax.swing)
     * - Color (java.awt)
     * - Font (java.awt)
     * - Point (java.awt)
     * @param propClass
     * @return
     */
    boolean isSupportedPropertyType(Class propClass)
    {
        if ( propClass != null &&
             (propClass.equals(java.lang.String.class) ||
              propClass.equals(javax.swing.border.Border.class) ||
              propClass.equals(java.awt.Font.class) ||
              propClass.equals(java.awt.Color.class) ||
              propClass.equals(java.awt.Point.class) ||
              propClass.equals(java.lang.Long.class) ||
              propClass.getName().equals("byte") ||
              propClass.equals(java.lang.Byte.class) ||
              propClass.getName().equals("short") ||
              propClass.equals(java.lang.Short.class) ||
              propClass.getName().equals("float") ||
              propClass.equals(java.lang.Float.class) ||
              propClass.getName().equals("long") ||
              propClass.equals(java.lang.Double.class) ||
              propClass.getName().equals("double") ||
              propClass.equals(java.lang.Integer.class) ||
              propClass.getName().equals("int") ||
              propClass.equals(java.lang.Boolean.class) ||
              propClass.getName().equals("boolean")))
        {
            return true;
        }

        return false;
    }

    public void valueChanged(TreeSelectionEvent e)
    {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) jtree.getLastSelectedPathComponent();
        if (node == null)
            return;
        Object nodeInfo = node.getUserObject();

        String rawClassString = (nodeInfo.toString()).replace(File.separatorChar, '.');
        String classFileName = null;

        if (rawClassString.startsWith(File.pathSeparator, 1))
        {
            String tmp = (nodeInfo.toString()).replace(File.separatorChar, '.');
            classFileName = tmp.substring(3, tmp.length());

        }
        else
            classFileName = (nodeInfo.toString()).replace(File.separatorChar, '.');

        DefaultListModel model = new DefaultListModel();
        DefaultListModel eventListModel = new DefaultListModel();

        String normalizedClsName = classFileName.substring(0, classFileName.length() - 6);
        Class tmpClass = null;
        try
        {
            tmpClass = Class.forName(normalizedClsName);

            fillPropertiesList(tmpClass, model);
            fillEventList(tmpClass, eventListModel);
        }
        catch (Exception e1)
        {
        }

        if ( tmpClass!=null )
            frame.btnImport.setEnabled(true);
        else
            frame.btnImport.setEnabled(false);

        frame.propList.setModel(model);
        frame.eventList.setModel(eventListModel);
    }

    private void fillPropertiesList(Class tmpClass, DefaultListModel model) throws IntrospectionException
    {
        BeanInfo bi = Introspector.getBeanInfo(tmpClass);

        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        for (int i = 0; i < pds.length; i++)
        {
            Class propClass = pds[i].getPropertyType();
            if ( isSupportedPropertyType(propClass) )
            {
                String propName = pds[i].getName();
                model.addElement(propName); //model.addElement(propName + "(" + propClass.getName() + ")");
            }
        }
    }

    boolean isDefaultListener( String sListenerName )
    {
        // basic listeners that all classes get.
        ListenerCollection listenerCollection = this.frame.theDesignCockpit.theMetadataDispenser.getListenerCollection();
        int iBasicSwingListeners = listenerCollection.iListenerCount;
        for (int iListener = 0; iListener < iBasicSwingListeners; iListener++) {
            String sName = listenerCollection.getDefaultListenerName(iListener);
            if ( sName.equalsIgnoreCase(sListenerName) )
                return true;
        }

        return false;
    }

    private void fillEventList(Class tmpClass, DefaultListModel model) throws IntrospectionException
    {

        BeanInfo bi = Introspector.getBeanInfo(tmpClass);
        EventSetDescriptor[] eds = bi.getEventSetDescriptors();
        for (int i = 0; i < eds.length; i++)
        {
            String propName = eds[i].getListenerType().getSimpleName();
            if ( !isDefaultListener(propName) )
                model.addElement(propName);
        }
    }

    public void mouseClicked(MouseEvent e)
    {
        if (e.getClickCount() == 2)
        {
            int index = frame.propList.locationToIndex(e.getPoint());
            System.out.println("Double clicked on Item " + index);
        }
    }

    public void mouseExited(MouseEvent e)
    {
    }

    public void mouseEntered(MouseEvent e)
    {
    }

    public void mousePressed(MouseEvent e)
    {
    }

    public void mouseReleased(MouseEvent e)
    {
    }

}

class DriveComboListener implements ActionListener
{
    // Retain the previously selected item in order to determine whether
    // the new item is the same
    Object oldItem;
    protected IDEImporter importerObject;

    public DriveComboListener(IDEImporter theImporter)
    {
        importerObject = theImporter;
    }

    public void actionPerformed(ActionEvent evt)
    {
        JComboBox cb = (JComboBox) evt.getSource();

        // Get the new item
        Object newItem = cb.getSelectedItem();

        // Determine if different from previously selected item
        boolean same = newItem.equals(oldItem);
        oldItem = newItem;

        if ("comboBoxEdited".equals(evt.getActionCommand()))
        {
            // User has typed in a string; only possible with an editable combobox
        }
        else if ("comboBoxChanged".equals(evt.getActionCommand()))
        {
            if (importerObject.tree != null)
            {
                String driveLetter = newItem.toString();

                FileTreeNode root = (FileTreeNode) importerObject.buildTree(driveLetter);
                DefaultTreeModel treemodel = (DefaultTreeModel) importerObject.tree.getModel();
                treemodel.setRoot(root);
                FileTreeNode node = (FileTreeNode) treemodel.getRoot();
                treemodel.nodeStructureChanged(node);
            }
        }
    }
}


public class IDEImporter extends JAFrame implements WindowListener
{
    public static final String JAVALIBRARYEXT = new String(".jar");
    public static final String JAVALIBRARYCLASS = new String(".class");

    protected JAButton btnImport = new JAButton("Import");
    protected JAButton btnCancelImport = new JAButton("Cancel");
    protected SuperDesignCockpit theDesignCockpit = null;
    protected JTree tree = null;
    protected JScrollPane treeView = null;
    protected JScrollPane propListView = null;
    protected JScrollPane classListView = null;
    protected JComboBox driveCombo;
    protected JAList propList = new JAList();
    protected ClassTree classList = new ClassTree();
    protected ImageIcon impIcon;
    protected ImageIcon impStopIcon;
    protected HammerConfigurationManager theConfigurationManager = null;
    protected HammerImageIconFactory theIconFactory = null;
    protected String sImageDirectory;
    private JScrollPane eventListView;
    public JAList eventList = new JAList();
    private JACheckBox compositeCheckbox;
    JPanel panel2 = new JPanel();
    JAButton btnBack = new JAButton("<< Back");
    JPanel drivePanel;
    int btnNextX=190;
    int btnBackX=190;
    int btnImportX=5;
    int btnCancelX=100;

    public IDEImporter(SuperDesignCockpit objDesignCockpit)
    {
        setTitle("Class Importer");
        theDesignCockpit = objDesignCockpit;
        AnchoringLayoutManager layoutManagerJAFrameXSubclass0Subclass01 = new AnchoringLayoutManager();
        getContentPane().setLayout(layoutManagerJAFrameXSubclass0Subclass01);
        Border loweredetched = BorderFactory.createEtchedBorder();
        setSize(700, 320);

        // Button locations
        btnNextX=(int)getSize().getWidth() - ((int)btnBack.getPreferredSize().getWidth() + (int)getInsets().right + 20);
        btnBackX=(int)getSize().getWidth() - ((int)btnBack.getPreferredSize().getWidth() + (int)getInsets().right + 20);
        btnCancelX=btnBackX - ((int)btnCancelImport.getPreferredSize().getWidth() + (int)getInsets().right + 20);
        btnImportX=btnCancelX - ((int)btnImport.getPreferredSize().getWidth() + (int)getInsets().right + 20);

        panel2.setLayout(new GridLayout(1,4,5,5));
        panel2.setSize(new Dimension(700, 250));
        panel2.setVisible(false);
        getContentPane().add(panel2, "panel2");

        Container jParContainer = objDesignCockpit;
        Dimension dm = jParContainer.getSize();

        Double wLoc = new Double((dm.getWidth() / 2) - this.getWidth() / 2);
        Double hLoc = new Double((dm.getHeight() / 2) - this.getHeight() / 2);

        setLocation(wLoc.intValue(), hLoc.intValue());
        this.addWindowListener(this);
        SetIcons();

        btnImport.setEnabled(false);
        btnImport.setLocation(btnNextX, 260);
        btnImport.setText("Next >>");

        //btnImport.setIcon(impIcon);
        //btnCancelImport.setIcon(impStopIcon);

        //  Add the control btnImport to the content pane.
        getContentPane().add(btnImport, "btnImport");
        layoutManagerJAFrameXSubclass0Subclass01.setAnchoring(btnImport, false, false, false, false);

        btnCancelImport.setLocation(btnCancelX, 260);
        btnCancelImport.setText("Cancel");

        //  Add the control btnCancelImport to the content pane.
        getContentPane().add(btnCancelImport, "btnCancelImport");
        layoutManagerJAFrameXSubclass0Subclass01.setAnchoring(btnCancelImport, false, false, false, false);

        // Retrieve all available drives
        driveCombo = new JComboBox();
        String sdefaultdir = getRepositoryPath(theDesignCockpit.getDesignProject().theMetaProject);
        driveCombo.addItem(sdefaultdir);
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; i++)
            driveCombo.addItem(roots[i].toString());
        DefaultTreeModel treemodel = setJListModel(sdefaultdir);
        tree = new JTree(treemodel);
        tree.setDoubleBuffered(true);
        FileTreeNode root = (FileTreeNode) treemodel.getRoot();
        HierarchyBrowserUpdater upd = new HierarchyBrowserUpdater(tree, root, treemodel, this);

        tree.addTreeExpansionListener(upd);
        tree.addTreeSelectionListener(upd);
        CustomTreeCellRenderer customCellRenderer = new CustomTreeCellRenderer(theIconFactory, sImageDirectory);
        tree.setCellRenderer(customCellRenderer);

        // Wizard Panel 1
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayout(1,3,10,5));
        panel1.setPreferredSize(new Dimension(690, 250));
        panel1.setMaximumSize(new Dimension(690, 250));

        // Create Component selection panel
        drivePanel = createClassFilePanel();
        drivePanel.setBorder(BorderFactory.createEtchedBorder());
        drivePanel.setPreferredSize( new Dimension(500, 250) );
        drivePanel.setMinimumSize( new Dimension(500, 250) );
        panel1.add(drivePanel);

        // Section in component tree
        classListView = new JScrollPane(classList);
        classListView.setViewportView(classList);
        JPanel classListPanel = new JPanel();
        classListPanel.setLayout(new BorderLayout());
        classListPanel.add(new JLabel("Import under"), BorderLayout.NORTH);
        classListPanel.add(classListView, BorderLayout.CENTER);
        classListPanel.setBorder(loweredetched);
        panel1.add(classListPanel);

        String labelText1 =
            "<html>" +
            "<TABLE><TR valign=top><TD valign=top align=left>" +
            "<OL>" +
            "<LI>Select the Component class file from the File selection dialog.</LI>" +
            "<LI>Select the Section name to import your component under.</LI>" +
            "<LI>Click on the Next button to continue the import or Cancel to exit.</LI><P>" +
            "</OL>" +
            "</TD></TR></TABLE>" +
            "</html>";
        JLabel label1 = new JLabel(labelText1, SwingConstants.LEFT);
        label1.setBorder(BorderFactory.createTitledBorder("Instructions"));
        panel1.add(label1);

        getContentPane().add(panel1, "panel1");


        // Properties list
        propListView = new JScrollPane(propList);
        propListView.setViewportView(propList);
        JPanel propListPanel = new JPanel();
        propListPanel.setLayout(new BorderLayout());
        propListPanel.add(new JLabel("Properties"), BorderLayout.NORTH);
        propListPanel.add(propListView, BorderLayout.CENTER);
        propListPanel.setPreferredSize(new Dimension(130, 200));
        propListPanel.setBorder(loweredetched);
        panel2.add(propListPanel);
        propList.addMouseListener(upd);

        // Event list
        eventListView = new JScrollPane(eventList);
        eventListView.setViewportView(eventList);
        JPanel eventListPanel = new JPanel();
        eventListPanel.setLayout(new BorderLayout());
        eventListPanel.add(new JLabel("Events"), BorderLayout.NORTH);
        eventListPanel.add(eventListView, BorderLayout.CENTER);
        eventListPanel.setPreferredSize(new Dimension(130, 200));
        eventListPanel.setBorder(loweredetched);
        panel2.add(eventListPanel);
        eventList.addMouseListener(upd);

        // Fill Class section list
        Vector metaVector = null;
        MetaProject mtProj = theDesignCockpit.getDesignProject().theMetaProject;
        MetaClass topClass = theDesignCockpit.getDesignProject().theMetaProject.getFirstClass();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("New Section");
        rootNode.add(node);
        while (topClass!=null)
        {
            node = new DefaultMutableTreeNode(topClass.theMetadata.sClassName);
            metaVector = mtProj.getMetadataDispenser().getMetaClassesList(topClass);
            for ( int i=0; i<metaVector.size(); i++ )
            {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(metaVector.get(i));
                node.add(child);
            }
            rootNode.add(node);

            topClass = topClass.getNextSibling();
        }
        classList.setModel(new DefaultTreeModel(rootNode));
        classList.expandAll();

        btnImport.addActionListener(new OKListener(this, this.theDesignCockpit, tree));
        btnCancelImport.addActionListener(new CancelListener(this));

        //layoutManagerJAFrameXSubclass0Subclass01.setAnchoring(classListView, false, false, false, false);
        //layoutManagerJAFrameXSubclass0Subclass01.setAnchoring(treeView, false, false, false, false);
        //layoutManagerJAFrameXSubclass0Subclass01.setAnchoring(propListView, false, false, false, false);

        /*  Popup component selection dialog
        final ComponentSelectDialog componentSelectDialog = createComponentSelectDialog(drivePanel);
        componentSelectDialog.setLocation(wLoc.intValue(), hLoc.intValue());
        componentSelectDialog.setSize(300,420);
        componentSelectDialog.show();
        if ( !componentSelectDialog.okSelected )
            return;
        */

        compositeCheckbox = new JACheckBox("Composite");
        compositeCheckbox.setToolTipText("Display child components in design mode");
        JPanel compositePanel = new JPanel();
        compositePanel.setLayout(new BorderLayout());
        compositePanel.add(compositeCheckbox, BorderLayout.NORTH);

        // Help
        String labelText =
            "<html>" +
            "<TABLE><TR valign=top><TD>" +
            "<OL>" +
            "<LI>Select the section to import your component under.</LI>" +
            "<LI>Choose the Properties you would like to import from the Properties list.</LI>" +
            "<LI>Choose all Listeners you would like to import from the Event list.</LI>" +
            "<LI>Click on the Import button to complete the process.</LI>" +
            "<OL>" +
            "</TD></TR></TABLE>" +
            "</html>";
        JLabel label = new JLabel(labelText, JLabel.CENTER);
        label.setBorder(BorderFactory.createTitledBorder("Instructions"));
        label.setPreferredSize(new Dimension(215, 200));
        compositePanel.add(label, BorderLayout.WEST);
        panel2.add(compositePanel);

        btnBack.setVisible(false);
        getContentPane().add(btnBack, "btnBack");
        btnBack.setLocation(btnBackX, 260);
        btnBack.addActionListener(new BackListener(this, this.theDesignCockpit, tree));

        // Show the main window
        show();
    }

    class BackListener implements ActionListener
    {
        IDEImporter theImporter = null;
        SuperDesignCockpit theDesignCockpit = null;

        public BackListener(IDEImporter objImporter, SuperDesignCockpit theDesignCockpit, JTree theJtree)
        {
            theImporter = objImporter;
            this.theDesignCockpit = theDesignCockpit;
            tree = theJtree;
        }

        public void actionPerformed(ActionEvent evt)
        {
            try
            {
                theImporter.setTitle("Class Importer");
                theImporter.btnBack.setVisible(false);
                theImporter.btnImport.setLocation(btnNextX, 260);
                theImporter.btnImport.setText("Next >>");
                theImporter.panel2.setVisible(false);
                theImporter.drivePanel.setVisible(true);
            }
            catch (Exception e)
            {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null,e);
            }
        }
    }

    private class ComponentSelectDialog extends JDialog
    {
        public boolean okSelected=false;

        public ComponentSelectDialog()
                throws HeadlessException
        {
            super(IDEImporter.this, "Select Component", true);
        }
    }

    private ComponentSelectDialog createComponentSelectDialog(JPanel drivePanel)
    {
        final ComponentSelectDialog componentSelectDialog = new ComponentSelectDialog();

        componentSelectDialog.setLayout(new BorderLayout());
        componentSelectDialog.add(drivePanel, BorderLayout.NORTH);
        JPanel okCancelPanel = new JPanel();

        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e)
            {
                componentSelectDialog.setVisible(false);
            }
        });

        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e)
            {
                componentSelectDialog.okSelected=true;
                componentSelectDialog.setVisible(false);
            }
        });

        okCancelPanel.add(okButton);
        okCancelPanel.add(cancelButton);
        componentSelectDialog.add(okCancelPanel, BorderLayout.CENTER);

        return componentSelectDialog;
    }

    /**
     * Select component class file
     */
    private JPanel createClassFilePanel()
    {
        JPanel drivePanel = new JPanel();
        drivePanel.setLayout(new BorderLayout());
        JLabel alabel = new JLabel("Component Selection", SwingConstants.LEFT);
        alabel.setSize(new Dimension(300, 20));
        drivePanel.add(alabel, BorderLayout.NORTH);
        DriveComboListener actionListener = new DriveComboListener(this);
        driveCombo.addActionListener(actionListener);
        driveCombo.setSize(new Dimension(300, 15));
        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        treeView = new JScrollPane(tree);
        treeView.setSize(new Dimension(300, 200));
        treeView.setFocusable(true);
        treeView.setViewportView(tree);

        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add(driveCombo, BorderLayout.NORTH);
        contentPanel.add(treeView, BorderLayout.CENTER);

        drivePanel.add(contentPanel, BorderLayout.CENTER);

        return drivePanel;
    }

    class ClassTree extends JATree
    {
        public ClassTree()
        {
            putClientProperty("JTree.lineStyle", "Angled");
            ((BasicTreeUI)getUI()).setRightChildIndent(8);
            ((BasicTreeUI)getUI()).setLeftChildIndent(5);
            ((BasicTreeUI)getUI()).setExpandedIcon(new WindowsTreeUI.ExpandedIcon());
            ((BasicTreeUI)getUI()).setCollapsedIcon(new WindowsTreeUI.CollapsedIcon());
            setRootVisible(false);

            expandAll();
        }

        public void expandAll() {
            int row = 0;
            while (row < getRowCount()) {
                expandRow(row);
                row++;
            }
        }
    }

    public DefaultTreeModel setJListModel(String driveLetter)
    {

        FileTreeNode root = (FileTreeNode) buildTree(driveLetter);
        DefaultTreeModel treemodel = new DefaultTreeModel(root);

        return treemodel;
    }

    protected void SetIcons()
    {
        theConfigurationManager = theDesignCockpit.getConfigurationManager();
        sImageDirectory = theConfigurationManager.getConfigurationVariable("ImagePath");

        if (sImageDirectory == null)
            sImageDirectory = "";
        else
        {
            if ((sImageDirectory.endsWith("/") == false) && (sImageDirectory.endsWith("\\") == false))
                sImageDirectory = sImageDirectory + "/";  // find in jars.
        }

        // Icon Creation Section
        theIconFactory = new HammerImageIconFactory(theDesignCockpit.theClassLoader);

        impIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "import1.png");
        impStopIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "media_stop_red.png");
    }

    public TreeNode buildTree(String dir)
    {
        FileTreeNode aroot = null;
        try
        {
            aroot = new FileTreeNode(new File(dir));
            aroot.readTree(false);
        }
        catch (Exception e)
        {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        return (TreeNode) aroot;
    }

    public void valueChanged(TreeSelectionEvent e)
    {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                tree.getLastSelectedPathComponent();

        if (node == null)
            return;

        Object nodeInfo = node.getUserObject();
        if (node.isLeaf())
        {

        }
        else
        {

        }
    }

    boolean Import(MetaProject theDesignProject) throws ClassNotFoundException
    {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) tree.getLastSelectedPathComponent();
        if (node == null)
            return false;
        Object oUserObject = node.getUserObject();
        String UnClassesToImport = oUserObject.toString();
        String sClassToImport = UnClassesToImport.replace(File.separator, ".").substring(0, UnClassesToImport.length() - 6);

        Metafier theMetafier = new Metafier(sClassToImport);
        if ( !theMetafier.processClass() )
        {
            return false;
        }

        //System.err.println(theMetafier.theDocument.toString());

        String repositoryPath = getRepositoryPath(theDesignProject);

        String xmlFilename = repositoryPath+File.separator+sClassToImport+".xml";
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(xmlFilename));
        if ( fc.showSaveDialog(this)!=JFileChooser.APPROVE_OPTION )
            return false;
        File selFile = fc.getSelectedFile();
        if ( selFile.exists() )
        {
            int iretval = JOptionPane.showConfirmDialog(this, "File exists, overwrite?\n", "Message", JOptionPane.YES_NO_OPTION);
            if ( iretval!=JOptionPane.YES_OPTION )
                return false;
        }

        try
        {
            theMetafier.theDocument.write(selFile);
        }
        catch (IOException e)
        {
            JOptionPane.showMessageDialog(this,"Can't write to file:\n"+selFile.getAbsolutePath()+"\n"+e, "Error", JOptionPane.ERROR_MESSAGE);
            return false;
        }

        repositoryPath = selFile.getParent();

        // Update default.conf
        theDesignCockpit.thePreferences.setRepositPath(repositoryPath);
        DefaultMutableTreeNode pnode = (DefaultMutableTreeNode)node.getParent();
        String additionalPath = pnode.getUserObject().toString();
        String oldPath = theDesignCockpit.thePreferences.getAdditionalClasspath();
        if ( oldPath==null )
        {
            theDesignCockpit.thePreferences.setAdditionalClasspath(additionalPath);
        }
        else if ( oldPath.indexOf(additionalPath)==-1 )
        {
            theDesignCockpit.thePreferences.setAdditionalClasspath(oldPath+";"+additionalPath);
        }
        theDesignCockpit.thePreferences.save(theDesignCockpit);

        // Reload component palette.
        theDesignCockpit.getDesignProject().theMetaProject.resetMetadata();
        theDesignCockpit.getDesignProject().theMetaProject.loadMeta("ch.abacus.lib.ui.renderer.deploy.metadata.meta");

        theDesignCockpit.theComponentPalettePane.clear();
        theDesignCockpit.getDesignProject().theMetaProject.loadCustomMeta("ch.abacus.lib.ui.renderer.deploy.metadata.meta", repositoryPath);
        theDesignCockpit.theComponentPalettePane.load(theDesignCockpit.getDesignProject().theMetaProject.getFirstClass(), null);
        theDesignCockpit.setbMetadataDirty(true);

        return true;
    }

    private String getRepositoryPath(MetaProject theDesignProject)
    {
        String repositoryPath = theDesignProject.getMetaDataUser().getConfigurationManager().getConfigurationVariable("RepositoryPath");
        repositoryPath = new File(repositoryPath).getAbsolutePath();
        if ( repositoryPath==null || repositoryPath.length()==0 )
            repositoryPath = theDesignProject.getProjectDirectory();
        if ( repositoryPath==null || repositoryPath.length()==0 )
            repositoryPath=System.getProperty("user.home");
        return repositoryPath;
    }

    class OKListener implements ActionListener
    {
        IDEImporter theImporter = null;
        SuperDesignCockpit theDesignCockpit = null;

        public OKListener(IDEImporter objImporter, SuperDesignCockpit theDesignCockpit, JTree theJtree)
        {
            theImporter = objImporter;
            this.theDesignCockpit = theDesignCockpit;
            tree = theJtree;
        }

        public void actionPerformed(ActionEvent evt)
        {
            try
            {
                if ( theImporter.drivePanel.isVisible())
                {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode) tree.getLastSelectedPathComponent();
                    Object oUserObject = node.getUserObject();

                    theImporter.setTitle("Class Importer: "+oUserObject.toString());
                    theImporter.btnBack.setVisible(true);
                    theImporter.btnImport.setLocation(btnImportX, 260);
                    theImporter.btnImport.setText("Import");
                    theImporter.drivePanel.setVisible(false);
                    theImporter.panel2.setVisible(true);
                }
                else if ( theImporter.panel2.isVisible())
                {
                    if ( theImporter.Import(theDesignCockpit.getDesignProject().theMetaProject)==true )
                        theImporter.setVisible(false);
                }
            }
            catch (ClassNotFoundException e)
            {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null,e);
            }
        }
    }

    class CancelListener implements ActionListener
    {
        IDEImporter theImporter = null;

        public CancelListener(IDEImporter objImporter)
        {
            theImporter = objImporter;
        }

        public void actionPerformed(ActionEvent evt)
        {
            theImporter.hide();
        }

    }

    class Metafier
    {
        public String sClassName = "default";
        public String sShortName = "";
        Class theClass = null;
        Class theJAComponentClass = null;
        Class theJAPanelClass = null;
        Class theJAFrameClass = null;
        Class theJAScrollPaneClass = null;
        Class theJATabbedPaneClass = null;
        Class theScrollBarClass = null;
        Class theSliderClass = null;
        Class theListClass = null;
        Class theTextAreaClass = null;
        Class theRadioClass = null;
        Class theCheckBoxClass = null;
        Class theComboBoxClass = null;
        Class theTextFieldClass = null;
        Class theLabelClass = null;
        public electric.xml.Document theDocument = null;
        public electric.xml.Element theRootElement = null;
        //String[] theSkippedProperties = {"Width", "Height", "Left", "Top", "Size", "Location", "Text", "Background", "Foreground"};
        String[] theSkippedProperties = {"Size", "Location"};

        public Metafier()
        {
        }

        public Metafier(String theClassName)
        {
            sClassName = theClassName;
        }

        boolean processClass() throws ClassNotFoundException
        {
            loadClass();

            boolean bTest = initializeMetadata();

            if (bTest)
                bTest = processClassHeaderInformation();

            //if (bTest)
            //    bTest = addClassEvents();

            if (bTest)
                bTest = addDefaultProperties();

            if (bTest)
                bTest = addClassProperties();

            //if (bTest)
            //    bTest = addClassFields();

            return bTest;
        }

        void loadClass() throws ClassNotFoundException
        {
            theClass = Class.forName(sClassName);
            int iLastDot = sClassName.lastIndexOf(".");  // returns -1 for not found so gives whole string.
            sShortName = sClassName.substring(iLastDot + 1);

            try
            {
                theJAComponentClass = Class.forName("javax.swing.JAComponent");
                theJAFrameClass = Class.forName("javax.swing.JAFrame");
                theJAPanelClass = Class.forName("javax.swing.JAPanel");
                theJAScrollPaneClass = Class.forName("javax.swing.JAScrollPane");
                theJATabbedPaneClass = Class.forName("javax.swing.JATabbedPane");
                theScrollBarClass = Class.forName("javax.swing.JAScrollBar");
                theSliderClass = Class.forName("javax.swing.JASlider");
                theListClass = Class.forName("javax.swing.JAList");
                theTextAreaClass = Class.forName("javax.swing.JATextArea");
                theRadioClass = Class.forName("javax.swing.JARadioButton");
                theCheckBoxClass = Class.forName("javax.swing.JACheckBox");
                theComboBoxClass = Class.forName("javax.swing.JAComboBox");
                theTextFieldClass = Class.forName("javax.swing.JATextField");
                theLabelClass = Class.forName("javax.swing.JALabel");
            }
            catch (java.lang.ClassNotFoundException e2)
            {
            }
        }

        /**
         *  <Component Section Name> - "Custom" OR "stdAbacusComponents"
         *      <Classes>
         *         <Class Section Name> -
         *           <Classes>
         *              <Class Name> -
         *                 <FullClassName>com.castellumtech.components.JOvalButton</FullClassName>
         *                  :
         *
         * @return
         */
        boolean initializeMetadata()
        {
            if ( classList.getSelectionPath()==null )
            {
                JOptionPane.showMessageDialog(null, "Please select a Section","Error",JOptionPane.ERROR_MESSAGE);
                return false;
            }

            theDocument = new electric.xml.Document();
            String componentSection = (String)classList.getSelectionPath().getPath()[classList.getSelectionPath().getPath().length-1].toString();
            if ( componentSection.equalsIgnoreCase("New Section") )
                componentSection = "Custom";

            String classSectionName = (String)classList.getSelectionPath().getPath()[classList.getSelectionPath().getPath().length-1].toString();
            if ( classSectionName==null )
            {
                JOptionPane.showMessageDialog(null, "Please select a Section","Error",JOptionPane.ERROR_MESSAGE);
                return false;
            }

            theRootElement = new electric.xml.Element(componentSection);
            theDocument.setRoot(theRootElement);

            electric.xml.Element rootClassesTag = new electric.xml.Element("Classes");
            theRootElement.addElement(rootClassesTag);

            if ( componentSection.equalsIgnoreCase("Custom") )
            {
                classSectionName = (String)JOptionPane.showInputDialog(null,"Component Section Name", "New Component Section",JOptionPane.OK_OPTION);
            }
            electric.xml.Element sectionTag = new electric.xml.Element(classSectionName);
            rootClassesTag.addElement(sectionTag);

            // Add global listeners
            addClassEvents(sectionTag);

            electric.xml.Element classTag = new electric.xml.Element("Classes");
            sectionTag.addElement(classTag);

            electric.xml.Element shortName = new electric.xml.Element(sShortName);
            classTag.addElement(shortName);

            electric.xml.Element theFullClassName = new electric.xml.Element("FullClassName");
            theFullClassName.addText(sClassName);
            shortName.addElement(theFullClassName);

            theRootElement = shortName;

            return true;
        }

        boolean IsSubclass(Class theTestClass, Class thePossibleSuper)
        {
            if (theTestClass == null)
                return false;
            if (theTestClass.equals(thePossibleSuper))
                return true;
            theTestClass = theTestClass.getSuperclass();
            return IsSubclass(theTestClass, thePossibleSuper);
        }

        boolean processClassHeaderInformation()
        {
            // Add superclass information.
            Class theSuperclass = theClass.getSuperclass();
            if (theSuperclass != null)
            {
                electric.xml.Element theSuperclassElement = new electric.xml.Element("Superclass");
                electric.xml.Element theName = new electric.xml.Element("Name");
                electric.xml.Element theFullPath = new electric.xml.Element("FullPath");
                String sSuperClassName = theSuperclass.getName();
                theFullPath.setText(sSuperClassName);
                int iLastDot = sSuperClassName.lastIndexOf(".");
                sSuperClassName = sSuperClassName.substring(iLastDot + 1);
                theName.setText(sSuperClassName);
                theRootElement.addElement(theSuperclassElement);
                theSuperclassElement.addElement(theName);
                theSuperclassElement.addElement(theFullPath);
            }
            boolean bIsJAComponent = IsSubclass(theClass, theJAComponentClass);
            boolean bIsJAFrame = IsSubclass(theClass, theJAFrameClass);
            boolean bIsJAPanel = IsSubclass(theClass, theJAPanelClass);
            boolean bIsJATabbedPane = IsSubclass(theClass, theJATabbedPaneClass);
            boolean bIsJAScrollPane = IsSubclass(theClass, theJAScrollPaneClass);
            boolean bIsJAScrollBar = IsSubclass(theClass, theScrollBarClass);
            boolean bIsJASlider = IsSubclass(theClass, theSliderClass);
            boolean bIsJAList = IsSubclass(theClass, theListClass);
            boolean bIsJATextArea = IsSubclass(theClass, theTextAreaClass);
            boolean bIsJARadio = IsSubclass(theClass, theRadioClass);
            boolean bIsJACheckBox = IsSubclass(theClass, theCheckBoxClass);
            boolean bIsJAComboBox = IsSubclass(theClass, theComboBoxClass);
            boolean bIsJATextField = IsSubclass(theClass, theTextFieldClass);
            boolean bIsJALabel = IsSubclass(theClass, theLabelClass);

            if (bIsJAFrame)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("FrameCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add container type
                electric.xml.Element theContainerType = new electric.xml.Element("ContainerType");
                theContainerType.setText("frame");
                theRootElement.addElement(theContainerType);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("ch.abacus.designcockpit.ide.DesignPanel");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJAScrollPane)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("SwingCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add container type
                electric.xml.Element theContainerType = new electric.xml.Element("ContainerType");
                theContainerType.setText("scrollpane");
                theRootElement.addElement(theContainerType);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JAPanel");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJAPanel)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("PanelCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add container type
                electric.xml.Element theContainerType = new electric.xml.Element("ContainerType");
                theContainerType.setText("panel");
                theRootElement.addElement(theContainerType);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JAPanel");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJATabbedPane)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("SwingCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add container type
                electric.xml.Element theContainerType = new electric.xml.Element("ContainerType");
                theContainerType.setText("tabbedpane");
                theRootElement.addElement(theContainerType);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JATabbedPane");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJAScrollBar)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("ScrollBarCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JAScrollBar");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJASlider)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("SliderCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JASlider");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJAList)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("ListCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JAList");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJATextArea)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("TextAreaCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JATextArea");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJARadio)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("RadioButtonCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JARadioButton");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJACheckBox)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("CheckBoxCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JACheckBox");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJAComboBox)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("ComboBoxCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JAComboBox");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJATextField)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("ControlCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JATextField");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else if (bIsJALabel)
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("ControlCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText("javax.swing.JALabel");
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }
            else
            {
                // Add code generator (if jcomponent then SwingCodeGenerator)
                electric.xml.Element theCodeGenerator = new electric.xml.Element("Custom");
                theCodeGenerator.setText("SwingCodeGenerator");
                theRootElement.addElement(theCodeGenerator);
                // Add display (use this class if it is a jcomponent else use DesignPanel.)
                electric.xml.Element theDisplayClass = new electric.xml.Element("Display");
                theDisplayClass.setText(sClassName);
                theRootElement.addElement(theDisplayClass);
                // Add listeners (check if listener methods exist for the class)
            }

            // <CompositeComponent/>
            if ( compositeCheckbox.isSelected() )
            {
                electric.xml.Element aCompositeComponent = new electric.xml.Element("CompositeComponent");
                theRootElement.addElement(aCompositeComponent);
            }

            return true;
        }

        boolean addMemberData()
        {
            Field[] theFields = theClass.getFields();
            Modifier mod = new Modifier();
            for (int i = 0; i < theFields.length; i++)
            {
                Class clsType = theFields[i].getType();
                String sName = theFields[i].getName();
                int iModifiers = theFields[i].getModifiers();
                // Look for a final static that matches.
                electric.xml.Element theMemberData = new electric.xml.Element("MemberData");
                electric.xml.Element theName = new electric.xml.Element("Name");
                theName.setText(sName);
                electric.xml.Element theType = new electric.xml.Element("Type");
                theType.setText(clsType.getName());
                theMemberData.addElement(theName);
                theMemberData.addElement(theType);
                if (mod.isFinal(iModifiers))
                    theMemberData.addElement(new electric.xml.Element("final"));
                if (mod.isStatic(iModifiers))
                    theMemberData.addElement(new electric.xml.Element("static"));
                theRootElement.addElement(theMemberData);
            }
            return true;
        }

        /**
         *
            <Property>
             <Name>Location</Name>
             <Get>getLocation</Get>
             <Set>setLocation</Set>
             <Class>java.awt.Point</Class>
             <Type>Class</Type>
             <Property>
               <Name>Left</Name>
               <DefaultValue>0</DefaultValue>
               <Visible/>
               <Class>int</Class>
               <Type>Class</Type>
             </Property>
             <Property>
               <Name>Top</Name>
               <DefaultValue>0</DefaultValue>
               <Visible/>
               <Class>int</Class>
               <Type>Class</Type>
             </Property>
            </Property>

         * @param sDefaultValue
         * @return
         */
        electric.xml.Element createPointPropertyElement(String sPropertyName, Point aPoint)
        {
            return createPointPropertyElement(sPropertyName, aPoint, "x", "y");
        }
        electric.xml.Element createPointPropertyElement(String sPropertyName, Point aPoint, String xLabel, String yLabel)
        {
            int leftDefault=(int)aPoint.getX();
            int topDefault =(int)aPoint.getY();
            boolean bVisible=true;
            String sClassName=aPoint.getClass().getName();
            String sTypeName="Class";

            electric.xml.Element theProperty = new electric.xml.Element("Property");
            electric.xml.Element theName = new electric.xml.Element("Name");
            theName.setText(sPropertyName);
            electric.xml.Element theGet = new electric.xml.Element("Get");
            theGet.setText("get" + sPropertyName);
            electric.xml.Element theSet = new electric.xml.Element("Set");
            theSet.setText("set" + sPropertyName);
            electric.xml.Element theClassElement = new electric.xml.Element("Class");
            theClassElement.setText((sClassName != null) ? sClassName : sTypeName);
            electric.xml.Element theType = new electric.xml.Element("Type");
            theType.setText((sClassName != null) ? "Class" : sTypeName);
            theProperty.addElement(theName);
            theProperty.addElement(theGet);
            theProperty.addElement(theSet);
            theProperty.addElement(theClassElement);
            theProperty.addElement(theType);

            // Left
            electric.xml.Element subProp = new electric.xml.Element("Property");

                electric.xml.Element subPropName = new electric.xml.Element("Name");
                subPropName.setText(xLabel);
                subProp.addElement(subPropName);

                electric.xml.Element subPropDefaultValue = new electric.xml.Element("DefaultValue");
                subPropDefaultValue.setText(String.valueOf(leftDefault));
                subProp.addElement(subPropDefaultValue);

                if (bVisible)
                    subProp.addElement(new electric.xml.Element("Visible"));

                electric.xml.Element subPropClass = new electric.xml.Element("Class");
                subPropClass.setText("int");
                subProp.addElement(subPropClass);

                electric.xml.Element subPropType = new electric.xml.Element("Type");
                subPropType.setText("Class");
                subProp.addElement(subPropType);

            theProperty.addElement(subProp);

            // Top
            subProp = new electric.xml.Element("Property");

                subPropName = new electric.xml.Element("Name");
                subPropName.setText(yLabel);
                subProp.addElement(subPropName);

                subPropDefaultValue = new electric.xml.Element("DefaultValue");
                subPropDefaultValue.setText(String.valueOf(topDefault));
                subProp.addElement(subPropDefaultValue);

                if (bVisible)
                    subProp.addElement(new electric.xml.Element("Visible"));

                subPropClass = new electric.xml.Element("Class");
                subPropClass.setText("int");
                subProp.addElement(subPropClass);

                subPropType = new electric.xml.Element("Type");
                subPropType.setText("Class");
                subProp.addElement(subPropType);

            theProperty.addElement(subProp);

            return theProperty;
        }

        /**
         *
         <Property>
            <Name>Size</Name>
            <Get>getSize</Get>
            <Set>setSize</Set>
            <Class>java.awt.Dimension</Class>
            <Type>Class</Type>
            <Property>
              <Name>Width</Name>
              <DefaultValue>80</DefaultValue>
              <Visible/>
              <Class>int</Class>
              <Type>Class</Type>
            </Property>
            <Property>
              <Name>Height</Name>
              <DefaultValue>22</DefaultValue>
              <Visible/>
              <Class>int</Class>
              <Type>Class</Type>
            </Property>
          </Property>

         * @param sDefaultValue
         * @return
         */
        electric.xml.Element createDimensionPropertyElement(String sPropertyName, Dimension aPoint)
        {
            int wDefault=(int)aPoint.getWidth();
            int hDefault =(int)aPoint.getHeight();
            boolean bVisible=true;
            String sClassName=aPoint.getClass().getName();
            String sTypeName="Class";

            electric.xml.Element theProperty = new electric.xml.Element("Property");
            electric.xml.Element theName = new electric.xml.Element("Name");
            theName.setText(sPropertyName);
            electric.xml.Element theGet = new electric.xml.Element("Get");
            theGet.setText("get" + sPropertyName);
            electric.xml.Element theSet = new electric.xml.Element("Set");
            theSet.setText("set" + sPropertyName);
            electric.xml.Element theClassElement = new electric.xml.Element("Class");
            theClassElement.setText((sClassName != null) ? sClassName : sTypeName);
            electric.xml.Element theType = new electric.xml.Element("Type");
            theType.setText((sClassName != null) ? "Class" : sTypeName);
            theProperty.addElement(theName);
            theProperty.addElement(theGet);
            theProperty.addElement(theSet);
            theProperty.addElement(theClassElement);
            theProperty.addElement(theType);

            // Left
            electric.xml.Element subProp = new electric.xml.Element("Property");

                electric.xml.Element subPropName = new electric.xml.Element("Name");
                subPropName.setText("Width");
                subProp.addElement(subPropName);

                electric.xml.Element subPropDefaultValue = new electric.xml.Element("DefaultValue");
                subPropDefaultValue.setText(String.valueOf(wDefault));
                subProp.addElement(subPropDefaultValue);

                if (bVisible)
                    subProp.addElement(new electric.xml.Element("Visible"));

                electric.xml.Element subPropClass = new electric.xml.Element("Class");
                subPropClass.setText("int");
                subProp.addElement(subPropClass);

                electric.xml.Element subPropType = new electric.xml.Element("Type");
                subPropType.setText("Class");
                subProp.addElement(subPropType);

            theProperty.addElement(subProp);

            // Top
            subProp = new electric.xml.Element("Property");

                subPropName = new electric.xml.Element("Name");
                subPropName.setText("Height");
                subProp.addElement(subPropName);

                subPropDefaultValue = new electric.xml.Element("DefaultValue");
                subPropDefaultValue.setText(String.valueOf(hDefault));
                subProp.addElement(subPropDefaultValue);

                if (bVisible)
                    subProp.addElement(new electric.xml.Element("Visible"));

                subPropClass = new electric.xml.Element("Class");
                subPropClass.setText("int");
                subProp.addElement(subPropClass);

                subPropType = new electric.xml.Element("Type");
                subPropType.setText("Class");
                subProp.addElement(subPropType);

            theProperty.addElement(subProp);

            return theProperty;
        }

        boolean addProperty( String sPropertyName, Object DefaultObjectValue, boolean bVisible, String sClassName, String sTypeName)
        {
            electric.xml.Element theProperty = null;

            if ( DefaultObjectValue instanceof Point && sPropertyName.equalsIgnoreCase("Location") )
                theProperty = createPointPropertyElement(sPropertyName, (Point)DefaultObjectValue, "Left", "Top");
            else if ( DefaultObjectValue instanceof Point )
                theProperty = createPointPropertyElement(sPropertyName, (Point)DefaultObjectValue);
            else if ( DefaultObjectValue instanceof Dimension )
                theProperty = createDimensionPropertyElement(sPropertyName, (Dimension)DefaultObjectValue);
            else
                theProperty = createPropertyElement(sPropertyName, (String)DefaultObjectValue, bVisible, sClassName, sTypeName);

            if ( theProperty==null )
                return false;

            theRootElement.addElement(theProperty);
            return true;
        }

        electric.xml.Element createPropertyElement( String sPropertyName, String sDefaultValue, boolean bVisible, String sClassName, String sTypeName)
        {
            electric.xml.Element theProperty = new electric.xml.Element("Property");
            electric.xml.Element theName = new electric.xml.Element("Name");
            theName.setText(sPropertyName);
            electric.xml.Element theGet = new electric.xml.Element("Get");
            theGet.setText(((sClassName != null) && (sClassName.equals("Boolean"))) || (sTypeName.equals("boolean")) ?
                    "is" + sPropertyName : "get" + sPropertyName);

            electric.xml.Element theSet = new electric.xml.Element("Set");
            theSet.setText("set" + sPropertyName);
            electric.xml.Element theClassElement = new electric.xml.Element("Class");
            theClassElement.setText((sClassName != null) ? sClassName : sTypeName);
            electric.xml.Element theType = new electric.xml.Element("Type");
            theType.setText((sClassName != null) ? "Class" : sTypeName);
            theProperty.addElement(theName);
            theProperty.addElement(theGet);
            theProperty.addElement(theSet);
            theProperty.addElement(theClassElement);
            theProperty.addElement(theType);
            if (sDefaultValue != null)
            {
                electric.xml.Element theDefaultValue = new electric.xml.Element("DefaultValue");
                theDefaultValue.setText(sDefaultValue);
                theProperty.addElement(theDefaultValue);
            }
            if (bVisible)
                theProperty.addElement(new electric.xml.Element("Visible"));

            // <DefaultConstantType>Border</DefaultConstantType>
            if ( sClassName.equals("javax.swing.border.Border") || sTypeName.equals("javax.swing.border.Border") )
            {
                electric.xml.Element aborder = new electric.xml.Element("DefaultConstantType");
                aborder.setText("Border");
                theProperty.addElement(aborder);
            }
            // <DefaultConstantType>java.awt.Font</DefaultConstantType>
            else if ( sClassName.equals("java.awt.Font") || sTypeName.equals("java.awt.Font") )
            {
                electric.xml.Element aborder = new electric.xml.Element("DefaultConstantType");
                aborder.setText("java.awt.Font");
                theProperty.addElement(aborder);
                aborder = new electric.xml.Element("Helper");
                aborder.setText("ch.abacus.designcockpit.ide.DefaultPropertyHelper");
                theProperty.addElement(aborder);
            }
            // <Helper>ch.abacus.designcockpit.ide.DefaultPropertyHelper</Helper>
            // <DefaultConstantType>Color</DefaultConstantType>
            else if ( sClassName.equals("java.awt.Color") || sTypeName.equals("java.awt.Color") )
            {
                electric.xml.Element aborder = new electric.xml.Element("DefaultConstantType");
                aborder.setText("Color");
                theProperty.addElement(aborder);
                aborder = new electric.xml.Element("Helper");
                aborder.setText("ch.abacus.designcockpit.ide.DefaultPropertyHelper");
                theProperty.addElement(aborder);
            }

            return theProperty;
        }

        boolean isSkippedProperty(String sPropertyName)
        {
            for (int i = 0; i < theSkippedProperties.length; i++)
            {
                if (sPropertyName.equals(theSkippedProperties[i]))
                    return true;
            }
            return false;
        }

        boolean addDefaultProperties()
        {
            //theSkippedProperties = new String[]{"Width", "Height", "Left", "Top", "Size", "Location", "Text", "Background", "Foreground"};
            theSkippedProperties = new String[]{"Size", "Location"};

            // Properties are defined as method pairs (get/set and is/set)
            /*
            addProperty("Width", "50", true, "Integer", "Class");
            addProperty("Height", "50", true, "Integer", "Class");
            addProperty("Left", "0", true, "Integer", "Class");
            addProperty("Top", "0", true, "Integer", "Class");
            addProperty("Text", null, true, "String", "Class");
            addProperty("Background", null, true, "Color", "Class");
            addProperty("Foreground", null, true, "Color", "Class");
            addProperty("AnchorTop", "false", true, "Boolean", "Class");
            addProperty("AnchorBottom", "false", true, "Boolean", "Class");
            addProperty("AnchorLeft", "false", true, "Boolean", "Class");
            addProperty("AnchorRight", "false", true, "Boolean", "Class");
            */

            addProperty("Location", new Point(0,0), true, "java.awt.Point", "Class");
            addProperty("Size", new Dimension(80,22), true, "java.awt.Dimension", "Class");

            return true;
        }

        boolean getBasicType(String sName)
        {
            int iDot = sName.indexOf(".");
            if (iDot != -1)
                return false;
            else
                return true;
        }

        String upperCaseFirstLetter(String str)
        {
            String retStr=str;

            char ch = str.charAt(0);
            if (Character.isLetter(ch))
                retStr = Character.valueOf(Character.toUpperCase(ch)).toString() + str.substring(1,str.length());

            return retStr;
        }

        boolean addClassProperties()
        {
            Object [] selectedProperties = propList.getSelectedValues();

            for (int i = 0; i < selectedProperties.length; i++)
            {
                String sPropName = (String)selectedProperties[i];
                if (isSkippedProperty(upperCaseFirstLetter(sPropName)))
                    continue;
                PropertyDescriptor propDescr = getPropertyDescriptor(sPropName);
                Class propClass = propDescr.getPropertyType();

                // boolean addProperty( String sPropertyName, String sDefaultValue, boolean bVisible, String sClassName, String sTypeName)

                if ( propClass.equals(java.lang.Boolean.class) || propClass.getName().equals("boolean") )
                    addProperty(upperCaseFirstLetter(sPropName), null, true, propClass.getName(), propClass.getName());
                else
                    addProperty(upperCaseFirstLetter(sPropName), null, true, propClass.getName(), "Class");
            }

            return true;
        }

        boolean addClassEvents()
        {
            return addClassEvents(theRootElement);
        }
        boolean addClassEvents(electric.xml.Element branchElement)
        {
            Object [] selectedProperties = eventList.getSelectedValues();

            electric.xml.Element element1=null;
            if ( selectedProperties.length>0 )
            {
                element1 = new electric.xml.Element("Listeners");
                branchElement.addElement(element1);
            }

            for (int i = 0; i < selectedProperties.length; i++)
            {
                String sPropName = (String)selectedProperties[i];

                // <Listener>ActionListener</Listener>
                electric.xml.Element theElement = new electric.xml.Element("Listener");
                theElement.setText(sPropName);
                element1.addChild(theElement);
            }

            return true;
        }

        /**
         * BeanInfo
         * @param sPropName
         * @return
         */
        private PropertyDescriptor getPropertyDescriptor(String sPropName)
        {
            String propName;
            BeanInfo bi = null;
            try
            {
                bi = Introspector.getBeanInfo(theClass);
            }
            catch (IntrospectionException e)
            {
                return null;
            }
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            for (int iDescriptor = 0; iDescriptor < pds.length; iDescriptor++)
            {
                propName = pds[iDescriptor].getName();
                if ( propName.equals(sPropName) )
                    return pds[iDescriptor];
            }
            return null;
        }


        /**
         * Properties are defined as method pairs (get/set and is/set)
         * Look for single parameter set methods.
         */
        boolean addClassPropertiesOld()
        {
            Method[] theMethodList = theClass.getMethods();
            for (int i = 0; i < theMethodList.length; i++)
            {
                String sMethodName = theMethodList[i].getName();
                if (sMethodName.startsWith("set"))
                {
                    String sRestOfName = sMethodName.substring(3);
                    Class[] theParamList = theMethodList[i].getParameterTypes();
                    if (theParamList.length == 1)
                    { // a property?
                        // Look for method with same return type called "is" or "get"
                        Class theExpectedReturnType = theParamList[0];
                        try
                        {
                            Method m = theClass.getMethod("get" + sRestOfName, (Class[]) null);
                            if (!isSkippedProperty(sRestOfName))
                            {
                                if (m != null)
                                {
                                    boolean bIsType = getBasicType(theExpectedReturnType.getName());
                                    if (bIsType)
                                        addProperty(sRestOfName, null, true, null,
                                                theExpectedReturnType.getName());
                                    else
                                        addProperty(sRestOfName, null, true, theExpectedReturnType.getName(), "Class");
                                }
                                else
                                {
                                    m = theClass.getMethod("is" + sRestOfName, (Class[]) null);
                                    boolean bIsType = getBasicType(theExpectedReturnType.getName());
                                    if (bIsType)
                                        addProperty(sRestOfName, null, true, null,
                                                theExpectedReturnType.getName());
                                    else
                                        addProperty(sRestOfName, null, true, theExpectedReturnType.getName(), "Class");
                                }
                            }
                        }
                        catch (java.lang.NoSuchMethodException e1)
                        {
                        }
                    }
                }
            }
            return true;
        }

        boolean addClassFields()
        {
            addMemberData();
            return true;
        }
    }

    public void show()
    {
        super.show();
    }

    public void windowClosed(WindowEvent event)
    {
    }

    public void windowDeiconified(WindowEvent event)
    {
    }

    public void windowIconified(WindowEvent event)
    {
    }

    public void windowActivated(WindowEvent event)
    {

    }

    public void windowDeactivated(WindowEvent event)
    {
    }

    public void windowOpened(WindowEvent event)
    {
    }

    public void windowClosing(WindowEvent event)
    {
    }

}

