/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.BorderFactory;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.MetaProperty;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableCellEditor;
import javax.swing.table.AbstractTableModel;
import javax.swing.event.TableModelEvent;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.lang.reflect.Method;

/**
 * User: Mario Castillo
 * Date: May 22, 2004
 * Time: 12:35:26 PM
 */

public class IDEJSSGridHeaderEditor extends AbstractPropertyHelper {
    public boolean execute(MetaObject metaObject, String sPropertyName, SuperDesignCockpit superDesignCockpit) {
        IDEJSSGridHeaderEditorDialog dialog = new IDEJSSGridHeaderEditorDialog(metaObject, sPropertyName, superDesignCockpit);
        return true;
    }
}

class IDEJSSGridHeaderEditorDialog extends JADialog {
    MetaObject theObject;
    IDEHeaderControlEditorTableModel theModel = new IDEHeaderControlEditorTableModel();
    IDEHeaderControlEditorTable theTabControlTable;
    JAScrollPane theHeaderControlScrollPane;
    UpButtonAction theUpAction;
    DownButtonAction theDownAction;
    OKButtonAction theOKAction;
    CancelButtonAction theCancelAction;
    SuperDesignCockpit theDesignCockpit;
    JAButton theUpButton;
    JAButton theDownButton;
    JAButton theOKButton;
    JAButton theCancelButton;
    AnchoringLayoutManager layoutManager = new AnchoringLayoutManager();

    public IDEJSSGridHeaderEditorDialog(MetaObject theObject, String sPropertyName, SuperDesignCockpit theDesignCockpit) {
        super(theDesignCockpit, "Grid Header Editor", true, false);
        this.theDesignCockpit = theDesignCockpit;
        this.theObject = theObject;
        this.theModel.theMetaObject = theObject;
        theTabControlTable = new IDEHeaderControlEditorTable(theModel, theDesignCockpit);
        theHeaderControlScrollPane = new JAScrollPane(theTabControlTable);
        this.theTabControlTable.Load();
        theUpAction = new UpButtonAction(this, theObject);
        theDownAction = new DownButtonAction(this, theObject);
        theOKAction = new OKButtonAction(this, theObject);
        theCancelAction = new CancelButtonAction(this, theObject);
        theUpButton = new JAButton(theUpAction);
        theDownButton = new JAButton(theDownAction);
        theOKButton = new JAButton(theOKAction);
        theCancelButton = new JAButton(theCancelAction);

        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());

        JAPanel pnlTable = new JAPanel();
        pnlTable.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        pnlTable.setLayout(new BorderLayout());
        pnlTable.add(theHeaderControlScrollPane, BorderLayout.CENTER);
        pane.add(pnlTable, BorderLayout.CENTER);

        JAPanel pnlButtons = new JAPanel();
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(0,10,0,10));


        pnlButtons.setLayout(new GridLayout(6, 1, 10,10));

        pnlButtons.add(theUpButton);
        pnlButtons.add(theDownButton);
        pnlButtons.add(theOKButton);
        pnlButtons.add(theCancelButton);

        JAPanel pnlTopButtons = new JAPanel();
        pnlTopButtons.add(pnlButtons);

        pane.add(pnlTopButtons, BorderLayout.EAST);

        setSize(400, 300);
        setLocationRelativeTo(null);

        show(null);
    }
}


class IDEHeaderControlEditorTable extends JATable {

    public IDEHeaderControlEditorTableModel theModel = null;
    public SuperDesignCockpit theDesignCockpit;
    public IDEHeaderControlEditorTable(IDEHeaderControlEditorTableModel theTableModel, SuperDesignCockpit theDesignCockpit) {
        super(theTableModel);
        theModel = theTableModel;
        this.theDesignCockpit = theDesignCockpit;
        this.addMouseListener(new IDEHeaderControlEditorTableMouseListener(this));
    }

    public void tableChanged(TableModelEvent evt) {
        super.tableChanged(evt);
    }

    public void Load() {
        theModel.Load(this);
        repaint();
    }

    public void resetContents() {
        theModel.clear();
        repaint();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            renderer = getDefaultRenderer(theModel.getColumnClass(column));
        }
        return renderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {

        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null)
            editor = getDefaultEditor(theModel.getColumnClass(column));
        return editor;
    }

    public void newValueSelected(String sNewValue, String sPropertyName, Integer theRow) {
        theModel.setValueAt(sNewValue, theRow.intValue(), 1);
    }

}

class IDEHeaderControlEditorTableModel extends AbstractTableModel {

    MetaObject      theMetaObject           = null;
    ArrayList       theTableFields          = null;
    IDEHeaderControlEditorTable theTable    = null;
    int[] tabPageIndex                      = null;
    MetaPropertyValueEx pvHeaderValue       = null;

    public void setArrayIndex(int row, int value) {
        tabPageIndex[row] = value;
        // Tell the table that it has changed.
        TableModelEvent event = new TableModelEvent(this, row, row);
        theTable.tableChanged(event);
    }

    public int getRowCount() {
        if (theTableFields == null)
            return 0;
        else
            return theTableFields.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        IDEHeaderPageDescriptor theDescriptor = (IDEHeaderPageDescriptor) theTableFields.get(row);
        if (theDescriptor != null) {
            if (column == 0) {  // object name
                theDescriptor.sName = (String) theNewValue;
            } else if (column == 1){  //object title
                theDescriptor.sTitle = (String) theNewValue;
            } else if (column == 2){  //object display
                theDescriptor.bDisplay=  ((Boolean)theNewValue).booleanValue();
            }
        }
    }

    public Object getValueAt(int row, int column) {
        IDEHeaderPageDescriptor theDescriptor = (IDEHeaderPageDescriptor) theTableFields.get(row);
        if (theDescriptor != null) {
            if (column == 0) {
                return theDescriptor.sName;
            } else if (column == 1){
                return theDescriptor.sTitle;
            }
            else
              return (new Boolean(theDescriptor.bDisplay));

        }
        return "";
    }

    public Class getColumnClass(int iColumn) {
        String theClassName = "";
        if(iColumn == 2)
            return Boolean.class;
        else
            return theClassName.getClass();
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0)
            return false;
        else
            return true;
    }

    public String getColumnName(int iColumn) {
        if(iColumn == 0)
            return "SQL.Column";
        else if(iColumn == 1)
            return "Header Name";
        else
            return "Display";
    }

    protected void Load(IDEHeaderControlEditorTable objTable) {
        ArrayList theCols =  null;
        theTableFields= new ArrayList();

        if (theMetaObject != null) {
            MetaObject theGrid = theMetaObject;
            int iPage = 0;

            pvHeaderValue = theMetaObject.getPropertyValue("Headers", 0);

            if(pvHeaderValue!=null)
            {
             // For future use, parse the string and populate the list based on this value
            }

            try
            {
                Method m= theMetaObject.theFabricatedObject.getClass().getMethod("getFieldNames", (Class[]) null);
                theCols = (ArrayList)m.invoke(theMetaObject.theFabricatedObject, (Object[])null);
            }
            catch(Exception e)
            {
                e.printStackTrace();
            }

            for(int c = 0; c < theCols.size();c++)
            {
                String theTitle = (String)theCols.get(c);
                String theDefaultDisplayHeader = (String)theCols.get(c);
                IDEHeaderPageDescriptor theDescriptor = new IDEHeaderPageDescriptor(theGrid, theDefaultDisplayHeader , theTitle , true );
                theTableFields.add(theDescriptor);
            }
        }
}

    protected void clear() {
        theTableFields = new ArrayList();
    }
}

class IDEHeaderControlEditorTableMouseListener implements MouseListener {
    IDEHeaderControlEditorTable theTable;

    public IDEHeaderControlEditorTableMouseListener(IDEHeaderControlEditorTable theTable) {
        this.theTable = theTable;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.getButton() != MouseEvent.BUTTON1) {
/*
            Point pt = evt.getPoint();
            int iRow = theTable.rowAtPoint(pt);
            new AbaNLSSelector(theTable.theModel.theMetaObject,  "TabTitle", iRow, theTable.theDesignCockpit, theTable);
*/
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

}

class UpButtonAction extends AbstractAction {
    MetaObject theMetaObject = null;
    IDEJSSGridHeaderEditorDialog theEditor = null;

    public UpButtonAction(IDEJSSGridHeaderEditorDialog theEditor, MetaObject theMetaObject) {
        super("Up");
        this.theMetaObject = theMetaObject;
        this.theEditor = theEditor;
    }

    public void actionPerformed(ActionEvent evt) {
        theEditor.theUpButton.setFocusPainted(false);
    }
}

class DownButtonAction extends AbstractAction {
    MetaObject theMetaObject = null;
    IDEJSSGridHeaderEditorDialog theEditor = null;

    public DownButtonAction(IDEJSSGridHeaderEditorDialog theEditor, MetaObject theMetaObject) {
        super("Down");
        this.theMetaObject = theMetaObject;
        this.theEditor = theEditor;
    }

    public void actionPerformed(ActionEvent evt) {

        IDEHeaderControlEditorTable theTable = theEditor.theTabControlTable;
        IDEHeaderControlEditorTableModel theModel = theEditor.theModel;
        int iRow = theTable.getSelectedRow();
        int iRowCount = theTable.getRowCount();
        if ((iRow != -1) && (iRow < (iRowCount - 1))) {
            Object objToRaise = theModel.theTableFields.get(iRow + 1);
            Object objToLower = theModel.theTableFields.get(iRow);
            theModel.theTableFields.set(iRow + 1, objToLower);
            theModel.theTableFields.set(iRow, objToRaise);
            theTable.repaint();
        }
        theEditor.theDownButton.setFocusPainted(false);
    }
}

class OKButtonAction extends AbstractAction {
    MetaObject theMetaObject = null;
    IDEJSSGridHeaderEditorDialog theEditor = null;

    public OKButtonAction(IDEJSSGridHeaderEditorDialog theEditor, MetaObject theMetaObject) {
        super("OK");
        this.theMetaObject = theMetaObject;
        this.theEditor = theEditor;
    }

    public void actionPerformed(ActionEvent evt) {
        ArrayList tmpList = this.theEditor.theModel.theTableFields;
        String propertyString = new String();

        Iterator listIterator = tmpList.iterator( );
        boolean bAdded = false;

        while (listIterator.hasNext( ))
        {
            if(propertyString.length()>0 & bAdded==true)
              propertyString+=";";

            IDEHeaderPageDescriptor item = (IDEHeaderPageDescriptor)listIterator.next();
            if(item.bDisplay)
            {
               propertyString += item.sName + "=" + item.sTitle;
               bAdded= true;
            }
            else
                bAdded = false;
        }

        theMetaObject.setPropertyValue("Headers",0,0,propertyString,false);
        this.theEditor.theDesignCockpit.getPropertyInspectorController().repaint();
        theEditor.hide();
        theEditor = null;
    }
}

class CancelButtonAction extends AbstractAction {
    MetaObject theMetaObject = null;
    IDEJSSGridHeaderEditorDialog theEditor = null;

    public CancelButtonAction(IDEJSSGridHeaderEditorDialog theEditor, MetaObject theMetaObject) {
        super("Cancel");
        this.theMetaObject = theMetaObject;
        this.theEditor = theEditor;
    }

    public void actionPerformed(ActionEvent evt) {
        theEditor.removeAll();
        theEditor.hide();
        theEditor = null;
    }
}

class IDEHeaderPageDescriptor {
    MetaObject theMetaObject;
    String sTitle;
    String sName;
    boolean bDisplay;

    public IDEHeaderPageDescriptor(MetaObject theMetaObject, String sTitle, String sName , boolean bDisp) {
        this.theMetaObject = theMetaObject;
        this.sTitle = sTitle;
        this.sName = sName;
        this.bDisplay = bDisp;
    }
}
