/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import com.ozten.font.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;


/**
 * Title:
 * Description:
 * Copyright:		Copyright (c) 2004
 * Company:			Abacus Research
 * @author			Adam Graham, Erin Bay Associates, LLC.
 * @version 1.0
 */

public class IDEOztenFontChooser {

	SuperDesignCockpit theDesignCockpit;

	public IDEOztenFontChooser(SuperDesignCockpit objDesignCockpit) {
		theDesignCockpit = objDesignCockpit;

		MetaObject theSelectedObject = theDesignCockpit.getSelectedObject();

		Font oldFont=theSelectedObject.getFont();
		Font newFont = JFontChooser.showDialog(null,"Choose a font","AaBbCcDdEe 0123456789",oldFont);

		if (theDesignCockpit != null && newFont!=null) {
			if (theSelectedObject != null) {
				theSelectedObject.setFont((Font) newFont);
			}
		}
	}
}
