/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.HammerNLSAccess;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProjectHeader;
import ch.abacus.lib.ui.renderer.common.HammerImageIconFactory;
import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


class IDEProjectToolDescription extends JATextArea {
    JAScrollPane thePane = null;

    public IDEProjectToolDescription(JAScrollPane objPane) {
        super();
        thePane = objPane;
    }

    /***__@Method: [fixupSize] ***/
    void fixupSize() {
        int iRows = getRows();
        int iColumns = getColumns();
        Font theFont = getFont();
        if (theFont != null) {
            FontMetrics theFontMetrics = getFontMetrics(theFont);
            if (theFontMetrics != null) {
                int iXSize = iColumns * theFontMetrics.stringWidth("m    WXZ"
                ) / 8;
                int iYSize = iRows * theFontMetrics.getHeight();
                thePane.setPreferredSize(new Dimension(iXSize, iYSize));
            }
        }
    }
}

class ProjectNLSTableModel extends AbstractTableModel {
    private ArrayList theNLSDocs = new ArrayList(0);
    private ArrayList theNLSKeys = new ArrayList(0);
    private IDEProjectTool theTool;

    public ProjectNLSTableModel(IDEProjectTool theTool) {
        this.theTool = theTool;
    }
    public int getRowCount() {
        if (theNLSKeys != null)
            return theNLSKeys.size()+1;
        else
            return 1;
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
            if (column==0) {
                if (row<theNLSKeys.size())
                    theNLSKeys.set(row, theNewValue);
                else {
                    theNLSKeys.add(theNewValue);
                    theNLSDocs.add("");
                }
            }
            else {
                if (row<theNLSDocs.size())
                    theNLSDocs.set(row, theNewValue);
                else
                    theNLSDocs.add(theNewValue);
            }
    }



    public Object getValueAt(int row, int column) {
        if (row<theNLSKeys.size()) {
            if (column==0)
                return theNLSKeys.get(row);
            else if (row<theNLSDocs.size())
                return theNLSDocs.get(row);
        }
        return null;
    }

    public Class getColumnClass(int iColumn) {
        return String.class;
    }

    public Class getCellClass(int iRow, int iColumn) {
        return String.class;
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0)
            return "Key";
        else
            return "Document Location";
    }


    protected void clear() {
        theNLSDocs = new ArrayList(0);
        theNLSKeys = new ArrayList(0);
    }

    protected void load() {
        if (theTool.theProject.theLocalNLSDocuments != null) {
            this.theNLSDocs = new ArrayList(0);
            this.theNLSKeys = new ArrayList(0);
            int iSize = theTool.theProject.theLocalNLSDocuments.size();
            for (int i=0; i<iSize; i++) {
                HammerNLSAccess theNLSAccess = (HammerNLSAccess) theTool.theProject.theLocalNLSDocuments.get(i);
                theNLSDocs.add(theNLSAccess.sDocument);
                theNLSKeys.add(theNLSAccess.sKey);
            }
        }

    }

    protected void save() {
        theTool.theProject.theLocalNLSDocuments = new ArrayList(0);
        int iSize = this.theNLSKeys.size();
        for (int i=0; i<iSize; i++) {
            String sKey = (String) theNLSKeys.get(i);
            String sDoc = (String) theNLSDocs.get(i);
            if ((sKey != null) && (sDoc!=null) && (sKey.trim().length()>0)
                && (sDoc.trim().length() > 0)) {
                HammerNLSAccess theNewAccess = new HammerNLSAccess(sKey.trim(),sDoc.trim());
                theTool.theProject.theLocalNLSDocuments.add(theNewAccess);
            }
        }
        theTool.theProject.getNLS().Load();
    }

    public void deleteSelectedRow(int iRow) {
        if (iRow < theNLSKeys.size()) {
            theNLSDocs.remove(iRow);
            theNLSKeys.remove(iRow);
        }
        this.theTool.theNLSTable.setVisible(false);
        this.theTool.theNLSDeleteRowButton.setVisible(false);
        this.theTool.theNLSTable.setVisible(true);
        this.theTool.theNLSDeleteRowButton.setVisible(true);
    }


}

class NLSDeleteRowAction implements ActionListener {
    private IDEProjectTool theTool;

    public NLSDeleteRowAction(IDEProjectTool theTool) {
        this.theTool = theTool;
    }
    public void actionPerformed(ActionEvent evt) {
        int iTableRow = theTool.theNLSTable.getSelectedRow();
        theTool.theNLSTableModel.deleteSelectedRow(iTableRow);
    }
}

public class IDEProjectTool extends JADialog {
    public boolean bAbalet = true;
    public boolean bApplication = false;
    public String sMainClass = null;
    public String sPackageName = null;
    public String sOutputDirectory = null;
    public String sCodeGenerationDocument = null;
    public String sAuthor = null;
    public String sDescription = null;
    public String sWorkspace = null;
    public String sClassPath = "";
    public String sTransientDirectory = "";
    private String sDeclVariablePrefix = "";
    public ArrayList theNLSDocs = new ArrayList(0);
    public ArrayList theNLSKeys = new ArrayList(0);
    MetaProjectHeader theMetadata = null;

    protected JAPanel theProjectIDPage = new JAPanel();
    protected JALabel JALabelX2 = new JALabel();
    protected JATextField theAuthor = new JATextField();
    protected JATextField theDeclVariablePrefix = new JATextField();
    protected JAPanel theProjectDescriptionPage = new JAPanel();
    protected JAScrollPane JAScrollPaneX1 = new JAScrollPane();
    protected IDEProjectToolDescription theProjectDescription = new IDEProjectToolDescription(JAScrollPaneX1);
    protected JAPanel theProjectPathPage = new JAPanel();
    protected JALabel JALabelX3 = new JALabel();
    protected JALabel JALabelX4 = new JALabel();
    protected JATextField theAddClassPath = new JATextField();
    protected JATextField theOutputDirectory = new JATextField();
    protected JATextField theTransientDirectory = new JATextField();
    protected JATextArea theAdditionalImports = new JATextArea();
    protected JATextArea theProjectRepositPath    = new JATextArea();
    protected JAPanel theCodeGenerationChoicePage = new JAPanel();
    protected javax.swing.ButtonGroup ButtonGroupX1 = new javax.swing.ButtonGroup();
    protected JARadioButton theAbaletButton = new JARadioButton();
    protected JARadioButton theApplicationButton = new JARadioButton();
    protected JAPanel theToolConfigurationPage = new JAPanel();
    protected JALabel JALabelX5 = new JALabel();
    protected JALabel JALabelX6 = new JALabel();
    protected JALabel JALabelX7 = new JALabel();
    protected JALabel JALabelX8 = new JALabel();
    protected JALabel JALabelX9 = new JALabel();
    protected JALabel JALabelX10 = new JALabel();
    protected JALabel JALabelX11 = new JALabel();
    protected JALabel JALabelX17 = new JALabel();
    protected JALabel JALabelX18 = new JALabel();
    protected JALabel JALabelX19 = new JALabel();
    protected JALabel JALabelX20 = new JALabel();
    protected JALabel JALabelX21 = new JALabel(); // Imports Label
    protected JALabel JALabelX22 = new JALabel(); // Custom components Path

    protected JSpinner theAlignmentGridX = new JSpinner();
    protected JSpinner theAlignmentGridY = new JSpinner();
    protected JSpinner theSizeBoxHeight = new JSpinner();
    protected JSpinner theSizeBoxWidth = new JSpinner();

    protected JAButton theProjectOKButton = new JAButton();
    protected JAButton theProjectCancelButton = new JAButton();
    protected JATextField theClassInfoDocument = new JATextField();
    protected JATextField theProjectPackage = new JATextField();
    protected SuperDesignCockpit theDesignCockpit = null;

    protected JAPanel theCodeFormatterPage = new JAPanel();
    protected JALabel JALabelX12 = new JALabel("Maximum Line Length");
    protected JALabel JALabelX13 = new JALabel("Indentation Level Spaces");
    protected JALabel JALabelX14 = new JALabel("Line End Delimiters");
    protected JALabel JALabelX15 = new JALabel("Sticky Delimiters");
    protected JATextField theMaxLineLength = new JATextField();
    protected JATextField theIndentation = new JATextField();
    protected JATextField theDelimiters = new JATextField();
    protected JATextField theStickyDelimiters = new JATextField();
    protected JALabel JALabelX16 = new JALabel("Platform Look & Feel");
    protected Object[] thePLAFChoices = {"java (metal)", "Motif", "Mac", "Windows"};
    protected Object[] theLookFeelChoices = {"Default","PlasticXPLookAndFeel", "Plastic3DLookAndFeel", "PlasticLookAndFeel"};
    protected JAComboBox thePLAF = new JAComboBox(thePLAFChoices);
    protected JAComboBox theCodeLookFeel = new JAComboBox(theLookFeelChoices);
    protected JAPanel thePLAFPage = new JAPanel();
    protected JACheckBox thePLAFGenerator = new JACheckBox("Generate PLAF Code?");
    protected JACheckBox thePLAFChangeDefault = new JACheckBox("Change Preferences?");
    protected JAPanel theNLSPage = new JAPanel();
    protected JATable theNLSTable = new JATable();
    protected JButton theNLSDeleteRowButton = new JButton();
    protected ProjectNLSTableModel theNLSTableModel = new ProjectNLSTableModel(this);
    public MetaProject theProject;
    protected JToolBar theToolBar   = new JToolBar(JToolBar.VERTICAL);
    protected HammerImageIconFactory theIconFactory = null;
    protected Icon idProjectSetIcon = null;
    protected Icon impDescriptionSetIcon = null;
    protected Icon impBuildSetIcon = null;
    protected Icon impCodeGenIcon = null;
    protected Icon impViewDisplayIcon = null;
    protected Icon impCodeFormatterIcon = null;
    protected Icon impLookAndFeelIcon = null;
    protected Icon impNLSIcon = null;
    protected JButton c8 = new JButton();
    protected JButton c7 = new JButton();
    protected JPanel currPanel = null;

    protected JACheckBox chkDisplayGrid = new JACheckBox("Display Grid");
    private JACheckBox chkSnapToGrid = new JACheckBox("Snap to Grid");
    private JACheckBox theNLSGenerator = new JACheckBox("Generate NLS Code");
    private JACheckBox theAccessGenerator = new JACheckBox("Generate Accessor Code");

    public IDEProjectTool(SuperDesignCockpit objDesignCockpit, MetaProject theProject) {
        super(objDesignCockpit, "Project Configuration Tool", true, false);
        this.setResizable(false);
        this.theProject = theProject;
        theMetadata = theProject.theProgramData;
        theDesignCockpit = objDesignCockpit;

        //  Set the layout.
        AnchoringLayoutManager layoutManagerProjectTool = new AnchoringLayoutManager();
        getContentPane().setLayout(layoutManagerProjectTool);

        setSize(630, 400);
        setLocationRelativeTo(null);

        Border loweredetched = BorderFactory.createEtchedBorder();
        Border titledDescborder =  new TitledBorder(loweredetched,"Description");
        Border idDescborder =  new TitledBorder(loweredetched,"Identification");
        Border buildDescborder =  new TitledBorder(loweredetched,"Build");
        Border codeGenDescborder =  new TitledBorder(loweredetched,"Code Generator");
        Border viewDisViewBorder =  new TitledBorder(loweredetched,"View Display");
        Border viewDisGridBorder =  new TitledBorder(loweredetched,"Grid Options");
        Border viewDisSizeBoxesBorder =  new TitledBorder(loweredetched,"Sizeboxes");
        Border codeFormDescborder =  new TitledBorder(loweredetched,"Code Fomatter");
        Border lookfeelDescborder =  new TitledBorder(loweredetched,"Look & Feel");
        Border NLSDescborder =  new TitledBorder(loweredetched,"NLS");

        /*****     ID Panel ********/
        AnchoringLayoutManager layoutManagertheProjectIDPage = new AnchoringLayoutManager();

        theProjectIDPage.setLayout(layoutManagertheProjectIDPage);
        theProjectIDPage.setLocation(130, 15);
        theProjectIDPage.setSize(450, 145);
        theProjectIDPage.setBorder(idDescborder);
        theProjectIDPage.setVisible(true);
        //  Add the control theProjectIDPage to the Tabbed pane.
        getContentPane().add("theProjectIDPage", theProjectIDPage);
        layoutManagertheProjectIDPage.setAnchoring(theProjectIDPage, false, false, false, false);

        JALabelX2.setLocation(36, 54);
        JALabelX2.setSize(72, 24);
        JALabelX2.setText("Author");
        //  Add the control JALabelX2 to the content pane.
        theProjectIDPage.add(JALabelX2, "JALabelX2");
        layoutManagertheProjectIDPage.setAnchoring(JALabelX2, false, false, false, false);
        theAuthor.setLocation(150, 50);
        theAuthor.setSize(244, 24);
        theAuthor.setText("");
        //  Add the control theAuthor to the content pane.
        theProjectIDPage.add(theAuthor, "theAuthor");
        layoutManagertheProjectIDPage.setAnchoring(theAuthor, true, false, true, false);

        JALabel lblDeclVariablePrefix = new JALabel("Decl-file Variable Prefix");
        lblDeclVariablePrefix.setLocation(36, 94);
        lblDeclVariablePrefix.setSize(100, 24);
        theProjectIDPage.add(lblDeclVariablePrefix, "lblDeclVariablePrefix");
        layoutManagertheProjectIDPage.setAnchoring(lblDeclVariablePrefix, false, false, false, false);
        theDeclVariablePrefix.setLocation(150, 90);
        theDeclVariablePrefix.setSize(244, 24);
        theDeclVariablePrefix.setText("");
        theProjectIDPage.add(theDeclVariablePrefix, "theDeclVariablePrefix");
        layoutManagertheProjectIDPage.setAnchoring(theDeclVariablePrefix, true, false, true, false);
        /*****  End of ID Panel ****/

        /*****  Description Panel ****/
        AnchoringLayoutManager layoutManagertheProjectDescriptionPage = new AnchoringLayoutManager();
        theProjectDescriptionPage.setLayout(layoutManagertheProjectDescriptionPage);
        theProjectDescriptionPage.setLocation(115, 15);
        theProjectDescriptionPage.setSize(490, 300);
        theProjectDescriptionPage.setVisible(false);

        //  Add the control theProjectDescriptionPage to the Tabbed pane.
        getContentPane().add("Description", theProjectDescriptionPage);
        JAScrollPaneX1.setLocation(10, 30);
        JAScrollPaneX1.setSize(450, 250);
        JAScrollPaneX1.setBorder(loweredetched);
        //  Add the control JAScrollPaneX1 to the content pane.
        theProjectDescriptionPage.add(JAScrollPaneX1, "JAScrollPaneX1");

        layoutManagertheProjectDescriptionPage.setAnchoring(JAScrollPaneX1, false, false, false, false);

        theProjectDescription.setLocation(0, 0);
        theProjectDescription.setSize(450, 150);
        theProjectDescription.setText("");
        theProjectDescription.setRows(12);
        theProjectDescription.setColumns(50);
        theProjectDescription.thePane = JAScrollPaneX1;
        theProjectDescription.fixupSize();
        theProjectDescriptionPage.setBorder(titledDescborder);
        //  Add the control theProjectDescription to the content pane.
        JAScrollPaneX1.setViewportView(theProjectDescription);
        /*****  End of Description Panel ****/

        /*****  Project Path Panel ****/
        AnchoringLayoutManager layoutManagertheProjectPathPage = new AnchoringLayoutManager();
        theProjectPathPage.setLayout(layoutManagertheProjectPathPage);
        theProjectPathPage.setLocation(130, 15);
        theProjectPathPage.setSize(450, 300);
        theProjectPathPage.setBorder(buildDescborder);
        //  Add the control theProjectPathPage to the Tsabbed pane.

        theProjectPathPage.setVisible(false);
        //if (theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER)
        //    theProjectPathPage.add("Build", theProjectPathPage);

        JALabelX4.setLocation(24, 20);
        JALabelX4.setSize(112, 24);
        JALabelX4.setText("Add Class Path");
        //  Add the control JALabelX4 to the content pane.
        theProjectPathPage.add(JALabelX4, "JALabelX4");
        layoutManagertheProjectPathPage.setAnchoring(JALabelX4, true, false, true, false);

        JALabelX11.setLocation(24, 56);
        JALabelX11.setSize(112, 24);
        JALabelX11.setText("Temporary Directory");
        //  Add the control JALabelX10 to the content pane.
        theProjectPathPage.add(JALabelX11, "JALabelX11");
        layoutManagertheProjectPathPage.setAnchoring(JALabelX11, true, false, true, false);

        JALabelX3.setLocation(24, 92);
        JALabelX3.setSize(112, 24);
        JALabelX3.setText("Output Directory");
        //  Add the control JALabelX3 to the content pane.
        theProjectPathPage.add(JALabelX3, "JALabelX3");
        layoutManagertheProjectPathPage.setAnchoring(JALabelX3, true, false, true, false);

        JALabelX21.setLocation(24, 126);
        JALabelX21.setSize(112, 24);
        JALabelX21.setText("Additional Imports");
        //  Add the control JALabelX3 to the content pane.
        theProjectPathPage.add(JALabelX21, "JALabelX21");
        layoutManagertheProjectPathPage.setAnchoring(JALabelX21, true, false, true, false);

        JALabelX22.setLocation(24, 196);
        JALabelX22.setSize(112, 24);
        JALabelX22.setText("Custom Components Path");
        //  Add the control JALabelX3 to the content pane.
        theProjectPathPage.add(JALabelX22, "JALabelX22");
        layoutManagertheProjectPathPage.setAnchoring(JALabelX22, true, false, true, false);

        theAddClassPath.setLocation(160, 20);
        theAddClassPath.setSize(252, 24);
        theAddClassPath.setText("");
        theAddClassPath.setBackground(this.getBackground());

         //  Add the control theAddClassPath to the content pane.
        theProjectPathPage.add(theAddClassPath, "theAddClassPath");
        layoutManagertheProjectPathPage.setAnchoring(theAddClassPath, true, false, true, false);

        theTransientDirectory.setLocation(160, 56);
        theTransientDirectory.setSize(252, 24);
        theTransientDirectory.setText("");
        theTransientDirectory.setBackground(this.getBackground());
        //  Add the control theOutputDirectory to the content pane.
        theProjectPathPage.add(theTransientDirectory, "theTransientDirectory");
        layoutManagertheProjectPathPage.setAnchoring(theTransientDirectory, true, false, true, false);

        theOutputDirectory.setLocation(160, 92);
        theOutputDirectory.setSize(252, 24);
        theOutputDirectory.setText("");
        theOutputDirectory.setBackground(this.getBackground());
        //  Add the control theOutputDirectory to the content pane.
        theProjectPathPage.add(theOutputDirectory, "theOutputDirectory");
        layoutManagertheProjectPathPage.setAnchoring(theOutputDirectory, true, false, true, false);

        theAdditionalImports.setLocation(160, 126);
        theAdditionalImports.setSize(252, 56);
        theAdditionalImports.setText("");
        theAdditionalImports.setBackground(this.getBackground());
        //  Add the control theOutputDirectory to the content pane.
        theProjectPathPage.add(theAdditionalImports, "theAdditionalImports");
        layoutManagertheProjectPathPage.setAnchoring(theAdditionalImports, true, false, true, false);

        theProjectRepositPath.setLocation(160, 196);
        theProjectRepositPath.setSize(252, 56);
        theProjectRepositPath.setText("");
        theProjectRepositPath.setBackground(this.getBackground());
        //  Add the control theOutputDirectory to the content pane.
        theProjectPathPage.add(theProjectRepositPath, "projectRepositPath");
        layoutManagertheProjectPathPage.setAnchoring(theProjectRepositPath, true, false, true, false);



        getContentPane().add(theProjectPathPage, "theProjectPathPage");
        /*****  End Project Path Panel ****/

        /*****  Generation Code  Panel ****/
        AnchoringLayoutManager layoutManagertheCodeGenerationChoicePage = new AnchoringLayoutManager();
        theCodeGenerationChoicePage.setLayout(layoutManagertheCodeGenerationChoicePage);
        theCodeGenerationChoicePage.setLocation(130, 15);
        theCodeGenerationChoicePage.setSize(450, 300);
        theCodeGenerationChoicePage.setBorder(codeGenDescborder);
        theCodeGenerationChoicePage.setVisible(false);

        //  Add the control theCodeGenerationChoicePage to the Tabbed pane.
 //    if (theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER)
 //       theProjectInfoPane.add("Code Generation", theCodeGenerationChoicePage);
        getContentPane().add("Code Generation", theCodeGenerationChoicePage);
        JALabelX7.setLocation(24, 20);
        JALabelX7.setSize(112, 24);
        JALabelX7.setText("Class Meta Document:");
        theCodeGenerationChoicePage.add(JALabelX7, "JALabelX7");
        layoutManagertheCodeGenerationChoicePage.setAnchoring(JALabelX7, true, false, true, false);
        theClassInfoDocument.setSize(352, 24);
        theClassInfoDocument.setLocation(24, 40);

        theCodeGenerationChoicePage.add(theClassInfoDocument, "theClassInfoDocument");
        layoutManagertheCodeGenerationChoicePage.setAnchoring(theClassInfoDocument, true, false, true, false);
        JALabelX8.setLocation(24, 74);
        JALabelX8.setSize(112, 24);
        JALabelX8.setText("Package Name:");
        theCodeGenerationChoicePage.add(JALabelX8, "JALabelX8");
        layoutManagertheCodeGenerationChoicePage.setAnchoring(JALabelX8, true, false, true, false);
        theProjectPackage.setSize(352, 24);
        theProjectPackage.setLocation(24, 98);
        theCodeGenerationChoicePage.add(theProjectPackage, "theProjectPackage");
        layoutManagertheCodeGenerationChoicePage.setAnchoring(theProjectPackage, true, false, true, false);
        theAbaletButton.setLocation(48, 130);
        theAbaletButton.setSize(80, 32);
        theAbaletButton.setText("Abalet");
        theAbaletButton.setBorder(loweredetched);
        //  Add the control theAbaletButton to the Group.
        ButtonGroupX1.add(theAbaletButton);
        //  Add the control theAbaletButton to the content pane.
        theCodeGenerationChoicePage.add(theAbaletButton, "theAbaletButton");
        layoutManagertheCodeGenerationChoicePage.setAnchoring(theAbaletButton, true, false, true, false);
        theApplicationButton.setLocation(450, 152);
        theApplicationButton.setSize(80, 32);
        theApplicationButton.setText("Application");
        theApplicationButton.setBorder(loweredetched);
        //  Add the control theApplicationButton to the Group.
        ButtonGroupX1.add(theApplicationButton);
        //  Add the control theApplicationButton to the content pane.
        theCodeGenerationChoicePage.add(theApplicationButton, "theApplicationButton");
        layoutManagertheCodeGenerationChoicePage.setAnchoring(theApplicationButton, false, true, true, false);

        theNLSGenerator.setLocation(24,160);
        theNLSGenerator.setSize(112, 24);
        theCodeGenerationChoicePage.add(theNLSGenerator, "theNLSGenerator");

        theAccessGenerator.setLocation(24,188);
        theAccessGenerator.setSize(112, 24);
        theCodeGenerationChoicePage.add(theAccessGenerator, "theAccessGenerator");
    //    theMetadata.setbAccesorCode(theProject.isGenerateAccessor());
    //    theMetadata.setbNLSTranslation(theProject.isNLSCodeTranslation());

        JALabelX18.setLocation(24,216);
        JALabelX18.setSize(112, 24);
        JALabelX18.setText("Application Look & Feel:");
        theCodeGenerationChoicePage.add(JALabelX18, "JALabelX18");

        theCodeLookFeel.setLocation(24,242);
        theCodeLookFeel.setSize(150, 24);
        theCodeGenerationChoicePage.add(theCodeLookFeel, "theCodeLookFeel");

        String genCodeLookFeel = theDesignCockpit.theCurrentDesignProject.getGenCodeLAF();
        if(genCodeLookFeel==null)
                genCodeLookFeel=theDesignCockpit.thePreferences.sGenLookFeelName;

        if(genCodeLookFeel!=null)
        {
            int genLAFCode = theDesignCockpit.theCurrentDesignProject.theMetaProject.getGenCodeLookFeel(genCodeLookFeel);
            theCodeLookFeel.setSelectedIndex(genLAFCode);
        }

        /*****  Generation Code  Panel ****/

        /*****  View displayer Panel ****/
        AnchoringLayoutManager layoutManagertheToolConfigurationPage = new AnchoringLayoutManager();
        theToolConfigurationPage.setLayout(layoutManagertheToolConfigurationPage);
        theToolConfigurationPage.setLocation(130, 15);
        theToolConfigurationPage.setSize(450, 300);

        theToolConfigurationPage.setBorder(viewDisViewBorder);
        theToolConfigurationPage.setVisible(false);
        //  Add the control theToolConfigurationPage to the Tabbed pane.

        getContentPane().add("View Displayer Configuration", theToolConfigurationPage);

        // The Grid Options panel...
        AnchoringLayoutManager layoutManagerGridOptionsPanel = new AnchoringLayoutManager();
        JAPanel pnlGridOptions = new JAPanel(layoutManagerGridOptionsPanel);
        pnlGridOptions.setSize(390, 150);
        pnlGridOptions.setLocation(30,30);
        pnlGridOptions.setBorder(viewDisGridBorder);
        theToolConfigurationPage.add(pnlGridOptions, "pnlGridOptions");
        layoutManagertheToolConfigurationPage.setAnchoring(pnlGridOptions, true, false, true, false);

        // The Display Grid component...
        chkDisplayGrid.setSize(104, 24);
        chkDisplayGrid.setLocation(30, 20);
        pnlGridOptions.add(chkDisplayGrid, "chkDisplayGrid");
        layoutManagerGridOptionsPanel.setAnchoring(chkDisplayGrid, true, false, true, false);

        // The Snap-to-Grid component...
        chkSnapToGrid.setSize(104, 24);
        chkSnapToGrid.setLocation(30, 50);
        pnlGridOptions.add(chkSnapToGrid, "chkSnapToGrid");
        layoutManagerGridOptionsPanel.setAnchoring(chkSnapToGrid, true, false, true, false);

        // The Grid Size label...
        JALabel lblGridSize = new JALabel("Grid Size");
        lblGridSize.setSize(104, 24);
        lblGridSize.setLocation(55, 80);
        pnlGridOptions.add(lblGridSize, "lblGridSize");
        layoutManagerGridOptionsPanel.setAnchoring(lblGridSize, true, false, true, false);

        // The Grid Size X label...
        JALabelX5.setLocation(55, 105);
        JALabelX5.setSize(20, 24);
        JALabelX5.setText("X");
        pnlGridOptions.add(JALabelX5, "JALabelX5");//  Add the control JALabelX5 to the content pane.
        layoutManagerGridOptionsPanel.setAnchoring(JALabelX5, true, false, true, false);

        // The Grid Size X ...
        theAlignmentGridX.setModel(new SpinnerNumberModel(theDesignCockpit.thePreferences.iViewDisplayerGridX, 4, 64, 1));
        theAlignmentGridX.setLocation(70, 100);
        theAlignmentGridX.setSize(44, 24);
        pnlGridOptions.add(theAlignmentGridX, "theAlignmentGridX"); //  Add the control theAlignmentGridX to the content pane.
        layoutManagerGridOptionsPanel.setAnchoring(theAlignmentGridX, true, false, true, false);

        // The Grid Size Y label...
        JALabelX6.setLocation(155, 105);
        JALabelX6.setSize(20, 24);
        JALabelX6.setText("Y");
        pnlGridOptions.add(JALabelX6, "JALabelX6"); //  Add the control JALabelX6 to the content pane.
        layoutManagerGridOptionsPanel.setAnchoring(JALabelX6, true, false, true, false);

        // The Grid Size Y ...
        theAlignmentGridY.setModel(new SpinnerNumberModel(theDesignCockpit.thePreferences.iViewDisplayerGridY, 4, 64, 1));
        theAlignmentGridY.setLocation(170, 100);
        theAlignmentGridY.setSize(44, 24);
        pnlGridOptions.add(theAlignmentGridY, "theAlignmentGridY"); //  Add the control theAlignmentGridY to the content pane.
        layoutManagerGridOptionsPanel.setAnchoring(theAlignmentGridY, true, false, true, false);

        // The Sizeboxes panel...
        AnchoringLayoutManager layoutManagerSizeBoxesPanel = new AnchoringLayoutManager();
        JAPanel pnlSizeBoxes = new JAPanel(layoutManagerSizeBoxesPanel);
        pnlSizeBoxes.setSize(390, 60);
        pnlSizeBoxes.setLocation(30,195);
        pnlSizeBoxes.setBorder(viewDisSizeBoxesBorder);
        theToolConfigurationPage.add(pnlSizeBoxes, "pnlSizeBoxes");
        layoutManagertheToolConfigurationPage.setAnchoring(pnlSizeBoxes, true, false, true, false);

        // The Width Label...
        JALabelX9.setLocation(35, 35);
        JALabelX9.setSize(112, 24);
        JALabelX9.setText("Width");
        pnlSizeBoxes.add(JALabelX9, "JALabelX9");//  Add the control JALabelX9 to the content pane.
        layoutManagerSizeBoxesPanel.setAnchoring(JALabelX9, true, false, true, false);

        // The Width component...
        theSizeBoxWidth.setLocation(70, 30);
        theSizeBoxWidth.setSize(44, 24);
        theSizeBoxWidth.setModel(new SpinnerNumberModel(theDesignCockpit.thePreferences.iSizeBoxWidth, 4, 16, 1));
        pnlSizeBoxes.add(theSizeBoxWidth, "theSizeBoxWidth"); //  Add the control theAlignmentGridX to the content pane.
        layoutManagerSizeBoxesPanel.setAnchoring(theSizeBoxWidth, true, false, true, false);

        // The Height label...
        JALabelX10.setLocation(133, 35);
        JALabelX10.setSize(112, 24);
        JALabelX10.setText("Height");
        //  Add the control JALabelX10 to the content pane.
        pnlSizeBoxes.add(JALabelX10, "JALabelX10");
        layoutManagerSizeBoxesPanel.setAnchoring(JALabelX10, true, false, true, false);

        // The Height component...
        theSizeBoxHeight.setLocation(170, 30);
        theSizeBoxHeight.setSize(44, 24);
        theSizeBoxHeight.setModel(new SpinnerNumberModel(theDesignCockpit.thePreferences.iSizeBoxHeight, 4, 16, 1));
        pnlSizeBoxes.add(theSizeBoxHeight, "theSizeBoxHeight"); //  Add the control theAlignmentGridY to the content pane.
        layoutManagerSizeBoxesPanel.setAnchoring(theSizeBoxHeight, true, false, true, false);

        /*****  Code Formatter Panel ****/
        // Now do the code beautifier.
        AnchoringLayoutManager layoutManagertheCodeFormatterPage = new AnchoringLayoutManager();
        theCodeFormatterPage.setLayout(layoutManagertheCodeFormatterPage);
        theCodeFormatterPage.setLocation(130, 15);
        theCodeFormatterPage.setSize(450, 300);
        theCodeFormatterPage.setBorder(codeFormDescborder);
        theCodeFormatterPage.setVisible(false);

//  Add the control theToolConfigurationPage to the Tabbed pane.
//        if (theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER)
//            theProjectInfoPane.add("Code Formatter", theCodeFormatterPage);
        getContentPane().add("Code Formatter", theCodeFormatterPage);
        JALabelX12.setLocation(24, 12);
        JALabelX12.setSize(112, 24);
        //  Add the control JALabelX12 to the content pane.
        theCodeFormatterPage.add(JALabelX12, "JALabelX12");
        layoutManagertheCodeFormatterPage.setAnchoring(JALabelX12, true, false, true, false);
        JALabelX13.setLocation(24, 48);
        JALabelX13.setSize(104, 24);
        //  Add the control JALabelX13 to the content pane.
        theCodeFormatterPage.add(JALabelX13, "JALabelX13");
        layoutManagertheCodeFormatterPage.setAnchoring(JALabelX13, true, false, true, false);

        JALabelX14.setLocation(24, 84);
        JALabelX14.setSize(112, 24);
        //  Add the control JALabelX14 to the content pane.
        theCodeFormatterPage.add(JALabelX14, "JALabelX14");
        layoutManagertheCodeFormatterPage.setAnchoring(JALabelX14, true, false, true, false);
        JALabelX15.setLocation(24, 120);
        JALabelX15.setSize(104, 24);
        //  Add the control JALabelX10 to the content pane.
        theCodeFormatterPage.add(JALabelX15, "JALabelX15");
        layoutManagertheCodeFormatterPage.setAnchoring(JALabelX15, true, false, true, false);

        theMaxLineLength.setLocation(184, 12);
        theMaxLineLength.setSize(104, 24);
        theMaxLineLength.setText("");
        //  Add the control theAlignmentGridX to the content pane.
        theCodeFormatterPage.add(theMaxLineLength, "theMaxLineLength");
        layoutManagertheCodeFormatterPage.setAnchoring(theMaxLineLength, true, false, true, false);

        theIndentation.setLocation(184, 48);
        theIndentation.setSize(104, 24);
        theIndentation.setText("");
        //  Add the control theAlignmentGridY to the content pane.
        theCodeFormatterPage.add(theIndentation, "theIndentation");
        layoutManagertheCodeFormatterPage.setAnchoring(theIndentation, true, false, true, false);

        theDelimiters.setLocation(184, 84);
        theDelimiters.setSize(104, 24);
        theDelimiters.setText("");
        //  Add the control theAlignmentGridX to the content pane.
        theCodeFormatterPage.add(theDelimiters, "theDelimiters");
        layoutManagertheCodeFormatterPage.setAnchoring(theDelimiters, true, false, true, false);

        theStickyDelimiters.setLocation(184, 120);
        theStickyDelimiters.setSize(104, 24);
        theStickyDelimiters.setText("");
        //  Add the control theAlignmentGridY to the content pane.
        theCodeFormatterPage.add(theStickyDelimiters, "theStickyDelimiters");
        layoutManagertheCodeFormatterPage.setAnchoring(theStickyDelimiters, true, false, true, false);

        /*****  Platform look & feel Panel ****/
        // Platform look & feel.

        AnchoringLayoutManager layoutManagerthePLAFPage = new AnchoringLayoutManager();
        thePLAFPage.setLayout(layoutManagerthePLAFPage);
        thePLAFPage.setLocation(130, 15);
        thePLAFPage.setSize(450, 300);
        thePLAFPage.setVisible(false);
        thePLAFPage.setBorder(lookfeelDescborder);

        getContentPane().add("Platform Look and Feel", thePLAFPage);
        JALabelX16.setLocation(24, 20);
        JALabelX16.setSize(112, 24);
        JALabelX16.setText("Platform");
        //  Add the control JALabelX3 to the content pane.
        thePLAFPage.add(JALabelX16, "JALabelX16");
        layoutManagerthePLAFPage.setAnchoring(JALabelX16, true, false, true, false);

        thePLAF.setLocation(184, 20);
        thePLAF.setSize(104, 24);
        if (theMetadata.sPlatformLookAndFeel != null)
            thePLAF.setSelectedIndex(theDesignCockpit.thePreferences.getPLAF(theMetadata.sPlatformLookAndFeel));
        else
            thePLAF.setSelectedIndex(theDesignCockpit.thePreferences.getPLAF());
        //  Add the control theAlignmentGridY to the content pane.
        thePLAFPage.add(thePLAF, "thePLAF");
        layoutManagerthePLAFPage.setAnchoring(thePLAF, true, false, true, false);

        thePLAFGenerator.setLocation(24, 60);
        thePLAFGenerator.setSize(104, 24);

        //  Add the control theAlignmentGridY to the content pane.
        thePLAFPage.add(thePLAFGenerator, "thePLAFGenerator");
        layoutManagerthePLAFPage.setAnchoring(thePLAFGenerator, true, false, true, false);

        thePLAFChangeDefault.setLocation(24, 100);
        thePLAFChangeDefault.setSize(104, 24);

        //  Add the control theAlignmentGridY to the content pane.
        thePLAFPage.add(thePLAFChangeDefault, "thePLAFChangeDefault");
        layoutManagerthePLAFPage.setAnchoring(thePLAFChangeDefault, true, false, true, false);
        /*****            ****/
        /*****  NLS Panel ****/
        /*****            ****/
        AnchoringLayoutManager layoutManagertheNLSPage = new AnchoringLayoutManager();
        theNLSPage.setLayout(layoutManagertheNLSPage);
        theNLSPage.setLocation(114, 15);
        theNLSPage.setSize(328, 300);
        theNLSPage.setVisible(false);
        theNLSPage.setBorder(NLSDescborder);

        theNLSTable.setLocation(10, 30);
        theNLSTable.setSize(380, 130);

        JScrollPane theNLSTablePane = new JScrollPane(theNLSTable);
        theNLSTablePane.setLocation(10, 30);
        theNLSTablePane.setSize(380, 160);
        // set model and column sizes.
        theNLSTable.setModel(this.theNLSTableModel);
        DefaultTableColumnModel theColumnModel = new DefaultTableColumnModel();
        TableColumn tc1 = new TableColumn(0, 120);
        tc1.setHeaderValue("NLS Key");
        theColumnModel.addColumn(tc1);
        TableColumn tc2 = new TableColumn(1, 260);
        tc2.setHeaderValue("Document Location");
        theColumnModel.addColumn(tc2);
        theNLSTable.setColumnModel(theColumnModel);
        TableColumn tc = theNLSTable.getColumnModel().getColumn(0);
        tc.setMaxWidth(120);
        tc = theNLSTable.getColumnModel().getColumn(1);
        tc.setMaxWidth(260);
        //  Add the control theAlignmentGridY to the content pane.
        theNLSPage.add(theNLSTablePane, "theNLSTable");
        layoutManagertheNLSPage.setAnchoring(theNLSTablePane, true, false, true, false);

        theNLSDeleteRowButton.setLocation(410, 50);
        theNLSDeleteRowButton.setSize(100, 22);
        theNLSDeleteRowButton.setText("Delete Row");
        theNLSDeleteRowButton.addActionListener(new NLSDeleteRowAction(this));
        theNLSPage.add(theNLSDeleteRowButton, "theNLSDeleteRowButton");
        layoutManagertheNLSPage.setAnchoring(theNLSDeleteRowButton, true, false, true, false);

        getContentPane().add("National Language Support", theNLSPage);
        theProjectOKButton.setLocation(350, 320);
        theProjectOKButton.setSize(224, 60);
        theProjectOKButton.setText("OK");
       // theProjectOKButton.setBorder(loweredetched);
        //  Add the control theProjectOKButton to the content pane.
        getContentPane().add(theProjectOKButton, "theProjectOKButton");
        layoutManagerProjectTool.setAnchoring(theProjectOKButton, false, false, false, false);
        theProjectCancelButton.setLocation(430, 320);
        theProjectCancelButton.setSize(224, 60);
        theProjectCancelButton.setText("Cancel");
       // theProjectCancelButton.setBorder(loweredetched);
        //  Add the control theProjectCancelButton to the content pane.
        getContentPane().add(theProjectCancelButton, "theProjectCancelButton");
        layoutManagerProjectTool.setAnchoring(theProjectCancelButton, false, false, false, false);
        // Icon Creation Section

        theIconFactory = new HammerImageIconFactory(theDesignCockpit.theClassLoader);

        theToolBar.setLocation(0, 15);
        theToolBar.setSize(100,300);

        // Enable rollover mode
        theToolBar.setRollover(true);
        theToolBar.setBorderPainted(true);
        theToolBar.setFloatable(false);

        JAScrollPane listSettings = new JAScrollPane(theToolBar);
        listSettings.setLocation(0,15);
        listSettings.setSize(100,300);
        listSettings.setFocusable(true);
        listSettings.setBackground(this.getBackground());
        listSettings.setBorder(loweredetched);
        addButtons();
        getContentPane().add(listSettings, "List Panels");

        listSettings.setBackground(theToolBar.getBackground());

        //  Add the control theToolConfigurationPage to the Tabbed pane.
        if (theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER)
            c8.setVisible(true);
        //  Add the control theToolConfigurationPage to the Tabbed pane.
        if (theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER)
            c7.setVisible(true);

        this.currPanel = theProjectIDPage;

        theProjectOKButton.addActionListener(new OKListener(this));
        theProjectCancelButton.addActionListener(new CancelListener(this));

        Load();

    // Show the main window
        show(null);

    }

    protected void addButtons()
    {
            idProjectSetIcon = theIconFactory.getHammerImageIcon(theDesignCockpit.sImageDirectory + "id_card.png");
            impDescriptionSetIcon = theIconFactory.getHammerImageIcon( theDesignCockpit.sImageDirectory + "window_information.png");
            impBuildSetIcon = theIconFactory.getHammerImageIcon( theDesignCockpit.sImageDirectory + "cup.png");
            impCodeGenIcon  = theIconFactory.getHammerImageIcon( theDesignCockpit.sImageDirectory + "text_code_java.png");
            impViewDisplayIcon = theIconFactory.getHammerImageIcon( theDesignCockpit.sImageDirectory + "form_blue.png");
            impCodeFormatterIcon = theIconFactory.getHammerImageIcon( theDesignCockpit.sImageDirectory + "document_gear.png");
            impLookAndFeelIcon = theIconFactory.getHammerImageIcon( theDesignCockpit.sImageDirectory + "window_preferences.png");
            impNLSIcon = theIconFactory.getHammerImageIcon( theDesignCockpit.sImageDirectory + "data_table.png");

          // Add a button to the toolbar; remove the label and margin before adding
            //JToggleButton c1 = new JToggleButton(idProjectSetIcon);
            JButton c1 = new JButton(idProjectSetIcon);
            c1.setText("Identification");
            c1.setMargin(new Insets(0, 0, 0, 0));
            c1.setSize(90,90);
            c1.setVerticalTextPosition(AbstractButton.BOTTOM);
            c1.setHorizontalTextPosition(AbstractButton.CENTER);
            c1.addActionListener(new ToolBarListener(this));
            theToolBar.add(c1);

            // Add a toggle button; remove the label and margin before adding
            JButton c2 = new JButton(impDescriptionSetIcon);
            c2.setText("Description   ");
            c2.setMargin(new Insets(0, 0, 0, 0));
            c2.setSize(90,90);
            c2.setVerticalTextPosition(AbstractButton.BOTTOM);
            c2.setHorizontalTextPosition(AbstractButton.CENTER);
            c2.addActionListener(new ToolBarListener(this));

            if (theDesignCockpit.theProgramMode==SuperDesignCockpit.JAVABUILDER)
            theToolBar.add(c2);

            // Add a button to the toolbar; remove the label and margin before adding
            JButton c3 = new JButton(impBuildSetIcon);
            c3.setText("<html>" + "Build" + "<br>" +" " + "</html>");
            c3.setMargin(new Insets(0, 0, 0, 0));
            c3.setSize(90,90);
            c3.setVerticalTextPosition(AbstractButton.BOTTOM);
            c3.setHorizontalTextPosition(AbstractButton.CENTER);
            c3.addActionListener(new ToolBarListener(this));

            if (theDesignCockpit.theProgramMode==SuperDesignCockpit.JAVABUILDER)
            theToolBar.add(c3);

            // Add a button to the toolbar; remove the label and margin before adding
            JButton c4 = new JButton(impCodeGenIcon);
            c4.setText("<html>" + "Code" + "<br>" +  "Generator" +"<html>");
            c4.setMargin(new Insets(0, 0, 0, 0));
            c4.setSize(90,90);
            c4.setVerticalTextPosition(AbstractButton.BOTTOM);
            c4.setHorizontalTextPosition(AbstractButton.CENTER);
            c4.addActionListener(new ToolBarListener(this));

            if (theDesignCockpit.theProgramMode==SuperDesignCockpit.JAVABUILDER)
            theToolBar.add(c4);

            JButton c5 = new JButton(impViewDisplayIcon);
            c5.setText("<html>" + "View" + "<br>" + "Display" + "</html>");
            c5.setMargin(new Insets(0, 0, 0, 0));
            c5.setSize(90,90);
            c5.setVerticalTextPosition(AbstractButton.BOTTOM);
            c5.setHorizontalTextPosition(AbstractButton.CENTER);
            c5.addActionListener(new ToolBarListener(this));
            theToolBar.add(c5);

            JButton c6 = new JButton(impCodeFormatterIcon);
            c6.setText("<html>" + "Code" + "<br>" + "Formatter" + "</html>");
            c6.setMargin(new Insets(0, 0, 0, 0));
            c6.setSize(90,90);
            c6.setVerticalTextPosition(AbstractButton.BOTTOM);
            c6.setHorizontalTextPosition(AbstractButton.CENTER);
            c6.addActionListener(new ToolBarListener(this));

            if (theDesignCockpit.theProgramMode==SuperDesignCockpit.JAVABUILDER)
            theToolBar.add(c6);

            c7.setText("<html>" +  "Look &" + "<br>" + "Feel" + "</html>");
            c7.setMargin(new Insets(0, 0, 0, 0));
            c7.setSize(90,90);
            c7.setVerticalTextPosition(AbstractButton.BOTTOM);
            c7.setHorizontalTextPosition(AbstractButton.CENTER);
            c7.setIcon(impLookAndFeelIcon);
            c7.addActionListener(new ToolBarListener(this));

            if (theDesignCockpit.theProgramMode==SuperDesignCockpit.JAVABUILDER)
            theToolBar.add(c7);

            c8.setText("<html>" + "NLS" + "<br>" +" " + "</html>");
            c8.setMargin(new Insets(10, 0, 10, 0));
            c8.setSize(90,90);
            c8.setVerticalTextPosition(AbstractButton.BOTTOM);
            c8.setHorizontalTextPosition(AbstractButton.CENTER);
            c8.setIcon(impNLSIcon);
            c8.addActionListener(new ToolBarListener(this));
            theToolBar.add(c8);


        theToolBar.setBackground(c1.getBackground());

    }

    public void setCurrentPanel(JPanel jCurrPanel)
    {
        this.currPanel = jCurrPanel;
    }

    public JPanel getCurrentPanel()
    {
        return this.currPanel;
    }

    public void Load() {
        sAuthor = theMetadata.sAuthor;
        theAuthor.setText(sAuthor);

        theDeclVariablePrefix.setText(theProject.getDeclVariablePrefix());

        sDescription = theMetadata.sDescription;
        theProjectDescription.setText(sDescription);

        sCodeGenerationDocument = theMetadata.sCodeGenerationDocument;
        theClassInfoDocument.setText(sCodeGenerationDocument);
        sWorkspace = theMetadata.sWorkspace;
        sOutputDirectory = theMetadata.sOutputDirectory;
        theOutputDirectory.setText(theMetadata.sOutputDirectory);
        bAbalet = theMetadata.bAbalet;
        theAbaletButton.setSelected(bAbalet);
        bApplication = theMetadata.bApplication;
        theApplicationButton.setSelected(bAbalet);
        sMainClass = theMetadata.sMainClass;
        sPackageName = theMetadata.sPackageName;
        sClassPath = theMetadata.getClassPath();
        if(theDesignCockpit.thePreferences.getAdditionalClasspath()!=null && (sClassPath!=null && sClassPath.length()>0))
            sClassPath = sClassPath + ";" +theDesignCockpit.thePreferences.getAdditionalClasspath();
        else
            sClassPath = theDesignCockpit.thePreferences.getAdditionalClasspath();
        theAddClassPath.setText(sClassPath);
        sTransientDirectory = theMetadata.sTransientDirectory;
        theAdditionalImports.setText(theProject.getAdditionalImports());
        theProjectRepositPath.setText(theDesignCockpit.thePreferences.getRepositPath());
        theTransientDirectory.setText(sTransientDirectory);
        chkDisplayGrid.setSelected(theDesignCockpit.thePreferences.bDisplayGrid);
        chkSnapToGrid.setSelected(theDesignCockpit.thePreferences.bSnapToGrid);
        theAccessGenerator.setSelected(theMetadata.isbAccesorCode());
        theNLSGenerator.setSelected(theMetadata.isbNLSTranslation());

        theMaxLineLength.setText((new Integer(theDesignCockpit.thePreferences.iMaxLineLength)).toString());
        theIndentation.setText((new Integer(theDesignCockpit.thePreferences.iIndentation)).toString());
        theDelimiters.setText(theDesignCockpit.thePreferences.sDelimiters);
        theStickyDelimiters.setText(theDesignCockpit.thePreferences.sStickyDelimiters);
        this.theNLSTableModel.load();
    }

    public void SaveAndClear() {
        DesignCockpitPreferences thePreferences = theDesignCockpit.thePreferences;
        sDescription = theMetadata.sDescription = theProjectDescription.getText();
        sCodeGenerationDocument = theMetadata.sCodeGenerationDocument = this.theClassInfoDocument.getText();
        sWorkspace = theMetadata.sWorkspace;
        bAbalet = theMetadata.bAbalet = theAbaletButton.isSelected();
        bApplication = theMetadata.bApplication = theApplicationButton.isSelected();
        sMainClass = theMetadata.sMainClass;
        sPackageName = theMetadata.sPackageName;
        sOutputDirectory = theMetadata.sOutputDirectory = theOutputDirectory.getText();
        sClassPath = theAddClassPath.getText();
        sTransientDirectory = theTransientDirectory.getText();
        theProject.setAdditionalImports(theAdditionalImports.getText());
        theMetadata.setClassPath(sClassPath);
        theDesignCockpit.thePreferences.setRepositPath(theProjectRepositPath.getText());
        theDesignCockpit.thePreferences.setAdditionalClasspath(sClassPath);
        theMetadata.sTransientDirectory = sTransientDirectory;
        theMetadata.sAuthor = theAuthor.getText();
        theProject.setDeclVariablePrefix(theDeclVariablePrefix.getText());
        thePreferences.sDelimiters = theDelimiters.getText();
        thePreferences.sStickyDelimiters = theStickyDelimiters.getText();
        thePreferences.iMaxLineLength = (new Integer(theMaxLineLength.getText())).intValue();
        thePreferences.iIndentation = (new Integer(theIndentation.getText())).intValue();

        if (thePLAFChangeDefault.isSelected()) {
            thePreferences.setPLAF(thePLAF.getSelectedIndex(), theDesignCockpit);
        }
        theMetadata.bGeneratePLAF = thePLAFGenerator.isSelected();
        if (theMetadata.bGeneratePLAF)
            theMetadata.sPlatformLookAndFeel = theDesignCockpit.thePreferences.getPLAF(thePLAF.getSelectedIndex());
        else
            theMetadata.sPlatformLookAndFeel = null;

        theMetadata.setbAccesorCode(theAccessGenerator.isSelected());
        theMetadata.setbNLSTranslation(theNLSGenerator.isSelected());

        theMetadata.sGenLookFeelName= thePreferences.getGenCodeLookFeel(theCodeLookFeel.getSelectedIndex());
        theDesignCockpit.theCurrentDesignProject.setGenCodeLAF(theMetadata.sGenLookFeelName);
        this.theNLSTableModel.save();

        theDesignCockpit.thePreferences.bDisplayGrid = chkDisplayGrid.isSelected();
        theDesignCockpit.thePreferences.bSnapToGrid = chkSnapToGrid.isSelected();
        theDesignCockpit.thePreferences.iViewDisplayerGridX =  ((Integer) (theAlignmentGridX.getValue())).intValue();
        theDesignCockpit.thePreferences.iViewDisplayerGridY = ((Integer) (theAlignmentGridY.getValue())).intValue();
        theDesignCockpit.thePreferences.iSizeBoxHeight = ((Integer) (theSizeBoxHeight.getValue())).intValue();
        theDesignCockpit.thePreferences.iSizeBoxWidth = ((Integer) (theSizeBoxWidth.getValue())).intValue();

//        theDesignCockpit.thePreferences.save(theDesignCockpit);
        theDesignCockpit.theViewDisplayer.repaint();

        theDesignCockpit.theSizeboxes.resizeAllSizeBoxes();
        if (theDesignCockpit.theFrameSizeboxes != null)
            theDesignCockpit.theFrameSizeboxes.resizeSizeBoxes();
        hide();
    }

    class ToolBarListener implements ActionListener {
        IDEProjectTool theProjectTool = null;

        public ToolBarListener (IDEProjectTool objProjectTool) {
            theProjectTool = objProjectTool;
        }

        public void actionPerformed(ActionEvent evt) {
            String act = evt.getActionCommand().trim();

            JPanel jCurrPanel = getCurrentPanel();
            jCurrPanel.setVisible(false);

            if (act.equals("Identification"))
            {
                setCurrentPanel(theProjectIDPage);
            }
            else if (act.equals("Description"))
            {
                setCurrentPanel(theProjectDescriptionPage);
            }
            else if (act.equals("<html>Build<br> </html>"))
            {
                setCurrentPanel(theProjectPathPage);
            }
            else if (act.equals("<html>Code<br>Generator<html>"))
            {
                setCurrentPanel(theCodeGenerationChoicePage);
            }
            else if (act.equals("<html>View<br>Display</html>"))
            {
               setCurrentPanel(theToolConfigurationPage);
            }
            else if (act.equals("<html>Look &<br>Feel</html>"))
            {
               setCurrentPanel(thePLAFPage);
            }
            else if (act.equals("<html>Code<br>Formatter</html>"))
            {
              setCurrentPanel(theCodeFormatterPage);
            }
            else if (act.equals("<html>" + "NLS" + "<br>" +" " + "</html>"))
            {
              setCurrentPanel(theNLSPage);
            }

            theProjectTool.currPanel.setVisible(true);
        }
    }
    class OKListener implements ActionListener {
        IDEProjectTool theProjectTool = null;

        public OKListener(IDEProjectTool objProjectTool) {
            theProjectTool = objProjectTool;
        }

        public void actionPerformed(ActionEvent evt) {
            theProjectTool.SaveAndClear();
        }
    }

    class CancelListener implements ActionListener {
        IDEProjectTool theProjectTool = null;

        public CancelListener(IDEProjectTool objProjectTool) {
            theProjectTool = objProjectTool;
        }

        public void actionPerformed(ActionEvent evt) {
            theProjectTool.hide();
        }

    }

}

