/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import javax.swing.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionEvent;
import java.awt.*;
import java.util.ArrayList;

/**
 * IDEWindowClosingEventHandler
 *
 * Before the design cockpit exits, all open project sessions are queried for saving.
 *
 */
public class IDEWindowClosingEventHandler extends WindowAdapter {
    SuperDesignCockpit theDesignCockpit;

    public IDEWindowClosingEventHandler(SuperDesignCockpit objDesignCockpit) {
        super();
        theDesignCockpit = objDesignCockpit;
    }

    public void windowClosing(WindowEvent evt) {
        ArrayList projToDelete = new ArrayList(0);
        DesignProject theDesignProject = theDesignCockpit.theFirstDesignProject;
        while (theDesignProject != null) {
            boolean bTest = theDesignProject.close(true);
            String newProjectName = theDesignProject.theMetaProject.sName;
            if (bTest == false) {
                Component[] theProjectWindowMenuItems = theDesignCockpit.getIDEMenuBar().getWindowMenu().getMenuComponents();
                for (int i = 0; i < theProjectWindowMenuItems.length; i++) {
                    if (theProjectWindowMenuItems[i] instanceof JMenuItem) {
                        JMenuItem theMenuItem = (JMenuItem) theProjectWindowMenuItems[i];
                        if (theMenuItem.getText().equals(newProjectName)) {
                            SelectProjectAction reopenAction = (SelectProjectAction) theMenuItem.getAction();
                            reopenAction.actionPerformed(new ActionEvent(theDesignCockpit, 0, reopenAction.theDesignProject.theMetaProject.sName));
                            break;
                        }
                    }
                }
                for (int j = 0; j < projToDelete.size(); j++) {
                    DesignProject theProject = (DesignProject) projToDelete.get(j);
                    theDesignCockpit.removeDesignProject(theProject);
                }
                return;
            } else { // remove from menu.
                Component[] theProjectWindowMenuItems = theDesignCockpit.getIDEMenuBar().getWindowMenu().getMenuComponents();
                for (int i = 0; i < theProjectWindowMenuItems.length; i++) {
                    if (theProjectWindowMenuItems[i] instanceof JMenuItem) {
                        JMenuItem theMenuItem = (JMenuItem) theProjectWindowMenuItems[i];
                        if (theMenuItem.getText().equals(newProjectName)) {
                            theDesignCockpit.getIDEMenuBar().getWindowMenu().remove(theMenuItem);
                            break;
                        }
                    }
                }
                projToDelete.add(theDesignProject);
                //  We must now add this closed file to the MRU list (unless it is a unsaved "new" project)...
                if (!((theDesignProject.theMetaProject.sName == null) || (theDesignProject.theMetaProject.sName.startsWith("New Project")) || (theDesignProject.theMetaProject.sName.trim().length() == 0))) {
                    if (theDesignCockpit.isCustomizing() == false)
                        theDesignCockpit.mruList.fileClosed(theDesignProject.getProjectDirectory() +theDesignProject.theMetaProject.sName);
                }
            }
            theDesignProject = theDesignProject.theNextDesignProject;
        }
        theDesignCockpit.thePreferences.sWorkingDirectory = theDesignCockpit.getCurrentDirectory();
        theDesignCockpit.thePreferences.save(theDesignCockpit);
        // ok, get rid of the SuperDesignCockpit now.
        // Calling dispose will cause the windowClosed event which is trapped
        // in another adapter.
        theDesignCockpit.dispose();

    }

}
