/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: May 26, 2004
 * Time: 2:13:46 AM
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.ObjectTreeViewNode;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.JATabbedPane;

import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class ObjectTreeViewSelectionListener implements TreeSelectionListener {
    public void valueChanged(TreeSelectionEvent evt) {
        TreePath thePath = evt.getPath();
        ObjectTreeView theTree = (ObjectTreeView) evt.getSource();
        ObjectTreeViewNode theSelectedNode = (ObjectTreeViewNode) thePath.getLastPathComponent();
        if (theSelectedNode != null) {
            if (theSelectedNode.equals(theTree.theCockpit.theObjectTreeViewPane.theRootNode)) {
                theTree.theCockpit.SelectContainer(null);
                theTree.theCockpit.SelectObject(null, false);
            } else if (theSelectedNode.getMetaObject() != null) {
                // Tabbed panes need to reset the selected tab so that it shows.
                if (theSelectedNode.getMetaObject().isTabbedPane()) {
                    if (theSelectedNode.getMetaObject().theVisualObject != null) {
                        DesignTabbedPane theTabbedPane = (DesignTabbedPane) theSelectedNode.getMetaObject().theVisualObject;
                        theTabbedPane.theListener.selectedIndex = -1;  // reset so the last tab page shows.
                        theTabbedPane.setSelectedIndex(-1);
                    }
                }
                // Check first if the selected object is in a tab.
                // If it is, we need to select the tabbed pane before selecting the object.
                MetaObject theObject = theSelectedNode.getMetaObject();
                MetaObject theLastChild = null;
                while ((theObject != null) && (theObject.isTabbedPane() == false)) {
                    theLastChild = theObject;
                    theObject = theObject.theParentObject;
                }
                // Rotate the page if it is in a tabbed pane.
                if ((theLastChild != null) && (theObject != null)) {
                    if (theObject.theVisualObject instanceof JATabbedPane) {
                        JATabbedPane theTabbedPane = (JATabbedPane) theObject.theVisualObject;
                        // Swap the pages.
                        int iSelectedIndex = theTabbedPane.getSelectedIndex();
                        if (iSelectedIndex >= 0)
                            theTabbedPane.setEnabledAt(iSelectedIndex, true);
                        theTabbedPane.setSelectedComponent(theLastChild.theVisualObject);
                        iSelectedIndex = theTabbedPane.getSelectedIndex();
                        for (int i = 0; i < theTabbedPane.getTabCount(); i++)
                            theTabbedPane.setEnabledAt(iSelectedIndex, (iSelectedIndex == i) ? false : true);
                        theTree.theCockpit.SelectContainer(theLastChild, false);
                        theTree.theCockpit.SelectObject(theSelectedNode.getMetaObject(), false);
                    }
                } else {
                    // Select the container and then the object.
                    MetaObject theSelectedObject = theSelectedNode.getMetaObject();
//                      MetaObject theNewSelectedContainer = theSelectedNode.getMetaObject().getVisualContainerObject(false, true);
//                      theTree.theCockpit.deselectObjects();
                    // make sure the object and its container parents are visible.
                    // clicking here turns off selection (I can't get ctrl key here - check later for another way)
                    theTree.theCockpit.SelectObject(theSelectedObject, false);
                    theSelectedObject.bringForward();
//                      if ((theSelectedContainer==null) || (!theSelectedContainer.equals(theNewSelectedContainer)))
//                          theTree.theCockpit.SelectContainer( theNewSelectedContainer);
                }
            }
        }
    }
}