/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.classEditor.LizardValueChoiceComboBox;
import ch.abacus.designcockpit.classEditor.LizardValueChoiceComboBoxModel;
import ch.abacus.designcockpit.external.IDEFocusRequester;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.renderer.common.jdbc.JSSTextField;
import ch.abacus.lib.ui.validation.IgnoreStandardEventsInterface;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

/**
 * Title:        uifactory
 * Description:  This is a program design tool that creates Abacus java applications using the UI Factory.  The output of this tool is an xml document that is processed by the UI factory to create the java programs.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

class PropertyTableKeyListener extends KeyAdapter {
    PropertyTable theTable;

    public PropertyTableKeyListener(PropertyTable theTable) {
        super();
        this.theTable = theTable;
    }

    public void KeyReleased(KeyEvent evt) {
        super.keyReleased(evt);
    }

    public void KeyPressed(KeyEvent evt) {
        super.keyPressed(evt);
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
            theTable.editingStopped(new ChangeEvent(theTable.theComboEditor));
            return;
        }
    }

    public void KeyTyped(KeyEvent evt) {
        super.keyTyped(evt);
    }
}

class PropertyTableValueChoiceComboBox extends LizardValueChoiceComboBox {
    int iRow = 0;
    int iColumn = 0;

    public PropertyTableValueChoiceComboBox(LizardValueChoiceComboBoxModel model, Object receiver) {
        super(model, receiver);
    }

    public void setRow(int iRow) {
        this.iRow = iRow;
    }

    public void setColumn(int iCol) {
        this.iColumn = iCol;
    }

    public void setSelectedItem(Object obj) {
        super.setSelectedItem(obj);
        if (obj instanceof String)
            setEditorText((String) obj);
        else if (obj instanceof Boolean)
            setEditorText(obj.toString());
    }
//      public void init() {
//          if (theReceiver instanceof PropertyTable) {
//              PropertyTable theTable = (PropertyTable)theReceiver;
//              String sValue = (String)theTable.theModel.getValueAt(iRow, iColumn);
//              this.resetEditor();
//          }
//      }
}


public class PropertyTable extends JATable implements ItemListener, IgnoreStandardEventsInterface {

    HelperTableCellRenderer helperButtonCellRenderer=null;
    ColorPropertyRenderer colorPropertyCellRenderer=null;
    BooleanRenderer booleanPropertyCellRenderer=null;

    public PropertyTableModel theModel;
    public SuperDesignCockpit theDesignCockpit;
    public LizardValueChoiceComboBoxModel theComboModel;
    public PropertyComboBoxEditor theComboEditor;
//  public IndexComboBoxModel theIndexComboBoxModel;
//  public IndexComboBox theIndexCombo;
    public IDEArrayValueEditor theArrayValueEditor;
    PropertyTableTextField theTextboxEditor;
    PropertyTableTextField theStaticEditor;

    class PropertyTableTextField extends JTextField {
        String thePropertyName;
        int theCellRow;
        int theCellColumn;
        boolean bHighlight;
        PropertyTable theTable;

        public PropertyTableTextField(PropertyTable theTable) {
            this.theTable = theTable;
        }


        void setRow(int row) {
            theCellRow = row;
        }

        void setColumn(int column) {
            theCellColumn = column;
        }

        void setHighlight(boolean state) {
            bHighlight = state;
        }

        void setPropertyName(String propertyName) {
            thePropertyName = propertyName;
        }

        int getRow() {
            return theCellRow;
        }

        int getColumn() {
            return theCellColumn;
        }

        boolean getHighlight() {
            return bHighlight;
        }

        String getPropertyName() {
            return thePropertyName;
        }
    }

    class PropertyTableFocusListener implements FocusListener {

        PropertyTable theTable;

        PropertyTableFocusListener(PropertyTable theTableParent) {
            theTable = theTableParent;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            MetaObject theMetaObject = theTable.theDesignCockpit.getDesignProject().getLastObjectSelected();
            theTable.invalidate();
            theTable.repaint();
            theMetaObject.doProperties();
            theMetaObject.theVisualObject.repaint();
            if (theMetaObject.equals(theTable.theDesignCockpit.getDesignProject().getSelectedFrame()))
                theTable.theDesignCockpit.theViewDisplayer.repaint();
        }

    }



    public PropertyTable(PropertyTableModel theTableModel, SuperDesignCockpit objDesignCockpit) {  // action listener for combo.
        super(theTableModel);
        this.setBorder(null);
        this.setGridColor(Color.LIGHT_GRAY);

        theComboModel = new LizardValueChoiceComboBoxModel(objDesignCockpit.theCurrentDesignProject.theMetaProject.getMetadataDispenser());
        // 2nd parameter is generic receiver
        theComboEditor = new PropertyComboBoxEditor(theComboModel, this);
        theStaticEditor = new PropertyTableTextField(this);
        theTextboxEditor = new PropertyTableTextField(this);
        theModel = theTableModel;
        theDesignCockpit = objDesignCockpit;
        setCellSelectionEnabled(true);
        addMouseListener(new PropertyTableMouseListener(this));
        theComboEditor.addItemListener(this);
        theComboEditor.setEditable(true);
        theStaticEditor.setEditable(false);

        setBackground ( Color.WHITE );
        getTableHeader ().setBackground ( IDETitleBar.colGroupFill );
        getTableHeader ().setBorder (  null );
    }


    /**
     * Implemented for interface IgnoreStandardEventsInterface. Returns true to ensure that this component will not be validated
     *
     * @return
     */
    public boolean isValidationIndependent() {
        return true;
    }


    public void itemStateChanged(ItemEvent evt) {
        Object oText = theComboEditor.getSelectedItem(); // evt.getItem();
        String sText = "";
        if (oText instanceof String)
            sText = (String) oText; //evt.getItem();
        else if (oText instanceof Boolean)
            sText = oText.toString(); //.getItem()).toString();
        if ((sText != null) && (sText.length() > 0)) {
            theComboEditor.setEditorText(sText);
            theModel.setValueAt(sText, theComboEditor.iRow, theComboEditor.iColumn);
        }
        else if(oText!=null)
        {
            theComboEditor.setEditorText(sText);
            theModel.setValueAt(sText, theComboEditor.iRow, theComboEditor.iColumn);
        }
    }

    public void nextRow() {
        int row = this.getSelectedRow();
        int column = 1;
        row++;
        if (row >= getRowCount())
            row = getRowCount() - 1;
        changeSelection(row, column, true, true);
        editCellAt(row, column);
        Component theEditor = this.getEditorComponent();
        if (theEditor instanceof JComponent)
            IDEFocusRequester.requestFocus((JComponent)theEditor);
        // otherwise nothing gets the focus.
        if (theEditor instanceof PropertyTableTextField) {
            PropertyTableTextField theField = (PropertyTableTextField) theEditor;
            theField.selectAll();
        }
    }

    public void prevRow() {
        int row = this.getSelectedRow();
        int column = 1;
        row--;
        if (row < 0)
            row = 0;
        changeSelection(row, column, true, true);
        editCellAt(row, column);
        Component theEditor = this.getEditorComponent();
        if (theEditor instanceof JComponent)
            IDEFocusRequester.requestFocus((JComponent)theEditor);
        // otherwise nothing gets the focus.
        if (theEditor instanceof PropertyTableTextField) {
            PropertyTableTextField theField = (PropertyTableTextField) theEditor;
            theField.selectAll();
        }
    }

    // This is for strings.
    public Boolean getExitingComboBox(String sText, Object objLosingFocus) {
        return new Boolean(true);
    }

    public Boolean getPromptForComboBox(String sText, Object objLosingFocus) {
        int iRow = getSelectedRow();
        String sPropertyName = (String) getValueAt(iRow, 0);
        int iLeftBracket = sPropertyName.indexOf("[");
        if (iLeftBracket != -1)
            sPropertyName = sPropertyName.substring(0, iLeftBracket);
        MetaPropertyDescriptor theProp = theModel.theMetaObject.theClass.getProperty(sPropertyName, true);
        if (theProp != null) {
            if (theProp.bAllowMultipleValues) {
                theArrayValueEditor.close();
                theArrayValueEditor = new IDEArrayValueEditor(theModel.theMetaObject, sPropertyName, theDesignCockpit);
            }
        }
        return new Boolean(true);
    }


    public boolean editCellAt(int row, int column) {
        boolean bRetVal = super.editCellAt(row, column);
        if (getCellEditor() != null) {
            Component theEditor = this.getEditorComponent();
            if (theEditor instanceof JTextField) {
                ((JTextField) theEditor).selectAll();
            }
        }
        return bRetVal;
    }

    public void tableChanged(TableModelEvent evt) {
        super.tableChanged(evt);
    }

    public void Load() {
        theModel.Load(this);
        setVisible(false);  // only way to refresh without forcing screen update of everything.
        setVisible(true);   // this is because of the models...
    }

    public void resetContents() {
        theModel.clear();
        setVisible(false);
        setVisible(true);
    }

    /**
     * User: Adam Graham
     * Date: May 17, 2004
     * Time: 4:35:35 PM
     */
    class HelperTableCellRenderer extends JPanel implements TableCellRenderer
    {
        protected JLabel label=new JLabel();
        protected JButton button=new JButton("...");
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        /**
         * Creates a helper table cell renderer.
         */
        public HelperTableCellRenderer() {
            super();
            this.setLayout(new BorderLayout());
            this.add(label, BorderLayout.WEST);
            this.add(button, BorderLayout.EAST);
        }

        public Component getTableCellRendererComponent(JTable table, Object value,
                              boolean isSelected, boolean hasFocus, int row, int column) {
            setFont(table.getFont());
            if (hasFocus) {
                setBorder( UIManager.getBorder("Table.focusCellHighlightBorder") );
            } else {
                setBorder(noFocusBorder);
            }
            setForeground( table.getForeground() );
            setBackground( table.getBackground() );
            this.setPreferredSize(new Dimension(this.getWidth(), (int)button.getPreferredSize().getHeight()));
            setValue(value);
            button.setBackground(new Color(153,204,255));
            Dimension dim=new Dimension( button.getFontMetrics(button.getFont()).stringWidth("...")*2, button.getFontMetrics(button.getFont()).getHeight() );
            button.setPreferredSize(dim);
            return this;
        }

        protected void setValue(Object value) { label.setText((value == null) ? "" : value.toString()); }
    }


    // 050226, acg
    Color getItemColor(String avalue, int iRow)
    {
        MetaPropertyDescriptor theProperty =  theModel.theClassProperties.get(iRow);
        Object theResolvedValue=null;
        MetaConstantGroupCollection theConstantTableGroup = theModel.theMetaObject.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
        if ( avalue==null )
            avalue = theProperty.getDefaultValue();
        Object nv = theConstantTableGroup.get(avalue);
        try
        {
            theResolvedValue = MetaConstantGroup.resolve(nv, theDesignCockpit.theMetadataDispenser,
                                    theDesignCockpit.theFirstDesignProject.getMetaDataUser().getClassLoader().getLoader());
        }
        catch (HammerException e) { e.printStackTrace(); }

        return (Color)theResolvedValue;
    }


    public class ColorPropertyRenderer extends JLabel implements TableCellRenderer
    {
        Color currentColor;
        int currentRow;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
        {
            currentRow = row;
            // 050226, acg
            currentColor = (Color)getItemColor(value.toString(), currentRow);

            return this;
        }

        // Paint current color
        public void paint(Graphics g)
        {
            JButton button=new JButton();
            Dimension dim=new Dimension( button.getFontMetrics(button.getFont()).stringWidth("...")*2, button.getFontMetrics(button.getFont()).getHeight() );

            // Border
            g.setColor(Color.black);
            g.fillRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());

            g.setColor(currentColor);
            g.fillRect(1, 1, (int)dim.getWidth()-2, (int)dim.getHeight()-2);
            FontMetrics fontMetrics = g.getFontMetrics();
            g.setColor(super.getForeground());
            g.drawString((String)getValueAt(currentRow,1), (int)dim.getWidth()+2, fontMetrics.getAscent());
        }
    }

    public class ColorPropertyEditor extends DefaultCellEditor
    {
        public ColorPropertyEditor()
        {
            super(new JComboBox());
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        MetaPropertyDescriptor theProperty =  theModel.theClassProperties.get(row);
        String sClass = theProperty.getClassName().trim();

        if ( column==0 && theProperty!=null && theProperty.getHelperClass()!=null && theProperty.getHelperClass().length()>0 )
        {
            if ( helperButtonCellRenderer==null )
              helperButtonCellRenderer = new HelperTableCellRenderer();

            renderer = helperButtonCellRenderer;
        }

        if (renderer == null) {
            renderer = getDefaultRenderer(theModel.getCellClass(row, column));
        }

        // Color property
        if ( column==1 && theProperty!=null && sClass!=null && sClass.endsWith("Color") )
        {
            if ( colorPropertyCellRenderer==null )
              colorPropertyCellRenderer = new ColorPropertyRenderer();

            renderer = colorPropertyCellRenderer;
        }

        // Checkbox
        if ( theModel.getCellClass(row, column)!=null &&
             theModel.getCellClass(row, column)==Boolean.class)
        {
            if ( booleanPropertyCellRenderer==null )
              booleanPropertyCellRenderer = new BooleanRenderer();

            renderer = booleanPropertyCellRenderer;
        }

        return renderer;
    }

    public Component getEditorComponent() {
        Component theComponent = super.getEditorComponent();
        if (theComponent != null) {
            if (theComponent instanceof JTextField) {
                IDECommonEditFocusAdapter.setSelectAllOnEdit((JTextField) theComponent, this);
            }
        }
        return theComponent;
    }


    static class BooleanRenderer extends JCheckBox implements TableCellRenderer
    {
        public BooleanRenderer()
        {
            super("False");
            setHorizontalAlignment(JLabel.LEFT);
        }

        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int row, int column)
        {
            setForeground(table.getForeground());
            setBackground(table.getBackground());

            boolean shouldSelect = (value != null && ((Boolean) value).booleanValue());

            if ( shouldSelect )
                setText("True");
            else
                setText("False");

            setSelected(shouldSelect);
            return this;
        }
    }

    static class BooleanEditor extends DefaultCellEditor
    {
        JTable theTable;

        public BooleanEditor(JTable atable)
        {
            super(new JCheckBox());
            theTable=atable;
            JCheckBox checkBox = (JCheckBox) getComponent();
            checkBox.setForeground(atable.getForeground());
            checkBox.setBackground(atable.getBackground());
            checkBox.setHorizontalAlignment(JCheckBox.LEFT);
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        MetaPropertyDescriptor theProp = theModel.getPropertyAt(row);

        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null) {
            editor = getDefaultEditor(theModel.getCellClass(row, column));
            if (editor instanceof DefaultCellEditor)
                ((DefaultCellEditor) editor).setClickCountToStart(1);
        }
        if (theProp == null)
            return editor;
        MetaProperty thePropertyValue =
                theModel.theMetaObject.getPropertyMetadata(theProp.getName());
        switch (column) {
            case 0:
                {
                    theStaticEditor.setColumn(column);
                    theStaticEditor.setRow(row);
                    DefaultCellEditor theEditor = new DefaultCellEditor(theStaticEditor);
                    theEditor.setClickCountToStart(1);
                    return theEditor;
                }
            case 1:
                {
                    String sClass = theProp.getClassName().trim();
                    String sName= theProp.getName(); // MHC

                    if ((sClass.endsWith("Boolean")) || (sClass.equals("boolean")))
                    {
                        return new BooleanEditor(this);
                    }

                    if(theProp.bObjectReference == true)
                    {
                        DesignProject theDesignProject = theDesignCockpit.getDesignProject();
                        ArrayList arrObj = theDesignProject.findObjectsByClass(sClass);
                        theProp.setObjectReferenceList(arrObj);
                        theComboEditor.Load(theProp);

                        theComboEditor.setColumn(column);
                        theComboEditor.setRow(row);
                        theComboEditor.setEditorText("");
                        DefaultCellEditor theEditor = new DefaultCellEditor(theComboEditor);
                        theEditor.setClickCountToStart(1);
                        return theEditor;
                    }
                    if(theProp.getDataAwareness()==true) // MHC
                    {
                        DesignProject theDesignProject = theDesignCockpit.getDesignProject();

                        MetaObject mt = theDesignProject.getLastObjectSelected();
                        Object objFieldAccess = mt.getSwingObject();

                        Class fldAccsClass = objFieldAccess.getClass();
                        Method[] availMthds = fldAccsClass.getMethods();

                        for(int i=0;i < availMthds.length;i++)
                        {
                          Method chMth = availMthds[i];
                          String methodName = chMth.getName();
                          if( methodName.equalsIgnoreCase("getFieldNames"))
                          {
                              try
                              {
                                ArrayList fields = (ArrayList)chMth.invoke(objFieldAccess, (Object[])null);
                                for(int n=0;n < fields.size();n++)
                                {
                                    try
                                    {
                                        theProp.setValueChoice(n,fields.get(n).toString());
                                    }
                                    catch(Exception e)
                                    {
                                        theProp.addValueChoice(fields.get(n).toString());
                                    }
                                }
                              }
                              catch(Exception e)
                              {
                                  e.printStackTrace();
                              }
                              break;
                          }
                        }

                        theComboEditor.Load(theProp);
                        theComboEditor.setColumn(column);
                        theComboEditor.setRow(row);

                        DefaultCellEditor theEditor = new DefaultCellEditor(theComboEditor);
                        theEditor.setClickCountToStart(1);

                        return theEditor;
                    }
                    else if ((theProp.getValueChoiceCount() <= 1) && (theProp.bObjectReference == false) &&
                            ((theProp.getIncludeTypeConstants() == null) || (theProp.getIncludeTypeConstants().length() == 0))) {
                        theTextboxEditor.setColumn(column);
                        theTextboxEditor.setRow(row);
                        DefaultCellEditor theEditor = new DefaultCellEditor(theTextboxEditor);
                        theEditor.setClickCountToStart(1);
                        return theEditor;
                    } else {
                        MetaPropertyValueEx pvValue = theModel.theMetaObject.getPropertyValue(theProp.getName(), 0);

                        if ( theProp.getClassName().endsWith("Color") )
                        {
                            theComboEditor.enableColorSelection();
                        }
                        else
                        {
                            theComboEditor.enableDefaultSelection();
                        }

                        theComboEditor.Load(theProp);
                        //theComboEditor.selectItem((String)(theModel.getValueAt(row, column)));
                        theComboEditor.setColumn(column);
                        theComboEditor.setRow(row);
                        if (pvValue != null) {
                            String sValue = pvValue.getStringValue();
                            if (sValue != null)
                                theComboEditor.setSelectedItem(sValue);
                        }
                        DefaultCellEditor theEditor = new DefaultCellEditor(theComboEditor);

                        theEditor.setClickCountToStart(1);
                        return theEditor;
                    }
                }
        }
        return editor;
    }

}

class PropertyComboBoxEditor extends PropertyTableValueChoiceComboBox
{
    PropertyTable theTable;
    ListCellRenderer defaultRenderer;

    public PropertyComboBoxEditor(LizardValueChoiceComboBoxModel model, Object receiver)
    {
        super(model, receiver);

        if ( receiver instanceof PropertyTable )
            theTable=(PropertyTable)receiver;
    }

    public void enableColorSelection()
    {
        if ( defaultRenderer==null )
            defaultRenderer=getRenderer();

        setRenderer(new ColorRenderer());
        //setEditor(new ColorComboEditor(this));
    }

    Color getItemColor(String avalue)
    {
        MetaPropertyDescriptor theProperty =  theTable.theModel.theClassProperties.get(iRow);
        Object theResolvedValue=null;
        MetaConstantGroupCollection theConstantTableGroup = theTable.theModel.theMetaObject.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
        Object nv = theConstantTableGroup.get(avalue);
        try
        {
            theResolvedValue = MetaConstantGroup.resolve(nv, theTable.theDesignCockpit.theMetadataDispenser,
                                    theTable.theDesignCockpit.theFirstDesignProject.getMetaDataUser().getClassLoader().getLoader());
        }
        catch (HammerException e) { e.printStackTrace(); }

        return (Color)theResolvedValue;
    }

    public void enableDefaultSelection()
    {
        setRenderer(defaultRenderer);
    }

    class ColorLabel extends JLabel
    {
        public ColorLabel(String strValue)
        {
            super(strValue);
        }

        // Paint current color
        public void paint(Graphics g)
        {
            String labelText = getText();
            Color currentColor = getItemColor(labelText);

            JButton button=new JButton();
            Dimension dim=new Dimension( button.getFontMetrics(button.getFont()).stringWidth("...")*2, button.getFontMetrics(button.getFont()).getHeight() );

            // Border
            g.setColor(Color.black);
            g.fillRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());

            g.setColor(currentColor);
            g.fillRect(1, 1, (int)dim.getWidth()-2, (int)dim.getHeight()-2);
            FontMetrics fontMetrics = g.getFontMetrics();
            g.setColor(theTable.getForeground());
            g.drawString(labelText, (int)dim.getWidth()+2, fontMetrics.getAscent());
        }
    }

    class ColorRenderer implements ListCellRenderer
    {
        public Component getListCellRendererComponent(JList list,
                                                      Object value,
                                                      int index,
                                                      boolean isSelected,
                                                      boolean cellHasFocus)
        {
            ColorLabel label = new ColorLabel((String)value);
            label.setOpaque(true);
            return label;
        }

    }

    class ColorComboEditor extends JTextField implements ComboBoxEditor
    {
        private JComboBox combo;

        /**
         *
         */
        public ColorComboEditor(JComboBox combo)
        {
            super();
            this.setComboBox(combo);
            this.setBorder(null);
        }

        public Component getEditorComponent()
        {
            return this;
        }

        public Object getItem()
        {
            return super.getText();
        }

        public void setItem(Object anObject)
        {
            super.setText((String) anObject);
        }

        public void setComboBox(JComboBox combo)
        {
            if (!combo.isEditable())
                combo.setEditable(true);

            this.combo = combo;
        }

        public JComboBox getComboBox()
        {
            return combo;
        }
    }
}
