/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.designcockpit.ide.IDEPropertyInspectorController;

import javax.swing.*;
import javax.swing.event.ChangeEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart Booth (Live Clue, inc)
 * Date: Jul 22, 2005
 * Time: 4:34:12 PM
 * <p>
 * Any Property Inspector must implement this interface, or it cannot be used.
 */
public interface IDEPropertyInspectorInterface {
    /**
     * Indicates that objects are selected and need to be modelled
     * @param objects - an array of MetaObjects.
     */
    void newObjectsSelected (MetaObject[] objects);

    /**
     * Indicates that no objects are selected and that the Property Inspector should reflect this
     * (by being disabled, etc).
     */
    void clearSelectedObjects();

    /**
     * You need to return the actual component that will be displayed in the Property Inspector's panel
     * @return the component
     */
    JComponent getPropertyInspectorComponent();

    /**
     * You will receive this message whenever the list of classes to be modelled is made available.
     * This will be at the start of the session, but also at any other time the metadata is refreshed
     * (after a metadata-editor session, for example)
     */
    void loadClasses();

    /**
     * During this method, you must initialize the Property Inspector. After this call, calls to
     * getPropertyInspectorComponent() must succeed. 
     * @param controller - instance of IDEPropertyInspectorController. You can access the SuperDesignCockpit frmo its getSuperDesignCockpit method
     */
    void init(IDEPropertyInspectorController controller);

    /**
     * Sent whenever the DC changes focus away from the Property Inspector, indicating that you need to remove any Editors that may be visible
     * @param event
     */
    void editingCanceled(ChangeEvent event);

    /**
     * Call when you want to update the properties that are already displayed.
     */
    void updateSelectedProperties();
}
