/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.*;

import javax.swing.table.TableModel;
import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.PopupMenuEvent;
import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Nov 9, 2004
 * Time: 1:15:18 PM
 * To change this template use File | Settings | File Templates.
 */
public class ManageClassPropertyDialog extends JADialog {
    final ManageClassDialog theDialog;
    protected MetaPropertyDescriptor theProperty;
    private boolean dialogModified = false;

    JATextField propertyName;
    PropertyClasses propertyClass;
    JATextField propertyGetMethod;
    JATextField propertySetMethod;
    ConstantGroups propertyConstantGroup;
    Defaults propertyDefaultValue;
    JACheckBox propertyVisible;
    JACheckBox propertyArray;
    JACheckBox propertyLanguages;
    JACheckBox propertyReadOnly;
    HelperClasses propertyHelperClass;
    MetaPropertyDescriptor theParentProperty = null;

    TreeSet theHelperClasses = new TreeSet();
    TreeSet thePropertyTypes = new TreeSet();
    TreeSet theDefaults = new TreeSet();


    public ManageClassPropertyDialog(ManageClassDialog dialog, MetaPropertyDescriptor metaProperty, MetaPropertyDescriptor parentProperty) {
        super(dialog, null, true, false);

        this.theDialog = dialog;
        this.theProperty = metaProperty;
        this.theParentProperty = parentProperty;
        createLists(); // this will populate theHelperClasses & theDataTypes
        initDisplay();
        populateDisplay();
    }

    public ManageClassPropertyDialog(ManageClassDialog dialog, MetaPropertyDescriptor metaProperty) {
        this(dialog, metaProperty, null);
    }

    public boolean isDialogModified() {
        return dialogModified;
    }

    private void populateDisplay() {
        propertyName.setText(theProperty.getName());
        propertyClass.selectPropertyClass(theProperty.getClassName());
        propertyGetMethod.setText(theProperty.getGetMethod());
        propertySetMethod.setText(theProperty.getSetMethod());
        propertyConstantGroup.selectConstant(theProperty.getIncludeTypeConstants());
        propertyDefaultValue.selectDefault(theProperty.getDefaultValue());
        propertyVisible.setSelected(theProperty.bVisible);
        propertyArray.setSelected(theProperty.bAllowMultipleValues);
        propertyLanguages.setSelected(theProperty.bAllowMultipleLanguages);
        propertyReadOnly.setSelected(theProperty.isReadOnly());
        propertyHelperClass.selectHelperClass(theProperty.getHelperClass());
    }

    private void updateProperty() {
        theProperty.setName(propertyName.getText());
        theProperty.setClassName((String) propertyClass.getSelectedItem());
        theProperty.setGetMethod(propertyGetMethod.getText());
        theProperty.setSetMethod(propertySetMethod.getText());
        theProperty.setSimpleDefaultValue((String) propertyDefaultValue.getSelectedItem());
        theProperty.bVisible = propertyVisible.isSelected();
        theProperty.bAllowMultipleValues = propertyArray.isSelected();
        theProperty.bAllowMultipleLanguages = propertyLanguages.isSelected();
        theProperty.setReadOnly(propertyReadOnly.isSelected());
        theProperty.setHelperClass((String) propertyHelperClass.getSelectedItem());

        String sConstantGroup = (String) propertyConstantGroup.getSelectedItem();
        if (sConstantGroup.equals("<none>"))
            sConstantGroup = null;
        theProperty.setIncludeTypeConstants(sConstantGroup);
    }

    private void initDisplay() {
        propertyName = new JATextField();
        propertyClass = new PropertyClasses();
        propertyGetMethod = new JATextField();
        propertySetMethod = new JATextField();
        propertyConstantGroup = new ConstantGroups();
        propertyDefaultValue = new Defaults();
        propertyVisible = new JACheckBox("Visible");
        propertyArray = new JACheckBox("Array");
        propertyLanguages = new JACheckBox("languages");
        propertyReadOnly = new JACheckBox("Read-Only");
        propertyHelperClass = new HelperClasses();
        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());

        JAPanel pnlComponents = new JAPanel(new GridBagLayout());
        pnlComponents.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;
        c.insets = new Insets(5,5,5,5);

        c.gridx =0; c.gridy =0; c.gridwidth = 1; c.gridheight = 1;
        c.weightx = 0; c.weighty = 0;
        pnlComponents.add(new JALabel("Property Name"), c);
        c.gridx =1; c.gridy =0; c.gridwidth = 3;
        c.weightx = 1; c.weighty = 0;
        pnlComponents.add(propertyName, c);

        c.gridx =0; c.gridy =1; c.gridwidth = 1;
        c.weightx = 0; c.weighty = 0;
        pnlComponents.add(new JALabel("Property's Class"), c);
        c.gridx =1; c.gridy =1; c.gridwidth = 3;
        c.weightx = 1; c.weighty = 0;
        pnlComponents.add(propertyClass, c);

        c.gridx =0; c.gridy =2; c.gridwidth = 1;
        c.weightx = 0; c.weighty = 0;
        pnlComponents.add(new JALabel("Get Method"), c);
        c.gridx =1; c.gridy =2; c.gridwidth = 3;
        c.weightx = 1; c.weighty = 0;
        pnlComponents.add(propertyGetMethod, c);

        c.gridx =0; c.gridy =3; c.gridwidth = 1;
        c.weightx = 0; c.weighty = 0;
        pnlComponents.add(new JALabel("Set Method"), c);
        c.gridx =1; c.gridy =3; c.gridwidth = 3;
        c.weightx = 1; c.weighty = 0;
        pnlComponents.add(propertySetMethod, c);

        c.gridx =0; c.gridy =4; c.gridwidth = 1;
        c.weightx = 0; c.weighty = 0;
        pnlComponents.add(new JALabel("Constant Group"), c);
        c.gridx =1; c.gridy =4; c.gridwidth = 3;
        c.weightx = 1; c.weighty = 0;
        pnlComponents.add(propertyConstantGroup, c);

        c.gridx =0; c.gridy =5; c.gridwidth = 1;
        c.weightx = 0; c.weighty = 0;
        pnlComponents.add(new JALabel("Default Value"), c);
        c.gridx =1; c.gridy =5; c.gridwidth = 3;
        c.weightx = 1; c.weighty = 0;
        pnlComponents.add(propertyDefaultValue, c);

        c.gridx =1; c.gridy =6; c.gridwidth = 1;
        c.weightx = 0; c.weighty = 0;
        pnlComponents.add(propertyVisible, c);

        c.gridy =7;
        pnlComponents.add(propertyArray, c);

        c.gridy =8;
        pnlComponents.add(propertyLanguages, c);

        c.gridy =9;
        pnlComponents.add(propertyReadOnly, c);

        c.gridx =0; c.gridy =10;
        pnlComponents.add(new JALabel("Helper Class"), c);
        c.gridx =1; c.gridy =10; c.gridwidth = 3;
        c.weightx = 1;
        pnlComponents.add(propertyHelperClass, c);


        JAPanel pnlDialogButtons = new JAPanel(new FlowLayout(FlowLayout.RIGHT, 5, 5));
        pnlDialogButtons.setBorder(BorderFactory.createTitledBorder(""));
        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");

        btnOK.addActionListener(new OkAction(this));
        btnCancel.addActionListener(new CancelAction(this));

        pnlDialogButtons.add(btnOK);
        pnlDialogButtons.add(btnCancel);
        pane.add(pnlComponents, BorderLayout.NORTH);
        pane.add(pnlDialogButtons, BorderLayout.SOUTH);

        //setSize(600, 350);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                CancelAction cancelAction = new CancelAction(ManageClassPropertyDialog.this);
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });

        String sTitle;
        if (theProperty.getName() == null) {
            if (theParentProperty != null)
                sTitle = "Create new Subproperty";
            else
                sTitle = "Create new Property";
        } else
            sTitle = "Edit the \"" + theProperty.getName() + "\" Property";
        setTitle(sTitle);
    }

    private void createLists() {
        ArrayList classes = new ArrayList();
        MetaClass firstClass = theDialog.theEditor.theMetadataDispenser.getFirstClass();
        enumerateClasses(firstClass, classes);
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            MetaClass metaClass = (MetaClass) iterator.next();
            // get the Helper for each property
            MetaPropertyDescriptor property = metaClass.getMetadata().theFirstProperty;
            while (property != null) {
                String sHelperClass = property.getHelperClass();
                if (sHelperClass != null && !sHelperClass.equals(""))
                    theHelperClasses.add(sHelperClass);

                String sDataType = property.getClassName();
                if (sDataType != null)
                    thePropertyTypes.add(sDataType);

                String sDefault = property.getDefaultValue();
                if (sDefault != null)
                    theDefaults.add(sDefault);

                property = property.getNextProperty();
            }

        }
    }

    void enumerateClasses(MetaClass theFirstClass, ArrayList classes) {
        MetaClass currClass = theFirstClass;
        while (currClass != null) {
            classes.add(currClass);
            if (currClass.getFirstClass() != null)
                enumerateClasses(currClass.getFirstClass(), classes);
            currClass = currClass.getNextSibling();
        }
    }

    class CancelAction implements ActionListener {
        private final ManageClassPropertyDialog dialog;

        public CancelAction(ManageClassPropertyDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (dialog.dialogModified == true) {
                Object sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = JOptionPane.YES_NO_OPTION;
                int messageType = JOptionPane.QUESTION_MESSAGE;
                int iChoice = JOptionPane.showConfirmDialog(dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == JOptionPane.YES_OPTION) {
                    dialog.dialogModified = false;
                    dialog.hide();
                }
            } else
                hide();
        }
    }


    class OkAction implements ActionListener {
        private final ManageClassPropertyDialog dialog;

        public OkAction(ManageClassPropertyDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            //if (dialogModified == true)
            dialogModified = true;
            dialog.updateProperty();
            //dialog.dialog.setMetadataModified(true);
            //else
            //    return; // nothing to save!


            dialog.hide();

        }
    }

    class ConstantGroups extends JAComboBox {
        public ConstantGroups() {
            Object[] groups = getConstantGroups();
            setModel(new DefaultComboBoxModel(groups));
        }

        /**
         * Returns a list of groups. This is comprised of Groups & Collections
         *
         * @return the groups that a user can select from (or "<none>", if no group is required)
         */
        Object[] getConstantGroups() {
            ArrayList groups = new ArrayList();

            groups.add("<none>");

            MetaConstantGroupCollection collection;
            collection = theDialog.theEditor.theMetadataDispenser.getFirstMetaConstantGroupCollection();
            while (collection != null) {
                groups.add(collection.sClassName);
                collection = collection.theNextSibling;
            }

            MetaConstantGroup group;
            group = theDialog.theEditor.theMetadataDispenser.getFirstMetaConstantGroup();
            while (group != null) {
                groups.add(group.sClassName);
                group = group.theNextSibling;
            }

            return groups.toArray();

        }

        public void selectConstant(String sConstant) {
            if (sConstant == null || sConstant.equals(""))
                sConstant = "<none>";
            setSelectedItem(sConstant);
        }

        private boolean isGroupSelected() {
            return (getSelectedItem() != "<none>");
        }

        Object[] getConstants() {
            if (isGroupSelected()) {
                String selectedItem = (String) getSelectedItem();
                MetaConstantGroupCollection collection = theDialog.theEditor.theMetadataDispenser.findConstantGroupCollection(selectedItem);
                if (collection != null) {
                    return collection.getConstantList().toArray();
                } else {
                    MetaConstantGroup group = theDialog.theEditor.theMetadataDispenser.findConstantGroup(selectedItem);
                    return group.getConstantList().toArray();
                }
            }
            return null;
        }

    }

    class PropertyClasses extends JAComboBox {
        public PropertyClasses() {
            super(thePropertyTypes.toArray());
            setEditable(true);
        }

        public void selectPropertyClass(String sClass) {
            setSelectedItem(sClass);
        }
    }

    class HelperClasses extends JAComboBox {
        public HelperClasses() {
            super(theHelperClasses.toArray());
            setEditable(true);
        }

        public void selectHelperClass(String sClass) {
            setSelectedItem(sClass);
        }
    }

    class Defaults extends JAComboBox {
        public Defaults() {
            setEditable(true);
            addPopupMenuListener(new PopupMenuListener() {
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Object selection = getSelectedItem(); // preserve selection, so we can restore it after the model is set
                    setAppropriateModel();
                    setSelectedItem(selection); // restore the original selection
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

            });
        }

        /**
         * if a Constant Group is set, then show the constants in that group
         * else, show al other defaults used by other properties
         */
        void setAppropriateModel() {
            Object[] constants = propertyConstantGroup.getConstants();
            if (constants != null) {
                setModel(new DefaultComboBoxModel(constants));
            } else {
                setModel(new DefaultComboBoxModel(theDefaults.toArray()));
            }
        }

        public void selectDefault(String sDefault) {
            setSelectedItem(sDefault);
        }

    }


}

