/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;

import javax.swing.BorderFactory;
import javax.swing.*;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Mar 30, 2004
 * Time: 4:51:34 PM
 * To change this template use Options | File Templates.
 */
public class MetadataEditorPageClasses extends JAPanel {
    final MetadataEditor editor;
    JATree treClasses = null;
    JATable tblDetails;
    JATable tblProperties;
    JATextArea txtComments = null;
    TableModel tableModel = null;


    DefaultTreeModel theTreeModel;
    IDEComponentPaletteNode baseClass = null;

    public MetadataEditorPageClasses (MetadataEditor editor) {
        super();
        this.editor = editor;
        initInterface();
        populateInterface();
    }

    boolean loadClass (MetaClass theFirstClass, IDEComponentPaletteNode thisNode) {
        // A node in the treeview for every class in the heirarchy.
        MetaClass currClass = theFirstClass;
        while (currClass != null) {
            IDEComponentPaletteNode theNewNode = new IDEComponentPaletteNode(currClass);
            if (thisNode == null)
                theTreeModel.insertNodeInto(theNewNode, baseClass,
                        baseClass.getChildCount());
            else
                theTreeModel.insertNodeInto(theNewNode, thisNode,
                        thisNode.getChildCount());
            if (currClass.getFirstClass() != null)
                loadClass(currClass.getFirstClass(), theNewNode);
            currClass = currClass.getNextSibling();
        }
        return true;
    }


    private void populateInterface () {
        //treClasses.removeAll();
        MetaClass theFirstClass = editor.theMetadataDispenser.getFirstClass();

        baseClass = new IDEComponentPaletteNode(theFirstClass);
        theTreeModel = new DefaultTreeModel(baseClass);
        treClasses.setModel(theTreeModel);

        loadClass(theFirstClass.getFirstClass(), baseClass);
        treClasses.expandRow(0); // start off with just the first level expanded
        treClasses.setSelectionRow(0);
        IDEComponentPaletteNode node = (IDEComponentPaletteNode) treClasses.getLastSelectedPathComponent();
        if (node != null) showClassAttributes(node.getMetaClass());

    }

    private void initInterface () {
        setLayout(new BorderLayout());

//        MetaClass theFirstClass = editor.theMetadataDispenser.getFirstClass();
//
//        baseClass = new IDEComponentPaletteNode(theFirstClass);
//        theTreeModel = new DefaultTreeModel(baseClass);

        JAPanel pnlClass = new JAPanel(new BorderLayout());
        JAPanel pnlNonVisibleClass = new JAPanel(new BorderLayout());
        treClasses = new JATree();

        JASplitPane splitPane;
        JAPanel pnlClasses = new JAPanel(new BorderLayout());
        JAPanel pnlClassAttributes = new JAPanel(new BorderLayout());
        pnlClasses.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        pnlClassAttributes.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));

        splitPane = new JASplitPane(JSplitPane.HORIZONTAL_SPLIT, pnlClasses, pnlClassAttributes);
        splitPane.setDividerLocation(200);

        JAPanel grpDetails = new JAPanel();
        grpDetails.setBorder(BorderFactory.createTitledBorder("Details"));
        grpDetails.setLayout(new GridLayout(1, 1, 10, 10));
        tblDetails = new JATable(12, 2);
        tblDetails.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        grpDetails.add(tblDetails);
        tblDetails.setTableHeader(null);

        JAPanel grpComments = new JAPanel();
        grpComments.setBorder(BorderFactory.createTitledBorder("Comments"));
        grpComments.setLayout(new GridLayout(1, 1, 10, 10));
        txtComments = new JATextArea(5, 30);
        grpComments.add(new JAScrollPane(txtComments));

        pnlNonVisibleClass.add(grpDetails, BorderLayout.NORTH);
        pnlNonVisibleClass.add(grpComments, BorderLayout.SOUTH);

        pnlClass.add(pnlNonVisibleClass, BorderLayout.NORTH);

        JAPanel grpProperties = new JAPanel();
        grpProperties.setBorder(BorderFactory.createTitledBorder("Properties"));
        grpProperties.setLayout(new GridLayout(1, 1, 10, 10));
        tblProperties = new JATable();
        tblProperties.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        grpProperties.add(new JScrollPane(tblProperties));
        pnlClass.add(grpProperties, BorderLayout.CENTER);

        //Provide minimum sizes for the two components in the split pane
        Dimension minimumSize = new Dimension(100, 50);
        pnlClasses.setMinimumSize(minimumSize);
        pnlClassAttributes.setMinimumSize(minimumSize);

        JALabel lblClasses = new JALabel("Classes");
        pnlClasses.add(lblClasses, BorderLayout.NORTH);
        pnlClasses.add(new JScrollPane(treClasses), BorderLayout.CENTER);

        JAPanel pnlButtonsClass = new JAPanel(new FlowLayout(FlowLayout.LEFT, 0, 5));
        JAButton btnModifyClasses = new JAButton("Modify Classes");
        btnModifyClasses.addActionListener(new ModifyClassesAction(this));
        pnlButtonsClass.add(btnModifyClasses);
        pnlClasses.add(pnlButtonsClass, BorderLayout.SOUTH);

        JALabel lblClassAttribytes = new JALabel("Class Attributes");
        pnlClassAttributes.add(lblClassAttribytes, BorderLayout.NORTH);
        pnlClassAttributes.add(pnlClass, BorderLayout.CENTER);

        JAPanel pnlButtons = new JAPanel(new FlowLayout(FlowLayout.LEFT, 0, 5));
        JAButton btnModifyClass = new JAButton("Modify Class");
        btnModifyClass.addActionListener(new ModifyClassAction(this));
        pnlButtons.add(btnModifyClass);
        pnlClassAttributes.add(pnlButtons, BorderLayout.SOUTH);

        this.add(splitPane);

        // assign listeners...
        treClasses.addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged (TreeSelectionEvent e) {
                IDEComponentPaletteNode node = (IDEComponentPaletteNode) treClasses.getLastSelectedPathComponent();

                if (node != null) showClassAttributes(node.getMetaClass());
            }
        });
    }

    private void showClassAttributes (MetaClass metaClass) {

        tblDetails.setValueAt("Full Classname", 0, 0);
        tblDetails.setValueAt(metaClass.getMetadata().sFullClassName, 0, 1);

        tblDetails.setValueAt("Superclass Name", 1, 0);
        tblDetails.setValueAt(metaClass.getMetadata().getSuperClassName(), 1, 1);

        tblDetails.setValueAt("Superclass FullPath", 2, 0);
        tblDetails.setValueAt(metaClass.getMetadata().getFullPathOfSuperClass(), 2, 1);

        tblDetails.setValueAt("Display", 3, 0);
        tblDetails.setValueAt(metaClass.getMetadata().sDisplayClass, 3, 1);

        tblDetails.setValueAt("Hidden", 4, 0);
        tblDetails.setValueAt(new Boolean(metaClass.getMetadata().bHidden), 4, 1);

        tblDetails.setValueAt("SkipDeclarations", 5, 0);
        tblDetails.setValueAt(new Boolean(metaClass.getMetadata().bSkipDecl), 5, 1);

        tblDetails.setValueAt("Design Borders", 6, 0);
        tblDetails.setValueAt(new Boolean(metaClass.getMetadata().bDesignBorders), 6, 1);

        tblDetails.setValueAt("Skip Default Listeners", 7, 0);
        tblDetails.setValueAt(new Boolean(metaClass.getMetadata().bDefaultListeners), 7, 1);

        tblDetails.setValueAt("Container Type", 8, 0);
        tblDetails.setValueAt(metaClass.getMetadata().containerType.getContainerTypeAsString(), 8, 1);

        tblDetails.setValueAt("Custom", 9, 0);
        tblDetails.setValueAt(metaClass.getMetadata().sCustomCodeGenerationMethod, 9, 1);

        tblDetails.setValueAt("Class Factory", 10, 0);
        tblDetails.setValueAt(metaClass.getMetadata().theFactoryName, 10, 1);

        tblDetails.setValueAt("Design Editor", 11, 0);
        tblDetails.setValueAt(metaClass.getMetadata().theDesignEditor, 11, 1);

        tblDetails.setEnabled(false);

        txtComments.setText(metaClass.getMetadata().sClassComment);
        txtComments.setCaretPosition(0);
        txtComments.setEditable(false);
        txtComments.setLineWrap(true);
        txtComments.setWrapStyleWord(true);

        tableModel = new TableModel(metaClass.getMetadata());
        tblProperties.setModel(tableModel);
        tblProperties.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
    }

    class TableModel extends AbstractTableModel {
        private MetaClassDetail theClass;
        private int rowCount;

        public TableModel (MetaClassDetail theClass) {
            this.theClass = theClass;
            rowCount = theClass.iNumberOfProperties;
        }

        public String getColumnName (int column) {
            switch (column) {
                case 0:
                    return "Name";
                case 1:
                    return "Type";
                default:
                    return "Default";
            }
        }


        /**
         * Returns the number of rows in the model. A
         * <code>JTable</code> uses this method to determine how many rows it
         * should display.  This method should be quick, as it
         * is called frequently during rendering.
         *
         * @return the number of rows in the model
         * @see #getColumnCount
         */
        public int getRowCount () {
            return rowCount;
        }

        /**
         * Returns the number of columns in the model. A
         * <code>JTable</code> uses this method to determine how many columns it
         * should create and display by default.
         *
         * @return the number of columns in the model
         * @see #getRowCount
         */
        public int getColumnCount () {
            return 3;
        }

        /**
         * Returns the value for the cell at <code>columnIndex</code> and
         * <code>rowIndex</code>.
         *
         * @param	rowIndex	the row whose value is to be queried
         * @param	columnIndex 	the column whose value is to be queried
         * @return	the value Object at the specified cell
         */
        public Object getValueAt (int rowIndex, int columnIndex) {
            // this is very inefficient !
            MetaPropertyDescriptor theProperty = theClass.theFirstProperty;

            for (int i = 0; i < rowIndex; i++)
                theProperty = theProperty.getNextProperty();

            switch (columnIndex) {
                case 0:
                    return theProperty.getName();
                case 1:
                    return theProperty.getClassName();
                default:
                    return theProperty.getDefaultValue();
            }
        }

    }

    class ModifyClassesAction implements ActionListener {
        private MetadataEditorPageClasses page;

        public ModifyClassesAction (MetadataEditorPageClasses page) {
            this.page = page;
        }

        public void actionPerformed (ActionEvent e) {
            IDEComponentPaletteNode node = (IDEComponentPaletteNode) treClasses.getLastSelectedPathComponent();
            MetaClass metaClass = node.getMetaClass();

            ManageClassesDialog dialog = new ManageClassesDialog(page, metaClass);
            dialog.show(new Runnable() {
                public void run () {
                    populateInterface();
                }
            });
        }

    }

    class ModifyClassAction implements ActionListener {
        private MetadataEditorPageClasses page;

        public ModifyClassAction (MetadataEditorPageClasses page) {
            this.page = page;
        }

        public void actionPerformed (ActionEvent e) {
            final IDEComponentPaletteNode node = (IDEComponentPaletteNode) treClasses.getLastSelectedPathComponent();
            if (node == null) return;
            final MetaClass metaClass = node.getMetaClass();

            final ManageClassDialog dialog = new ManageClassDialog(page.editor, metaClass);
            dialog.show(new Runnable() {
                public void run () {
                    if (dialog.isDialogModified()) {
                        showClassAttributes(metaClass);

                    }
                }
            });
        }

    }

}
