/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;

import javax.swing.BorderFactory;
import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class MetadataEditorPageConstantCollections extends JAPanel {
    final MetadataEditor editor;
    JAList lstCollections = new JAList();
    JAList lstGroups = new JAList();
    ListSelectionListener selectionListener = new SelectionListener();
    ArrayList collections = new ArrayList();
    JAButton btnModifyCollections = new JAButton("Modify Collections");
    String[] groups = null;

    public MetadataEditorPageConstantCollections (MetadataEditor editor) {
        super();
        this.editor = editor;
        initDisplay();
        populateDisplay();
    }

    public void populateDisplay () {
        MetaConstantGroupCollection collection;
        collections.clear();

        collection = editor.theMetadataDispenser.getFirstMetaConstantGroupCollection();
        while (collection != null) {
            collections.add(collection.sClassName);
            collection = collection.theNextSibling;
        }
        lstCollections.setListData(collections.toArray());

        if (collections.size() != 0)
            lstCollections.setSelectedIndex(0);

    }

    void initDisplay () {
        //this.setLocation(0,0);
        //this.setSize(400,400);
        setLayout(new BorderLayout());
        //setBorder(BorderFactory.createEtchedBorder());

        JASplitPane splitPane;
        JAPanel pnlCollections = new JAPanel(new BorderLayout());
        JAPanel pnlGroupsInCollection = new JAPanel(new BorderLayout());
        pnlCollections.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        pnlGroupsInCollection.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));


        splitPane = new JASplitPane(JSplitPane.HORIZONTAL_SPLIT, pnlCollections, pnlGroupsInCollection);
//splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(200);

        //Provide minimum sizes for the two components in the split pane
        Dimension minimumSize = new Dimension(100, 50);
        pnlCollections.setMinimumSize(minimumSize);
        pnlGroupsInCollection.setMinimumSize(minimumSize);


        JALabel lblCollections = new JALabel("Collections");
        pnlCollections.add(lblCollections, BorderLayout.NORTH);
        pnlCollections.add(new JScrollPane(lstCollections), BorderLayout.CENTER);
        JAPanel pnlModifyCollections = new JAPanel(new FlowLayout(FlowLayout.LEFT, 0, 5));
        pnlModifyCollections.add(btnModifyCollections);
        pnlCollections.add(pnlModifyCollections, BorderLayout.SOUTH);

        JALabel lblGroups = new JALabel("Groups in Collection");
        pnlGroupsInCollection.add(lblGroups, BorderLayout.NORTH);
        pnlGroupsInCollection.add(new JAScrollPane(lstGroups), BorderLayout.CENTER);
        JAButton btnModifyConstants = new JAButton("Modify Groups");
        JAPanel pnlModifyConstants = new JAPanel(new FlowLayout(FlowLayout.LEFT, 0, 5));
        pnlModifyConstants.add(btnModifyConstants);
        pnlGroupsInCollection.add(pnlModifyConstants, BorderLayout.SOUTH);

        this.add(splitPane);

        // assign listeners...
        lstCollections.addListSelectionListener(selectionListener);
        btnModifyCollections.addActionListener(new ModifyCollectionsAction(this));
        btnModifyConstants.addActionListener(new ModifyGroupsInCollectionAction(this));

    }

    void showGroupsOfTheCollection (String sCollection) {
        //System.out.println(sCollection);
        // find the real collection...
        MetaConstantGroupCollection collection = this.editor.theMetadataDispenser.findConstantGroupCollection(sCollection);
        if (collection != null) {
            //String[]
            groups = new String[collection.getGroupCount()];
            for (int i = 0; i < collection.getGroupCount(); i++) {
                groups[i] = collection.getGroup(i).sClassName;
            }
            lstGroups.setListData(groups);
        } else {
            lstGroups.setListData(new String[0]);
        }
    }

    class SelectionListener implements ListSelectionListener {
        /**
         * Called whenever the value of the selection changes.
         * @param e the event that characterizes the change.
         */
        public void valueChanged (ListSelectionEvent e) {
            showGroupsOfTheCollection((String) lstCollections.getSelectedValue());
        }

    }

    class ModifyCollectionsAction implements ActionListener {
        private final MetadataEditorPageConstantCollections pageCollections;

        public ModifyCollectionsAction (MetadataEditorPageConstantCollections pageCollections) {
            this.pageCollections = pageCollections;
        }

        public void actionPerformed (ActionEvent e) {
            ManageConstantCollectionsDialog dialog = new ManageConstantCollectionsDialog(pageCollections, "Manage Constant-Group Collections", "Collections");
            dialog.show();
            populateDisplay();
        }
    }


    class ModifyGroupsInCollectionAction implements ActionListener {
        private MetadataEditorPageConstantCollections page;

        public ModifyGroupsInCollectionAction (MetadataEditorPageConstantCollections page) {
            this.page = page;
        }

        public void actionPerformed (ActionEvent e) {
           MetaConstantGroupCollection collection = page.editor.theMetadataDispenser.findConstantGroupCollection((String) page.lstCollections.getSelectedValue());
           ManageCollectionGroupsDialog dialog = new ManageCollectionGroupsDialog(page, collection, "Manage Groups in Collection", "Select Groups" ) ;
           dialog.show();
           populateDisplay();
        }

    }

}


