/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ui;

import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.jdbc.JSSDataSource;
import ch.abacus.lib.ui.renderer.common.MetaObjectAccess;
import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * Created by IntelliJ IDEA.
 * User: Mario
 * Date: Oct 1, 2004
 * Time: 5:01:02 PM
 * To change this template use File | Settings | File Templates.
 */

public class JODbButtonBar extends JComponent implements ActionListener
 {
    private JAButton JInsert;
    private JAButton JForward;
    private JAButton JPrevious;
    private JAButton JDelete;
    private JAButton JUpdate;
    private JAButton JClear;
    private JODbButtonBar parent = null;

    private JSSDataSource currentDataSet = null;
    private ButtonbarListener buttonbarListener = null;
    private ArrayList buttonlisternerList = new ArrayList();

    Container contentPane;

    public JODbButtonBar()
    {
        //AnchoringLayoutManager lmRenderingObject = new AnchoringLayoutManager();
        //setLayout(lmRenderingObject);

        JForward = new JAButton();
        JPrevious = new JAButton();
        JClear = new JAButton();
        JUpdate = new JAButton();
        JInsert = new JAButton();
        JDelete = new JAButton();

        // Spacing is 112
        JPrevious.setLocation(5,5);
        JPrevious.setSize(88,32);
        JPrevious.setToolTipText("Previous");

        JForward.setLocation(103,5);
        JForward.setSize(88,32);
        JPrevious.setToolTipText("Next");

        JClear.setLocation(201,5);
        JClear.setSize(88,32);
        JClear.setToolTipText("Clear");

        JInsert.setLocation(302,5);
        JInsert.setSize(88,32);
        JInsert.setToolTipText("Insert");

        JUpdate.setLocation(403,5);
        JUpdate.setSize(88,32);
        JUpdate.setToolTipText("Update");

        JDelete.setLocation(504,5);
        JDelete.setSize(88,32);
        JDelete.setToolTipText("Delete");

        setButtonImages();
        addHandlers();
        addButtons();
        parent = this;
    }

    public void setDataSource(JSSDataSource ds)
    {
            currentDataSet = ds;
    }

    public JSSDataSource getDataSource()
    {
            return currentDataSet;
    }

    private void addButtons()
    {
        this.add(JPrevious,"Previous");
        this.add(JForward,"Forward");
        this.add(JClear,"Clear");
        this.add(JInsert,"Insert");
        this.add(JUpdate,"Update");
        this.add(JDelete,"Delete");
    }

    private void addHandlers()
    {
         JInsert.addActionListener(new JInsertButton$$$ActionListener());
         JClear.addActionListener(new JClearButton$$$ActionListener());
         JForward.addActionListener(new JForwardButton$$$ActionListener());
         JPrevious.addActionListener(new JPreviousButton$$$ActionListener());
         JUpdate.addActionListener(new JUpdateButton$$$ActionListener());
         JDelete.addActionListener(new JDeleteButton$$$ActionListener());
    }

    private void setButtonImages()
    {
        JInsert.setImageIcon("/ch/abacus/lib/images/add.png");
        JForward.setImageIcon("ch/abacus/lib/images/designcockpit/glp_next.png");
        JPrevious.setImageIcon("ch/abacus/lib/images/designcockpit/glp_prior.png");
        JDelete.setImageIcon("ch/abacus/lib/images/remove.png");
        JUpdate.setImageIcon("ch/abacus/lib/images/exchange.png");
        JClear.setImageIcon("ch/abacus/lib/images/selection.png");
    }

    public void addActionListener(ActionListener l)
    {
        buttonlisternerList.add(l);
    }

    private void sendActionPerfomed(ActionEvent eventParam)
    {
        for (int i = 0; i < buttonlisternerList.size(); i++) {
            ActionListener actionButtonbarListener = (ActionListener)buttonlisternerList.get(i);
            actionButtonbarListener.actionPerformed(eventParam);
        }
    }

    public void removeActionListener(ActionListener l)
    {
	    if (l != null)
        {
            listenerList.remove(ActionListener.class, l);
            buttonlisternerList.remove(ActionListener.class);
        }
    }

    public void actionPerformed(ActionEvent e)
    {
    //do nothing if no listeners are registered

        if (buttonlisternerList.size()==0)
                return;

        if (e.getSource() == JForward)
        {
            ActionEvent w = new ActionEvent(e.getSource(),ActionEvent.ACTION_PERFORMED,"Forward");
            sendActionPerfomed(w);
        }
        else if (e.getSource() == JPrevious)
        {
            ActionEvent w = new ActionEvent(e.getSource(),ActionEvent.ACTION_PERFORMED,"Previous");
            sendActionPerfomed(w);
        }
        else if (e.getSource() == JClear)
        {
            ActionEvent w = new ActionEvent(e.getSource(),ActionEvent.ACTION_PERFORMED,"Clear");
            sendActionPerfomed(w);
        }
        else if (e.getSource() == JUpdate)
        {
            ActionEvent w = new ActionEvent(e.getSource(),ActionEvent.ACTION_PERFORMED,"Update");
            sendActionPerfomed(w);
        }
        else if (e.getSource() == JDelete)
        {
            ActionEvent w = new ActionEvent(e.getSource(),ActionEvent.ACTION_PERFORMED,"Delete");
            sendActionPerfomed(w);
        }
        else if (e.getSource() == JInsert)
        {
            ActionEvent w = new ActionEvent(e.getSource(),ActionEvent.ACTION_PERFORMED,"Insert");
            sendActionPerfomed(w);
        }
    }

    public synchronized void addButtonbarListener(ButtonbarListener l) {
        buttonbarListener = ButtonbarEventMulticaster.add(buttonbarListener, l);
    }
    public synchronized void removeButtonbarListener(ButtonbarListener l) {
        buttonbarListener = ButtonbarEventMulticaster.remove(buttonbarListener, l);
    }
    /* Internal Listeners */

    class JInsertButton$$$ActionListener implements ActionListener  {
      public void actionPerformed(java.awt.event.ActionEvent p0) {
        currentDataSet.insert();
        parent.actionPerformed(p0);
      }
    }

    class JClearButton$$$ActionListener implements ActionListener  {
      public void actionPerformed(java.awt.event.ActionEvent p0) {
        currentDataSet.clear();
        parent.actionPerformed(p0);
      }
    }

    class JForwardButton$$$ActionListener implements ActionListener  {
      public void actionPerformed(java.awt.event.ActionEvent p0) {
        currentDataSet.next();
        parent.actionPerformed(p0);
      }
    }

    class JPreviousButton$$$ActionListener implements ActionListener  {
      public void actionPerformed(java.awt.event.ActionEvent p0) {
        currentDataSet.previous();
        parent.actionPerformed(p0);
      }
    }

    class JUpdateButton$$$ActionListener implements ActionListener  {
      public void actionPerformed(java.awt.event.ActionEvent p0) {
        currentDataSet.update();
        parent.actionPerformed(p0);
      }
    }

    class JDeleteButton$$$ActionListener implements ActionListener  {
      public void actionPerformed(java.awt.event.ActionEvent p0) {
        currentDataSet.delete();
        parent.actionPerformed(p0);
      }
    }

}
