/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql.reveng;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.argouml.kernel.ProjectManager;
import org.argouml.language.sql.TableDefinition;
import org.argouml.language.sql.reveng.ModellerC;
import org.argouml.language.sql.reveng.ModellerLevel;
import org.argouml.language.sql.reveng.ModellerP;
import org.argouml.model.Model;
import org.argouml.profile.Profile;

public class Modeller {
    public static final int ASSOCIATION = 1;
    public static final int GENERALIZATION = 2;
    public static final String ASSOCIATION_1 = "1";
    public static final String ASSOCIATION_01 = "0..1";
    private Object model;
    private String fileName;
    private Collection<Object> newElements;
    private String settingLevel;
    private Map<String, TableDefinition> tablesByName;

    public Modeller(Object theModel, Profile theSqlProfile, String theFileName) {
        this.model = theModel;
        this.newElements = new HashSet<Object>();
        this.fileName = theFileName;
        this.tablesByName = new HashMap<String, TableDefinition>();
    }

    public String getMappingDataTypeSQLToUML(String typeSQL) {
        String typeUML = "String";
        if (typeSQL.toLowerCase().indexOf("char") > 0) {
            typeUML = "String";
        } else if (typeSQL.toLowerCase().indexOf("int") > 0) {
            typeUML = "Integer";
        } else if (typeSQL.toLowerCase().indexOf("Boolean") > 0) {
            typeUML = "Boolean";
        } else if (typeSQL.toLowerCase().indexOf("text") > 0) {
            typeUML = "String";
        }
        return typeUML;
    }

    public Collection<Object> getNewElements() {
        return this.newElements;
    }

    public void generateModele() {
        ModellerLevel generation = null;
        generation = this.settingLevel.equals("MCD") ? new ModellerC(this) : new ModellerP(this);
        generation.genereInModele();
    }

    public Object getAssociationEnd(String name, Object mClassifier, Object mClassifierEnd) {
        Object mAssociationEnd = null;
        for (Object ae : Model.getFacade().getAssociationEnds(mClassifier)) {
            Object assoc = Model.getFacade().getAssociation(ae);
            if (!name.equals(Model.getFacade().getName(ae)) || Model.getFacade().getConnections(assoc).size() != 2 || Model.getFacade().getType(Model.getFacade().getNextEnd(ae)) != mClassifierEnd) continue;
            mAssociationEnd = ae;
        }
        if (mAssociationEnd == null) {
            Object mAssociation = Modeller.buildDirectedAssociation(name, mClassifierEnd, mClassifier);
            mAssociationEnd = Model.getFacade().getAssociationEnd(mClassifier, mAssociation);
        }
        return mAssociationEnd;
    }

    public static Object buildDirectedAssociation(String name, Object sourceClassifier, Object destClassifier) {
        return Model.getCoreFactory().buildAssociation(destClassifier, true, sourceClassifier, false, name);
    }

    public void addTable(TableDefinition table) {
        this.tablesByName.put(table.getName(), table);
    }

    public TableDefinition getTableFromName(String nameTable) {
        TableDefinition ret = this.tablesByName.get(nameTable);
        if (ret == null) {
            ret = new TableDefinition();
            ret.setName(nameTable);
            this.addTable(ret);
        }
        return ret;
    }

    public Map<String, TableDefinition> getTablesByName() {
        return this.tablesByName;
    }

    public Object addClass(TableDefinition table) {
        Object mClass = this.addClassifier(Model.getCoreFactory().createClass(), table.getName(), table.getComment(), null);
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Model.getCoreHelper().setRoot(mClass, false);
        }
        this.newElements.add(mClass);
        return mClass;
    }

    public Object getOrAddDatatype(Object packageOfType, String typeSpec) {
        Object mClassifierType = Model.getFacade().lookupIn(packageOfType, typeSpec);
        if (mClassifierType == null) {
            mClassifierType = Model.getCoreFactory().buildDataType(typeSpec, packageOfType);
            this.newElements.add(mClassifierType);
        }
        return mClassifierType;
    }

    private Object addClassifier(Object newClassifier, String name, String documentation, List<String> typeParameters) {
        Object currentPackage = this.model;
        Object mClassifier = Model.getFacade().lookupIn(currentPackage, name);
        Object mNamespace = currentPackage;
        if (mClassifier == null) {
            mClassifier = newClassifier;
            Model.getCoreHelper().setName(mClassifier, name);
            Model.getCoreHelper().setNamespace(mClassifier, mNamespace);
            this.newElements.add(mClassifier);
        }
        this.addDocumentationTag(mClassifier, documentation);
        return mClassifier;
    }

    private void addDocumentationTag(Object modelElement, String sDocumentation) {
        if (sDocumentation != null && sDocumentation.trim().length() >= 1) {
            String[] docs = new String[]{sDocumentation};
            this.buildTaggedValue(modelElement, "documentation", docs);
            this.addStereotypes(modelElement);
        }
    }

    private void buildTaggedValue(Object me, String sTagName, String[] sTagData) {
        Object tv = Model.getFacade().getTaggedValue(me, sTagName);
        if (tv == null) {
            Model.getExtensionMechanismsHelper().addTaggedValue(me, Model.getExtensionMechanismsFactory().buildTaggedValue(sTagName, sTagData[0]));
        } else {
            Model.getExtensionMechanismsHelper().setDataValues(tv, sTagData);
        }
    }

    private void addStereotypes(Object modelElement) {
        Object tv;
        if (Model.getFacade().getUmlVersion().charAt(0) == '1' && (tv = Model.getFacade().getTaggedValue(modelElement, "stereotype")) != null) {
            String stereo = Model.getFacade().getValueOfTag(tv);
            if (stereo != null && stereo.length() > 0) {
                StringTokenizer st = new StringTokenizer(stereo, ", ");
                while (st.hasMoreTokens()) {
                    Model.getCoreHelper().addStereotype(modelElement, this.getUML1Stereotype(st.nextToken().trim()));
                }
                ProjectManager.getManager().updateRoots();
            }
            Model.getUmlFactory().delete(tv);
        }
    }

    private Object getUML1Stereotype(String name) {
        Object stereotype = Model.getFacade().lookupIn(this.model, name);
        if (stereotype == null) {
            return Model.getExtensionMechanismsFactory().buildStereotype(name, this.model);
        }
        if (!Model.getFacade().isAStereotype(stereotype)) {
            return Model.getExtensionMechanismsFactory().buildStereotype(name, this.model);
        }
        return stereotype;
    }

    public Object buildAttribute(Object classifier, Object type, String name) {
        Object mAttribute = Model.getCoreFactory().buildAttribute2(classifier, type);
        this.newElements.add(mAttribute);
        Model.getCoreHelper().setName(mAttribute, name);
        return mAttribute;
    }

    public void setLevel(String level) {
        this.settingLevel = level;
    }

    public Object getGeneralization(Object mPackage, Object parent, Object child) {
        Object mGeneralization = Model.getFacade().getGeneralization(child, parent);
        if (mGeneralization == null) {
            mGeneralization = Model.getCoreFactory().buildGeneralization(child, parent);
            this.newElements.add(mGeneralization);
        }
        if (mGeneralization != null) {
            Model.getCoreHelper().setNamespace(mGeneralization, mPackage);
        }
        return mGeneralization;
    }

    public Object getModel() {
        return this.model;
    }
}

