/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.argouml.configuration.Configuration;
import org.argouml.configuration.ConfigurationKey;
import org.argouml.i18n.Translator;
import org.argouml.uml.reveng.Setting;
import org.argouml.uml.reveng.SettingsTypes;

public class SqlImportSettings {
    private static final ConfigurationKey KEY_IMPORT_EXTENDED_SGBD_NAME = Configuration.makeKey((String)"import", (String)"extended", (String)"sql", (String)"sgbd", (String)"name");
    private static final ConfigurationKey KEY_IMPORT_EXTENDED_MODELE_LEVEL = Configuration.makeKey((String)"import", (String)"extended", (String)"sql", (String)"model", (String)"level");
    private static final String DEFAULT_SGBD = "MySql";
    public static final String LEVEL_MCD = "MCD";
    public static final String LEVEL_MPD = "MPD";
    private static SqlImportSettings theInstance;
    private List<SettingsTypes.Setting> settingsList;
    private SettingsTypes.UniqueSelection sgbdSetting;
    private SettingsTypes.UniqueSelection levelSetting;

    public static synchronized SqlImportSettings getInstance() {
        if (theInstance == null) {
            theInstance = new SqlImportSettings();
        }
        return theInstance;
    }

    private SqlImportSettings() {
    }

    private Map<String, String> createListSupportedDump() {
        HashMap<String, String> listSupportedDump = new HashMap<String, String>();
        this.addLabelFromParserName(listSupportedDump, DEFAULT_SGBD);
        this.addLabelFromParserName(listSupportedDump, "SqlServer");
        return listSupportedDump;
    }

    private void addLabelFromParserName(Map<String, String> lst, String parserName) {
        String label = Translator.localize((String)("argouml-sql.import.database." + parserName));
        lst.put(parserName, label);
    }

    public List<SettingsTypes.Setting> getImportSettings() {
        if (this.settingsList == null) {
            this.settingsList = new ArrayList<SettingsTypes.Setting>();
            this.createSgbdSetting();
            this.settingsList.add((SettingsTypes.Setting)this.sgbdSetting);
            this.createLevelSetting();
            this.settingsList.add((SettingsTypes.Setting)this.levelSetting);
        }
        return this.settingsList;
    }

    private void createSgbdSetting() {
        Map<String, String> listSupportedDump = this.createListSupportedDump();
        ArrayList<String> lstCle = new ArrayList<String>(listSupportedDump.keySet());
        ArrayList<String> lstVal = new ArrayList<String>(listSupportedDump.values());
        String val = Configuration.getString((ConfigurationKey)KEY_IMPORT_EXTENDED_SGBD_NAME);
        int indexSelectedSgbd = val.length() == 0 ? lstCle.indexOf(DEFAULT_SGBD) : new Integer(val).intValue();
        String label = Translator.localize((String)"argouml-sql.import.listdatabase");
        this.sgbdSetting = new Setting.UniqueSelection(label, lstVal, indexSelectedSgbd);
    }

    public String getCodeSgbd() {
        String ret = null;
        Map<String, String> listSupportedDump = this.createListSupportedDump();
        ArrayList<String> lstCle = new ArrayList<String>(listSupportedDump.keySet());
        String val = Configuration.getString((ConfigurationKey)KEY_IMPORT_EXTENDED_SGBD_NAME);
        Integer indexSelectedSgbd = val.length() == 0 ? Integer.valueOf(lstCle.indexOf(DEFAULT_SGBD)) : new Integer(val);
        ret = (String)lstCle.get(indexSelectedSgbd);
        return ret;
    }

    public SettingsTypes.UniqueSelection getSgbdSetting() {
        return this.sgbdSetting;
    }

    private void createLevelSetting() {
        String val = Configuration.getString((ConfigurationKey)KEY_IMPORT_EXTENDED_MODELE_LEVEL, (String)"0");
        int indexSelectedLevel = new Integer(val);
        String label = Translator.localize((String)"argouml-sql.import.level");
        this.levelSetting = new Setting.UniqueSelection(label, this.getLstLevel(), indexSelectedLevel);
    }

    public SettingsTypes.UniqueSelection getLevelSetting() {
        return this.levelSetting;
    }

    private List<String> getLstLevel() {
        ArrayList<String> listLevel = new ArrayList<String>();
        this.addLabelFromModele(listLevel, LEVEL_MPD);
        this.addLabelFromModele(listLevel, LEVEL_MCD);
        return listLevel;
    }

    public String getCodeLevel() {
        String ret = LEVEL_MPD;
        String val = Configuration.getString((ConfigurationKey)KEY_IMPORT_EXTENDED_MODELE_LEVEL, (String)"0");
        if (val.equals("0")) {
            ret = LEVEL_MPD;
        } else if (val.equals("1")) {
            ret = LEVEL_MCD;
        }
        return ret;
    }

    private void addLabelFromModele(List<String> lst, String parserName) {
        String label = Translator.localize((String)("argouml-sql.import.level." + parserName));
        lst.add(label);
    }

    public void saveSettings() {
        if (this.sgbdSetting != null) {
            Configuration.setString((ConfigurationKey)KEY_IMPORT_EXTENDED_SGBD_NAME, (String)String.valueOf(this.sgbdSetting.getSelection()));
        }
        if (this.levelSetting != null) {
            Configuration.setString((ConfigurationKey)KEY_IMPORT_EXTENDED_MODELE_LEVEL, (String)String.valueOf(this.levelSetting.getSelection()));
        }
    }
}

