/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.state2.diagram;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.argouml.model.AddAssociationEvent;
import org.argouml.model.Model;
import org.argouml.model.RemoveAssociationEvent;
import org.argouml.notation.Notation;
import org.argouml.notation.NotationName;
import org.argouml.notation.NotationProvider;
import org.argouml.notation.NotationProviderFactory2;
import org.argouml.notation.NotationRenderer;
import org.argouml.notation.NotationSettings;
import org.argouml.state2.diagram.FigRegion;
import org.argouml.ui.ActionCreateContainedModelElement;
import org.argouml.ui.targetmanager.TargetManager;
import org.argouml.uml.diagram.ArgoDiagram;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.state.ui.SelectionState;
import org.argouml.uml.diagram.ui.ArgoFig;
import org.argouml.uml.diagram.ui.FigNodeModelElement;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.Selection;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.presentation.Connector;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigRRect;
import org.tigris.gef.presentation.FigText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigVertex
extends FigNodeModelElement {
    private static final Logger LOG = Logger.getLogger(FigVertex.class.getName());
    private static final int MARGIN = 2;
    private NotationProvider notationProviderBody;
    private FigBody bodyText;
    private FigGroup regionCompartment;

    public FigVertex(Object owner, Rectangle bounds, DiagramSettings settings) {
        super(owner, bounds, settings);
        this.allowRemoveFromDiagram(false);
        this.initialize();
        NotationName notation = Notation.findNotation((String)this.getNotationSettings().getNotationLanguage());
        this.notationProviderBody = NotationProviderFactory2.getInstance().getNotationProvider(3, this.getOwner(), (NotationRenderer)this, notation);
        this.updateNameText();
        LOG.log(Level.INFO, "Registering as listener");
        Model.getPump().addModelEventListener((PropertyChangeListener)((Object)this), this.getOwner(), "region");
    }

    public void setEnclosingFig(Fig encloser) {
        LayerPerspective lp = (LayerPerspective)this.getLayer();
        if (lp == null) {
            return;
        }
        super.setEnclosingFig(encloser);
        Object region = null;
        if (encloser != null) {
            List regions = Model.getStateMachinesHelper().getRegions(encloser.getOwner());
            if (regions.isEmpty()) {
                region = Model.getUmlFactory().buildNode(Model.getMetaTypes().getRegion(), encloser.getOwner());
            } else {
                FigVertex compositeState = (FigVertex)encloser;
                for (DiagramElement de : compositeState.regionCompartment.getDiagramElements()) {
                    if (!((Fig)de).getBounds().contains(this.getBounds())) continue;
                    region = de.getOwner();
                    break;
                }
            }
        } else {
            ArgoDiagram diagram = (ArgoDiagram)lp.getDiagram();
            Object stateMachine = diagram.getOwner();
            List regions = Model.getStateMachinesHelper().getRegions(stateMachine);
            region = regions.isEmpty() ? Model.getUmlFactory().buildNode(Model.getMetaTypes().getRegion(), stateMachine) : regions.get(0);
        }
        if (region != null && Model.getFacade().getContainer(this.getOwner()) != region) {
            Model.getStateMachinesHelper().setContainer(this.getOwner(), region);
        }
    }

    protected Fig createBigPortFig() {
        return new FigRRect(0, 0, 0, 0, LINE_COLOR, FILL_COLOR);
    }

    private void initialize() {
        this.getNameFig().setLineWidth(0);
        this.getNameFig().setFilled(false);
        this.bodyText = new FigBody(0, 0, 0, 0);
        this.regionCompartment = new FigRegionCompartment(0, 0, 0, 0);
        this.addFig(this.getBigPort());
        this.addFig((Fig)this.getNameFig());
        this.addFig((Fig)this.getBodyText());
        this.addFig((Fig)this.regionCompartment);
        this.setBounds(this.getBounds());
    }

    protected void initNotationProviders(Object own) {
        if (this.notationProviderBody != null) {
            this.notationProviderBody.cleanListener();
        }
        super.initNotationProviders(own);
        NotationName notation = Notation.findNotation((String)this.getNotationSettings().getNotationLanguage());
        if (Model.getFacade().isAState(own)) {
            this.notationProviderBody = NotationProviderFactory2.getInstance().getNotationProvider(3, own, (NotationRenderer)this, notation);
        }
    }

    protected void modelChanged(PropertyChangeEvent mee) {
        super.modelChanged(mee);
        assert (mee.getPropertyName().equals("region"));
        if (mee instanceof AddAssociationEvent) {
            Object newRegion = mee.getNewValue();
            FigRegion rg = new FigRegion(newRegion);
            rg.setBounds(this.regionCompartment.getX(), this.regionCompartment.getY(), rg.getMinimumSize().width, rg.getMinimumSize().height);
            this.regionCompartment.addFig((Fig)rg);
            this.setSize(Math.max(this.getMinimumSize().width, this.getWidth()), Math.max(this.getMinimumSize().height, this.getHeight()));
        }
        if (mee instanceof RemoveAssociationEvent) {
            Object oldRegion = mee.getNewValue();
            for (DiagramElement de : this.regionCompartment.getDiagramElements()) {
                if (de.getOwner() != oldRegion) continue;
                this.regionCompartment.removeFig((Fig)de);
                this.renderingChanged();
                this.damage();
            }
            LOG.log(Level.FINE, "Removing region {0}", oldRegion);
        }
    }

    public void removeFromDiagramImpl() {
        if (this.notationProviderBody != null) {
            this.notationProviderBody.cleanListener();
        }
        super.removeFromDiagramImpl();
    }

    public void renderingChanged() {
        super.renderingChanged();
        if (this.notationProviderBody != null) {
            this.bodyText.setText(this.notationProviderBody.toString(this.getOwner(), this.getNotationSettings()));
        }
        this.calcBounds();
        this.setBounds(this.getBounds());
    }

    private FigText getBodyText() {
        return this.bodyText;
    }

    protected void textEditStarted(FigText ft) {
        super.textEditStarted(ft);
        if (ft == this.bodyText) {
            this.showHelp(this.notationProviderBody.getParsingHelp());
        }
    }

    public void textEdited(FigText ft) throws PropertyVetoException {
        super.textEdited(ft);
        if (ft == this.getBodyText()) {
            this.notationProviderBody.parse(this.getOwner(), ft.getText());
            ft.setText(this.notationProviderBody.toString(this.getOwner(), this.getNotationSettings()));
        }
    }

    public void notationRenderingChanged(NotationProvider np, String rendering) {
        super.notationRenderingChanged(np, rendering);
        if (this.notationProviderBody == np) {
            this.bodyText.setText(rendering);
            this.updateBounds();
            this.damage();
        }
    }

    public NotationSettings getNotationSettings(NotationProvider np) {
        return this.getNotationSettings();
    }

    public Object getOwner(NotationProvider np) {
        return this.getOwner();
    }

    public Dimension getMinimumSize() {
        Dimension nameSize = this.getNameFig().getMinimumSize();
        Dimension bodySize = this.getBodyText().getMinimumSize();
        int h = this.getTopMargin() + nameSize.height + this.getBottomMargin();
        h += this.regionCompartment.getMinimumSize().height;
        if (this.getBodyText().getText().length() > 0) {
            h += bodySize.height;
        }
        int w = this.getLeftMargin() + Math.max(nameSize.width, bodySize.width) + this.getRightMargin();
        if (Model.getFacade().isACompositeState(this.getOwner())) {
            w = Math.max(180, w);
            h = Math.max(150, h);
        } else {
            w = Math.max(80, w);
            h = Math.max(40, h);
        }
        return new Dimension(w, h);
    }

    public boolean getUseTrapRect() {
        return true;
    }

    public List<Rectangle> getTrapRects(Fig draggedFig) {
        if (draggedFig instanceof Connector) {
            ArrayList<Rectangle> rects = new ArrayList<Rectangle>(1);
            rects.add(this.getBigPort().getBounds());
            return rects;
        }
        List regions = Model.getStateMachinesHelper().getRegions(this.getOwner());
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(regions.size());
        if (regions.isEmpty()) {
            rects.add(this.regionCompartment.getBounds());
        } else {
            for (Fig f : this.regionCompartment.getFigs()) {
                rects.add(f.getBounds());
            }
        }
        return rects;
    }

    protected void setStandardBounds(int x, int y, int w, int h) {
        Dimension nameSize = this.getNameFig().getMinimumSize();
        Dimension bodySize = this.getBodyText().getMinimumSize();
        this.getNameFig().setBounds(x + this.getLeftMargin(), y + this.getTopMargin(), w - this.getLeftMargin() - this.getRightMargin(), nameSize.height);
        if (this.getBodyText().getText().length() > 0) {
            this.getBodyText().setBounds(x + this.getLeftMargin(), y + this.getTopMargin() + nameSize.height, bodySize.width, bodySize.height);
        } else {
            this.getBodyText().setBounds(x + this.getLeftMargin(), y + this.getTopMargin() + nameSize.height, bodySize.width, 1);
        }
        this.regionCompartment.setBounds(x + this.getLeftMargin(), this.getBodyText().getY() + this.getBodyText().getHeight(), w - this.getLeftMargin() - this.getRightMargin(), h - this.getTopMargin() - this.getBottomMargin() - this.getNameFig().getHeight() - this.getBodyText().getHeight());
        this.getBigPort().setBounds(x, y, w, h);
        this.calcBounds();
    }

    int getRightMargin() {
        return 2;
    }

    int getLeftMargin() {
        return 2;
    }

    int getTopMargin() {
        return 2;
    }

    int getBottomMargin() {
        return 2;
    }

    public Vector getPopUpActions(MouseEvent me) {
        Vector popUpActions = super.getPopUpActions(me);
        if (TargetManager.getInstance().getTargets().size() == 1) {
            popUpActions.add(popUpActions.size() - FigVertex.getPopupAddOffset(), new ActionCreateContainedModelElement(Model.getMetaTypes().getRegion(), this.getOwner()));
        }
        return popUpActions;
    }

    public Selection makeSelection() {
        if (this.getOwner() != null) {
            return new SelectionState((Fig)this);
        }
        return null;
    }

    private class FigRegionCompartment
    extends FigGroup {
        public FigRegionCompartment(int x, int y, int width, int height) {
        }

        protected void setBoundsImpl(int x, int y, int w, int h) {
            this._x = x;
            this._y = y;
            this._w = w;
            this._h = h;
            Iterator it = this.getFigs().iterator();
            while (it.hasNext()) {
                Fig fig = (Fig)it.next();
                if (it.hasNext()) {
                    fig.setBounds(x, y, w, fig.getMinimumSize().height);
                    h -= fig.getMinimumSize().height;
                } else {
                    fig.setBounds(x, y, w, h);
                }
                y += fig.getHeight();
            }
        }

        public Dimension getMinimumSize() {
            int minWidth = 0;
            int minHeight = 0;
            Iterator it = this.getFigs().iterator();
            while (it.hasNext()) {
                Fig fig = (Fig)it.next();
                minWidth = Math.max(fig.getMinimumSize().width, minWidth);
                if (it.hasNext()) {
                    minHeight += fig.getHeight();
                    continue;
                }
                minHeight += fig.getMinimumSize().height;
            }
            return new Dimension(minWidth, minHeight);
        }

        public void paint(Graphics g) {
            super.paint(g);
            Iterator it = this.getFigs().iterator();
            while (it.hasNext()) {
                Fig fig = (Fig)it.next();
                if (!it.hasNext()) continue;
                g.setColor(this.getLineColor());
                this.drawDashedLine(g, 1, fig.getX(), fig.getY() + fig.getHeight(), fig.getX() + fig.getWidth(), fig.getY() + fig.getHeight(), 0, new float[]{5.0f, 5.0f}, 10);
            }
        }
    }

    private class FigBody
    extends FigText {
        public FigBody(int x, int y, int width, int height) {
            super(x, y, width, height);
            this.setFont(FigVertex.this.getSettings().getFont(0));
            this.setTextColor(ArgoFig.TEXT_COLOR);
            this.setLineWidth(0);
            this.setFilled(false);
            this.setExpandOnly(true);
            this.setReturnAction(1);
            this.setJustification(0);
        }
    }
}

