/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.AttributedCharacterIterator;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tigris.gef.persistence.export.FontUtility;
import org.tigris.gef.presentation.Fig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgWriter2D
extends Graphics2D {
    private static final Logger LOG = Logger.getLogger(SvgWriter2D.class.getCanonicalName());
    private static final Stroke DEFAULT_STROKE = new BasicStroke();
    private static final Color DEFAULT_COLOR = Color.black;
    private static final Color DEFAULT_BACKGROUND = Color.white;
    private PrintWriter writer;
    private Document svg;
    private Stack<Element> elements = new Stack();
    private Stack<GraphicsContext> graphicsContexts = new Stack();
    private GraphicsContext activeGC;
    private Shape clip;
    private int hInset = 10;
    private int vInset = 10;
    private String svgNamespace = "http://www.w3.org/2000/svg";
    private boolean isInline = false;
    private RenderingHints renderingHints = new RenderingHints(null);
    private AffineTransform transform = new AffineTransform();

    public SvgWriter2D(OutputStream stream, Rectangle area) throws ParserConfigurationException, UnsupportedEncodingException {
        this.writer = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.svg = builder.newDocument();
        Element root = this.svg.createElement("svg");
        root.setAttribute("xmlns", this.svgNamespace);
        root.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        root.setAttribute("width", "" + (2 * this.hInset + area.width));
        root.setAttribute("height", "" + (2 * this.vInset + area.height));
        root.setAttribute("version", "1.1");
        this.elements.push(root);
        this.activeGC = new GraphicsContext(Color.black, Color.white, 1);
        this.activeGC.font = new Font("Verdana", 0, 8);
        this.graphicsContexts.push(this.activeGC);
        Element group = this.svg.createElement("g");
        group.setAttribute("stroke", this.toHexString(this.activeGC.foreground));
        group.setAttribute("fill", this.toHexString(this.activeGC.background));
        group.setAttribute("font", this.activeGC.font.getFontName());
        group.setAttribute("stroke-width", "1");
        this.elements.push(group);
    }

    public SvgWriter2D(OutputStream stream, Rectangle drawingArea, boolean isInline) throws ParserConfigurationException, UnsupportedEncodingException {
        this(stream, drawingArea);
        this.isInline = isInline;
    }

    @Override
    public Graphics2D create() {
        return this;
    }

    @Override
    public void dispose() {
        while (!this.elements.isEmpty()) {
            this.popElement();
        }
        this.printDOMTree(this.svg);
        this.writer.close();
    }

    public void printDOMTree(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                if (!this.isInline) {
                    this.writer.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                    this.writer.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
                }
                this.printDOMTree(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                this.printElementNode(node);
                break;
            }
            case 5: {
                this.writer.print("&");
                this.writer.print(node.getNodeName());
                this.writer.print(";");
                break;
            }
            case 4: {
                this.writer.print("<![CDATA[");
                this.writer.print(node.getNodeValue());
                this.writer.print("]]>");
                break;
            }
            case 3: {
                this.printTextNode(node);
                break;
            }
            case 7: {
                this.writer.print("<?");
                this.writer.print(node.getNodeName());
                String data = node.getNodeValue();
                this.writer.print("");
                this.writer.print(data);
                this.writer.print("?>");
                break;
            }
        }
    }

    private void printElementNode(Node node) {
        this.writer.print("<");
        this.writer.print(node.getNodeName());
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            this.writer.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
        }
        NodeList children = node.getChildNodes();
        if (children.getLength() > 0) {
            this.writer.println(">");
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                this.printDOMTree(children.item(i));
            }
            this.writer.print("</");
            this.writer.print(node.getNodeName());
            this.writer.println(">");
        } else {
            this.writer.println("/>");
        }
    }

    private void printTextNode(Node node) {
        String text = node.getNodeValue();
        block5: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '&': {
                    this.writer.print("&amp;");
                    continue block5;
                }
                case '<': {
                    this.writer.print("&lt;");
                    continue block5;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block5;
                }
                default: {
                    this.writer.print(text.charAt(i));
                }
            }
        }
    }

    @Override
    public Color getColor() {
        return this.activeGC.foreground;
    }

    private String getColorAsString() {
        return this.toHexString(this.activeGC.foreground);
    }

    private String toHexString(Color c) {
        return "#" + Integer.toHexString(c.getRGB()).substring(2);
    }

    @Override
    public void setColor(Color c) {
        this.activeGC.foreground = c;
    }

    @Override
    public void setPaintMode() {
        this.activeGC.XOR = false;
        LOG.warning("Unimplemented - setPaintMode");
    }

    @Override
    public void setXORMode(Color otherColor) {
        this.activeGC.XOR = true;
        LOG.warning("Unimplemented - setXORMode");
    }

    @Override
    public Font getFont() {
        return this.activeGC.font;
    }

    @Override
    public void setFont(Font f) {
        if (f != null) {
            this.activeGC.font = f;
            LOG.fine("setFont " + f.getFontName() + " " + f);
        } else {
            LOG.fine("null setFont " + this.activeGC.font.getFontName() + " " + this.activeGC.font);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return FontUtility.getFontMetrics(f);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        LOG.warning("unimplemented copyArea");
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        LOG.warning("Unimplemented -  drawImage");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver observer) {
        LOG.warning("Unimplemented -  drawImage");
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        LOG.warning("Unimplemented -  drawImage");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        LOG.warning("Unimplemented -  drawImage");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        LOG.warning("Unimplemented -  drawImage");
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        LOG.warning("Unimplemented -  drawImage");
        return true;
    }

    private void drawRect(double x, double y, double w, double h, Color strokeColor, Color fillColor) {
        LOG.fine("drawRect " + x + " " + y + " " + w + " " + h);
        Element rect = this.svg.createElement("rect");
        rect.setAttribute("x", "" + x);
        rect.setAttribute("y", "" + y);
        rect.setAttribute("width", "" + w);
        rect.setAttribute("height", "" + h);
        this.setDrawingAttributes(rect, new GraphicsContext(strokeColor, fillColor, this.activeGC.lineWidth));
        ((Element)this.elements.peek()).appendChild(rect);
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {
        this.drawRect(x, y, w, h, this.activeGC.foreground, null);
    }

    private void drawRect(double x, double y, double w, double h) {
        this.drawRect(x, y, w, h, this.activeGC.foreground, null);
    }

    private void fillRect(double x, double y, double w, double h) {
        this.drawRect(x, y, w, h, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.drawRect(x, y, w, h, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void clearRect(int x, int y, int w, int h) {
        this.drawRect(x, y, w, h, this.activeGC.background, this.activeGC.background);
    }

    private void drawOval(double x, double y, double w, double h, Color strokeColor, Color fill) {
        LOG.fine("drawOval " + x + " " + y + " " + w + " " + h);
        Element oval = this.svg.createElement("ellipse");
        oval.setAttribute("cx", "" + (x + w / 2.0));
        oval.setAttribute("cy", "" + (y + h / 2.0));
        oval.setAttribute("rx", "" + w / 2.0);
        oval.setAttribute("ry", "" + h / 2.0);
        this.setDrawingAttributes(oval, new GraphicsContext(strokeColor, fill, this.activeGC.lineWidth));
        ((Element)this.elements.peek()).appendChild(oval);
    }

    @Override
    public void drawOval(int x, int y, int w, int h) {
        this.drawOval(x, y, w, h, this.activeGC.foreground, null);
    }

    private void drawOval(double x, double y, double w, double h) {
        this.drawOval(x, y, w, h, this.activeGC.foreground, null);
    }

    private void fillOval(double x, double y, double w, double h) {
        this.drawOval(x, y, w, h, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void fillOval(int x, int y, int w, int h) {
        this.drawOval(x, y, w, h, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void drawArc(int x, int y, int w, int h, int startAngle, int arcAngle) {
        LOG.warning("Not implemented : drawArc");
    }

    @Override
    public void fillArc(int x, int y, int w, int h, int startAngle, int arcAngle) {
        LOG.warning("Not implemented : fillArc");
    }

    private void drawRoundRect(double x, double y, double w, double h, double arcw, double arch, Color stroke, Color fill) {
        LOG.fine("drawRoundRect " + x + " " + y + " " + w + " " + h);
        Element rect = this.svg.createElement("rect");
        rect.setAttribute("x", "" + x);
        rect.setAttribute("y", "" + y);
        rect.setAttribute("width", "" + w);
        rect.setAttribute("height", "" + h);
        rect.setAttribute("rx", "" + arcw);
        rect.setAttribute("ry", "" + arch);
        this.setDrawingAttributes(rect, new GraphicsContext(stroke, fill, this.activeGC.lineWidth));
        ((Element)this.elements.peek()).appendChild(rect);
    }

    @Override
    public void drawRoundRect(int x, int y, int w, int h, int arcw, int arch) {
        this.drawRoundRect(x, y, w, h, arcw, arch, this.activeGC.foreground, this.activeGC.background);
    }

    private void drawRoundRect(double x, double y, double w, double h, double arcw, double arch) {
        this.drawRoundRect(x, y, w, h, arcw, arch, this.activeGC.foreground, this.activeGC.background);
    }

    @Override
    public void fillRoundRect(int x, int y, int w, int h, int arcw, int arch) {
        this.drawRoundRect(x, y, w, h, arcw, arch, this.activeGC.foreground, this.activeGC.foreground);
    }

    private void fillRoundRect(double x, double y, double w, double h, double arcw, double arch) {
        this.drawRoundRect(x, y, w, h, arcw, arch, this.activeGC.foreground, this.activeGC.foreground);
    }

    private void drawPolygon(int[] xPoints, int[] yPoints, int nPoints, Color stroke, Color fill) {
        LOG.fine("drawPolygon");
        double maxX = 0.0;
        double maxY = 0.0;
        Element polygon = this.svg.createElement("polygon");
        this.setDrawingAttributes(polygon, new GraphicsContext(stroke, fill, this.activeGC.lineWidth));
        StringBuffer pointList = new StringBuffer();
        for (int i = 0; i < nPoints; ++i) {
            if (i > 0) {
                pointList.append(" ");
            }
            pointList.append("" + xPoints[i] + "," + yPoints[i]);
            if ((double)xPoints[i] > maxX) {
                maxX = xPoints[i];
            }
            if (!((double)yPoints[i] > maxY)) continue;
            maxY = yPoints[i];
        }
        polygon.setAttribute("points", pointList.toString());
        ((Element)this.elements.peek()).appendChild(polygon);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(xPoints, yPoints, nPoints, this.activeGC.foreground, null);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(xPoints, yPoints, nPoints, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        LOG.fine("drawPolyLine");
        double maxX = 0.0;
        double maxY = 0.0;
        Element polyline = this.svg.createElement("polyline");
        this.setDrawingAttributes(polyline);
        StringBuffer pointList = new StringBuffer();
        for (int i = 0; i < nPoints; ++i) {
            if (i > 0) {
                pointList.append(" ");
            }
            pointList.append("" + xPoints[i] + "," + yPoints[i]);
            if ((double)xPoints[i] > maxX) {
                maxX = xPoints[i];
            }
            if (!((double)yPoints[i] > maxY)) continue;
            maxY = yPoints[i];
        }
        polyline.setAttribute("points", pointList.toString());
        ((Element)this.elements.peek()).appendChild(polyline);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    private void drawLine(double x1, double y1, double x2, double y2) {
        LOG.fine("drawLine " + x1 + " " + y1 + " " + x2 + " " + y2);
        Element line = this.svg.createElement("line");
        line.setAttribute("x1", "" + x1);
        line.setAttribute("y1", "" + y1);
        line.setAttribute("x2", "" + x2);
        line.setAttribute("y2", "" + y2);
        this.setDrawingAttributes(line);
        ((Element)this.elements.peek()).appendChild(line);
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.setClip(new Rectangle(x, y, w, h));
    }

    @Override
    public void setClip(Shape newClip) {
        this.clip = newClip;
        LOG.fine("setClip " + newClip);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        if (this.clip == null) {
            this.setClip(x, y, w, h);
        } else {
            this.clip(new Rectangle(x, y, w, h));
        }
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void clip(Shape s) {
        if (this.clip == null) {
            this.clip = s;
        } else {
            Area clipArea = new Area(this.clip);
            clipArea.intersect(new Area(s));
            GeneralPath clipShape = new GeneralPath();
            clipShape.append(clipArea.getPathIterator(null), true);
            this.clip = clipShape;
        }
        LOG.fine("Clip with " + s + " result = " + this.clip);
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void scale(double xscale, double yscale) {
        LOG.fine("Scale " + xscale + " " + yscale);
        this.transform.scale(xscale, yscale);
        this.transformGroup("scale(" + xscale + "," + yscale + ")");
    }

    @Override
    public void setTransform(AffineTransform tx) {
        this.transform = tx;
        LOG.fine("setTransform " + tx);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
        LOG.fine("Shear " + shx + " " + shy);
    }

    @Override
    public void transform(AffineTransform tx) {
        this.transform.concatenate(tx);
        LOG.fine("Transform " + tx);
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
        LOG.fine("Translate " + tx + " " + ty);
    }

    @Override
    public void drawString(String t, int x, int y) {
        this.drawString(t, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator aci, int i1, int i2) {
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.renderingHints.putAll(hints);
        LOG.warning("Warning - addRenderingHint not supported");
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
        LOG.warning("Warning - setRenderingHint not supported");
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.renderingHints.putAll(hints);
        LOG.warning("Warning - setRenderingHint not supported");
    }

    @Override
    public void draw(Shape s) {
        LOG.fine("Draw - " + s);
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            this.drawLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.drawRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D r = (RoundRectangle2D)s;
            this.drawRoundRect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), r.getArcWidth(), r.getArcHeight());
        } else if (s instanceof Polygon) {
            this.drawPolygon((Polygon)s);
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.drawOval(e.getCenterX(), e.getCenterY(), e.getWidth() / 2.0, e.getHeight() / 2.0);
        } else {
            this.drawPath(s, this.activeGC.foreground, null);
        }
    }

    private void drawPath(Shape gp, Color lineColor, Color fillColor) {
        LOG.fine("draw GeneralPath");
        Element element = this.svg.createElement("path");
        this.setDrawingAttributes(element, new GraphicsContext(lineColor, fillColor, this.activeGC.lineWidth));
        element.setAttribute("d", this.getPath(gp));
        ((Element)this.elements.peek()).appendChild(element);
    }

    private String getPath(Shape gp) {
        StringBuffer path = new StringBuffer();
        PathIterator pi = gp.getPathIterator(null);
        while (!pi.isDone()) {
            double[] coords = new double[6];
            int type = pi.currentSegment(coords);
            if (type == 0) {
                double[] start = new double[]{coords[0], coords[1]};
                double[] last = start;
                path.append(" M " + coords[0] + " " + coords[1]);
                LOG.fine("MOVETO " + coords[0] + ", " + coords[1]);
            } else if (type == 1) {
                path.append(" L " + coords[0] + " " + coords[1]);
                LOG.fine("LINETO " + coords[0] + ", " + coords[1]);
            } else if (type == 3) {
                path.append(" C " + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3] + " " + coords[4] + " " + coords[5]);
                LOG.fine("CUBICTO " + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3] + " " + coords[4] + " " + coords[5]);
            } else if (type == 2) {
                path.append(" Q " + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3]);
                LOG.fine("QUADTO " + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3]);
            } else if (type == 4) {
                path.append(" Z");
                LOG.fine("CLOSE path");
            } else {
                LOG.warning("Unsupported GeneralPath segment type " + type);
            }
            pi.next();
        }
        return path.toString();
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        LOG.warning("Unimplemented -  drawGlyphVector");
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        LOG.warning("Unimplemented -  drawImage");
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void drawString(String str, float x, float y) {
        Element text = this.svg.createElement("text");
        text.setAttribute("x", "" + x);
        text.setAttribute("y", "" + y);
        text.setAttribute("font-family", this.activeGC.font.getFamily());
        text.setAttribute("font-size", "" + this.activeGC.font.getSize());
        text.setAttribute("fill", this.getColorAsString());
        if (this.getFont().isBold()) {
            text.setAttribute("font-weight", "bold");
        }
        if (this.getFont().isItalic()) {
            text.setAttribute("font-style", "italic");
        }
        text.appendChild(this.svg.createTextNode(str));
        ((Element)this.elements.peek()).appendChild(text);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
    }

    @Override
    public void fill(Shape s) {
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            this.drawLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.fillRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D r = (RoundRectangle2D)s;
            this.fillRoundRect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), r.getArcWidth(), r.getArcHeight());
        } else if (s instanceof Polygon) {
            this.fillPolygon((Polygon)s);
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.fillOval(e.getCenterX(), e.getCenterY(), e.getWidth() / 2.0, e.getHeight() / 2.0);
        } else {
            this.drawPath(s, this.activeGC.foreground, this.activeGC.foreground);
            LOG.warning("Falling back to fill shape " + s);
        }
    }

    @Override
    public Color getBackground() {
        return this.activeGC.background;
    }

    @Override
    public Composite getComposite() {
        return this.activeGC.composite;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        LOG.warning("Unimplemented - getDeviceConfiguration");
        return null;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        LOG.warning("Unimplemented - getFontRenderContext");
        return null;
    }

    @Override
    public Paint getPaint() {
        return this.activeGC.paint;
    }

    @Override
    public Stroke getStroke() {
        return this.activeGC.stroke;
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return s.intersects(rect);
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
        this.transformGroup("rotate(" + this.degrees(theta) + ")");
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
        this.transformGroup("rotate(" + this.degrees(theta) + "," + x + "," + y + ")");
    }

    @Override
    public void setBackground(Color color) {
        this.activeGC.background = color;
    }

    @Override
    public void setComposite(Composite comp) {
        if (comp != null) {
            this.activeGC.composite = comp;
            LOG.fine("New composite = " + this.activeGC.composite);
        }
    }

    @Override
    public void setPaint(Paint newPaint) {
        if (newPaint != null) {
            this.activeGC.paint = newPaint;
            LOG.fine("new paint = " + this.activeGC.paint);
        }
    }

    private void updateRenderGroup() {
    }

    @Override
    public void setStroke(Stroke s) {
        if (s != null) {
            this.activeGC.stroke = s;
            LOG.fine("new stroke = " + this.activeGC.stroke);
        }
    }

    private double degrees(double theta) {
        return theta / Math.PI * 180.0;
    }

    private void transformGroup(String transformation) {
        Element g = this.svg.createElement("g");
        g.setAttribute("transform", transformation);
        ((Element)this.elements.peek()).appendChild(g);
    }

    private void setDrawingAttributes(Element element) {
        this.setDrawingAttributes(element, (GraphicsContext)this.graphicsContexts.peek(), this.activeGC);
    }

    private void setDrawingAttributes(Element element, GraphicsContext gc) {
        this.setDrawingAttributes(element, (GraphicsContext)this.graphicsContexts.peek(), gc);
    }

    private void setDrawingAttributes(Element element, GraphicsContext gc1, GraphicsContext gc2) {
        int alpha;
        if (gc2.background != null && !gc2.background.equals(gc1.background)) {
            element.setAttribute("fill", this.toHexString(gc2.background));
        }
        if (!gc2.foreground.equals(gc1.foreground)) {
            element.setAttribute("stroke", this.toHexString(gc2.foreground));
        }
        if ((alpha = gc2.foreground.getAlpha()) != gc1.foreground.getAlpha()) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3);
            element.setAttribute("opacity", "" + nf.format((double)alpha / 255.0));
        }
        if (gc2.stroke != null && !gc2.stroke.equals(gc1.stroke)) {
            Stroke s = gc2.stroke;
            if (s instanceof BasicStroke) {
                String dashString = "";
                float[] dashes = ((BasicStroke)s).getDashArray();
                if (dashes != null && dashes.length > 1) {
                    for (float dash : dashes) {
                        dashString = dashString + dash + ", ";
                    }
                    dashString = dashString.substring(0, dashString.length() - 2);
                    element.setAttribute("stroke-dasharray", dashString);
                }
                element.setAttribute("stroke-width", "" + ((BasicStroke)s).getLineWidth());
            } else {
                element.setAttribute("stroke-width", "1");
            }
        }
    }

    public void beginFig(Fig fig) {
        this.beginFig(fig, null, null);
    }

    public void beginFig(Fig fig, String cssClass, String url) {
        if (url != null) {
            this.createLink(url);
        }
        Element group = this.svg.createElement("g");
        if (cssClass != null) {
            group.setAttribute("class", cssClass);
        }
        GraphicsContext gc = new GraphicsContext(fig.getLineColor(), fig.getFillColor(), fig.getLineWidth());
        this.setDrawingAttributes(group, (GraphicsContext)this.graphicsContexts.peek(), gc);
        this.graphicsContexts.push(gc);
        this.elements.push(group);
    }

    private void createLink(String url) {
        Element link = this.svg.createElement("a");
        link.setAttribute("xlink:href", url);
        this.elements.push(link);
    }

    public void endFig() {
        this.popElement();
        this.popElement();
        this.graphicsContexts.pop();
    }

    private Element popElement() {
        Element popped = this.elements.pop();
        Element top = (Element)this.elements.peek();
        if (top == null) {
            this.svg.appendChild(popped);
        } else {
            top.appendChild(popped);
        }
        return popped;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Stack<T>
    extends LinkedList<T> {
        private Stack() {
        }

        @Override
        public void push(T e) {
            this.addFirst(e);
        }

        @Override
        public T pop() {
            return (T)this.removeFirst();
        }
    }

    private class GraphicsContext {
        Color foreground;
        Color background;
        Composite composite;
        Paint paint;
        Stroke stroke;
        AffineTransform transform;
        Shape clip;
        int lineWidth = 0;
        Font font;
        boolean XOR = false;

        GraphicsContext(Color fg, Color bg, int w) {
            this.foreground = fg;
            this.background = bg;
            this.paint = bg;
            this.lineWidth = w;
        }
    }
}

