/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.argouml.core.propertypanels.ui.SimpleListModel;
import org.argouml.core.propertypanels.ui.UMLModelElementListModel;
import org.argouml.model.Model;
import org.argouml.ui.LookAndFeelMgr;
import org.argouml.uml.ui.UMLLinkMouseListener;
import org.argouml.uml.ui.UMLLinkedListCellRenderer;

class UMLLinkedList
extends JList
implements MouseListener {
    private static final Logger LOG = Logger.getLogger(UMLLinkedList.class.getName());

    public UMLLinkedList(ListModel dataModel, boolean showIcon, boolean showPath) {
        this(dataModel, (ListCellRenderer)new UMLLinkedListCellRenderer(showIcon, showPath));
        this.setSelectionMode(0);
        this.setForeground(Color.blue);
        this.setSelectionForeground(Color.blue.darker());
        UMLLinkMouseListener mouseListener = new UMLLinkMouseListener((JList)this);
        this.addMouseListener((MouseListener)mouseListener);
    }

    public UMLLinkedList(ListModel dataModel) {
        this(dataModel, true);
    }

    public UMLLinkedList(ListModel dataModel, boolean showIcon) {
        this(dataModel, showIcon, true);
    }

    UMLLinkedList(ListModel dataModel, ListCellRenderer renderer) {
        super(dataModel);
        this.setDoubleBuffered(true);
        if (renderer != null) {
            this.setCellRenderer(renderer);
        }
        this.setFont(LookAndFeelMgr.getInstance().getStandardFont());
        this.addMouseListener(this);
    }

    public Object getTarget() {
        if (this.getModel() instanceof SimpleListModel) {
            return ((SimpleListModel)this.getModel()).getUmlElement();
        }
        return ((UMLModelElementListModel)this.getModel()).getTarget();
    }

    public void mouseClicked(MouseEvent e) {
        this.showPopup(e);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.hasPopup()) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.hasPopup()) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent e) {
        this.showPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.showPopup(e);
    }

    private final void showPopup(MouseEvent event) {
        if (event.isPopupTrigger() && !Model.getModelManagementHelper().isReadOnly(this.getTarget())) {
            Point point = event.getPoint();
            int index = this.locationToIndex(point);
            JPopupMenu popup = new JPopupMenu();
            ListModel lm = this.getModel();
            if (lm instanceof UMLModelElementListModel && ((UMLModelElementListModel)lm).buildPopup(popup, index)) {
                LOG.log(Level.FINE, "Showing popup");
                popup.show(this, point.x, point.y);
            }
        }
    }

    protected boolean hasPopup() {
        if (this.getModel() instanceof UMLModelElementListModel) {
            return ((UMLModelElementListModel)this.getModel()).hasPopup();
        }
        return false;
    }
}

