/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationModel;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationValueField;
import org.argouml.model.Model;

class UMLValueSpecificationPanel
extends JPanel {
    private static final long serialVersionUID = 1494398250907085817L;
    private static final Logger LOG = Logger.getLogger(UMLValueSpecificationPanel.class.getName());
    private final UMLValueSpecificationModel model;
    private JComboBox typeInstanceValueList;
    private UMLValueSpecificationValueField valueField;
    private Component scrollPane;

    public UMLValueSpecificationPanel(UMLValueSpecificationModel model, String title) {
        super(new GridBagLayout());
        LOG.log(Level.FINE, ">>New ValueSpecification panel created");
        TitledBorder border = new TitledBorder(title);
        this.setBorder(border);
        this.model = model;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JComboBox combo = this.uiSelect();
        this.add((Component)combo, c);
        this.valueField = this.createField((String)combo.getSelectedItem());
    }

    private UMLValueSpecificationValueField createField(String sType) {
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        UMLValueSpecificationValueField ret = null;
        try {
            Class<?> oClass = Class.forName("org.argouml.core.propertypanels.ui.UMLValueSpecificationValueField" + sType);
            Constructor<?> constructeur = oClass.getConstructor(UMLValueSpecificationModel.class, Boolean.TYPE);
            ret = (UMLValueSpecificationValueField)constructeur.newInstance(this.model, true);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unknow type " + sType + " : " + e, e);
            return null;
        }
        this.scrollPane = ret.getComponent();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = -1;
        c.gridwidth = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add(this.scrollPane, c);
        return ret;
    }

    private JComboBox uiSelect() {
        Object expression;
        Collection listVS = Model.getDataTypesHelper().getValueSpecifications();
        Object[] typeInstanceValue = listVS.toArray();
        this.typeInstanceValueList = new JComboBox<Object>(typeInstanceValue);
        int iSel = 0;
        if (this.model != null && (expression = this.model.getExpression()) != null) {
            Class<?>[] interfaces = expression.getClass().getInterfaces();
            iSel = -1;
            for (int iInterf = 0; iInterf < interfaces.length && iSel == -1; ++iInterf) {
                for (int iVS = 0; iVS < typeInstanceValue.length && iSel == -1; ++iVS) {
                    if (!interfaces[iInterf].getSimpleName().equals(typeInstanceValue[iVS])) continue;
                    iSel = iVS;
                }
            }
        }
        this.typeInstanceValueList.setSelectedIndex(iSel);
        this.typeInstanceValueList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ae.getActionCommand().equals("comboBoxChanged")) {
                    JComboBox lst = (JComboBox)ae.getSource();
                    String sTypeVS = (String)lst.getSelectedItem();
                    UMLValueSpecificationPanel.this.model.createValueSpecification(sTypeVS);
                    UMLValueSpecificationPanel.this.createField(sTypeVS);
                }
            }
        });
        return this.typeInstanceValueList;
    }

    public void selectDefaultVS() {
        this.typeInstanceValueList.setSelectedIndex(0);
    }
}

