/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.loader.StandardClassLoader;

public final class ClassLoaderFactory {
    private static int debug = 0;
    private static String[] triggers = new String[]{"com.sun.jndi.ldap.LdapCtxFactory", "com.sun.net.ssl.internal.ssl.Provider", "javax.naming.Context", "javax.net.SocketFactory", "javax.security.cert.X509Certificate", "javax.sql.DataSource", "org.apache.catalina.startup.Bootstrap"};

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        int i;
        if (debug >= 1) {
            ClassLoaderFactory.log("Creating new class loader");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (unpacked != null) {
            i = 0;
            while (i < unpacked.length) {
                File file = unpacked[i];
                if (file.isDirectory() && file.exists() && file.canRead()) {
                    if (!ClassLoaderFactory.validateDirectory(file)) {
                        if (debug >= 1) {
                            ClassLoaderFactory.log("  Skipping directory " + file.getAbsolutePath());
                        }
                    } else {
                        if (debug >= 1) {
                            ClassLoaderFactory.log("  Including directory " + file.getAbsolutePath());
                        }
                        URL url = new URL("file", null, String.valueOf(file.getCanonicalPath()) + File.separator);
                        list.add(url.toString());
                    }
                }
                ++i;
            }
        }
        if (packed != null) {
            i = 0;
            while (i < packed.length) {
                File directory = packed[i];
                if (directory.isDirectory() && directory.exists() && directory.canRead()) {
                    String[] filenames = directory.list();
                    int j = 0;
                    while (j < filenames.length) {
                        String filename = filenames[j].toLowerCase();
                        if (filename.endsWith(".jar")) {
                            File file = new File(directory, filenames[j]);
                            if (!ClassLoaderFactory.validateJarFile(file)) {
                                if (debug >= 1) {
                                    ClassLoaderFactory.log("  Skipping jar file " + file.getAbsolutePath());
                                }
                            } else {
                                if (debug >= 1) {
                                    ClassLoaderFactory.log("  Including jar file " + file.getAbsolutePath());
                                }
                                URL url = new URL("file", null, file.getCanonicalPath());
                                list.add(url.toString());
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        String[] array = list.toArray(new String[list.size()]);
        StandardClassLoader classLoader = null;
        classLoader = parent == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    public static int getDebug() {
        return debug;
    }

    public static String[] getTriggers() {
        return triggers;
    }

    private static void log(String message) {
        System.out.print("ClassLoaderFactory:  ");
        System.out.println(message);
    }

    private static void log(String message, Throwable exception) {
        ClassLoaderFactory.log(message);
        exception.printStackTrace(System.out);
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static void setTriggers(String[] newTriggers) {
        triggers = newTriggers;
    }

    public static boolean validateDirectory(File directory) throws IOException {
        if (triggers == null) {
            return true;
        }
        int i = 0;
        while (i < triggers.length) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(triggers[i]);
            }
            catch (Throwable throwable) {
                clazz = null;
            }
            if (clazz != null) {
                File file = new File(directory, String.valueOf(triggers[i].replace('.', File.separatorChar)) + ".class");
                if (debug >= 2) {
                    ClassLoaderFactory.log(" Checking for " + file.getAbsolutePath());
                }
                if (file.exists() && file.canRead()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean validateJarFile(File jarfile) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = new JarFile(jarfile);
        int i = 0;
        while (i < triggers.length) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(triggers[i]);
            }
            catch (Throwable throwable) {
                clazz = null;
            }
            if (clazz != null) {
                JarEntry jarEntry;
                String name = String.valueOf(triggers[i].replace('.', '/')) + ".class";
                if (debug >= 2) {
                    ClassLoaderFactory.log(" Checking for " + name);
                }
                if ((jarEntry = jarFile.getJarEntry(name)) != null) {
                    jarFile.close();
                    return false;
                }
            }
            ++i;
        }
        jarFile.close();
        return true;
    }
}

