/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.IntermediateOutputStream;
import org.apache.tomcat.util.buf.WriteConvertor;

public final class C2BConverter {
    private IntermediateOutputStream ios;
    private WriteConvertor conv;
    private ByteChunk bb;

    public C2BConverter(String encoding) throws IOException {
        this(new ByteChunk(1024), encoding);
    }

    public C2BConverter(ByteChunk output, String encoding) throws IOException {
        this.bb = output;
        this.ios = new IntermediateOutputStream(output);
        this.conv = new WriteConvertor(this.ios, encoding);
    }

    public final void convert(char c) throws IOException {
        this.conv.write(c);
    }

    public final void convert(char[] c, int off, int len) throws IOException {
        this.conv.write(c, off, len);
    }

    public final void flushBuffer() throws IOException {
        this.conv.flush();
    }

    public ByteChunk getByteChunk() {
        return this.bb;
    }

    public final void recycle() {
        this.conv.recycle();
        this.bb.recycle();
    }

    public void setByteChunk(ByteChunk bb) {
        this.bb = bb;
        this.ios.setByteChunk(bb);
    }
}

