/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.util.log.Log;
import org.apache.tomcat.util.log.LogHandler;

public class LogManager {
    static LogHandler defaultChannel = new LogHandler();
    protected Hashtable loggers = new Hashtable();
    protected Hashtable channels = new Hashtable();
    private static int dL = 0;

    public void addChannel(String name, LogHandler logH) {
        if (name == null) {
            name = "";
        }
        this.channels.put(name, logH);
        Enumeration enumeration = this.loggers.keys();
        while (enumeration.hasMoreElements()) {
            String k = (String)enumeration.nextElement();
            Log l = (Log)this.loggers.get(k);
            if (!name.equals(l.getChannel(this))) continue;
            l.setProxy(this, logH);
        }
    }

    public Hashtable getChannels() {
        return this.channels;
    }

    public Log getLog(String channel, String prefix, Object owner) {
        LogHandler proxy;
        if (prefix == null && owner != null) {
            String cname = owner.getClass().getName();
            prefix = cname.substring(cname.lastIndexOf(".") + 1);
        }
        if ((proxy = (LogHandler)this.channels.get(channel)) == null) {
            proxy = defaultChannel;
        }
        Log log = new Log(channel, prefix, proxy, owner);
        this.loggers.put(String.valueOf(channel) + ":" + prefix, log);
        if (dL > 0) {
            System.out.println("getLog facade " + channel + ":" + prefix);
        }
        return log;
    }

    public Hashtable getLoggers() {
        return this.loggers;
    }

    public static void setDefault(LogHandler l) {
        if (defaultChannel == null) {
            defaultChannel = l;
        }
    }
}

